/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.DefaultImageDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.helper.SystemHelper;
import com.prelytis.dashboard.interfaces.ApplicationException;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.SystemResponseFactory;
import com.prelytis.dashboard.model.helper.LanguageHelper;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.model.helper.ThemeHelper;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.sentinel.security.ISentinelAuthenticationFacade;
import com.prelytis.dashboard.sentinel.security.SentinelAuthenticationFacade;
import com.prelytis.dashboard.value.LifeCycleRequest;
import com.prelytis.dashboard.value.LifeCycleResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.SystemRequest;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;

class LifeCycleResponseFactory
extends ResponseFactory {
    LifeCycleResponseFactory() {
    }

    @Override
    public synchronized Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        LifeCycleRequest value = (LifeCycleRequest)request;
        if (value.getAction() == null) {
            throw new DashboardException();
        }
        if (value.getAction() == LifeCycleRequest.Action.STOP_SERVICE) {
            return this.stopService();
        }
        switch (value.getAction()) {
            case START_SERVICE: {
                return this.startService(daoFactory);
            }
            case RELOAD_SYSTEM_PREFERENCES: {
                return this.reloadSystemPreferences(daoFactory);
            }
            case RELOAD_CONTEXT: {
                return this.reloadContext(daoFactory);
            }
            case STATUS: {
                return this.status(daoFactory);
            }
        }
        throw new DashboardException();
    }

    private Response status(DaoFactory daoFactory) {
        LifeCycleResponse response = new LifeCycleResponse();
        BeanPRPInfo info = this.getInfo(daoFactory);
        this.update(response, daoFactory, info);
        return response;
    }

    private BeanPRPInfo getInfo(DaoFactory daoFactory) {
        try {
            PrelytisInfoDao infoDao = daoFactory.getPrelytisInfoDao();
            return infoDao.getPrelytisInfo();
        }
        catch (Exception e) {
            log.warn((Object)e);
            return null;
        }
    }

    private LifeCycleResponse reloadContext(DaoFactory daoFactory) {
        log.info((Object)"Axway Sentinel Web Dashboard interactive configuration reloaded");
        LifeCycleResponse response = new LifeCycleResponse();
        this.update(response, daoFactory, this.getInfo(daoFactory));
        response.setState(Integer.valueOf(4));
        return response;
    }

    private LifeCycleResponse reloadSystemPreferences(DaoFactory daoFactory) {
        log.info((Object)"Axway Sentinel Web Dashboard system preferences reloading");
        LifeCycleResponse response = new LifeCycleResponse();
        this.update(response, daoFactory, this.getInfo(daoFactory));
        response.setState(Integer.valueOf(4));
        return response;
    }

    private void update(LifeCycleResponse response, DaoFactory daoFactory, BeanPRPInfo info) {
        Configuration configuration = Configuration.getInstance();
        String baseDir = configuration.getBaseDir();
        List<String> sentinelPassportDomains = null;
        try {
            ISentinelAuthenticationFacade sentinelFacade = SentinelAuthenticationFacade.getInstance();
            if (sentinelFacade.usesDomain()) {
                sentinelPassportDomains = Arrays.asList(sentinelFacade.getDomains());
            }
        }
        catch (DashboardException e) {
            log.error((Object)("Cannot retrieve domain information " + e.getLocalizedMessage()));
        }
        response.setDefaultLocale(configuration.getDefaultLocale());
        response.setBaseDir(baseDir);
        if (info != null) {
            response.setSentinelPassportDomains(sentinelPassportDomains);
            response.setRelease(info.getRelease());
            response.setChangeLanguageEnabled(Boolean.valueOf(info.isUserChooseLanguage()));
            response.setChangeThemeEnabled(Boolean.valueOf(info.isUserChooseTheme()));
            response.setShowConfirmDialog(Boolean.valueOf(info.isDisplayPopup()));
            response.setParamMenu(Boolean.valueOf(info.isParamMenu()));
            response.setAutoNameGeneration(Boolean.valueOf(info.isAutoNameGeneration()));
            response.setDirectLink(Boolean.valueOf(info.isDirectLink()));
            response.setHideNameFromLists(Boolean.valueOf(info.isHideNameFromLists()));
            response.setDisplayTooltip(Boolean.valueOf(info.isDisplayTooltips()));
            response.setDisplayReportFilterTop(Boolean.valueOf(info.isDisplayReportFilterTop()));
            response.setSimplifiedRuleEnabled(Boolean.valueOf(info.isSimplifiedRuleEnabled()));
            response.setNewParameterIfEmpty(Boolean.valueOf(info.isNewParameterIfEmpty()));
            response.setShowAutoValidateFilter(Boolean.valueOf(info.isAutoValidateFilter()));
            response.setDefaultTimeZone(info.getDefaultTimeZone());
            response.setShowHelp(Boolean.valueOf(info.isShowHelp()));
            response.setChangePasswordEnabled(Boolean.valueOf(info.isChangePasswordEnabled()));
            response.setLinkPreviewWidth(Integer.valueOf(info.getLinkPreviewWidth()));
            response.setLinkPreviewHeight(Integer.valueOf(info.getLinkPreviewHeight()));
            response.setLinkPreviewScale(Double.valueOf(info.getLinkPreviewScale()));
            response.setIpAllowedRest(this.getIpSet(info.getIpAllowedRest()));
            response.setTaskManagerAutoStart(Boolean.valueOf(info.isStartTaskMgr()));
            response.setUploadMaxSize(Integer.valueOf(info.getUploadMaxSize()));
            response.setUploadThreshold(Integer.valueOf(info.getUploadThreshold()));
            response.setUploadRepository(info.getUploadRepository());
            response.setPasswordRegex(info.getPasswordRegex());
            response.setChromeFrameEnabled(Boolean.valueOf(info.isChromeFrameEnabled()));
            response.setHeaderType(info.getHeaderType());
            try {
                LanguageHelper languageHelper = LanguageHelper.getInstance(daoFactory);
                response.setLanguageList(languageHelper.getActiveLanguageList());
                ThemeHelper themeHelper = ThemeHelper.getInstance(daoFactory);
                List<Element> eltList = themeHelper.list(null, 2, null, null, null);
                for (Element elt : eltList) {
                    BeanThemeDefinition theme = (BeanThemeDefinition)elt;
                    response.getThemeList().add(theme);
                }
                DefaultImageDao avatarDao = daoFactory.getDefaultImageDao();
                response.getAvatarList().addAll(avatarDao.getAvatarList());
                StyleHelper styleHelper = StyleHelper.getInstance(daoFactory);
                eltList = styleHelper.list(null, 2, null, null, null);
                for (Element elt : eltList) {
                    BeanStyleDefinition style = (BeanStyleDefinition)elt;
                    response.getStyleList().add(style);
                }
                if (info != null) {
                    String desc = (String)info.getDescriptionMap().get(configuration.getDefaultLocale());
                    StringBuilder sb = new StringBuilder().append(desc);
                    response.setBrand(sb.toString());
                }
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
        response.setPdfExport(Boolean.TRUE);
        response.setXlsExport(Boolean.TRUE);
        response.setLicenseOwner("Axway");
        response.setLicenseEndDate(null);
        response.setWhiteLabel(Boolean.TRUE);
        if (info != null) {
            response.setState(Integer.valueOf(1));
            log.info((Object)"Axway Sentinel Web Dashboard started");
        } else {
            response.setState(Integer.valueOf(0));
            log.info((Object)"Axway Sentinel Web Dashboard stopped");
        }
    }

    private LifeCycleResponse startService(DaoFactory daoFactory) throws DashboardException {
        try {
            Configuration configuration = Configuration.getInstance();
            this.checkDatabaseVersion(configuration.getDataSourceConfiguration());
            this.createDefaultFolders(configuration.getDataSourceConfiguration());
            BeanPRPInfo info = this.getInfo(daoFactory);
            if (info != null) {
                if (info.isFixDatabaseOnStartup()) {
                    this.fixDatabase(daoFactory, SystemRequest.Action.FIX_DATABASE);
                }
                if (info.isFixDictionnariesOnStartup()) {
                    this.fixDatabase(daoFactory, SystemRequest.Action.FIX_DICTIONNARIES);
                }
                this.fixEntitiesParentList(daoFactory);
                if (info.isFixI18nOnStartup()) {
                    this.fixI18n(daoFactory, info.isOverwriteI18n());
                }
            }
            LifeCycleResponse response = new LifeCycleResponse();
            this.update(response, daoFactory, info);
            return response;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private LifeCycleResponse stopService() {
        try {
            DaoFactory.getInstance().clear();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        Configuration configuration = Configuration.getInstance();
        DataSourceConfiguration dsConf = configuration.getDataSourceConfiguration();
        dsConf.emptyCache();
        LifeCycleResponse response = new LifeCycleResponse();
        response.setState(Integer.valueOf(0));
        log.info((Object)"Axway Sentinel Web Dashboard stopped");
        return response;
    }

    private void fixEntitiesParentList(DaoFactory daoFactory) {
        try {
            SystemRequest request = new SystemRequest();
            request.setAction(SystemRequest.Action.FIX_ENTITIES_PARENT_LIST);
            SystemResponseFactory systemResponseFactory = new SystemResponseFactory();
            systemResponseFactory.create((Request)request, null, daoFactory);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void fixI18n(DaoFactory daoFactory, Boolean overwrite) {
        try {
            SystemResponseFactory systemResponseFactory = new SystemResponseFactory();
            SystemRequest request = new SystemRequest();
            request.setAction(SystemRequest.Action.FIX_I18N);
            request.setOverwrite(overwrite);
            systemResponseFactory.create((Request)request, null, daoFactory);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void fixDatabase(DaoFactory daoFactory, SystemRequest.Action fix) {
        try {
            SystemResponseFactory systemResponseFactory = new SystemResponseFactory();
            SystemRequest request = new SystemRequest();
            request.setAction(fix);
            systemResponseFactory.create((Request)request, null, daoFactory);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private Collection<String> getIpSet(String ip) {
        String[] ipList;
        Collection<String> allowedIp = Collections.synchronizedCollection(new HashSet());
        for (String hostName : ipList = ip == null ? new String[]{} : ip.split(",")) {
            if ("all".equals(hostName)) {
                return null;
            }
            if ("localhost".equals(hostName)) {
                this.addLocalhostIPs(allowedIp);
                continue;
            }
            try {
                allowedIp.add(InetAddress.getByName(hostName).getHostAddress());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return allowedIp;
    }

    private void addLocalhostIPs(Collection<String> set) {
        try {
            Enumeration<NetworkInterface> netEnum = NetworkInterface.getNetworkInterfaces();
            while (netEnum.hasMoreElements()) {
                NetworkInterface netface = netEnum.nextElement();
                Enumeration<InetAddress> addEnum = netface.getInetAddresses();
                while (addEnum.hasMoreElements()) {
                    String ip = addEnum.nextElement().getHostAddress();
                    set.add(ip);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void checkDatabaseVersion(DataSourceConfiguration dsc) throws ApplicationException {
        try {
            SystemHelper helper = SystemHelper.getInstance();
            String databaseVersion = helper.getDatabaseVersion(dsc.getDataSource());
            if ("4.2.0".equals(databaseVersion)) {
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        ApplicationException ae = new ApplicationException(ErrorCode.INSIGHT_PARAMETER_ERROR, "Parameter error");
        ae.setLocalizedMessage("The database version does not correspond to the product version");
        throw ae;
    }

    private void createDefaultFolders(DataSourceConfiguration dsc) {
        String baseDir = Configuration.getInstance().getBaseDir();
        List<String> defaultFolders = SystemHelper.getInstance().getDefaultFolders(dsc.getDataSource());
        for (String defaultFolder : defaultFolders) {
            String folderFullPath = defaultFolder.replace("{WEBDASHBOARD-DIR}", baseDir);
            this.createFolder(folderFullPath);
        }
    }

    private void createFolder(String folderPath) {
        File folder = new File(folderPath);
        if (folder.exists()) {
            log.debug((Object)"Folder already exists on disk.");
        } else {
            try {
                folder.mkdirs();
                log.debug((Object)("Created folder:" + folder.getCanonicalPath()));
            }
            catch (SecurityException e) {
                log.error((Object)e);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }
}

