/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.LanguageDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.UserDao;
import com.prelytis.dashboard.helper.ConnectionInformationHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.model.ExecutionContextHelper;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.sql.ConnectionInformation;
import com.prelytis.dashboard.value.ExecutionContext;
import com.prelytis.dashboard.value.LoginRequest;
import com.prelytis.dashboard.value.LoginResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.BeanLanguage;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.BeanUserExecutionContext;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class LoginResponseFactory
extends ResponseFactory {
    private static final int DATE = 1;
    private static final int DATE_TIME = 2;
    private static final int TIME = 3;

    LoginResponseFactory() {
    }

    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        LoginRequest value = (LoginRequest)request;
        LoginRequest.Action action = value.getAction();
        if (action == null) {
            throw new NullPointerException("Missing action on LoginRequest");
        }
        switch (action) {
            default: {
                return this.createLoginResponse(daoFactory, value);
            }
            case RELOAD: 
        }
        return this.createReloadResponse(daoFactory, value);
    }

    private LoginResponse createLoginResponse(DaoFactory daoFactory, LoginRequest value) throws DashboardException {
        int connectionType;
        boolean force = false;
        if (value.getForceConnection() != null) {
            force = value.getForceConnection();
        }
        int n = connectionType = value.getConnectionType() == null ? 1 : value.getConnectionType();
        if (value.getUserPrincipal() == null) {
            throw this.createLoginException(daoFactory, ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidUser");
        }
        String principal = value.getUserPrincipal().getName();
        if (principal == null) {
            throw this.createLoginException(daoFactory, ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidUser");
        }
        UserHelper userHelper = UserHelper.getInstance(daoFactory);
        BeanUserDefinition user = null;
        try {
            user = connectionType == 5 ? userHelper.getDefinition(principal) : userHelper.findUserUsingLogin(principal);
        }
        catch (DashboardRuntimeException de) {
            if (de.getCode() == ErrorCode.NOT_FOUND_ERROR) {
                throw this.createLoginException(daoFactory, ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidUser");
            }
            throw de;
        }
        if (value.getPublicAccess().booleanValue() && user.getExecutionContextList().size() != 1 && ((BeanUserExecutionContext)user.getExecutionContextList().get(0)).getProfile() != 0) {
            log.info((Object)("Unknown public user " + principal));
            throw this.createLoginException(daoFactory, ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidUser");
        }
        if (!userHelper.isUserActive((BeanUser)user)) {
            log.info((Object)("Inactive user " + principal));
            throw this.createLoginException(daoFactory, ErrorCode.INSIGHT_INACTIVE_USER, "invalidUser");
        }
        if (connectionType == 1 && !user.getStandardAccess() || connectionType == 3 && !user.isMobileAccess()) {
            log.info((Object)("Inactive user " + principal));
            throw this.createLoginException(daoFactory, ErrorCode.INSIGHT_INACTIVE_USER, "invalidUser");
        }
        try {
            ExecutionContextHelper helper = ExecutionContextHelper.getInstance(daoFactory);
            ExecutionContext ec = helper.getExecutionContext((BeanUser)user, value.getExecutionContext());
            if (ec == null) {
                log.info((Object)("Invalid execution context for " + principal));
                throw this.createLoginException(daoFactory, ErrorCode.INSIGHT_INACTIVE_USER, "invalidUser");
            }
            ConnectionInformation connectionInformation = this.getConnectionInformation(value, (BeanUser)user, ec);
            ConnectionInformationHelper.getInstance(daoFactory).connectUser(connectionInformation, force);
            boolean showHidden = value.getShowHiddenItems() != null ? value.getShowHiddenItems() : false;
            LoginResponse response = this.createResponse(daoFactory, (BeanUser)user, ec, connectionType == 3, showHidden);
            response.setExecutionContextList(helper.getExecutionContextList((BeanUser)user));
            response.setConnectionType(Integer.valueOf(connectionType));
            response.setConnectionDate(connectionInformation.getConnectionDate());
            response.setUserSessionGuid(connectionInformation.getSessionGUID());
            return response;
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private Response createReloadResponse(DaoFactory daoFactory, LoginRequest value) throws DashboardException {
        ExpressionEvaluationDataHelper eedh = ExpressionEvaluationDataHelper.getInstance(daoFactory);
        ExpressionEvaluationData data = eedh.getExpressionEvaluationData(value.getUserSessionGuid(), value.getExecutionContext());
        UserHelper userHelper = UserHelper.getInstance(daoFactory);
        BeanUser user = userHelper.getCore(data.getUserName());
        ExecutionContextHelper helper = ExecutionContextHelper.getInstance(daoFactory);
        ExecutionContext ec = helper.getExecutionContext(user, value.getExecutionContext());
        boolean showHidden = value.getShowHiddenItems() != null ? value.getShowHiddenItems() : false;
        LoginResponse response = this.createResponse(daoFactory, user, ec, false, showHidden);
        response.setExecutionContextList(helper.getExecutionContextList(user));
        response.setUserSessionGuid(value.getUserSessionGuid());
        return response;
    }

    private LoginResponse createResponse(DaoFactory daoFactory, BeanUser user, ExecutionContext ec, boolean mobility, boolean showHidden) {
        LanguageDao languageDao = daoFactory.getLanguageDao();
        BeanLanguage language = (BeanLanguage)languageDao.getCore(user.getLanguageOID());
        SessionDao sessionDao = daoFactory.getSessionDao();
        UserDao userDao = daoFactory.getUserDao();
        Locale locale = new Locale(language.getLanguage());
        ec.setMenu(sessionDao.getMenuList(user, ec, mobility, showHidden, locale));
        LoginResponse response = new LoginResponse();
        response.setDefaultExecutionContext(ec);
        response.setUserName(user.getName());
        response.setExternalId(user.getExternalId());
        response.setDescription((String)user.getDescriptionMap().get(locale));
        response.setLocale(locale);
        response.setLanguageName(language.getName());
        response.setTimeZone(TimeZone.getTimeZone(user.getTimeZone()));
        response.setChartType(user.getChartType());
        response.setDateFormat(this.getFormat(language.getDateFormat(), locale, 1));
        response.setDateTimeFormat(this.getFormat(language.getDateTimeFormat(), locale, 2));
        response.setTimeFormat(this.getFormat(language.getTimeFormat(), locale, 3));
        response.setThemeName(user.getThemeName());
        response.setHomeName(user.getHomeName());
        response.setAvatar(userDao.getAvatar(user.getObjectID()));
        response.setRichGraphics(user.getRichGraphics() != null ? user.getRichGraphics() : false);
        response.setUseAmLang(user.getUseAmLang() == null || user.getUseAmLang() != false);
        response.setUseAmTheme(user.getUseAmTheme() == null || user.getUseAmTheme() != false);
        response.setUseAmTimeZone(user.getUseAmTimeZone() == null || user.getUseAmTimeZone() != false);
        response.setUseAmHome(user.getUseAmHome() == null || user.getUseAmHome() != false);
        response.setHeaderType(user.getHeaderType());
        response.setBookmarks(userDao.getBookmarks(user.getObjectID(), ec.getObjectID(), locale));
        return response;
    }

    private String getFormat(String pattern, Locale locale, int type) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
            return sdf.toPattern();
        }
        catch (Exception e) {
            log.debug((Object)e);
            try {
                DateFormat f;
                switch (type) {
                    case 1: {
                        f = DateFormat.getDateInstance(3, locale);
                        break;
                    }
                    default: {
                        f = DateFormat.getDateTimeInstance(3, 3, locale);
                        break;
                    }
                    case 3: {
                        f = DateFormat.getTimeInstance(3, locale);
                    }
                }
                if (f instanceof SimpleDateFormat) {
                    return ((SimpleDateFormat)f).toPattern();
                }
            }
            catch (Exception e2) {
                log.debug((Object)e2);
            }
            switch (type) {
                case 1: {
                    return "yyyyMMdd";
                }
                default: {
                    return "yyyyMMdd HH:mm";
                }
                case 3: 
            }
            return "HH:mm";
        }
    }

    private final ConnectionInformation getConnectionInformation(LoginRequest value, BeanUser user, ExecutionContext ec) {
        GuidFactory guidFactory = GuidFactory.getInstance();
        ConnectionInformation ci = new ConnectionInformation(guidFactory.generateGUID((Object)user), user.getObjectID(), user.getName(), ec.getObjectID(), ec.getName(), ec.getProfile(), ec.getEntityName(), ec.getWorkspaceName(), new Date(), value.getConnectionType().intValue(), value.getIpAddress(), value.getForwardedIpAddress());
        return ci;
    }

    private DashboardException createLoginException(DaoFactory daoFactory, ErrorCode errorCode, String key) {
        PrelytisInfoHelper prelytisInfoHelper = PrelytisInfoHelper.getInstance(daoFactory);
        Locale locale = prelytisInfoHelper.getDefaultLocale();
        return ExceptionHelper.getInstance(locale).createLoginException(errorCode, key);
    }
}

