/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PostItDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.value.PostItRequest;
import com.prelytis.dashboard.value.PostItResponse;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.PostIt;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.List;

public final class PostItResponseFactory
extends ResponseFactory {
    @Override
    public Response create(Request request, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        PostItRequest value = (PostItRequest)request;
        int userOid = data.getUserOid();
        int execCtxOid = data.getExecutionContextOid();
        List closed = value.getClosed();
        List postItList = value.getPostItList();
        PostItDao dao = daoFactory.getPostItDao();
        if (closed != null && !closed.isEmpty()) {
            for (int i = 0; i < closed.size(); ++i) {
                dao.delete(userOid, execCtxOid, value.getSessionType(), value.getDocumentName(), ((Integer)closed.get(i)).intValue());
            }
        }
        if (postItList != null && !postItList.isEmpty()) {
            for (PostIt p : postItList) {
                if (p == null) continue;
                dao.savePostIt(userOid, execCtxOid, value.getSessionType(), value.getDocumentName(), p);
            }
        }
        PostItResponse res = new PostItResponse();
        res.setPostItList(dao.getPostItList(userOid, execCtxOid, value.getSessionType(), value.getDocumentName()));
        return res;
    }
}

