/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.ResponseFactory;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.UserRequest;
import com.prelytis.dashboard.value.UserResponse;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;

class UserResponseFactory
extends ResponseFactory {
    UserResponseFactory() {
    }

    @Override
    public Response create(Request value, ExpressionEvaluationData data, DaoFactory daoFactory) throws DashboardException {
        UserRequest request = (UserRequest)value;
        switch (request.getAction()) {
            case BOOKMARKS: {
                return this.createBookmarksResponse(daoFactory, request, data);
            }
            case SETTINGS: {
                UserHelper userHelper = UserHelper.getInstance(daoFactory);
                return userHelper.getResponse(request, data);
            }
        }
        return null;
    }

    private Response createBookmarksResponse(DaoFactory daoFactory, UserRequest request, ExpressionEvaluationData data) {
        UserHelper userHelper = UserHelper.getInstance(daoFactory);
        userHelper.saveBookmarks(request.getBookmarks(), data);
        UserResponse response = new UserResponse();
        response.setBookmarks(userHelper.getBookmarks(data));
        return response;
    }
}

