/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.ControlGroupDao;
import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbWorkspaceFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanControlGroup;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class ControlGroupHelper
extends ParameterHelper
implements Dependency {
    private final ControlGroupDao dao;

    ControlGroupHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = daoFactory.getControlGroupDao();
    }

    public static final ControlGroupHelper getInstance(DaoFactory daoFactory) {
        return new ControlGroupHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanControlGroup)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanControlGroup)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanControlGroup)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanControlGroup elt = this.helper.get((Dao)this.dao, name, 1, BeanControlGroup.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.CONTROL_GROUP);
    }

    public BeanControlGroup create(ExpressionEvaluationData data) throws DashboardException {
        BeanControlGroup elt = new BeanControlGroup();
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanControlGroup elt = this.helper.get((Dao)this.dao, name, instanceType, BeanControlGroup.class);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.CONTROL_GROUP);
    }

    private ParameterResponse getSave(BeanControlGroup elt, ExpressionEvaluationData data) throws DashboardException {
        BeanControlGroup prev = (BeanControlGroup)this.dao.getCore(elt.getName());
        if (prev.getLastModifier() != null && !prev.getLastModifier().equals(elt.getLastModifier())) {
            elt.setLastModifier(prev.getLastModifier());
            long ms = (new Date().getTime() - prev.getLastModificationDate().getTime()) / 60000L;
            if (ms < 1L) {
                ms = 1L;
            }
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("concurrentSave", new Object[]{prev.getLastModifier(), ms}, null);
        }
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.CONTROL_GROUP);
    }

    private ParameterResponse getSaveAsNew(BeanControlGroup elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.CONTROL_GROUP);
    }

    public void save(BeanControlGroup elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        if (isNew) {
            this.helper.checkForSaveAsNew((Dao)this.dao, data, (Element)elt);
            elt.setObjectID(0);
            elt.setOwner(data.getUserName());
            elt.setCreationDate(new Date());
        }
        this.helper.checkForSave(data, (Element)elt);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        this.dao.save((Element)elt);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanControlGroup elt = (BeanControlGroup)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.CONTROL_GROUP);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.CONTROL_GROUP).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.CONTROL_GROUP);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.CONTROL_GROUP, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanControlGroup elt = this.helper.get((Dao)this.daoFactory.getControlGroupDao(), value.getName(), 1, BeanControlGroup.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.CONTROL_GROUP);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sortField, Integer maxSize, ExpressionEvaluationData data) {
        DbDefaultFilter filter = this.helper.getFilter(defaultFilter, data, DbDefaultFilter.class);
        return this.dao.listAll(filter, instanceType, sortField, maxSize);
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        DbWorkspaceFilter workspaceFilter = new DbWorkspaceFilter();
        workspaceFilter.setControlGroupOid(objectID);
        return Arrays.asList(new DependencyDefinition((DbDefaultFilter)workspaceFilter, SessionParameterType.WORKSPACE));
    }

    public BeanControlGroup getDefinition(String name) throws DashboardException {
        BeanControlGroup elt = this.getDefinition(SessionParameterType.CONTROL_GROUP, name, BeanControlGroup.class);
        return elt;
    }
}

