/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.ControlUserDao;
import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.ThresholdTypeDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.filter.DbThresholdTypeFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.ITaskWithThresholds;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.model.helper.ThresholdTypeHelper;
import com.prelytis.dashboard.util.ThresholdHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.Agregation;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanReportUsedField;
import com.prelytis.dashboard.value.data.BeanTask;
import com.prelytis.dashboard.value.data.BeanTaskControl;
import com.prelytis.dashboard.value.data.BeanTaskControlUser;
import com.prelytis.dashboard.value.data.BeanTaskDefinition;
import com.prelytis.dashboard.value.data.BeanThresholdTypeDefinition;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.ReportFilter;
import com.prelytis.dashboard.value.data.filter.TaskFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Thresholds;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public final class ControlHelper
extends ParameterHelper
implements Dependency,
References {
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;
    private final TaskDao dao;

    ControlHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getTaskDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
    }

    public static ControlHelper getInstance(DaoFactory daoFactory) {
        return new ControlHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanTaskControl)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanTaskControl)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanTaskControl)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
            case REFRESH: {
                return this.getRefresh((BeanTaskControl)value.getElement(), data);
            }
            case CUSTOMIZE: 
            case OPEN_CUSTOMIZE: {
                return this.getCustomize(action, value.getName(), data);
            }
            case DELETE_CUSTOMIZE: {
                return this.getDeleteCusto(value.getName(), (BeanTaskControl)value.getElement(), data);
            }
            case SAVE_CUSTOMIZE: {
                ControlUserDao controlDao = this.daoFactory.getControlUserDao();
                controlDao.save((BeanTaskControlUser)value.getElement());
                return new ParameterResponse();
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getDeleteCusto(String name, BeanTaskControl element, ExpressionEvaluationData data) throws DashboardException {
        Object def = element != null ? element : (BeanTask)this.dao.getCore(name);
        if (def.getTaskType() != TaskType.TASK_TYPE_CONTROL) {
            throw ExceptionHelper.getInstance(data.getLocale()).createNotFoundException(SessionParameterType.CONTROL, name);
        }
        ControlUserDao controlDao = this.daoFactory.getControlUserDao();
        controlDao.delete(def.getObjectID(), data.getUserOid().intValue(), data.getExecutionContextOid().intValue());
        return new ParameterResponse();
    }

    private ParameterResponse getSaveAsNew(BeanTaskControl elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    private ParameterResponse getSave(BeanTaskControl elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    public void save(BeanTaskControl elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanTaskControl elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.checkMandatoryFields(elt, data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanTask)elt);
        this.updateDescKeys((BeanTaskDefinition)elt, false);
        this.updateDescriptionMap((BeanTaskDefinition)elt, this.helper.getLocales(), data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        TaskHelper taskHelper = TaskHelper.getInstance(this.daoFactory);
        taskHelper.checkSchedule(data, (BeanTask)elt);
        if (elt instanceof ITaskWithThresholds) {
            BeanTaskControl t = elt;
            taskHelper.updateThresholdValues((ITaskWithThresholds)t, false);
        }
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void checkMandatoryFields(BeanTaskControl elt, Locale locale) throws DashboardException {
        if (elt.getCalculationReportName() == null || elt.getCalculationReportName().isEmpty()) {
            DashboardException noValidDataEx = ExceptionHelper.getInstance(locale).createDashboardException(ErrorCode.NO_VALID_DATA, "reportMandatory", null, null);
            throw noValidDataEx;
        }
        if (elt.getQueryFieldName() == null || elt.getQueryFieldName().isEmpty()) {
            DashboardException noValidDataEx = ExceptionHelper.getInstance(locale).createDashboardException(ErrorCode.NO_VALID_DATA, "fieldNameMandatory", null, null);
            throw noValidDataEx;
        }
    }

    private void updateDescriptionMap(BeanTaskDefinition elt, List<Locale> locales, Locale defaultLocale) {
        this.helper.updateDescriptionMap((Bean)elt, locales, defaultLocale);
        this.helper.updateDescriptionMap(elt.getMessageBodyMap(), locales, defaultLocale);
        this.helper.updateDescriptionMap(elt.getMessageSubjectMap(), locales, defaultLocale);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTask elt = this.helper.get((Dao)this.dao, name, 1, BeanTask.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getCustomize(ParameterRequest.Action action, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTaskControlUser elt;
        block2: {
            BeanTaskControl def = this.helper.get((Dao)this.dao, name, 2, BeanTaskControl.class);
            elt = null;
            ControlUserDao controlDao = this.daoFactory.getControlUserDao();
            try {
                elt = controlDao.open(def, data.getUserOid().intValue(), data.getExecutionContextOid().intValue());
            }
            catch (Exception e) {
                if (action != ParameterRequest.Action.CUSTOMIZE) break block2;
                elt = controlDao.create(def, data.getUserOid().intValue(), data.getExecutionContextOid().intValue());
            }
        }
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTask elt = this.helper.get((Dao)this.dao, name, instanceType, BeanTask.class);
        if (elt.getTaskType() != TaskType.TASK_TYPE_CONTROL) {
            throw ExceptionHelper.getInstance(data.getLocale()).createNotFoundException(SessionParameterType.CONTROL, name);
        }
        this.updateNames(elt);
        TaskHelper taskHelper = TaskHelper.getInstance(this.daoFactory);
        if (elt instanceof ITaskWithThresholds) {
            ITaskWithThresholds t = (ITaskWithThresholds)elt;
            taskHelper.updateThresholdValues(t, true);
        }
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.TASK);
    }

    public BeanTaskControl create(ExpressionEvaluationData data) throws DashboardException {
        BeanTaskControl elt = new BeanTaskControl();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.updateDescKeys((BeanTaskDefinition)elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
        ReportFilter reportFilter = new ReportFilter();
        reportFilter.setExecutionMode(Integer.valueOf(0));
        List<Element> reportList = reportHelper.list((DefaultFilter)reportFilter, 2, null, 1, data);
        if (reportList.isEmpty()) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_CONTROL_CREATION_NO_SUITABLE_REPORT, null, null, null);
        }
        if (reportList.size() > 0) {
            BeanReportCrossTable ct;
            AbstractBeanReport report = (AbstractBeanReport)reportList.get(0);
            if (report instanceof BeanReportStd) {
                BeanReportStd std = (BeanReportStd)report;
                if (std.getFieldList().size() > 0) {
                    BeanReportStdUsedField usedField = (BeanReportStdUsedField)std.getFieldList().get(0);
                    elt.setFieldName(usedField.getName());
                    elt.setDataType(usedField.getDataType());
                    elt.setQueryFieldName(usedField.getField().getName());
                    elt.setAgregation(usedField.getAgregation());
                }
            } else if (report instanceof BeanReportCrossTable && (ct = (BeanReportCrossTable)report).getDataFieldList().size() > 0) {
                BeanReportDataUsedField usedField = (BeanReportDataUsedField)ct.getDataFieldList().get(0);
                elt.setFieldName(usedField.getName());
                elt.setDataType(usedField.getDataType());
                elt.setQueryFieldName(usedField.getField().getName());
                elt.setAgregation(usedField.getAgregation());
            }
        }
        TaskHelper taskHelper = TaskHelper.getInstance(this.daoFactory);
        taskHelper.initCommon((BeanTask)elt);
        taskHelper.initThresholds((ITaskWithThresholds)elt);
        elt.setFreqUnitName("day");
        taskHelper.updateFreq((BeanTaskDefinition)elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getRefresh(BeanTaskControl task, ExpressionEvaluationData data) throws DashboardException {
        this.refreshThresholds(task);
        return this.helper.getResponse((I18nElement)task, data, SessionParameterType.TASK);
    }

    private void updateNames(BeanTask bean) throws DashboardException {
        bean.setFreqUnitName(this.getName(SessionParameterType.TIME_UNIT, bean.getFreqUnitOID()));
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        bean.setParentTaskName(this.optName(SessionParameterType.TASK, bean.getParentTaskOID()));
        bean.setTaskGroupName(this.optName(SessionParameterType.TASK_GROUP, bean.getTaskGrpOID()));
        if (bean instanceof BeanTaskControl) {
            BeanTaskControl elt = (BeanTaskControl)bean;
            ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
            AbstractBeanReport rpt = reportHelper.getDefinition(elt.getCalculationReportOID());
            List fieldList = null;
            if (rpt instanceof BeanReportStd) {
                fieldList = ((BeanReportStd)rpt).getFieldList();
            } else if (rpt instanceof BeanReportCrossTable) {
                fieldList = ((BeanReportCrossTable)rpt).getDataFieldList();
            }
            if (fieldList != null && !fieldList.isEmpty()) {
                for (BeanReportUsedField usedField : fieldList) {
                    FieldAgregation fa;
                    FieldAgregation fieldAgregation = fa = usedField instanceof Agregation ? ((Agregation)usedField).getAgregation() : FieldAgregation.AGREGATION_NONE;
                    if (!elt.getQueryFieldName().equals(usedField.getField().getName()) || !elt.getAgregation().equals((Object)fa)) continue;
                    elt.setFieldName(usedField.getName());
                    elt.setDataType(usedField.getDataType());
                    break;
                }
                if (elt.getFieldName() == null) {
                    BeanReportUsedField usedField = (BeanReportUsedField)fieldList.get(0);
                    elt.setFieldName(usedField.getName());
                    elt.setDataType(usedField.getDataType());
                }
            }
            elt.setCalculationReportName(rpt.getName());
            elt.setThresholdTypeName(this.getName(SessionParameterType.THRESHOLD_TYPE, elt.getThresholdTypeOID()));
            TaskHelper taskHelper = TaskHelper.getInstance(this.daoFactory);
            taskHelper.updateFreq((BeanTaskDefinition)elt);
        }
    }

    private void updateOids(BeanTask bean) throws DashboardException {
        if (bean.getFreqUnitName() != null && !bean.getFreqUnitName().isEmpty()) {
            bean.setFreqUnitOID(this.getOid(SessionParameterType.TIME_UNIT, bean.getFreqUnitName()));
        } else {
            bean.setFreqUnitOID(1);
        }
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        bean.setParentTaskOID(this.optOid(SessionParameterType.TASK, bean.getParentTaskName()));
        bean.setTaskGrpOID(this.optOid(SessionParameterType.TASK_GROUP, bean.getTaskGroupName()));
        if (bean instanceof BeanTaskControl) {
            BeanTaskControl elt = (BeanTaskControl)bean;
            ReportHelper reportHelper = ReportHelper.getInstance(this.daoFactory);
            AbstractBeanReport rpt = reportHelper.getDefinition(elt.getCalculationReportName());
            List fieldList = null;
            if (rpt instanceof BeanReportStd) {
                fieldList = ((BeanReportStd)rpt).getFieldList();
            } else if (rpt instanceof BeanReportCrossTable) {
                fieldList = ((BeanReportCrossTable)rpt).getDataFieldList();
            }
            if (fieldList != null && elt.getFieldName() != null) {
                for (BeanReportUsedField usedField : fieldList) {
                    if (!elt.getFieldName().equals(usedField.getName())) continue;
                    FieldAgregation fa = usedField instanceof Agregation ? ((Agregation)usedField).getAgregation() : FieldAgregation.AGREGATION_NONE;
                    elt.setQueryFieldName(usedField.getField().getName());
                    elt.setAgregation(fa);
                    elt.setDataType(usedField.getDataType());
                    break;
                }
            }
            elt.setCalculationReportOID(rpt.getObjectID());
            elt.setThresholdTypeOID(this.getOid(SessionParameterType.THRESHOLD_TYPE, elt.getThresholdTypeName()));
            TaskHelper taskHelper = TaskHelper.getInstance(this.daoFactory);
            taskHelper.updateMessageUserList((BeanTaskDefinition)elt);
        }
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTaskControl elt = this.helper.get((Dao)this.dao, name, 2, BeanTaskControl.class);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.updateDescKeys((BeanTaskDefinition)elt, true);
        this.updateNames((BeanTask)elt);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK);
    }

    private void refreshThresholds(BeanTaskControl bean) throws DashboardException {
        ThresholdTypeHelper thresholdTypeHelper = ThresholdTypeHelper.getInstance(this.daoFactory);
        BeanThresholdTypeDefinition thresholdType = thresholdTypeHelper.getDefinition(bean.getThresholdTypeName());
        bean.setThresholdTypeOID(bean.getThresholdTypeOID());
        bean.setThresholdTypeName(thresholdType.getName());
        bean.setThresholdIcon(thresholdType.getIcon());
        bean.setThresholds(ThresholdHelper.copy((Thresholds)thresholdType.getThresholds()));
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.TASK).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.TASK);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.TASK, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanTask elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanTask.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.TASK);
    }

    public BeanTask getCore(String name) throws DashboardException {
        BeanTask elt = this.helper.get((Dao)this.dao, name, 1, BeanTask.class);
        if (elt.getTaskType() != TaskType.TASK_TYPE_CONTROL) {
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createNotFoundException(SessionParameterType.CONTROL, name);
        }
        this.updateNames(elt);
        return elt;
    }

    public BeanTaskControl getDefinition(String name) throws DashboardException {
        BeanTaskControl elt = this.helper.get((Dao)this.dao, name, 2, BeanTaskControl.class);
        this.updateNames((BeanTask)elt);
        return elt;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbTaskFilter filter = this.helper.getFilter(defaultFilter, data, DbTaskFilter.class);
        filter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_CONTROL));
        if (defaultFilter instanceof TaskFilter) {
            TaskFilter src = (TaskFilter)defaultFilter;
            filter.setDashboardOid(this.optOid(SessionParameterType.DASHBOARD, src.getDashboardName()));
            filter.setFolderOid(this.optOid(SessionParameterType.FOLDER, src.getFolderName()));
            filter.setParentTaskOid(this.optOids(SessionParameterType.TASK, src.getParentTaskName()));
            filter.setPersFieldOid(this.optOid(SessionParameterType.PERS_FIELD, src.getPersFieldName()));
            filter.setQueryOid(this.optOid(SessionParameterType.QUERY, src.getQueryName()));
            filter.setReportOid(this.optOid(SessionParameterType.REPORT, src.getReportName()));
            filter.setTaskGrpOid(this.optOids(SessionParameterType.TASK_GROUP, src.getTaskGroupName()));
            filter.setTimeUnitOid(this.optOid(SessionParameterType.TIME_UNIT, src.getTimeUnitName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setParentTaskOid(new Integer[]{objectID});
        list.add(new DependencyDefinition((DbDefaultFilter)taskFilter, SessionParameterType.TASK));
        return list;
    }

    protected void updateDescKeys(BeanTaskDefinition bean, boolean replace) {
        this.helper.updateDescKey((Bean)bean, replace);
        if (replace || this.helper.isInvalidDescKey(bean.getMessageBodyKey())) {
            bean.setMessageBodyKey(this.guidFactory.generateGUID((Object)bean));
        }
        if (replace || this.helper.isInvalidDescKey(bean.getMessageSubjectKey())) {
            bean.setMessageSubjectKey(this.guidFactory.generateGUID((Object)bean));
        }
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setUsedByTaskControl(oid);
        ReportDao reportDao = this.daoFactory.getReportDao();
        l.addAll(reportDao.listAll((DbDefaultFilter)reportFilter, 1));
        DbThresholdTypeFilter thresholdTypeFilter = new DbThresholdTypeFilter();
        thresholdTypeFilter.setUsedByTaskControl(oid);
        ThresholdTypeDao thresholdTypeDao = this.daoFactory.getThresholdTypeDao();
        l.addAll(thresholdTypeDao.listAll((DbDefaultFilter)thresholdTypeFilter, 1));
        return l;
    }
}

