/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.ReportCustoDao;
import com.prelytis.dashboard.dao.StyleDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.TreeNodeHelper;
import com.prelytis.dashboard.value.CustomizationRequest;
import com.prelytis.dashboard.value.CustomizationResponse;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportCalculation;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanReport;
import com.prelytis.dashboard.value.data.BeanReportCalculation;
import com.prelytis.dashboard.value.data.BeanReportCalculationLabel;
import com.prelytis.dashboard.value.data.BeanReportCalculationLine;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportCrossTableUsedField;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdBreak;
import com.prelytis.dashboard.value.data.BeanReportStdSortField;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.data.report.AbstractCustomization;
import com.prelytis.dashboard.value.data.report.CrossCustomization;
import com.prelytis.dashboard.value.data.report.StdCustomization;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Font;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.LogManager;

public class CustomizationReportHelper {
    private final DaoFactory daoFactory;
    private final ReportCustoDao dao;
    private final ReportHelper reportHelper;

    private CustomizationReportHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
        this.dao = daoFactory.getReportCustoDao();
        this.reportHelper = ReportHelper.getInstance(this.daoFactory);
    }

    public static final CustomizationReportHelper getInstance(DaoFactory daoFactory) {
        return new CustomizationReportHelper(daoFactory);
    }

    public CustomizationResponse getResponse(CustomizationRequest value, ExpressionEvaluationData data) throws DashboardException {
        int userOid = data.getUserOid();
        AbstractBeanReport report = value.getAbr();
        if (report == null) {
            report = this.reportHelper.getDefinition(value.getName());
        }
        SecurityAdapter sa = new SecurityAdapter();
        sa.setElement((I18nElement)report);
        CustomizationResponse response = new CustomizationResponse();
        response.setElement(sa);
        switch (value.getAction()) {
            case CUSTOMIZE: {
                AbstractCustomization custo = this.dao.open(report, userOid);
                if (custo != null) {
                    this.update(data, custo, report);
                } else {
                    custo = this.createCustomization(data, report);
                }
                response.setCustomization(custo);
                break;
            }
            case SAVE_CUSTOMIZE: {
                AbstractCustomization custo = value.getCustomization();
                StyleDao styleDao = this.daoFactory.getStyleDao();
                Bean style = styleDao.getCore(custo.getStyleName());
                custo.setStyleOid(style.getObjectID());
                custo.setDisplayProperties((DisplayProperties)this.reportHelper.getDbChartProperties(custo.getDisplayProperties()));
                this.dao.save(value.getCustomization(), userOid);
                break;
            }
            case DELETE_CUSTOMIZE: {
                BeanReport rpt = this.reportHelper.getCore(value.getName());
                this.dao.delete(rpt.getObjectID(), userOid);
            }
        }
        return response;
    }

    private void update(ExpressionEvaluationData data, AbstractCustomization custo, AbstractBeanReport report) throws DashboardException {
        custo.setDisplayProperties(this.reportHelper.getDisplayProperties(custo.getDisplayProperties()));
        if (custo.getStyleOid() == report.getStyleOid()) {
            custo.setStyleName(report.getStyleName());
        } else {
            StyleDao styleDao = this.daoFactory.getStyleDao();
            custo.setStyleName(styleDao.getCore(custo.getStyleOid()).getName());
        }
        custo.setReportName(report.getName());
        if (custo instanceof StdCustomization && report instanceof BeanReportStd) {
            BeanReportStd std = (BeanReportStd)report;
            StdCustomization c = (StdCustomization)custo;
            ArrayList descriptions = new ArrayList();
            for (BeanReportStdUsedField field : std.getFieldList()) {
                descriptions.add(field.getDescriptionMap().get(data.getLocale()));
            }
            c.setDescriptions(descriptions);
        }
        List custoFilterList = custo.getFilterList();
        List<ReportFilter> reportFilterList = this.reportHelper.getVisibleFilterList(report, data);
        HashMap<String, ReportFilter> filterMap = new HashMap<String, ReportFilter>();
        for (ReportFilter filter : custoFilterList) {
            filterMap.put(filter.getName(), filter);
        }
        custoFilterList.clear();
        ConversionHelper helper = ConversionHelper.getDBConverter();
        for (ReportFilter filter : reportFilterList) {
            ReportFilter custoFilter = (ReportFilter)filterMap.get(filter.getName());
            if (custoFilter != null) {
                filter.setUseFilter(custoFilter.getUseFilter());
                try {
                    filter.setValue(helper.parse(filter.getDatatype(), (String)custoFilter.getValue()));
                }
                catch (ParseException e) {
                    LogManager.getLogger(CustomizationReportHelper.class).warn((Object)e);
                }
            }
            custoFilterList.add(filter);
        }
    }

    private AbstractCustomization createCustomization(ExpressionEvaluationData data, AbstractBeanReport report) throws DashboardException {
        if (report instanceof BeanReportCrossTable) {
            BeanReportCrossTable ct = (BeanReportCrossTable)report;
            CrossCustomization custo = new CrossCustomization();
            this.fill(data, (AbstractCustomization)custo, (AbstractBeanReport)ct);
            ArrayList<String> dataKeys = new ArrayList<String>();
            Boolean[] dataVisibleFields = new Boolean[ct.getDataFieldList().size()];
            int cpt = 0;
            for (BeanReportDataUsedField usedField : ct.getDataFieldList()) {
                dataKeys.add(usedField.getDescriptionKey());
                dataVisibleFields[cpt++] = usedField.isVisible();
            }
            custo.setDataKeys(dataKeys);
            custo.setDataVisibleFields(dataVisibleFields);
            ArrayList<String> xAxisKeys = new ArrayList<String>();
            HashMap<Integer, List<BeanReportCalculationLine>> xAxisLines = new HashMap<Integer, List<BeanReportCalculationLine>>();
            TreeNodeHelper tnh = TreeNodeHelper.getInstance();
            List l = tnh.getNodeList(ct.getColFieldList());
            Boolean[] xVisibleField = new Boolean[l.size()];
            this.fill(xAxisKeys, xAxisLines, l, xVisibleField);
            custo.setXAxisKeys(xAxisKeys);
            custo.setXAxisLines(xAxisLines);
            custo.setXAxisVisibleFields(xVisibleField);
            ArrayList<String> yAxisKeys = new ArrayList<String>();
            HashMap<Integer, List<BeanReportCalculationLine>> yAxisLines = new HashMap<Integer, List<BeanReportCalculationLine>>();
            l = tnh.getNodeList(ct.getRowFieldList());
            Boolean[] yVisibleField = new Boolean[l.size()];
            this.fill(yAxisKeys, yAxisLines, l, yVisibleField);
            custo.setYAxisKeys(yAxisKeys);
            custo.setYAxisLines(yAxisLines);
            custo.setYAxisVisibleFields(yVisibleField);
            return custo;
        }
        if (report instanceof BeanReportStd) {
            BeanReportStd std = (BeanReportStd)report;
            StdCustomization custo = new StdCustomization();
            this.fill(data, (AbstractCustomization)custo, (AbstractBeanReport)std);
            ArrayList descriptions = new ArrayList();
            ArrayList<String> descriptionKeys = new ArrayList<String>();
            Boolean[] visibleFields = new Boolean[std.getFieldList().size()];
            int i = 0;
            for (BeanReportStdUsedField field : std.getFieldList()) {
                descriptions.add(field.getDescriptionMap().get(data.getLocale()));
                descriptionKeys.add(field.getDescriptionKey());
                visibleFields[i] = field.isVisible();
                ++i;
            }
            custo.setDescriptionKeys(descriptionKeys);
            custo.setDescriptions(descriptions);
            custo.setVisibleFields(visibleFields);
            ArrayList<BeanReportCalculationLine> globalLines = new ArrayList<BeanReportCalculationLine>();
            this.copy(std.getGlobalCalcLineList(), globalLines);
            custo.setGlobalLines(globalLines);
            HashMap<String, ArrayList<BeanReportCalculationLine>> sectionLines = new HashMap<String, ArrayList<BeanReportCalculationLine>>();
            for (Object section : std.getSectionList()) {
                ArrayList<BeanReportCalculationLine> cl = new ArrayList<BeanReportCalculationLine>();
                this.copy(section.getCalculationLineList(), cl);
                sectionLines.put(section.getName(), cl);
            }
            custo.setSectionLines(sectionLines);
            HashMap<Integer, ArrayList<BeanReportCalculationLine>> breakLines = new HashMap<Integer, ArrayList<BeanReportCalculationLine>>();
            for (BeanReportStdBreak b : std.getBreakList()) {
                ArrayList<BeanReportCalculationLine> cl = new ArrayList<BeanReportCalculationLine>();
                this.copy(b.getCalculationLineList(), cl);
                breakLines.put(b.getColId(), cl);
            }
            custo.setBreakLines(breakLines);
            ArrayList<BeanReportStdSortField> sortList = new ArrayList<BeanReportStdSortField>();
            for (BeanReportStdSortField sortField : std.getSortFieldList()) {
                BeanReportStdSortField sf = new BeanReportStdSortField();
                sf.setColId(sortField.getColId());
                sf.setSortOrder(sortField.getSortOrder());
                sortList.add(sf);
            }
            custo.setSortList(sortList);
            return custo;
        }
        throw new DashboardException();
    }

    private void fill(List<String> axisKeys, Map<Integer, List<BeanReportCalculationLine>> axisLines, List<BeanReportCrossTableUsedField> fieldList, Boolean[] visiblesFields) throws DashboardException {
        int cpt = 0;
        for (BeanReportCrossTableUsedField field : fieldList) {
            axisKeys.add(field.getDescriptionKey());
            ArrayList<BeanReportCalculationLine> lineList = new ArrayList<BeanReportCalculationLine>();
            this.copy(field.getCalculationLineList(), lineList);
            axisLines.put(field.getId(), lineList);
            visiblesFields[cpt++] = field.isVisible();
        }
    }

    private void copy(List<BeanReportCalculationLine> ref, List<BeanReportCalculationLine> dest) throws DashboardException {
        for (BeanReportCalculationLine line : ref) {
            dest.add(this.getCopy(line));
        }
    }

    private BeanReportCalculationLine getCopy(BeanReportCalculationLine line) throws DashboardException {
        BeanReportCalculationLine resu = new BeanReportCalculationLine();
        resu.getStyle().init((Font)line.getStyle());
        for (AbstractBeanReportCalculation calculation : line.getCalculationList()) {
            resu.getCalculationList().add(this.getCopy(calculation));
        }
        return resu;
    }

    private AbstractBeanReportCalculation getCopy(AbstractBeanReportCalculation calculation) throws DashboardException {
        if (calculation instanceof BeanReportCalculation) {
            BeanReportCalculation ref = (BeanReportCalculation)calculation;
            BeanReportCalculation resu = new BeanReportCalculation();
            resu.setCalculation(ref.getCalculation());
            resu.setCalculationOnDistinctValues(ref.isCalculationOnDistinctValues());
            resu.setCalculationOnRawData(ref.isCalculationOnRawData());
            resu.setStyle(ref.getStyle());
            resu.setColId(ref.getColId());
            resu.setFormat(ref.getFormat());
            resu.setRefColId(ref.getRefColId());
            return resu;
        }
        if (calculation instanceof BeanReportCalculationLabel) {
            BeanReportCalculationLabel ref = (BeanReportCalculationLabel)calculation;
            BeanReportCalculationLabel resu = new BeanReportCalculationLabel();
            resu.setColId(ref.getColId());
            String descKey = ref.getDescriptionKey();
            resu.setDescriptionKey(descKey);
            resu.getDescriptionMap().putAll(ref.getDescriptionMap());
            resu.setStyle(ref.getStyle());
            resu.setFormat(ref.getFormat());
            return resu;
        }
        return null;
    }

    private void fill(ExpressionEvaluationData data, AbstractCustomization custo, AbstractBeanReport report) throws DashboardException {
        custo.setColRowInversion(report.getColRowInversion());
        custo.setReportOid(report.getObjectID());
        custo.setReportName(report.getName());
        custo.setDisplayProperties(report.getDisplayProperties());
        custo.setStyleOid(report.getStyleOid());
        custo.setStyleName(report.getStyleName());
        custo.setFilterList(this.reportHelper.getVisibleFilterList(report, data));
    }

    public AbstractCustomization getCustomizedReport(AbstractBeanReport report, ExpressionEvaluationData data) throws DashboardException {
        AbstractCustomization custo = this.dao.open(report, data.getUserOid().intValue());
        if (custo != null) {
            this.update(data, custo, report);
        }
        this.fillGlobalLines(report, custo);
        return custo;
    }

    public void fillGlobalLines(AbstractBeanReport report, AbstractCustomization custo) {
        if (custo instanceof StdCustomization) {
            List globalLines = ((StdCustomization)custo).getGlobalLines();
            for (int i = 0; i < globalLines.size(); ++i) {
                BeanReportCalculationLine lines = (BeanReportCalculationLine)globalLines.get(i);
                List listLines = lines.getCalculationList();
                for (int j = 0; j < listLines.size(); ++j) {
                    BeanReportCalculationLabel label;
                    Map<Locale, String> map;
                    AbstractBeanReportCalculation line = (AbstractBeanReportCalculation)listLines.get(j);
                    if (!(line instanceof BeanReportCalculationLabel) || (map = this.getLabelMapSTD(label = (BeanReportCalculationLabel)line, report)) == null) continue;
                    label.setDescriptionMap(map);
                }
            }
        }
    }

    public Map<Locale, String> getLabelMapSTD(BeanReportCalculationLabel label, AbstractBeanReport report) {
        List globalLines = ((BeanReportStd)report).getGlobalCalcLineList();
        for (int i = 0; i < globalLines.size(); ++i) {
            BeanReportCalculationLine lines = (BeanReportCalculationLine)globalLines.get(i);
            List listLines = lines.getCalculationList();
            for (int j = 0; j < listLines.size(); ++j) {
                AbstractBeanReportCalculation line = (AbstractBeanReportCalculation)listLines.get(j);
                if (!(line instanceof BeanReportCalculationLabel)) continue;
                BeanReportCalculationLabel labelReport = (BeanReportCalculationLabel)line;
                if (!label.getDescriptionKey().equals(labelReport.getDescriptionKey())) continue;
                return labelReport.getDescriptionMap();
            }
        }
        return null;
    }
}

