/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.DashboardCommentDao;
import com.prelytis.dashboard.dao.DashboardDao;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.ExternSessionDao;
import com.prelytis.dashboard.dao.PageLayoutDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.TextDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbExternSessionFilter;
import com.prelytis.dashboard.dao.filter.DbLinkFilter;
import com.prelytis.dashboard.dao.filter.DbPageLayoutFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.filter.DbTextFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.value.DashBoardCommentRequest;
import com.prelytis.dashboard.value.DashBoardCommentResponse;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanDashBoard;
import com.prelytis.dashboard.value.data.BeanDashBoardBlock;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockControl;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockExternSession;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockForm;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockMetric;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockReport;
import com.prelytis.dashboard.value.data.BeanDashBoardBlockTextSession;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanDashBoardFilter;
import com.prelytis.dashboard.value.data.BeanDashBoardTemplate;
import com.prelytis.dashboard.value.data.BeanDashboardComment;
import com.prelytis.dashboard.value.data.BeanDashboardFilterLinkedField;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanTaskDefinition;
import com.prelytis.dashboard.value.data.BeanTaskDocExport;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanWorkspaceDefinition;
import com.prelytis.dashboard.value.data.BeanWorkspaceSession;
import com.prelytis.dashboard.value.data.BeanWorkspaceSessionGroup;
import com.prelytis.dashboard.value.data.DashBoardFilter;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.data.filter.DashboardFilter;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.structure.DashboardCommentParam;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class DashBoardHelper
extends ParameterHelper
implements Dependency,
References {
    private static final int SESSION_GROUP_EN_COURS_OID = 8;
    private static final int SESSION_GROUP_CACHE_OID = 6;
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;
    private final boolean addDocInWorkspace;
    private final boolean addDashBoardDepDoc;
    private final DashboardDao dao;
    private final WorkspaceDao workspaceDao;
    private final int commentsLifetime;

    DashBoardHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getDashboardDao();
        this.workspaceDao = this.daoFactory.getWorkspaceDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        BeanPRPInfo info = prelytisInfoDao.getPrelytisInfo();
        this.autoNameGeneration = info.isAutoNameGeneration();
        this.addDocInWorkspace = info.isAddDocInWorkspace();
        this.addDashBoardDepDoc = info.isAddDashBoardDepDoc();
        this.commentsLifetime = info.getCommentsLifetime();
    }

    public static DashBoardHelper getInstance(DaoFactory daoFactory) {
        return new DashBoardHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanDashBoard)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanDashBoardDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanDashBoardDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanDashBoard elt = this.helper.get((Dao)this.dao, name, 1, BeanDashBoard.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        if (elt.getExecutionMode() == 1) {
            // empty if block
        }
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.DASHBOARD);
    }

    public BeanDashBoardDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanDashBoardDefinition elt = new BeanDashBoardDefinition();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.updateDescKeys(elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanDashBoard elt = this.helper.get((Dao)this.dao, name, instanceType, BeanDashBoard.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.DASHBOARD);
    }

    private ParameterResponse getSaveAsNew(BeanDashBoardDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.DASHBOARD);
    }

    private ParameterResponse getSave(BeanDashBoardDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.DASHBOARD);
    }

    public void save(BeanDashBoardDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanDashBoardDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanDashBoard)elt);
        this.updateDescKeys(elt, false);
        this.updateDescriptionMap(elt, this.helper.getLocales(), data.getLocale());
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        if (elt.isShowFilterFirst() && (elt.getFilterList() == null || elt.getFilterList().isEmpty())) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("dashboardMissingFilter", null, null);
        }
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
        if (this.addDocInWorkspace) {
            boolean modif = false;
            BeanWorkspaceDefinition workspaceDef = (BeanWorkspaceDefinition)this.workspaceDao.getDefinition(data.getWorkspaceOid().intValue());
            List sessionList = workspaceDef.getMoreSessionList();
            modif = this.addWorkspaceSession(sessionList, workspaceDef, SessionType.DASHBOARD, elt.getObjectID(), 8, true, data.getLocale());
            if (this.addDashBoardDepDoc) {
                for (BeanDashBoardTemplate template : elt.getTemplateList()) {
                    for (BeanDashBoardBlock block : template.getBlockList()) {
                        BeanDashBoardBlockExternSession extSession;
                        if (block instanceof BeanDashBoardBlockReport) {
                            BeanDashBoardBlockReport report = (BeanDashBoardBlockReport)block;
                            if (!this.addWorkspaceSession(sessionList, workspaceDef, SessionType.DOCUMENT, report.getReportOid(), 6, false, data.getLocale())) continue;
                            modif = true;
                            continue;
                        }
                        if (!(block instanceof BeanDashBoardBlockExternSession) || !this.addWorkspaceSession(sessionList, workspaceDef, SessionType.EXTERN, (extSession = (BeanDashBoardBlockExternSession)block).getExternSessionOid(), 6, false, data.getLocale())) continue;
                        modif = true;
                    }
                }
            }
            if (modif) {
                this.workspaceDao.save((Element)workspaceDef);
            }
        }
        if (elt.getExecutionMode() == 1) {
            DbTaskFilter filter = new DbTaskFilter();
            filter.setDashboardOid(Integer.valueOf(elt.getObjectID()));
            filter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_DOCUMENT_EXPORT));
            TaskHelper taskHelper = TaskHelper.getInstance(this.daoFactory);
            boolean exists = taskHelper.exists(filter);
            if (!exists) {
                BeanTaskDocExport docExport = new BeanTaskDocExport();
                docExport.setName(this.guidFactory.generateGUID((Object)docExport));
                docExport.setDashboardOid(Integer.valueOf(elt.getObjectID()));
                docExport.setDashboardName(elt.getName());
                docExport.setDataType(2);
                docExport.setOwnerEntOID(elt.getOwnerEntOID());
                docExport.setOwnerEntityName(elt.getOwnerEntityName());
                docExport.setCreationDate(elt.getCreationDate());
                docExport.setOwner(elt.getOwner());
                docExport.setLastModificationDate(elt.getLastModificationDate());
                docExport.setLastModifier(elt.getLastModifier());
                docExport.getDescriptionMap().putAll(elt.getDescriptionMap());
                taskHelper.save((BeanTaskDefinition)docExport, data, true);
            }
        }
    }

    private void updateDescriptionMap(BeanDashBoardDefinition elt, List<Locale> locales, Locale defaultLocale) {
        this.helper.updateDescriptionMap((Bean)elt, locales, defaultLocale);
        for (BeanDashBoardTemplate template : elt.getTemplateList()) {
            this.helper.updateDescriptionMap(template.getDescriptionMap(), locales, defaultLocale);
        }
        for (BeanDashBoardFilter filter : elt.getFilterList()) {
            this.helper.updateDescriptionMap(filter.getDescriptionMap(), locales, defaultLocale);
        }
    }

    private boolean addWorkspaceSession(List<BeanWorkspaceSession> sessionList, BeanWorkspaceDefinition workspaceDef, SessionType beanType, int beanObjectID, int sessionGroupOid, boolean sort, final Locale locale) throws DashboardException {
        boolean modif = false;
        if (sessionList != null) {
            TreeNode sessionGroupNode;
            TreeNode<Object> sessionGroup;
            BeanWorkspaceSession workspaceSession = null;
            SessionDao sessionDao = this.daoFactory.getSessionDao();
            for (BeanWorkspaceSession session : sessionList) {
                BeanSession beanSession = (BeanSession)sessionDao.getCore(session.getObjectID());
                if (session.getType() != beanType || beanSession.getRefOid() != beanObjectID) continue;
                workspaceSession = session;
                workspaceSession.setAccessLevel(Integer.valueOf(2));
            }
            if (workspaceSession != null && (sessionGroup = this.getTreeNode((TreeNode<Object>)(sessionGroupNode = workspaceDef.getSessionGroupNode()), sessionGroupOid)) != null && workspaceSession != null) {
                List children = sessionGroup.getChildren();
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
                newNode.setUserObject((Object)workspaceSession);
                newNode.setParent(sessionGroup);
                children.add(newNode);
                if (sort) {
                    final Collator collator = Collator.getInstance(locale);
                    Collections.sort(children, new Comparator<TreeNode<Object>>(){

                        @Override
                        public int compare(TreeNode<Object> o1, TreeNode<Object> o2) {
                            String d2;
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1000;
                            }
                            if (o2 == null) {
                                return -1000;
                            }
                            Object ou1 = o1.getUserObject();
                            Object ou2 = o2.getUserObject();
                            if (!(ou1 instanceof BeanWorkspaceSession)) {
                                return 999;
                            }
                            if (!(ou2 instanceof BeanWorkspaceSession)) {
                                return -999;
                            }
                            BeanWorkspaceSession s1 = (BeanWorkspaceSession)ou1;
                            BeanWorkspaceSession s2 = (BeanWorkspaceSession)ou2;
                            String d1 = (String)s1.getDescriptionMap().get(locale);
                            if (d1 == (d2 = (String)s2.getDescriptionMap().get(locale))) {
                                return 0;
                            }
                            if (d1 == null) {
                                return 998;
                            }
                            if (d2 == null) {
                                return -998;
                            }
                            return collator.compare(d1, d2);
                        }
                    });
                    int cpt = 0;
                    for (TreeNode tn : children) {
                        if (!(tn.getUserObject() instanceof BeanWorkspaceSession)) continue;
                        BeanWorkspaceSession s = (BeanWorkspaceSession)tn.getUserObject();
                        s.setSortOrder(cpt++);
                    }
                }
                sessionList.remove(workspaceSession);
                modif = true;
            }
        }
        return modif;
    }

    private TreeNode<Object> getTreeNode(TreeNode<Object> sessionGroupNode, int sessionGroupOid) {
        TreeNode<Object> res = null;
        for (TreeNode tree : sessionGroupNode.getChildren()) {
            BeanWorkspaceSessionGroup group;
            if (tree.getUserObject() != null && tree.getUserObject() instanceof BeanWorkspaceSessionGroup && (group = (BeanWorkspaceSessionGroup)tree.getUserObject()).getObjectID() == sessionGroupOid) {
                return tree;
            }
            if (tree.isLeaf()) continue;
            res = this.getTreeNode((TreeNode<Object>)tree, sessionGroupOid);
        }
        return res;
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanDashBoardDefinition elt = (BeanDashBoardDefinition)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.updateDescKeys(elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        for (BeanDashBoardTemplate bdt : elt.getTemplateList()) {
            bdt.setDescriptionKey(this.guidFactory.generateGUID((Object)bdt));
        }
        List filterList = elt.getFilterList();
        if (filterList != null) {
            for (BeanDashBoardFilter f : filterList) {
                f.setDescriptionKey(this.guidFactory.generateGUID((Object)f));
            }
        }
        this.updateNames((BeanDashBoard)elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.DASHBOARD);
    }

    private void updateNames(BeanDashBoard bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        bean.setPageLayoutName(this.getName(SessionParameterType.PAGE_LAYOUT, bean.getPageLayoutOid()));
        if (bean instanceof BeanDashBoardDefinition) {
            BeanDashBoardDefinition elt = (BeanDashBoardDefinition)bean;
            for (BeanDashBoardTemplate template : elt.getTemplateList()) {
                for (BeanDashBoardBlock block : template.getBlockList()) {
                    BeanDashBoardBlockControl b;
                    if (block instanceof BeanDashBoardBlockControl) {
                        b = (BeanDashBoardBlockControl)block;
                        b.setControlName(this.getName(SessionParameterType.TASK, b.getControlOid()));
                        continue;
                    }
                    if (block instanceof BeanDashBoardBlockExternSession) {
                        b = (BeanDashBoardBlockExternSession)block;
                        b.setExternSessionName(this.getName(SessionParameterType.EXTERN_SESSION, b.getExternSessionOid()));
                        continue;
                    }
                    if (block instanceof BeanDashBoardBlockForm) {
                        b = (BeanDashBoardBlockForm)block;
                        b.setFormName(this.getName(SessionParameterType.FORM, b.getOid()));
                        continue;
                    }
                    if (block instanceof BeanDashBoardBlockMetric) {
                        b = (BeanDashBoardBlockMetric)block;
                        b.setMetricName(this.getName(SessionParameterType.TASK, b.getMetricOid()));
                        continue;
                    }
                    if (block instanceof BeanDashBoardBlockReport) {
                        b = (BeanDashBoardBlockReport)block;
                        b.setReportName(this.getName(SessionParameterType.REPORT, b.getReportOid()));
                        continue;
                    }
                    if (!(block instanceof BeanDashBoardBlockTextSession)) continue;
                    b = (BeanDashBoardBlockTextSession)block;
                    b.setTextSessionName(this.getName(SessionParameterType.TEXT, b.getTextSessionOid()));
                }
            }
            for (BeanDashBoardFilter filter : elt.getFilterList()) {
                if (filter.getValueListOID() == 0) continue;
                filter.setValueListName(this.getName(SessionParameterType.QUERY, filter.getValueListOID()));
            }
        }
    }

    private void updateDescKeys(BeanDashBoardDefinition elt, boolean replace) {
        this.helper.updateDescKey((Bean)elt, replace);
        for (BeanDashBoardTemplate template : elt.getTemplateList()) {
            if (!replace && !this.helper.isInvalidDescKey(template.getDescriptionKey())) continue;
            template.setDescriptionKey(this.guidFactory.generateGUID((Object)template));
        }
        for (BeanDashBoardFilter filter : elt.getFilterList()) {
            if (!replace && !this.helper.isInvalidDescKey(filter.getDescriptionKey())) continue;
            filter.setDescriptionKey(this.guidFactory.generateGUID((Object)filter));
        }
    }

    private void updateOids(BeanDashBoard bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        bean.setPageLayoutOid(this.getOid(SessionParameterType.PAGE_LAYOUT, bean.getPageLayoutName()));
        if (bean instanceof BeanDashBoardDefinition) {
            BeanDashBoardDefinition elt = (BeanDashBoardDefinition)bean;
            StringBuffer errMsg = new StringBuffer();
            int templateInd = -1;
            for (BeanDashBoardTemplate template : elt.getTemplateList()) {
                ++templateInd;
                int blockInd = -1;
                for (BeanDashBoardBlock block : template.getBlockList()) {
                    ++blockInd;
                    try {
                        BeanDashBoardBlockControl b;
                        if (block instanceof BeanDashBoardBlockControl) {
                            b = (BeanDashBoardBlockControl)block;
                            b.setControlOid(this.getOid(SessionParameterType.TASK, b.getControlName()));
                            continue;
                        }
                        if (block instanceof BeanDashBoardBlockExternSession) {
                            b = (BeanDashBoardBlockExternSession)block;
                            b.setExternSessionOid(this.getOid(SessionParameterType.EXTERN_SESSION, b.getExternSessionName()));
                            continue;
                        }
                        if (block instanceof BeanDashBoardBlockForm) {
                            b = (BeanDashBoardBlockForm)block;
                            b.setOid(this.getOid(SessionParameterType.FORM, b.getFormName()));
                            continue;
                        }
                        if (block instanceof BeanDashBoardBlockMetric) {
                            b = (BeanDashBoardBlockMetric)block;
                            b.setMetricOid(this.getOid(SessionParameterType.TASK, b.getMetricName()));
                            continue;
                        }
                        if (block instanceof BeanDashBoardBlockReport) {
                            b = (BeanDashBoardBlockReport)block;
                            b.setReportOid(this.getOid(SessionParameterType.REPORT, b.getReportName()));
                            continue;
                        }
                        if (!(block instanceof BeanDashBoardBlockTextSession)) continue;
                        b = (BeanDashBoardBlockTextSession)block;
                        b.setTextSessionOid(this.getOid(SessionParameterType.TEXT, b.getTextSessionName()));
                    }
                    catch (DashboardException e) {
                        if (errMsg.length() > 0) {
                            errMsg.append(", ");
                        }
                        errMsg.append(ExceptionHelper.getInstance(Locale.ENGLISH).getMessage("invalidBlockDocument", new Object[]{templateInd, blockInd}));
                    }
                }
            }
            if (errMsg.length() > 0) {
                throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("invalidFieldValues", new Object[]{errMsg}, null);
            }
            for (BeanDashBoardFilter filter : elt.getFilterList()) {
                if (filter.getValueListOID() == 0) continue;
                filter.setValueListOID(this.getOid(SessionParameterType.QUERY, filter.getValueListName()));
            }
        }
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.DASHBOARD, value.getMinAccessLevel()).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.DASHBOARD);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.DASHBOARD, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanDashBoard elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanDashBoard.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.DASHBOARD);
    }

    public BeanDashBoardDefinition getDefinition(String name) throws DashboardException {
        BeanDashBoardDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanDashBoardDefinition.class);
        this.updateNames((BeanDashBoard)bean);
        return bean;
    }

    public List<ReportFilter> getFilterList(List<BeanDashBoardFilter> refFilterList, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<ReportFilter> dstFilterList = new ArrayList<ReportFilter>();
        for (BeanDashBoardFilter filter : refFilterList) {
            DashBoardFilter dstFilter = new DashBoardFilter();
            dstFilter.setName(filter.getName());
            dstFilter.setDescription((String)filter.getDescriptionMap().get(data.getLocale()));
            dstFilter.setDatatype(filter.getDataType());
            dstFilter.setLinkable(true);
            dstFilter.setMandatory(filter.isMandatory());
            dstFilter.setVisible(filter.isVisible());
            dstFilter.setPromptType(filter.getPromptType());
            dstFilter.setUseFilter(filter.isUseFilter());
            dstFilter.setValue(filter.getDefaultValue());
            dstFilter.setBlockId(filter.getBlockOid());
            dstFilter.setTemplateId(filter.getTemplateOid());
            dstFilter.setSrcFilterName(filter.getSrcFilterName());
            if (filter.getParameter() != '2') continue;
            Set map = dstFilter.getReportFilterMap();
            Set list = filter.getFilterList();
            if (list != null) {
                for (BeanDashboardFilterLinkedField field : list) {
                    BeanDashboardFilterLinkedField newField = new BeanDashboardFilterLinkedField();
                    newField.setBlockId(field.getBlockId());
                    newField.setTemplateId(field.getTemplateId());
                    newField.setFieldName(field.getFieldName());
                    map.add(newField);
                }
            }
            dstFilterList.add((ReportFilter)dstFilter);
        }
        return dstFilterList;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sortField, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbDashboardFilter filter = this.helper.getFilter(defaultFilter, data, DbDashboardFilter.class);
        if (defaultFilter instanceof DashboardFilter) {
            DashboardFilter src = (DashboardFilter)defaultFilter;
            filter.setExecutionContextOid(this.optOid(SessionParameterType.EXECUTION_CONTEXT, src.getExecutionContextName()));
            filter.setExternSessionOid(this.optOid(SessionParameterType.EXTERN_SESSION, src.getExternSessionName()));
            filter.setFormOid(this.optOid(SessionParameterType.FORM, src.getFormName()));
            filter.setPageLayoutOid(this.optOid(SessionParameterType.PAGE_LAYOUT, src.getPageLayoutName()));
            filter.setReportOid(this.optOid(SessionParameterType.REPORT, src.getReportName()));
            filter.setTextOid(this.optOid(SessionParameterType.TEXT, src.getTextName()));
            filter.setExecutionMode(src.getExecutionMode());
            filter.setUsedByWorkspace(this.optOid(SessionParameterType.WORKSPACE, src.getWorkspaceName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sortField, maxSize);
        if (instanceType != 1) {
            for (Element elt : eltList) {
                this.updateNames((BeanDashBoard)elt);
            }
        }
        return eltList;
    }

    public Response getResponse(DashBoardCommentRequest request, ExpressionEvaluationData data) throws DashboardException {
        BeanDashboardComment cmt = request.getDashBoardComment();
        if (cmt != null) {
            if (cmt.getExecMode() == 1) {
                cmt.setTaskOid(this.getOid(SessionParameterType.TASK, cmt.getTaskName()));
            } else {
                cmt.setDashboardOid(this.getOid(SessionParameterType.DASHBOARD, cmt.getDashboardName()));
            }
            cmt.setUserOid(data.getUserOid().intValue());
            cmt.setExecCtxOid(data.getExecutionContextOid().intValue());
            cmt.setUserName(data.getUserName());
            cmt.setExecCtxName(data.getExecutionContextName());
        }
        DashBoardCommentResponse response = new DashBoardCommentResponse();
        DashboardCommentDao commentDao = this.daoFactory.getDashboardCommentDao();
        DashBoardCommentRequest.Action action = request.getAction() == null ? DashBoardCommentRequest.Action.OPEN : request.getAction();
        switch (action) {
            case OPEN: {
                break;
            }
            case SAVE: {
                commentDao.save(cmt);
                break;
            }
            case DELETE: {
                commentDao.delete(cmt);
                break;
            }
        }
        response.setCommentParam(this.getCommentSettings(commentDao, request, data));
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DashboardCommentParam getCommentSettings(DashboardCommentDao dao, DashBoardCommentRequest request, ExpressionEvaluationData data) throws DashboardException {
        String taskName;
        int taskOid;
        int dashboardOid;
        if (data.getProfile() == 0) {
            return this.getInactiveCommentParam();
        }
        BeanDashBoard dashboard = (BeanDashBoard)this.dao.getCore(request.getDashboardName());
        if (!dashboard.isCommentActive()) {
            return this.getInactiveCommentParam();
        }
        if (request.getTaskName() != null) {
            BeanTaskDefinition task = this.getDefinition(SessionParameterType.TASK, request.getTaskName(), BeanTaskDefinition.class);
            if (!(task instanceof BeanTaskDocExport)) throw new DashboardException();
            BeanTaskDocExport docExport = (BeanTaskDocExport)task;
            if (docExport.getDataType() != 2) throw new DashboardException();
            dashboardOid = docExport.getDashboardOid();
            taskOid = docExport.getObjectID();
            taskName = docExport.getName();
        } else {
            dashboardOid = dashboard.getObjectID();
            taskOid = 0;
            taskName = null;
        }
        DashboardCommentParam param = dao.getDashboardCommentList(taskOid, request.getDateHisto(), request.getNum(), data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), request.getNbTempl(), dashboardOid, this.commentsLifetime);
        UserHelper userHelper = UserHelper.getInstance(this.daoFactory);
        for (List list : param.getComments().values()) {
            for (BeanDashboardComment comment : list) {
                comment.setDashboardName(dashboard.getName());
                comment.setTaskName(taskName);
                BeanUser user = userHelper.getCore(comment.getUserOid());
                comment.setUserName(user.getName());
                comment.setExecCtxName(this.getName(SessionParameterType.EXECUTION_CONTEXT, comment.getExecCtxOid()));
                comment.setDescription((String)user.getDescriptionMap().get(data.getLocale()));
            }
        }
        return param;
    }

    private DashboardCommentParam getInactiveCommentParam() {
        DashboardCommentParam param = new DashboardCommentParam();
        param.setCommentActive(false);
        return param;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer dashboardOid = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbUserFilter userFilter = new DbUserFilter();
        userFilter.setDashboardOid(dashboardOid);
        list.add(new DependencyDefinition((DbDefaultFilter)userFilter, SessionParameterType.USER));
        DbLinkFilter linkFilter = new DbLinkFilter();
        linkFilter.setDstDashboard(dashboardOid);
        list.add(new DependencyDefinition((DbDefaultFilter)linkFilter, SessionParameterType.LINK));
        DbTaskFilter docExportFilter = new DbTaskFilter();
        docExportFilter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_DOCUMENT_EXPORT));
        docExportFilter.setDashboardOid(dashboardOid);
        list.add(new DependencyDefinition((DbDefaultFilter)docExportFilter, SessionParameterType.TASK));
        DbTaskFilter docGenerationFilter = new DbTaskFilter();
        docGenerationFilter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_DOC_GENERATION));
        docGenerationFilter.setDashboardOid(dashboardOid);
        list.add(new DependencyDefinition((DbDefaultFilter)docGenerationFilter, SessionParameterType.TASK));
        return list;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbPageLayoutFilter pageLayoutFilter = new DbPageLayoutFilter();
        pageLayoutFilter.setOwnerEntityOid(data.getEntityOid());
        pageLayoutFilter.setSelectForDisplayType(5);
        pageLayoutFilter.setUsedByDashBoard(oid);
        PageLayoutDao pageLayoutDao = this.daoFactory.getPageLayoutDao();
        l.addAll(pageLayoutDao.listAll((DbDefaultFilter)pageLayoutFilter, 1));
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setOwnerEntityOid(data.getEntityOid());
        reportFilter.setSelectForDisplayType(5);
        reportFilter.setUsedByDashBoard(oid);
        ReportDao reportDao = this.daoFactory.getReportDao();
        l.addAll(reportDao.listAll((DbDefaultFilter)reportFilter, 1));
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(data.getEntityOid());
        entityFilter.setSelectForDisplayType(5);
        entityFilter.setUsedByDashBoard(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        DbExternSessionFilter externSessionFilter = new DbExternSessionFilter();
        externSessionFilter.setUsedByDashBoard(oid);
        ExternSessionDao externSessionDao = this.daoFactory.getExternSessionDao();
        l.addAll(externSessionDao.listAll((DbDefaultFilter)externSessionFilter, 1));
        DbTextFilter textFilter = new DbTextFilter();
        textFilter.setUsedByDashBoard(oid);
        TextDao textDao = this.daoFactory.getTextDao();
        l.addAll(textDao.listAll((DbDefaultFilter)textFilter, 1));
        return l;
    }

    public BeanDashBoard getCore(String name) throws DashboardException {
        BeanDashBoard bean = this.helper.get((Dao)this.dao, name, 1, BeanDashBoard.class);
        this.updateNames(bean);
        return bean;
    }
}

