/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.DataStructureHelperDataBase;
import com.prelytis.dashboard.model.helper.DataStructureHelperDataDictionnary;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.QueryDSTableHelper;
import com.prelytis.dashboard.value.data.BeanQueryDataStructure;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoin;
import com.prelytis.dashboard.value.data.BeanQueryMultiWorld;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DSField;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Table;
import java.sql.SQLException;
import java.util.List;

public abstract class DataStructureHelper<T extends BeanQueryStar> {
    public static final int TABLE_DIM_TYPE = 2;
    public static final int FIELD_IMPORT_ALL = 1;
    public static final int FIELD_IMPORT_NOKEYS = 2;
    public static final int FIELD_IMPORT_NONE = 3;
    protected final QueryDSTableHelper tableContainer;
    protected final T ds;
    protected final ExpressionEvaluationData data;
    protected GuidFactory guidFactory = GuidFactory.getInstance();

    DataStructureHelper(T ds, ExpressionEvaluationData data) {
        this.tableContainer = new QueryDSTableHelper(ds, data.getLocale());
        this.ds = ds;
        this.data = data;
    }

    public abstract void addTable(BeanQueryDataStructureTable var1, Table var2, BeanQueryDataStructureTableJoin var3) throws DashboardException;

    public abstract BeanQueryDataStructureTable detect(Table var1, int var2, int var3) throws DashboardException;

    public abstract BeanQueryDataStructureTable detect(int var1, int var2, int var3) throws DashboardException;

    public BeanQueryDataStructureTable findTable(List<BeanQueryDataStructureTable> childList, Table table, String join) {
        BeanQueryDataStructureTable defaultTable = null;
        for (int i = 0; i < childList.size(); ++i) {
            BeanQueryDataStructureTable dsTable = childList.get(i);
            if (!dsTable.getTable().equals((Object)table)) continue;
            if (join.equals(dsTable.getJoin().getJoinName())) {
                return dsTable;
            }
            if (defaultTable != null) continue;
            defaultTable = dsTable;
        }
        return defaultTable;
    }

    public abstract List<DSField> listField(BeanQueryDataStructureTable var1) throws DashboardException;

    public abstract void updateFieldList(BeanQueryDataStructureTable var1, List<DSField> var2);

    protected DashboardException getDashboardException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        if (e instanceof SQLException) {
            return ExceptionHelper.getInstance(this.data.getLocale()).createDashboardException("dbError", new String[]{e.getMessage()}, null);
        }
        return new DashboardException((Throwable)e);
    }

    public static final DataStructureHelper<?> getInstance(DaoFactory daoFactory, BeanQueryStar ds, ExpressionEvaluationData data) throws DashboardException {
        if (ds instanceof BeanQueryMultiWorld) {
            return new DataStructureHelperDataDictionnary(daoFactory, (BeanQueryMultiWorld)ds, data);
        }
        WorldDao worldDao = daoFactory.getWorldDao();
        BeanWorldDefinition world = (BeanWorldDefinition)worldDao.getDefinition(ds.getWorldName());
        WorldHelper worldHelper = WorldHelper.getInstance((DaoFactory)daoFactory, (BeanWorldDefinition)world, (ExpressionEvaluationData)data);
        return new DataStructureHelperDataBase((BeanQueryDataStructure)ds, data, worldHelper);
    }

    public void refresh() throws DashboardException {
        if (this.ds.getTableFact() != null) {
            this.refresh(this.ds.getTableFact());
        }
    }

    private void refresh(BeanQueryDataStructureTable table) throws DashboardException {
        List<DSField> list = this.listField(table);
        this.updateFieldList(table, list);
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            this.refresh(t);
        }
    }
}

