/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.db.operator.ConnectionHelper;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.DataStructureHelper;
import com.prelytis.dashboard.value.data.BeanQueryDataStructure;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoin;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoinElement;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableKey;
import com.prelytis.dashboard.value.data.DSField;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.DatatypesHelper;
import com.prelytis.dashboard.value.util.DateTruncation;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.IPoolDBInfo;
import com.prelytis.dashboard.value.util.Table;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

class DataStructureHelperDataBase
extends DataStructureHelper<BeanQueryDataStructure> {
    private final WorldHelper worldHelper;

    DataStructureHelperDataBase(BeanQueryDataStructure ds, ExpressionEvaluationData data, WorldHelper worldHelper) {
        super(ds, data);
        this.worldHelper = worldHelper;
    }

    private String getCatalog(BeanQueryDataStructureTable table) {
        return this.worldHelper.getCatalog(table.getCatalog());
    }

    private String getSchema(BeanQueryDataStructureTable table) {
        return this.worldHelper.getSchema(table.getSchema());
    }

    private String getTableName(BeanQueryDataStructureTable table) {
        return this.worldHelper.getTable(table.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanQueryDataStructureTable detect(Table table, int level, int importField) throws DashboardException {
        BeanQueryDataStructureTable beanQueryDataStructureTable;
        Connection con = ConnectionHelper.getConnection((IPoolDBInfo)this.worldHelper.getPoolDbInfo());
        try {
            DatabaseMetaData dmd = con.getMetaData();
            BeanQueryDataStructureTable dsTable = this.tableContainer.initFactTable(table);
            this.build(dmd, dsTable, level, importField);
            beanQueryDataStructureTable = dsTable;
        }
        catch (Throwable throwable) {
            try {
                con.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw this.getDashboardException(e);
            }
        }
        con.close();
        return beanQueryDataStructureTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanQueryDataStructureTable detect(int tableId, int level, int importField) throws DashboardException {
        BeanQueryDataStructureTable beanQueryDataStructureTable;
        Connection con = ConnectionHelper.getConnection((IPoolDBInfo)this.worldHelper.getPoolDbInfo());
        try {
            DatabaseMetaData dmd = con.getMetaData();
            String[] types = null;
            BeanQueryDataStructureTable parentTable = this.tableContainer.findTableById(tableId);
            boolean exist = false;
            try (ResultSet rs = dmd.getTables(this.getCatalog(parentTable), this.getSchema(parentTable), this.getTableName(parentTable), types);){
                exist = rs.next();
            }
            if (exist) {
                this.build(dmd, parentTable, level, importField);
            }
            beanQueryDataStructureTable = parentTable;
        }
        catch (Throwable throwable) {
            try {
                con.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw this.getDashboardException(e);
            }
        }
        con.close();
        return beanQueryDataStructureTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(DatabaseMetaData dmd, BeanQueryDataStructureTable parentTable, int level, int importField) throws DashboardException {
        try {
            List childList = parentTable.getTableChildList();
            if (level > 1) {
                try (ResultSet rs = dmd.getImportedKeys(this.getCatalog(parentTable), this.getSchema(parentTable), this.getTableName(parentTable));){
                    while (rs.next()) {
                        Table table = new Table(rs.getString(1), rs.getString(2), rs.getString(3));
                        String pkColName = rs.getString(4);
                        String fkColName = rs.getString(8);
                        String fkName = rs.getString(12);
                        String pkName = rs.getString(13);
                        BeanQueryDataStructureTable dsTable = this.findTable(childList, table, fkName);
                        if (dsTable == null) {
                            this.caracTable(parentTable, table, fkColName, pkColName, fkName, pkName);
                            continue;
                        }
                        if (fkName == null) continue;
                        if (!fkName.equals(dsTable.getJoin().getJoinName())) {
                            this.caracTable(parentTable, table, fkColName, pkColName, fkName, pkName);
                            continue;
                        }
                        BeanQueryDataStructureTableJoin join = dsTable.getJoin();
                        List joinEltList = join.getJoinElementList();
                        BeanQueryDataStructureTableJoinElement tableJoinElement = new BeanQueryDataStructureTableJoinElement();
                        tableJoinElement.setRightField(fkColName);
                        tableJoinElement.setLeftField(pkColName);
                        tableJoinElement.setId(joinEltList.size());
                        joinEltList.add(tableJoinElement);
                    }
                }
                catch (Exception e) {
                    throw this.getDashboardException(e);
                }
            }
            this.buildFieldList(dmd, parentTable, importField);
            this.buildKeyList(dmd, parentTable);
            BeanQueryDataStructureTableJoin join = parentTable.getJoin();
            if (importField == 2 && join != null) {
                List joineEltList = join.getJoinElementList();
                List fieldList = parentTable.getTableFieldList();
                block8: for (int i = 0; i < joineEltList.size(); ++i) {
                    for (int j = 0; j < fieldList.size(); ++j) {
                        BeanQueryDataStructureTableField fieldJ = (BeanQueryDataStructureTableField)fieldList.get(j);
                        if (!fieldJ.getSqlField().equals(((BeanQueryDataStructureTableJoinElement)joineEltList.get(i)).getRightField())) continue;
                        fieldJ.setActive(false);
                        break;
                    }
                    BeanQueryDataStructureTable gdParentTable = parentTable.getParentTable();
                    List gdpfieldList = gdParentTable.getTableFieldList();
                    for (int j = 0; j < gdpfieldList.size(); ++j) {
                        BeanQueryDataStructureTableField fieldPrntJ = (BeanQueryDataStructureTableField)gdpfieldList.get(j);
                        if (!fieldPrntJ.getSqlField().equals(((BeanQueryDataStructureTableJoinElement)joineEltList.get(i)).getRightField())) continue;
                        fieldPrntJ.setActive(false);
                        continue block8;
                    }
                }
            }
            int newLevel = level - 1;
            for (int i = 0; i < childList.size(); ++i) {
                this.build(dmd, (BeanQueryDataStructureTable)childList.get(i), newLevel, importField);
            }
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildKeyList(DatabaseMetaData dmd, BeanQueryDataStructureTable parentTable) throws DashboardException {
        try {
            ArrayList<String> keyEltList;
            HashMap<List<String>, String> indexNameMap = new HashMap<List<String>, String>();
            for (BeanQueryDataStructureTableKey key : parentTable.getDsTableKeyList()) {
                indexNameMap.put(key.getFieldList(), key.getName());
            }
            parentTable.getDsTableKeyList().clear();
            HashSet<ArrayList<String>> addedKeys = new HashSet<ArrayList<String>>();
            try (ResultSet rs = dmd.getPrimaryKeys(this.getCatalog(parentTable), this.getSchema(parentTable), this.getTableName(parentTable));){
                TreeMap<Integer, String> keyEltMap = new TreeMap<Integer, String>();
                while (rs.next()) {
                    keyEltMap.put(rs.getInt(5), rs.getString(4));
                }
                keyEltList = new ArrayList<String>(keyEltMap.values());
                if (!addedKeys.contains(keyEltList)) {
                    this.tableContainer.addKey(parentTable, this.getIndexName(indexNameMap, keyEltList), true, keyEltList);
                    addedKeys.add(keyEltList);
                }
            }
            rs = dmd.getIndexInfo(this.getCatalog(parentTable), this.getSchema(parentTable), this.getTableName(parentTable), true, true);
            try {
                int lastOrdPos = -1;
                keyEltList = new ArrayList();
                while (rs.next()) {
                    String indexName = rs.getString(6);
                    if (rs.wasNull()) {
                        indexName = null;
                    }
                    int ordPos = rs.getInt(8);
                    String colName = rs.getString(9);
                    if (rs.wasNull()) {
                        colName = null;
                    }
                    if (colName == null || indexName == null) continue;
                    if (lastOrdPos != -1 && ordPos <= lastOrdPos) {
                        if (!addedKeys.contains(keyEltList)) {
                            this.tableContainer.addKey(parentTable, this.getIndexName(indexNameMap, keyEltList), false, keyEltList);
                            addedKeys.add(keyEltList);
                        }
                        keyEltList = new ArrayList();
                        lastOrdPos = -1;
                    } else {
                        lastOrdPos = ordPos;
                    }
                    keyEltList.add(colName);
                }
                if (!keyEltList.isEmpty() && !addedKeys.contains(keyEltList)) {
                    this.tableContainer.addKey(parentTable, this.getIndexName(indexNameMap, keyEltList), false, keyEltList);
                    addedKeys.add(keyEltList);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    private String getIndexName(Map<List<String>, String> indexNameMap, List<String> keyEltList) {
        String indexName = indexNameMap.get(keyEltList);
        if (indexName != null && !"".equals(indexName)) {
            return indexName;
        }
        return this.guidFactory.generateGUID(keyEltList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFieldList(BeanQueryDataStructureTable parentTable, int importField) throws DashboardException {
        try (Connection con = ConnectionHelper.getConnection((IPoolDBInfo)this.worldHelper.getPoolDbInfo());){
            DatabaseMetaData dmd = con.getMetaData();
            this.buildFieldList(dmd, parentTable, importField);
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFieldList(DatabaseMetaData dmd, BeanQueryDataStructureTable parentTable, int importField) throws DashboardException {
        try {
            List fieldList = parentTable.getTableFieldList();
            assert (fieldList.isEmpty());
            String c = this.getCatalog(parentTable);
            String s = this.getSchema(parentTable);
            String t = this.getTableName(parentTable);
            HashSet<String> insertableColumns = new HashSet<String>();
            HashSet<String> updatableColumns = new HashSet<String>();
            boolean usePriv = this.fillPrivileges(dmd, insertableColumns, updatableColumns, c, s, t);
            try (ResultSet rs = dmd.getColumns(c, s, t, null);){
                ResultSetMetaData rmd = rs.getMetaData();
                int nbCols = rmd.getColumnCount();
                if (nbCols < 23) {
                    Logger.getLogger(DataStructureHelperDataBase.class).warn((Object)("DatabaseMetaData.getColumns() should return 23 columns (not " + nbCols + ")"));
                }
                while (rs.next()) {
                    boolean updatable;
                    DataType datatype = DatatypesHelper.getDatatypeFromSql((int)rs.getInt(5));
                    if (datatype == null || datatype.equals((Object)DataType.BLOB)) continue;
                    String sql = rs.getString(4);
                    boolean active = importField != 3;
                    int size = rs.getInt(7);
                    int digits = rs.getInt(9);
                    boolean nullable = 1 == rs.getInt(11) && "YES".equals(rs.getString(18));
                    String desc = rs.getString(12);
                    if (desc == null || "".equals(desc)) {
                        desc = sql;
                    }
                    boolean autoincrement = nbCols >= 23 ? "YES".equals(rs.getString(23)) : false;
                    boolean insertable = usePriv ? insertableColumns.contains(sql) : true;
                    boolean bl = updatable = usePriv ? updatableColumns.contains(sql) : true;
                    String name = this.buildFieldName(parentTable, sql);
                    BeanQueryDataStructureTableField field = this.addField(parentTable, sql, name, desc, datatype, DateTruncation.NONE, active, size, digits, nullable, autoincrement, insertable, updatable);
                    if (!DataType.isDate((DataType)field.getDataType())) continue;
                    for (DateTruncation dt : DateTruncation.values()) {
                        if (dt == DateTruncation.NONE) continue;
                        this.addField(parentTable, sql, this.getName(name, dt), this.getDescription(desc, dt), datatype, dt, active, size, digits, nullable, autoincrement, insertable, updatable);
                    }
                }
            }
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    private String getDescription(String desc, DateTruncation dt) {
        StringBuilder sb = new StringBuilder();
        if (desc != null) {
            sb.append(desc);
        }
        switch (dt) {
            case DAY: {
                sb.append(" [DAY]");
                break;
            }
            case HOUR: {
                sb.append(" [HOUR]");
                break;
            }
            case MONTH: {
                sb.append(" [MONTH]");
                break;
            }
            case WEEK: {
                sb.append(" [WEEK]");
                break;
            }
            case YEAR: {
                sb.append(" [YEAR]");
            }
        }
        return sb.toString();
    }

    private String getName(String name, DateTruncation dt) {
        StringBuilder sb = new StringBuilder(name);
        switch (dt) {
            case DAY: {
                sb.append("/d");
                break;
            }
            case HOUR: {
                sb.append("/h");
                break;
            }
            case MONTH: {
                sb.append("/m");
                break;
            }
            case WEEK: {
                sb.append("/w");
                break;
            }
            case YEAR: {
                sb.append("/y");
            }
        }
        return sb.toString();
    }

    private BeanQueryDataStructureTableField addField(BeanQueryDataStructureTable parentTable, String sql, String name, String desc, DataType datatype, DateTruncation dt, boolean active, int size, int digits, boolean nullable, boolean autoincrement, boolean insertable, boolean updatable) {
        String descKey = this.guidFactory.generateGUID((Object)parentTable);
        String fieldGroupName = this.getFieldGroupName(datatype);
        BeanQueryDataStructureTableField field = this.tableContainer.addField(parentTable, sql, name, descKey, datatype, dt, fieldGroupName, active, size, digits, nullable);
        field.getDescriptionMap().put(this.data.getLocale(), desc);
        field.setInsertable(insertable);
        field.setUpdatable(updatable);
        field.setAutoincrement(autoincrement);
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillPrivileges(DatabaseMetaData dmd, Set<String> insertableColumns, Set<String> updatableColumns, String c, String s, String t) {
        boolean usePriv = false;
        try (ResultSet rs = dmd.getColumnPrivileges(c, s, t, null);){
            while (rs.next()) {
                if (!usePriv) {
                    usePriv = true;
                }
                if ("INSERT".equals(rs.getString(7))) {
                    insertableColumns.add(rs.getString(4));
                    continue;
                }
                if (!"UPDATE".equals(rs.getString(7))) continue;
                updatableColumns.add(rs.getString(4));
            }
        }
        catch (Exception e) {
            usePriv = false;
        }
        return usePriv;
    }

    private String buildFieldName(BeanQueryDataStructureTable parentTable, String sql) {
        String tableName = parentTable.getName();
        if (sql.length() > 60) {
            return sql.substring(0, 60);
        }
        if (tableName == null || sql.length() + tableName.length() > 59) {
            return sql;
        }
        return new StringBuffer().append(tableName).append(".").append(sql).toString();
    }

    private void caracTable(BeanQueryDataStructureTable parentTable, Table table, String left, String right, String joinName, String pk_name) throws Exception {
        BeanQueryDataStructureTable dsTable = this.tableContainer.addTable(parentTable, table);
        BeanQueryDataStructureTableJoin tableJoin = dsTable.getJoin();
        tableJoin.setJoinType(1);
        BeanQueryDataStructureTableJoinElement tableJoinElement = new BeanQueryDataStructureTableJoinElement();
        tableJoinElement.setRightField(right);
        tableJoinElement.setLeftField(left);
        tableJoin.setJoinName(joinName);
        tableJoin.getJoinElementList().add(tableJoinElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DSField> listField(BeanQueryDataStructureTable parentTable) throws DashboardException {
        try {
            HashMap initialMap = new HashMap();
            HashMap initialLCMap = new HashMap();
            List fieldList = parentTable.getTableFieldList();
            for (int i = 0; i < fieldList.size(); ++i) {
                BeanQueryDataStructureTableField field = (BeanQueryDataStructureTableField)fieldList.get(i);
                DateTruncation dt = field.getDateTruncation() == null ? DateTruncation.NONE : field.getDateTruncation();
                DSField dsField = new DSField();
                dsField.setSqlField(field.getSqlField());
                dsField.setName(field.getName());
                String description = (String)field.getDescriptionMap().get(this.data.getLocale());
                if (description == null) {
                    description = field.getName();
                }
                dsField.setDescription(description);
                dsField.setDataType(field.getDataType());
                dsField.setDateTruncation(dt);
                dsField.setSelected(field.isActive());
                dsField.setFieldGroupName(field.getFieldGroupName());
                dsField.setSize(field.getSize());
                dsField.setDigits(field.getDigits());
                dsField.setNullable(field.isNullable());
                dsField.setInsertable(field.isInsertable());
                dsField.setUpdatable(field.isUpdatable());
                dsField.setAutoincrement(field.isAutoincrement());
                this.getMap(initialMap, dt).put(dsField.getSqlField(), dsField);
                this.getMap(initialLCMap, dt).put(dsField.getSqlField().toLowerCase(), dsField);
            }
            ArrayList<DSField> list = new ArrayList<DSField>();
            try (Connection con = ConnectionHelper.getConnection((IPoolDBInfo)this.worldHelper.getPoolDbInfo());){
                DatabaseMetaData dmd = con.getMetaData();
                this.buildKeyList(dmd, parentTable);
                String c = this.getCatalog(parentTable);
                String s = this.getSchema(parentTable);
                String t = this.getTableName(parentTable);
                HashSet<String> insertableColumns = new HashSet<String>();
                HashSet<String> updatableColumns = new HashSet<String>();
                boolean usePriv = this.fillPrivileges(dmd, insertableColumns, updatableColumns, c, s, t);
                try (ResultSet rs = dmd.getColumns(c, s, t, null);){
                    ResultSetMetaData rmd = rs.getMetaData();
                    int nbCols = rmd.getColumnCount();
                    if (nbCols < 23) {
                        Logger.getLogger(DataStructureHelperDataBase.class).warn((Object)("DatabaseMetaData.getColumns() should return 23 columns (not " + nbCols + ")"));
                    }
                    Map<String, DSField> iMap = this.getDefaultMap(initialMap);
                    Map<String, DSField> iLCMap = this.getDefaultMap(initialLCMap);
                    while (rs.next()) {
                        boolean autoincrement;
                        String sql = rs.getString(4);
                        short sqlType = rs.getShort(5);
                        int fieldSize = rs.getInt(7);
                        int fieldPrecision = rs.getInt(9);
                        String desc = rs.getString(12);
                        boolean nullable = 1 == rs.getInt(11) && "YES".equals(rs.getString(18));
                        boolean bl = autoincrement = nbCols >= 23 ? "YES".equals(rs.getString(23)) : false;
                        DataType dataType = DatatypesHelper.getDatatypeFromSql((int)sqlType);
                        if (dataType == null || dataType.equals((Object)DataType.BLOB)) continue;
                        boolean insertable = usePriv ? insertableColumns.contains(sql) : true;
                        boolean updatable = usePriv ? updatableColumns.contains(sql) : true;
                        DSField fld = this.getField(parentTable, iMap, iLCMap, sql, desc, dataType, DateTruncation.NONE, fieldSize, fieldPrecision, nullable, autoincrement, insertable, updatable);
                        list.add(fld);
                        if (!DataType.isDate((DataType)dataType)) continue;
                        for (DateTruncation dt : DateTruncation.values()) {
                            if (dt == DateTruncation.NONE) continue;
                            DataType newDatatype = dt == DateTruncation.HOUR ? DataType.TIMESTAMP : DataType.DATE;
                            list.add(this.getField(parentTable, this.getMap(initialMap, dt), this.getMap(initialLCMap, dt), sql, this.getName(fld.getDescription(), dt), newDatatype, dt, fieldSize, fieldPrecision, nullable, autoincrement, insertable, updatable));
                        }
                    }
                }
            }
            return list;
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    private DSField getField(BeanQueryDataStructureTable parentTable, Map<String, DSField> iMap, Map<String, DSField> iLCMap, String sql, String desc, DataType datatype, DateTruncation dt, int fieldSize, int fieldPrecision, boolean nullable, boolean autoincrement, boolean insertable, boolean updatable) {
        DSField dsField = iMap.get(sql);
        if (dsField == null) {
            dsField = iLCMap.remove(sql.toLowerCase());
            if (dsField != null) {
                iMap.remove(dsField.getSqlField());
            }
        } else {
            iLCMap.remove(sql.toLowerCase());
        }
        if (dsField == null) {
            dsField = new DSField();
            String name = this.buildFieldName(parentTable, this.getName(sql, dt));
            dsField.setName(name);
            dsField.setDescription(desc == null || "".equals(desc) ? sql : desc);
            dsField.setDataType(datatype);
            dsField.setDateTruncation(dt);
            dsField.setSelected(false);
            String fieldGroupName = this.getFieldGroupName(datatype);
            dsField.setFieldGroupName(fieldGroupName);
            dsField.setSize(fieldSize);
            dsField.setDigits(fieldPrecision);
            dsField.setNullable(nullable);
            dsField.setAutoincrement(autoincrement);
            dsField.setInsertable(insertable);
            dsField.setUpdatable(updatable);
        } else if (dsField.getSize() < 0) {
            dsField.setSize(fieldSize);
            dsField.setDigits(fieldPrecision);
            dsField.setNullable(nullable);
            dsField.setAutoincrement(autoincrement);
            dsField.setInsertable(insertable);
            dsField.setUpdatable(updatable);
        }
        dsField.setSqlField(sql);
        dsField.setJdbcDataType(datatype.getSqlType());
        return dsField;
    }

    private <T> Map<String, T> getDefaultMap(Map<DateTruncation, Map<String, T>> initialMap) {
        return this.getMap(initialMap, DateTruncation.NONE);
    }

    private <T> Map<String, T> getMap(Map<DateTruncation, Map<String, T>> initialMap, DateTruncation dt) {
        Map<String, T> m = initialMap.get(dt);
        if (m == null) {
            m = new HashMap<String, T>();
            initialMap.put(dt, m);
        }
        return m;
    }

    private String getFieldGroupName(DataType datatype) {
        if (DataType.isNumeric((DataType)datatype)) {
            return "Metric";
        }
        if (DataType.isDate((DataType)datatype)) {
            return "TimeAxis";
        }
        return "Attribut";
    }

    @Override
    public void updateFieldList(BeanQueryDataStructureTable parentTable, List<DSField> list) {
        HashMap initialMap = new HashMap();
        List fieldList = parentTable.getTableFieldList();
        ArrayList<BeanQueryDataStructureTableField> toDel = new ArrayList<BeanQueryDataStructureTableField>();
        for (BeanQueryDataStructureTableField field : fieldList) {
            BeanQueryDataStructureTableField f = this.getMap(initialMap, field.getDateTruncation()).put(field.getSqlField(), field);
            if (f == null) continue;
            toDel.add(f);
        }
        for (DSField dsField : list) {
            Map m = (Map)initialMap.get(dsField.getDateTruncation());
            BeanQueryDataStructureTableField field = m != null ? (BeanQueryDataStructureTableField)m.remove(dsField.getSqlField()) : null;
            String key = null;
            if (field == null) {
                key = this.guidFactory.generateGUID((Object)dsField);
                field = this.tableContainer.addField(parentTable, dsField.getSqlField(), dsField.getName(), key, dsField.getDataType(), dsField.getDateTruncation(), dsField.getFieldGroupName(), dsField.isSelected(), dsField.getSize(), dsField.getDigits(), dsField.isNullable());
                field.setDescriptionKey(key);
                field.setInsertable(dsField.isInsertable());
                field.setUpdatable(dsField.isUpdatable());
                field.setAutoincrement(dsField.isAutoincrement());
            } else {
                key = field.getDescriptionKey();
                field.setName(dsField.getName());
                field.setDataType(dsField.getDataType());
                field.setFieldGroupName(dsField.getFieldGroupName());
                field.setActive(dsField.isSelected());
                field.setSize(dsField.getSize());
                field.setDigits(dsField.getDigits());
                field.setNullable(dsField.isNullable());
                field.setInsertable(dsField.isInsertable());
                field.setUpdatable(dsField.isUpdatable());
                field.setAutoincrement(dsField.isAutoincrement());
            }
            field.getDescriptionMap().put(this.data.getLocale(), dsField.getDescription());
        }
        for (Map m : initialMap.values()) {
            for (BeanQueryDataStructureTableField field : m.values()) {
                this.tableContainer.deleteField(field);
            }
        }
        for (BeanQueryDataStructureTableField field : toDel) {
            this.tableContainer.deleteField(field);
        }
    }

    @Override
    public void addTable(BeanQueryDataStructureTable parent, Table newTable, BeanQueryDataStructureTableJoin list) throws DashboardException {
        BeanQueryDataStructureTable table = this.tableContainer.addTable(parent, newTable);
        if (list != null) {
            BeanQueryDataStructureTableJoin join = table.getJoin();
            if (join != list) {
                join.getJoinElementList().clear();
                join.setJoinName(list.getJoinName());
                join.setJoinType(list.getJoinType());
            }
            for (int i = 0; i < list.getJoinElementList().size(); ++i) {
                BeanQueryDataStructureTableJoinElement elt = (BeanQueryDataStructureTableJoinElement)list.getJoinElementList().get(i);
                elt.setJoin(join);
                elt.setId(i);
                if (join == list) continue;
                join.getJoinElementList().add(elt);
            }
        }
        this.buildFieldList(table, 1);
    }
}

