/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.model.helper.DataStructureHelper;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.value.data.BeanQuery;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoin;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoinElement;
import com.prelytis.dashboard.value.data.BeanQueryMultiWorld;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanQuerySQLFilter;
import com.prelytis.dashboard.value.data.DSField;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.DateTruncation;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DataStructureHelperDataDictionnary
extends DataStructureHelper<BeanQueryMultiWorld> {
    private final DaoFactory daoFactory;

    DataStructureHelperDataDictionnary(DaoFactory daoFactory, BeanQueryMultiWorld ds, ExpressionEvaluationData data) {
        super(ds, data);
        this.daoFactory = daoFactory;
    }

    private IQueryDefinition getQuery(String tableName) throws DashboardException {
        QueryHelper queryHelper = QueryHelper.getInstance(this.daoFactory);
        IQueryDefinition query = queryHelper.getFinal(tableName);
        EntityHelper entityHelper = new EntityHelper(this.daoFactory);
        EntityDao.Relation relation = entityHelper.getRelation(((BeanQueryMultiWorld)this.ds).getOwnerEntOID(), query.getOwnerEntOID());
        if (relation != EntityDao.Relation.SAME && relation != EntityDao.Relation.PARENT) {
            StringBuffer sb = new StringBuffer();
            sb.append("Cannot use query '").append(tableName).append("' in query '").append(((BeanQueryMultiWorld)this.ds).getName()).append("' (see entity rules))");
            throw new SecurityException(sb.toString());
        }
        return query;
    }

    private void buildFieldList(IQueryDefinition query, BeanQueryDataStructureTable parentTable, int importField) throws DashboardException {
        try {
            HashMap<String, String[]> fieldMap = new HashMap<String, String[]>();
            List fieldList = parentTable.getTableFieldList();
            for (int i = fieldList.size() - 1; i >= 0; --i) {
                BeanQueryDataStructureTableField field = (BeanQueryDataStructureTableField)fieldList.get(i);
                fieldMap.put(field.getSqlField(), new String[]{field.getName(), field.getDescriptionKey()});
                this.tableContainer.deleteField(field);
            }
            for (BeanQuerySQLField sqlField : query.getBeanQuerySQLFieldList()) {
                String sql = sqlField.getName();
                String[] tmp = (String[])fieldMap.get(sql);
                String descKey = null;
                String name = null;
                if (tmp != null) {
                    name = tmp[0];
                    descKey = tmp[1];
                } else {
                    name = this.buildFieldName(parentTable, sql);
                }
                boolean active = importField != 3 && sqlField.isActive();
                BeanQueryDataStructureTableField field = this.tableContainer.addField(parentTable, sql, name, descKey, sqlField.getDataType(), DateTruncation.NONE, sqlField.getFieldGroupName(), active, sqlField.getSize(), sqlField.getDigits(), sqlField.isNullable());
                field.getDescriptionMap().putAll(sqlField.getDescriptionMap());
            }
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    private String buildFieldName(BeanQueryDataStructureTable parentTable, String sql) {
        String tableName = parentTable.getName();
        if (sql.length() > 60) {
            return sql.substring(0, 60);
        }
        if (sql.length() + tableName.length() > 59) {
            return sql;
        }
        return new StringBuffer().append(tableName).append(".").append(sql).toString();
    }

    @Override
    public BeanQueryDataStructureTable detect(Table table, int level, int importField) throws DashboardException {
        BeanQueryDataStructureTable dsTable = this.tableContainer.initFactTable(table);
        this.build(dsTable, level, importField);
        return dsTable;
    }

    @Override
    public BeanQueryDataStructureTable detect(int tableId, int level, int importField) throws DashboardException {
        BeanQueryDataStructureTable parentTable = this.tableContainer.findTableById(tableId);
        QueryDao queryDao = this.daoFactory.getQueryDao();
        BeanQuery query = (BeanQuery)queryDao.getCore(parentTable.getName());
        EntityHelper entityHelper = new EntityHelper(this.daoFactory);
        EntityDao.Relation relation = entityHelper.getRelation(((BeanQueryMultiWorld)this.ds).getOwnerEntOID(), query.getOwnerEntOID());
        if (relation != EntityDao.Relation.SAME && relation != EntityDao.Relation.CHILD) {
            StringBuffer sb = new StringBuffer();
            sb.append("Cannot use query '").append(query.getName()).append("' in query '").append(((BeanQueryMultiWorld)this.ds).getName()).append("' (see entity rules))");
            throw new SecurityException(sb.toString());
        }
        this.build(parentTable, level, importField);
        return parentTable;
    }

    @Override
    public List<DSField> listField(BeanQueryDataStructureTable parentTable) throws DashboardException {
        try {
            HashMap<String, DSField> initialMap = new HashMap<String, DSField>();
            List fieldList = parentTable.getTableFieldList();
            for (int i = 0; i < fieldList.size(); ++i) {
                BeanQueryDataStructureTableField field = (BeanQueryDataStructureTableField)fieldList.get(i);
                DSField dsField = new DSField();
                dsField.setSqlField(field.getSqlField());
                dsField.setName(field.getName());
                String description = (String)field.getDescriptionMap().get(this.data.getLocale());
                if (description == null) {
                    description = field.getName();
                }
                dsField.setDescription(description);
                dsField.setDataType(field.getDataType());
                dsField.setSelected(field.isActive());
                dsField.setFieldGroupName(field.getFieldGroupName());
                dsField.setSize(field.getSize());
                dsField.setDigits(field.getDigits());
                dsField.setNullable(field.isNullable());
                dsField.setInsertable(field.isInsertable());
                dsField.setUpdatable(field.isUpdatable());
                dsField.setAutoincrement(field.isAutoincrement());
                initialMap.put(dsField.getSqlField(), dsField);
            }
            ArrayList<DSField> list = new ArrayList<DSField>();
            IQueryDefinition queryDef = this.getQuery(parentTable.getName());
            for (BeanQuerySQLField sqlField : queryDef.getBeanQuerySQLFieldList()) {
                String sql = sqlField.getName();
                DataType datatype = sqlField.getDataType();
                DSField dsField = (DSField)initialMap.remove(sql);
                if (dsField == null) {
                    dsField = new DSField();
                    dsField.setSqlField(sql);
                    dsField.setName(sql);
                    dsField.setDescription(sql);
                    dsField.setDataType(datatype);
                    dsField.setSelected(false);
                    dsField.setFieldGroupName(sqlField.getFieldGroupName());
                }
                dsField.setJdbcDataType(datatype.getSqlType());
                list.add(dsField);
            }
            this.updateFilter(queryDef, parentTable);
            return list;
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    @Override
    public void updateFieldList(BeanQueryDataStructureTable parentTable, List<DSField> list) {
        int i;
        HashMap<String, BeanQueryDataStructureTableField> initialMap = new HashMap<String, BeanQueryDataStructureTableField>();
        List fieldList = parentTable.getTableFieldList();
        for (i = 0; i < fieldList.size(); ++i) {
            BeanQueryDataStructureTableField field = (BeanQueryDataStructureTableField)fieldList.get(i);
            initialMap.put(field.getSqlField(), field);
        }
        for (i = 0; i < list.size(); ++i) {
            DSField dsField = list.get(i);
            BeanQueryDataStructureTableField field = (BeanQueryDataStructureTableField)initialMap.remove(dsField.getSqlField());
            String key = null;
            if (field == null) {
                key = this.guidFactory.generateGUID((Object)dsField);
                field = this.tableContainer.addField(parentTable, dsField.getSqlField(), dsField.getName(), key, dsField.getDataType(), dsField.getDateTruncation(), dsField.getFieldGroupName(), dsField.isSelected(), dsField.getSize(), dsField.getDigits(), dsField.isNullable());
            } else {
                key = field.getDescriptionKey();
                field.setName(dsField.getName());
                field.setDataType(dsField.getDataType());
                field.setFieldGroupName(dsField.getFieldGroupName());
                field.setActive(dsField.isSelected());
                field.setSize(dsField.getSize());
                field.setDigits(dsField.getDigits());
                field.setNullable(dsField.isNullable());
            }
            field.setInsertable(dsField.isInsertable());
            field.setUpdatable(dsField.isUpdatable());
            field.setAutoincrement(dsField.isAutoincrement());
            field.getDescriptionMap().put(this.data.getLocale(), dsField.getDescription());
        }
        for (BeanQueryDataStructureTableField field : initialMap.values()) {
            this.tableContainer.deleteField(field);
        }
    }

    private void build(BeanQueryDataStructureTable parentTable, int level, int importField) throws DashboardException {
        try {
            List childList = parentTable.getTableChildList();
            IQueryDefinition query = this.getQuery(parentTable.getName());
            this.buildFieldList(query, parentTable, importField);
            BeanQueryDataStructureTableJoin join = parentTable.getJoin();
            if (importField == 2 && join != null) {
                List joinEltList = join.getJoinElementList();
                List fieldList = parentTable.getTableFieldList();
                block2: for (int i = 0; i < joinEltList.size(); ++i) {
                    for (int j = 0; j < fieldList.size(); ++j) {
                        BeanQueryDataStructureTableField fieldJ = (BeanQueryDataStructureTableField)fieldList.get(j);
                        if (!fieldJ.getSqlField().equals(((BeanQueryDataStructureTableJoinElement)joinEltList.get(i)).getRightField())) continue;
                        fieldJ.setActive(false);
                        break;
                    }
                    BeanQueryDataStructureTable gdParentTable = parentTable.getParentTable();
                    List gdpfieldList = gdParentTable.getTableFieldList();
                    for (int j = 0; j < gdpfieldList.size(); ++j) {
                        BeanQueryDataStructureTableField fieldPrntJ = (BeanQueryDataStructureTableField)gdpfieldList.get(j);
                        if (!fieldPrntJ.getSqlField().equals(((BeanQueryDataStructureTableJoinElement)joinEltList.get(i)).getRightField())) continue;
                        fieldPrntJ.setActive(false);
                        continue block2;
                    }
                }
            }
            int newLevel = level - 1;
            for (int i = 0; i < childList.size(); ++i) {
                this.build((BeanQueryDataStructureTable)childList.get(i), newLevel, importField);
            }
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    @Override
    public void addTable(BeanQueryDataStructureTable parent, Table newTable, BeanQueryDataStructureTableJoin list) throws DashboardException {
        BeanQueryDataStructureTable table = this.tableContainer.addTable(parent, newTable);
        if (list != null) {
            BeanQueryDataStructureTableJoin join = table.getJoin();
            if (join != list) {
                join.getJoinElementList().clear();
                join.setJoinName(list.getJoinName());
                join.setJoinType(list.getJoinType());
            }
            for (int i = 0; i < list.getJoinElementList().size(); ++i) {
                BeanQueryDataStructureTableJoinElement elt = (BeanQueryDataStructureTableJoinElement)list.getJoinElementList().get(i);
                elt.setJoin(join);
                elt.setId(i);
                if (join == list) continue;
                join.getJoinElementList().add(elt);
            }
        }
        IQueryDefinition query = this.getQuery(table.getName());
        this.updateFilter(query, table);
        this.buildFieldList(query, table, 1);
    }

    private void updateFilter(IQueryDefinition query, BeanQueryDataStructureTable table) {
        Map filterMap = ((BeanQueryMultiWorld)this.ds).getFilterMap();
        HashSet<Integer> set = new HashSet<Integer>(filterMap.keySet());
        this.updateSet(set, table);
        for (Integer tid : filterMap.keySet()) {
            filterMap.remove(tid);
        }
        ArrayList<BeanQuerySQLFilter> filterList = (ArrayList<BeanQuerySQLFilter>)filterMap.get(table.getId());
        if (filterList == null) {
            filterList = new ArrayList<BeanQuerySQLFilter>();
            filterMap.put(table.getId(), filterList);
        } else {
            filterList.clear();
        }
        if (query.getBeanQuerySQLFilterList() != null) {
            for (BeanQuerySQLFilter filter : query.getBeanQuerySQLFilterList()) {
                if (filter.getParameter() != '1') continue;
                BeanQuerySQLFilter newFilter = new BeanQuerySQLFilter();
                newFilter.setDataType(filter.getDataType());
                newFilter.setDefaultValue(filter.getDefaultValue());
                newFilter.setDescriptionKey(filter.getDescriptionKey());
                newFilter.setFltMode(filter.getFltMode());
                newFilter.setName(this.buildFieldName(table, filter.getName()));
                newFilter.setOperand(filter.getOperand());
                newFilter.setParameter(filter.getParameter());
                newFilter.setTableId(filter.getTableId());
                newFilter.setSql(filter.getName());
                filterList.add(newFilter);
            }
        }
    }

    private void updateSet(Set<Integer> set, BeanQueryDataStructureTable table) {
        if (table == null) {
            return;
        }
        set.remove(table.getId());
        if (table.getTableChildList() == null) {
            return;
        }
        for (BeanQueryDataStructureTable c : table.getTableChildList()) {
            this.updateSet(set, c);
        }
    }
}

