/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.PersFieldDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbColorListFilter;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbLinkFilter;
import com.prelytis.dashboard.dao.filter.DbPersFieldFilter;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.dao.filter.DbStyleFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.filter.DbTextFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.dao.filter.DbWorkspaceFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.SecurityHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanEntityDefinition;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.EntityFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class EntityHelper
extends ParameterHelper
implements Dependency,
References {
    private final EntityDao dao;
    private final SecurityHelper securityHelper;

    EntityHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getEntityDao();
        this.securityHelper = SecurityHelper.getInstance(daoFactory);
    }

    public static EntityHelper getInstance(DaoFactory daoFactory) {
        return new EntityHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanEntity)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanEntityDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanEntityDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
            case REFRESH: {
                return this.getRefresh((BeanEntityDefinition)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.ENTITY);
    }

    public BeanEntityDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanEntityDefinition elt = this.dao.getDefault();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setParentEntOID(data.getEntityOid().intValue());
        elt.setParentEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.refresh(elt);
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanEntityDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.ENTITY);
    }

    private ParameterResponse getSave(BeanEntityDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.ENTITY);
    }

    public void save(BeanEntityDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanEntityDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        if (isNew) {
            this.helper.checkForSaveAsNew((Dao)this.dao, data, (Element)elt);
            elt.setObjectID(0);
            elt.setOwner(data.getUserName());
            elt.setCreationDate(new Date());
        } else {
            BeanEntity prev = (BeanEntity)this.dao.getCore(elt.getName());
            this.checkOwnerEntity(data, prev);
            this.helper.checkSaveConcurrency(data, (Bean)elt, isImport, (Bean)prev);
            if (data.getEntityName().equals(elt.getName()) && !elt.isActive()) {
                throw new SecurityException();
            }
        }
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        this.updateOids((BeanEntity)elt);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.refresh(elt);
        this.checkOwnerEntity(data, (BeanEntity)elt);
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
        this.dao.fixEntitiesParentList();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanEntity elt = this.helper.get((Dao)this.dao, name, 1, BeanEntity.class);
        this.checkOwnerEntity(data, elt);
        if (elt.getObjectID() < 100) {
            throw new SecurityException();
        }
        if (data.getEntityOid().intValue() == elt.getObjectID()) {
            throw new SecurityException();
        }
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt, 7), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanEntity elt = this.helper.get((Dao)this.dao, name, instanceType, BeanEntity.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.ENTITY);
    }

    private void updateNames(BeanEntity bean) throws DashboardException {
        bean.setParentEntityName(this.getName(SessionParameterType.ENTITY, bean.getParentEntOID()));
    }

    private void updateOids(BeanEntity bean) throws DashboardException {
        bean.setParentEntOID(this.getOid(SessionParameterType.ENTITY, bean.getParentEntityName()));
    }

    private void checkOwnerEntity(ExpressionEvaluationData data, BeanEntity elt) throws DashboardException {
        if (elt.getObjectID() == 0 ? !this.isChild(data.getEntityOid(), elt.getParentEntOID()) : !this.isChild(data.getEntityOid(), elt.getObjectID())) {
            throw new SecurityException();
        }
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanEntityDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanEntityDefinition.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setParentEntOID(data.getEntityOid().intValue());
        elt.setParentEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.ENTITY);
    }

    public boolean isChild(int entityOID, int ownerEntityOid) {
        EntityDao.Relation relation = this.getRelation(entityOID, ownerEntityOid);
        return relation == EntityDao.Relation.CHILD || relation == EntityDao.Relation.SAME;
    }

    public boolean isParent(int entityOID, int ownerEntityOid) {
        EntityDao.Relation relation = this.getRelation(entityOID, ownerEntityOid);
        return relation == EntityDao.Relation.PARENT || relation == EntityDao.Relation.SAME;
    }

    public EntityDao.Relation getRelation(int entityOid1, int entityOid2) {
        return this.securityHelper.getRelation(entityOid1, entityOid2);
    }

    public boolean hasRights(int entityOid1, int entityOid2) {
        boolean rights = this.isParent(entityOid1, entityOid2);
        boolean useSimplifiedRules = this.daoFactory.getPrelytisInfoDao().isSimplifiedRuleEnabled();
        if (useSimplifiedRules) {
            rights = rights || this.isChild(entityOid1, entityOid2);
        }
        return rights;
    }

    private ParameterResponse getRefresh(BeanEntityDefinition bean, ExpressionEvaluationData data) throws DashboardException {
        this.refresh(bean);
        return this.helper.getResponse((I18nElement)bean, data, SessionParameterType.ENTITY);
    }

    private void refresh(BeanEntityDefinition bean) {
        List persFieldList = bean.getBeanPersFieldValueList();
        Map map = this.getMap(persFieldList);
        persFieldList.clear();
        BeanEntityDefinition def = this.dao.getDefault();
        for (BeanPersFieldValue value : def.getBeanPersFieldValueList()) {
            BeanPersFieldValue v = (BeanPersFieldValue)map.get(value.getName());
            if (v != null) {
                value.setValues(v.getValues());
                value.setUseChildValues(v.isUseChildValues());
            }
            persFieldList.add(value);
        }
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.ENTITY).getAccessLevel();
            boolean restricted = false;
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.ENTITY);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
                restricted = true;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), restricted, SessionParameterType.ENTITY, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanEntity elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanEntity.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.ENTITY);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbEntityFilter filter = this.helper.getFilter(defaultFilter, data, DbEntityFilter.class);
        if (defaultFilter instanceof EntityFilter) {
            EntityFilter src = (EntityFilter)defaultFilter;
            filter.setActive(src.getActive());
        }
        List list = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : list) {
            this.updateNames((BeanEntity)elt);
        }
        return list;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt, 7), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt, int selectForDisplayType) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbColorListFilter colorListFilter = new DbColorListFilter();
        colorListFilter.setOwnerEntityOid(objectID);
        colorListFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)colorListFilter, SessionParameterType.COLOR_LIST));
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setOwnerEntityOid(objectID);
        dashboardFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)dashboardFilter, SessionParameterType.DASHBOARD));
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(objectID);
        entityFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)entityFilter, SessionParameterType.ENTITY));
        DbLinkFilter linkFilter = new DbLinkFilter();
        linkFilter.setOwnerEntityOid(objectID);
        linkFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)linkFilter, SessionParameterType.LINK));
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setOwnerEntityOid(objectID);
        queryFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)queryFilter, SessionParameterType.QUERY));
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setOwnerEntityOid(objectID);
        reportFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)reportFilter, SessionParameterType.REPORT));
        DbStyleFilter styleFilter = new DbStyleFilter();
        styleFilter.setOwnerEntityOid(objectID);
        styleFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)styleFilter, SessionParameterType.STYLE));
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setOwnerEntityOid(objectID);
        taskFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)taskFilter, SessionParameterType.TASK));
        DbTextFilter textFilter = new DbTextFilter();
        textFilter.setOwnerEntityOid(objectID);
        textFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)textFilter, SessionParameterType.TEXT));
        DbUserFilter userFilter = new DbUserFilter();
        userFilter.setEntityOid(objectID);
        userFilter.setSelectForDisplayType(Integer.valueOf(selectForDisplayType));
        list.add(new DependencyDefinition((DbDefaultFilter)userFilter, SessionParameterType.USER));
        DbWorkspaceFilter workspaceFilter = new DbWorkspaceFilter();
        workspaceFilter.setOwnerEntityOid(objectID);
        workspaceFilter.setSelectForDisplayType(selectForDisplayType);
        list.add(new DependencyDefinition((DbDefaultFilter)workspaceFilter, SessionParameterType.WORKSPACE));
        return list;
    }

    public BeanEntityDefinition getDefinition(String name) throws DashboardException {
        BeanEntityDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanEntityDefinition.class);
        this.updateNames((BeanEntity)bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(data.getEntityOid());
        entityFilter.setSelectForDisplayType(5);
        entityFilter.setUsedByEntity(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        DbPersFieldFilter persFieldFilter = new DbPersFieldFilter();
        persFieldFilter.setUsedByEntity(oid);
        PersFieldDao persFieldDao = this.daoFactory.getPersFieldDao();
        l.addAll(persFieldDao.listAll((DbDefaultFilter)persFieldFilter, 1));
        return l;
    }
}

