/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.FormDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbFormFilter;
import com.prelytis.dashboard.dao.filter.DbLinkFilter;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.FormSelectHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanForm;
import com.prelytis.dashboard.value.data.BeanFormDefinition;
import com.prelytis.dashboard.value.data.BeanFormField;
import com.prelytis.dashboard.value.data.BeanFormFieldSelect;
import com.prelytis.dashboard.value.data.BeanFormFieldValue;
import com.prelytis.dashboard.value.data.BeanFormFinal;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanQueryDataStructure;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableFilter;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableKey;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanWorkspaceDefinition;
import com.prelytis.dashboard.value.data.BeanWorkspaceSession;
import com.prelytis.dashboard.value.data.BeanWorkspaceSessionGroup;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.data.SortOrder;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.FormFilter;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.util.DateTruncation;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.LogManager;

public final class FormHelper
extends ParameterHelper
implements Dependency,
References {
    private static final int SESSION_GROUP_EN_COURS_OID = 8;
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;
    private final boolean addDocInWorkspace;
    private final FormDao dao;
    private final WorkspaceDao workspaceDao;

    FormHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = daoFactory.getFormDao();
        this.workspaceDao = daoFactory.getWorkspaceDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        BeanPRPInfo info = prelytisInfoDao.getPrelytisInfo();
        this.autoNameGeneration = info.isAutoNameGeneration();
        this.addDocInWorkspace = info.isAddDocInWorkspace();
    }

    public static FormHelper getInstance(DaoFactory daoFactory) {
        return new FormHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanForm)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanFormDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanFormDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
            case REFRESH: {
                return this.getRefresh((BeanFormDefinition)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getRefresh(BeanFormDefinition element, ExpressionEvaluationData data) throws DashboardException {
        this.updateOids((BeanForm)element);
        BeanFormDefinition elt = this.refresh(this.daoFactory.getQueryDao(), element, data);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.FORM);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.FORM);
    }

    public BeanFormDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanFormDefinition elt = new BeanFormDefinition();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.updateDescKeys(elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.refresh(this.daoFactory.getQueryDao(), elt, data);
    }

    private ParameterResponse getSaveAsNew(BeanFormDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.FORM);
    }

    private ParameterResponse getSave(BeanFormDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.FORM);
    }

    public void save(BeanFormDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanFormDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        BeanWorkspaceDefinition workspaceDef;
        List sessionList;
        boolean modif;
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanForm)elt);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.updateDescKeys(elt, false);
        this.updateDescriptionMap(elt, this.helper.getLocales(), data.getLocale());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
        if (this.addDocInWorkspace && (modif = this.addWorkspaceSession(sessionList = (workspaceDef = this.helper.get((Dao)this.workspaceDao, data.getWorkspaceName(), 2, BeanWorkspaceDefinition.class)).getMoreSessionList(), workspaceDef, SessionType.FORM, elt.getObjectID(), 8, true, data.getLocale()))) {
            this.workspaceDao.save((Element)workspaceDef);
        }
    }

    private void updateDescriptionMap(BeanFormDefinition elt, List<Locale> locales, Locale defaultLocale) {
        this.helper.updateDescriptionMap((Bean)elt, locales, defaultLocale);
        this.updateDescriptionMap(elt.getAvlFields(), locales, defaultLocale);
        this.updateDescriptionMap(elt.getUsedFields(), locales, defaultLocale);
    }

    private void updateDescriptionMap(List<BeanFormField> fields, List<Locale> locales, Locale defaultLocale) {
        for (BeanFormField field : fields) {
            this.helper.updateDescriptionMap(field.getDescriptionMap(), locales, defaultLocale);
            this.helper.updateDescriptionMap(field.getCommentMap(), locales, defaultLocale);
        }
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanForm elt = this.helper.get((Dao)this.dao, name, 1, BeanForm.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanForm elt = this.helper.get((Dao)this.dao, name, instanceType, BeanForm.class);
        if (elt instanceof BeanFormDefinition) {
            BeanFormDefinition form = (BeanFormDefinition)elt;
            QueryDao queryDao = this.daoFactory.getQueryDao();
            elt = this.refresh(queryDao, form, data);
            if (instanceType == 3) {
                elt = this.getFinal(form, data);
            }
        }
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.FORM);
    }

    private boolean addWorkspaceSession(List<BeanWorkspaceSession> sessionList, BeanWorkspaceDefinition workspaceDef, SessionType beanType, int beanObjectID, int sessionGroupOid, boolean sort, final Locale locale) throws DashboardException {
        boolean modif = false;
        if (sessionList != null) {
            TreeNode sessionGroupNode;
            TreeNode<Object> sessionGroup;
            BeanWorkspaceSession workspaceSession = null;
            SessionDao sessionDao = this.daoFactory.getSessionDao();
            for (BeanWorkspaceSession session : sessionList) {
                BeanSession beanSession = (BeanSession)sessionDao.getCore(session.getObjectID());
                if (session.getType() != beanType || beanSession.getRefOid() != beanObjectID) continue;
                workspaceSession = session;
                workspaceSession.setAccessLevel(Integer.valueOf(2));
            }
            if (workspaceSession != null && (sessionGroup = this.getTreeNode((TreeNode<Object>)(sessionGroupNode = workspaceDef.getSessionGroupNode()), sessionGroupOid)) != null && workspaceSession != null) {
                List children = sessionGroup.getChildren();
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode();
                newNode.setUserObject((Object)workspaceSession);
                newNode.setParent(sessionGroup);
                children.add(newNode);
                if (sort) {
                    final Collator collator = Collator.getInstance(locale);
                    Collections.sort(children, new Comparator<TreeNode<Object>>(){

                        @Override
                        public int compare(TreeNode<Object> o1, TreeNode<Object> o2) {
                            String d2;
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1000;
                            }
                            if (o2 == null) {
                                return -1000;
                            }
                            Object ou1 = o1.getUserObject();
                            Object ou2 = o2.getUserObject();
                            if (!(ou1 instanceof BeanWorkspaceSession)) {
                                return 999;
                            }
                            if (!(ou2 instanceof BeanWorkspaceSession)) {
                                return -999;
                            }
                            BeanWorkspaceSession s1 = (BeanWorkspaceSession)ou1;
                            BeanWorkspaceSession s2 = (BeanWorkspaceSession)ou2;
                            String d1 = (String)s1.getDescriptionMap().get(locale);
                            if (d1 == (d2 = (String)s2.getDescriptionMap().get(locale))) {
                                return 0;
                            }
                            if (d1 == null) {
                                return 998;
                            }
                            if (d2 == null) {
                                return -998;
                            }
                            return collator.compare(d1, d2);
                        }
                    });
                    int cpt = 0;
                    for (TreeNode tn : children) {
                        if (!(tn.getUserObject() instanceof BeanWorkspaceSession)) continue;
                        BeanWorkspaceSession s = (BeanWorkspaceSession)tn.getUserObject();
                        s.setSortOrder(cpt++);
                    }
                }
                sessionList.remove(workspaceSession);
                modif = true;
            }
        }
        return modif;
    }

    private TreeNode<Object> getTreeNode(TreeNode<Object> sessionGroupNode, int sessionGroupOid) {
        TreeNode<Object> res = null;
        for (TreeNode tree : sessionGroupNode.getChildren()) {
            BeanWorkspaceSessionGroup group;
            if (tree.getUserObject() != null && tree.getUserObject() instanceof BeanWorkspaceSessionGroup && (group = (BeanWorkspaceSessionGroup)tree.getUserObject()).getObjectID() == sessionGroupOid) {
                return tree;
            }
            if (tree.isLeaf()) continue;
            res = this.getTreeNode((TreeNode<Object>)tree, sessionGroupOid);
        }
        return res;
    }

    private void updateNames(BeanForm bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        bean.setQueryName(this.getName(SessionParameterType.QUERY, bean.getQueryOID()));
    }

    private void updateOids(BeanForm bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        bean.setQueryOID(this.getOid(SessionParameterType.QUERY, bean.getQueryName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        QueryDao queryDao = this.daoFactory.getQueryDao();
        BeanFormDefinition elt = this.refresh(queryDao, (BeanFormDefinition)this.dao.getDefinition(name), data);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.updateDescKeys(elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateNames((BeanForm)elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.FORM);
    }

    private void updateDescKeys(BeanFormDefinition elt, boolean replace) {
        this.helper.updateDescKey((Bean)elt, replace);
        this.updateDescKeys(elt.getAvlFields(), replace);
        this.updateDescKeys(elt.getUsedFields(), replace);
    }

    private void updateDescKeys(List<BeanFormField> fields, boolean replace) {
        for (BeanFormField field : fields) {
            if (replace || this.helper.isInvalidDescKey(field.getDescriptionKey())) {
                field.setDescriptionKey(this.guidFactory.generateGUID((Object)field));
            }
            if (!replace && !this.helper.isInvalidDescKey(field.getCommentKey())) continue;
            field.setCommentKey(this.guidFactory.generateGUID((Object)field));
        }
    }

    public BeanFormDefinition getDefinition(String name) throws DashboardException {
        BeanQueryDataStructure ds;
        BeanQueryDataStructureTable t;
        QueryDao queryDao = this.daoFactory.getQueryDao();
        BeanFormDefinition form = this.helper.get((Dao)this.dao, name, 2, BeanFormDefinition.class);
        if (form.getQueryOID() == 0) {
            form.getAvlFields().clear();
            form.getUsedFields().clear();
            return form;
        }
        this.updateNames((BeanForm)form);
        ConversionHelper conv = ConversionHelper.getDBConverter();
        Bean qd = queryDao.getDefinition(form.getQueryOID());
        if (qd instanceof BeanQueryDataStructure && (t = this.getTable((ds = (BeanQueryDataStructure)qd).getTableFact(), form.getTableName())) != null) {
            Map<String, BeanQueryDataStructureTableField> fieldMap = this.getFieldMap(t);
            FormSelectHelper helper = FormSelectHelper.getInstance(t);
            for (BeanFormField ff : form.getUsedFields()) {
                BeanFormFieldSelect fs;
                FormSelectHelper.FormSelect select;
                if (ff instanceof BeanFormFieldValue) {
                    BeanFormFieldValue fv = (BeanFormFieldValue)ff;
                    BeanQueryDataStructureTableField tf = fieldMap.get(fv.getFieldName());
                    if (tf != null) {
                        fv.setSqlNullable(tf.isNullable());
                        fv.setDataType(tf.getDataType());
                        fv.setPrimaryKey(this.isPKPart(helper.getPrimaryKey(), tf));
                        try {
                            fv.setMinValue(conv.parse(ff.getDataType(), (String)fv.getMinValue()));
                        }
                        catch (ParseException pe) {
                            LogManager.getLogger(this.getClass()).warn((Object)pe);
                        }
                        try {
                            fv.setMaxValue(conv.parse(ff.getDataType(), (String)fv.getMaxValue()));
                        }
                        catch (ParseException pe) {
                            LogManager.getLogger(this.getClass()).warn((Object)pe);
                        }
                    }
                } else if (ff instanceof BeanFormFieldSelect && (select = helper.getFromKeyName((fs = (BeanFormFieldSelect)ff).getValueListIndexName())) != null) {
                    fs.setDataType(select.getDescField().getDataType());
                    fs.setPrimaryKey(this.isPKPart(helper, select));
                }
                try {
                    ff.setDefaultValue(conv.parse(ff.getDataType(), (String)ff.getDefaultValue()));
                }
                catch (ParseException pe) {
                    LogManager.getLogger(this.getClass()).warn((Object)pe);
                }
            }
        }
        return form;
    }

    public BeanFormFinal getFinal(BeanFormDefinition def, ExpressionEvaluationData data) throws DashboardException {
        BeanFormFinal form = new BeanFormFinal((BeanForm)def);
        for (BeanFormField f : def.getUsedFields()) {
            if (!f.isLinkable() || !(f instanceof BeanFormFieldValue)) continue;
            BeanFormFieldValue fv = (BeanFormFieldValue)f;
            ReportFilter filter = new ReportFilter();
            filter.setName(fv.getFieldName());
            filter.setDescription((String)fv.getDescriptionMap().get(data.getLocale()));
            filter.setDatatype(f.getDataType());
            filter.setVisible(true);
            filter.setLinkable(true);
            filter.setMandatory(false);
            filter.setUseFilter(false);
            filter.setPromptType(1);
            form.getFilterList().add(filter);
        }
        return form;
    }

    public List<ReportFilter> getFilterList(List<BeanFormField> list) {
        ArrayList<ReportFilter> filterList = new ArrayList<ReportFilter>();
        if (list != null) {
            for (BeanFormField f : list) {
                if (!f.isLinkable() || !(f instanceof BeanFormFieldValue)) continue;
                BeanFormFieldValue fv = (BeanFormFieldValue)f;
                ReportFilter rf = new ReportFilter();
                rf.setName(fv.getFieldName());
                rf.setDescription(fv.getDescriptionKey());
                rf.setDatatype(fv.getDataType());
                rf.setMandatory(false);
                rf.setUseFilter(false);
                rf.setLinkable(true);
                rf.setPromptType(1);
                filterList.add(rf);
            }
        }
        return filterList;
    }

    public BeanFormDefinition refresh(QueryDao queryDao, BeanFormDefinition form, ExpressionEvaluationData data) throws DashboardException {
        BeanFormFieldValue field;
        List avlFieldList = form.getAvlFields();
        avlFieldList.clear();
        BeanQueryDataStructure qs = null;
        BeanQueryDataStructureTable table = null;
        if (form.getQueryOID() != 0) {
            Bean qd = queryDao.getDefinition(form.getQueryOID());
            if (qd instanceof BeanQueryDataStructure) {
                BeanQueryDataStructure ds = (BeanQueryDataStructure)qd;
                BeanQueryDataStructureTable t = this.getTable(ds.getTableFact(), form.getTableName());
                if (t != null) {
                    qs = ds;
                    table = t;
                } else if (ds.getTableFact() != null) {
                    form.setTableName(ds.getTableFact().getName());
                    qs = ds;
                    table = ds.getTableFact();
                } else {
                    form.setQueryOID(0);
                }
            } else {
                form.setQueryOID(0);
            }
        }
        if (form.getQueryOID() == 0) {
            DbQueryFilter filter = new DbQueryFilter();
            filter.setForForm(Boolean.TRUE);
            filter.setOwnerEntityOid(data.getEntityOid());
            filter.setSelectForDisplayType(4);
            List list = queryDao.listAll((DbDefaultFilter)filter, 2);
            for (Element elt : list) {
                BeanQueryDataStructure ds;
                BeanQueryDataStructureTable t;
                if (!(elt instanceof BeanQueryDataStructure) || (t = (ds = (BeanQueryDataStructure)elt).getTableFact()) == null) continue;
                qs = ds;
                table = t;
                form.setQueryOID(elt.getObjectID());
                form.setTableName(t.getName());
                break;
            }
        }
        if (qs == null || table == null) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("notFound", null, null);
        }
        FormSelectHelper helper = FormSelectHelper.getInstance(table);
        HashMap<String, String> contextMap = new HashMap<String, String>();
        for (BeanQueryDataStructureTableFilter filter : table.getFilterList()) {
            contextMap.put(filter.getFieldName(), filter.getPersField());
        }
        Map<String, BeanQueryDataStructureTableField> fieldMap = this.getFieldMap(table);
        HashMap<String, Object> initialFieldMap = new HashMap<String, Object>();
        ArrayList usedFieldList = new ArrayList(form.getUsedFields());
        List newUsedFieldList = form.getUsedFields();
        newUsedFieldList.clear();
        for (BeanFormField f : usedFieldList) {
            BeanFormFieldSelect fs;
            FormSelectHelper.FormSelect select;
            if (f instanceof BeanFormFieldValue) {
                BeanFormFieldValue fv = (BeanFormFieldValue)f;
                BeanQueryDataStructureTableField tf = fieldMap.get(fv.getFieldName());
                if (tf == null) continue;
                field = new BeanFormFieldValue();
                field.setFieldName(tf.getName());
                field.setSqlNullable(tf.isNullable());
                field.setDataType(tf.getDataType());
                field.setCommentKey(fv.getCommentKey());
                field.getCommentMap().putAll(fv.getCommentMap());
                field.setDescriptionKey(fv.getDescriptionKey());
                field.getDescriptionMap().putAll(fv.getDescriptionMap());
                field.setDefaultValue(fv.getDefaultValue());
                field.setDisplayType(fv.getDisplayType());
                field.setLinkable(fv.isLinkable());
                field.setMaxValue(fv.getMaxValue());
                field.setMinValue(fv.getMinValue());
                field.setRequired(fv.isRequired() || !tf.isNullable());
                field.setSqlInsert(fv.isSqlInsert());
                field.setSqlUpdate(fv.isSqlUpdate());
                field.setPrimaryKey(this.isPKPart(helper.getPrimaryKey(), tf));
                if (field.isPrimaryKey()) {
                    field.setRequired(true);
                    field.setSqlNullable(false);
                    field.setSqlUpdate(false);
                }
                newUsedFieldList.add(field);
                initialFieldMap.put(tf.getName(), field);
                continue;
            }
            if (!(f instanceof BeanFormFieldSelect) || (select = helper.getFromKeyName((fs = (BeanFormFieldSelect)f).getValueListIndexName())) == null) continue;
            fs.setDataType(select.getDescField().getDataType());
            newUsedFieldList.add(fs);
            boolean isPK = false;
            for (BeanQueryDataStructureTableField tf : select.getFkFields()) {
                initialFieldMap.put(tf.getName(), fs);
                isPK = isPK || this.isPKPart(helper.getPrimaryKey(), tf);
            }
            fs.setPrimaryKey(isPK);
            if (!fs.isPrimaryKey()) continue;
            fs.setRequired(true);
            fs.setSqlNullable(false);
            fs.setSqlUpdate(false);
        }
        for (BeanFormField f : table.getTableFieldList()) {
            boolean addToAvlField;
            if (f.getDateTruncation() != null && f.getDateTruncation() != DateTruncation.NONE) continue;
            BeanFormField ref = (BeanFormField)initialFieldMap.get(f.getName());
            boolean bl = addToAvlField = f.isNullable() || ref != null;
            if (contextMap.containsKey(f.getSqlField())) {
                if (ref instanceof BeanFormFieldValue) {
                    field = (BeanFormFieldValue)ref;
                } else {
                    if (ref != null) {
                        newUsedFieldList.remove(ref);
                    }
                    field = this.getFFV((BeanQueryDataStructureTableField)f);
                    field.setDisplayType(EnumSet.of(BeanFormField.DisplayType.VISIBLE));
                    newUsedFieldList.add(field);
                }
                field.setSqlInsert(!f.isAutoincrement());
                field.setSqlUpdate(false);
                field.setLinkable(false);
                field.setDefaultValue(contextMap.get(f.getSqlField()));
                continue;
            }
            List<FormSelectHelper.FormSelect> selectList = helper.getFromFieldName(f.getName());
            if (selectList != null) {
                BeanFormFieldSelect rs = ref instanceof BeanFormFieldSelect ? (BeanFormFieldSelect)ref : null;
                for (FormSelectHelper.FormSelect select : selectList) {
                    BeanQueryDataStructureTableKey key = select.getKey();
                    if (key.getName() == null) continue;
                    if (rs == null || !key.getName().equals(rs.getValueListIndexName())) {
                        BeanQueryDataStructureTableField descField = select.getDescField();
                        BeanFormFieldSelect field2 = new BeanFormFieldSelect();
                        field2.setDescriptionKey(this.guidFactory.generateGUID((Object)field2));
                        field2.getDescriptionMap().putAll(descField.getDescriptionMap());
                        field2.setDataType(descField.getDataType());
                        field2.setCommentKey(this.guidFactory.generateGUID((Object)field2));
                        field2.setValueListIndexName(key.getName());
                        field2.setValueListSortOrder(SortOrder.SORT_ASCENDING);
                        field2.setDisplayType(EnumSet.of(BeanFormField.DisplayType.UPDATABLE, BeanFormField.DisplayType.VISIBLE));
                        field2.setSqlInsert(!f.isAutoincrement());
                        field2.setSqlUpdate(!f.isAutoincrement());
                        field2.setLinkable(true);
                        field2.setRequired(!field2.isSqlNullable());
                        if (addToAvlField) {
                            avlFieldList.add(field2);
                            continue;
                        }
                        newUsedFieldList.add(field2);
                        addToAvlField = true;
                        continue;
                    }
                    if (rs == null) continue;
                    rs.setSqlNullable(f.isNullable());
                    rs.setDataType(f.getDataType());
                    rs.setRequired(!rs.isSqlNullable());
                }
            }
            if (ref != null && !(ref instanceof BeanFormFieldSelect)) continue;
            field = this.getFFV((BeanQueryDataStructureTableField)f);
            if (f.isAutoincrement()) {
                field.getDisplayType().remove(BeanFormField.DisplayType.UPDATABLE);
            } else {
                field.setDisplayType(EnumSet.of(BeanFormField.DisplayType.UPDATABLE, BeanFormField.DisplayType.VISIBLE));
            }
            field.setSqlInsert(!f.isAutoincrement());
            field.setSqlUpdate(!f.isAutoincrement());
            field.setLinkable(true);
            if (addToAvlField) {
                avlFieldList.add(field);
                continue;
            }
            newUsedFieldList.add(field);
        }
        return form;
    }

    private boolean isPKPart(BeanQueryDataStructureTableKey primaryKey, BeanQueryDataStructureTableField tf) {
        if (primaryKey == null || primaryKey.getFieldList().isEmpty()) {
            return true;
        }
        for (String f : primaryKey.getFieldList()) {
            if (!f.equals(tf.getSqlField())) continue;
            return true;
        }
        return false;
    }

    private boolean isPKPart(FormSelectHelper helper, FormSelectHelper.FormSelect select) {
        for (BeanQueryDataStructureTableField tf : select.getFkFields()) {
            if (!this.isPKPart(helper.getPrimaryKey(), tf)) continue;
            return true;
        }
        return false;
    }

    private BeanFormFieldValue getFFV(BeanQueryDataStructureTableField f) {
        BeanFormFieldValue field = new BeanFormFieldValue();
        field.setFieldName(f.getName());
        field.setSqlNullable(f.isNullable());
        field.setRequired(!field.isSqlNullable());
        field.setDataType(f.getDataType());
        field.setDescriptionKey(this.guidFactory.generateGUID((Object)field));
        field.getDescriptionMap().putAll(f.getDescriptionMap());
        field.setCommentKey(this.guidFactory.generateGUID((Object)field));
        field.setDisplayType(EnumSet.of(BeanFormField.DisplayType.UPDATABLE, BeanFormField.DisplayType.VISIBLE));
        return field;
    }

    private BeanQueryDataStructureTable getTable(BeanQueryDataStructureTable table, String tableName) {
        if (table == null) {
            return null;
        }
        if (table.getName().equals(tableName)) {
            return table;
        }
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            BeanQueryDataStructureTable st = this.getTable(t, tableName);
            if (st == null) continue;
            return st;
        }
        return null;
    }

    private Map<String, BeanQueryDataStructureTableField> getFieldMap(BeanQueryDataStructureTable table) {
        HashMap<String, BeanQueryDataStructureTableField> fieldMap = new HashMap<String, BeanQueryDataStructureTableField>();
        for (BeanQueryDataStructureTableField f : table.getTableFieldList()) {
            if (f.getDateTruncation() != null && f.getDateTruncation() != DateTruncation.NONE) continue;
            fieldMap.put(f.getName(), f);
        }
        return fieldMap;
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.FORM).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.FORM);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.FORM, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanForm elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanForm.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.FORM);
    }

    public BeanForm getCore(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanForm elt = this.helper.get((Dao)this.dao, name, 1, BeanForm.class);
        this.updateNames(elt);
        return elt;
    }

    public BeanForm getCore(String name) throws DashboardException {
        BeanForm elt = this.helper.get((Dao)this.dao, name, 1, BeanForm.class);
        this.updateNames(elt);
        return elt;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbFormFilter filter = this.helper.getFilter(defaultFilter, data, DbFormFilter.class);
        if (defaultFilter instanceof FormFilter) {
            FormFilter src = (FormFilter)defaultFilter;
            filter.setQueryOid(this.optOid(SessionParameterType.QUERY, src.getQueryName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        if (instanceType != 1) {
            for (Element elt : eltList) {
                this.updateNames((BeanForm)elt);
            }
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbLinkFilter linkFilter = new DbLinkFilter();
        linkFilter.setDstForm(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)linkFilter, SessionParameterType.LINK));
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setFormOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)dashboardFilter, SessionParameterType.DASHBOARD));
        return list;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setOwnerEntityOid(data.getEntityOid());
        queryFilter.setSelectForDisplayType(5);
        queryFilter.setUsedByForm(oid);
        QueryDao queryDao = this.daoFactory.getQueryDao();
        l.addAll(queryDao.listAll((DbDefaultFilter)queryFilter, 1));
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(data.getEntityOid());
        entityFilter.setSelectForDisplayType(5);
        entityFilter.setUsedByForm(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        return l;
    }
}

