/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.SessionDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbOwnerEntityFilter;
import com.prelytis.dashboard.dao.filter.DbVersionFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.I18nComparator;
import com.prelytis.dashboard.interfaces.Comment;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.ProfileRestriction;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SystemRestriction;
import com.prelytis.dashboard.interfaces.UserCustomisation;
import com.prelytis.dashboard.interfaces.Versionable;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.SecurityHelper;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.BasicBean;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.OwnerEntityFilter;
import com.prelytis.dashboard.value.data.filter.VersionFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class Helper {
    private final DaoFactory daoFactory;
    private final GuidFactory guidFactory;
    private final Pattern pattern;
    private final Pattern userPattern;

    private Helper(DaoFactory daoFactory, GuidFactory guidFactory) {
        this.daoFactory = daoFactory;
        this.guidFactory = guidFactory;
        this.pattern = Pattern.compile("^[a-zA-Z0-9][\\w-]*$");
        this.userPattern = Pattern.compile("^[[\\p{L}]*[0-9][. @]*]*[\\w-. @]*$");
    }

    public static Helper getInstance(DaoFactory daoFactory, GuidFactory guidFactory) {
        return new Helper(daoFactory, guidFactory);
    }

    public static Helper getInstance(DaoFactory daoFactory) {
        return new Helper(daoFactory, GuidFactory.getInstance());
    }

    public ParameterResponse getResponse(I18nElement elt, ExpressionEvaluationData data, SessionParameterType sessionParameterType) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), sessionParameterType).getAccessLevel();
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        BeanSession session = (BeanSession)sessionDao.getCore(sessionParameterType.getId());
        ParameterResponse response = new ParameterResponse();
        response.setDescription((String)session.getDescriptionMap().get(data.getLocale()));
        SecurityHelper securityHelper = SecurityHelper.getInstance(this.daoFactory);
        SecurityAdapter sa = securityHelper.create(elt, data, accessLevel);
        response.setElement(sa);
        response.setAccessLevel(Integer.valueOf(accessLevel));
        return response;
    }

    public <T extends Bean> T get(Dao dao, String name, int instanceType, Class<T> clazz) throws DashboardException {
        try {
            Bean elt = instanceType == 1 ? dao.getCore(name) : dao.getDefinition(name);
            return (T)((Bean)clazz.cast(elt));
        }
        catch (DashboardRuntimeException dre) {
            if (dre.getCode() == ErrorCode.NOT_FOUND_ERROR) {
                String message = "Object name: " + name + " class: " + clazz + " message: " + dre.getMessage();
                throw new DashboardException(ErrorCode.NOT_FOUND_ERROR, (Throwable)dre, message);
            }
            throw dre;
        }
    }

    public <T extends Bean> T get(Dao dao, String name, Integer instanceType, Class<T> clazz) throws DashboardException {
        return this.get(dao, name, instanceType == null ? 1 : instanceType, clazz);
    }

    public void checkOwnerEntity(EntityHelper entityHelper, ExpressionEvaluationData data, OwnerEntity ownerEntity) throws DashboardException {
        if (!entityHelper.isChild(data.getEntityOid(), ownerEntity.getOwnerEntOID())) {
            throw new SecurityException();
        }
    }

    void updateForCopy(Bean elt) {
        this.updateForCopy(elt, false);
    }

    void updateForCopy(Bean elt, boolean autoNameGeneration) {
        elt.setObjectID(0);
        if (autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        } else {
            elt.setName("");
        }
        if (elt instanceof SystemRestriction) {
            ((SystemRestriction)elt).setSystem(false);
        }
    }

    <T extends DbDefaultFilter> T getFilter(DefaultFilter filter, ExpressionEvaluationData data, Class<T> clazz) {
        DbDefaultFilter t;
        try {
            t = (DbDefaultFilter)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DashboardRuntimeException((Throwable)e);
        }
        if (filter != null) {
            t.setDescription(filter.getDescription());
            t.setName(filter.getName());
            t.setSearch(filter.getSearch());
        }
        if (t.getLanguageOid() == null && data != null) {
            t.setLanguageOid(data.getLanguageOid());
        }
        if (t instanceof DbOwnerEntityFilter) {
            DbOwnerEntityFilter oef = (DbOwnerEntityFilter)t;
            if (filter instanceof OwnerEntityFilter) {
                OwnerEntityFilter i = (OwnerEntityFilter)filter;
                oef.setSelectForDisplayType(i.getSelectForDisplayType());
                if (i.getOwnerEntityName() != null && !i.getOwnerEntityName().isEmpty()) {
                    EntityDao entityDao = this.daoFactory.getEntityDao();
                    BeanEntity entity = (BeanEntity)entityDao.getCore(i.getOwnerEntityName());
                    oef.setOwnerEntityOid(Integer.valueOf(entity.getObjectID()));
                }
            }
            if (data != null && oef.getOwnerEntityOid() == null) {
                oef.setOwnerEntityOid(data.getEntityOid());
            }
        }
        if (t instanceof DbVersionFilter) {
            DbVersionFilter dst = (DbVersionFilter)t;
            if (filter instanceof VersionFilter) {
                VersionFilter src = (VersionFilter)filter;
                dst.setDateModification(src.getDateModification());
                dst.setDateOperator(src.getDateOperator());
                dst.setVersion(src.getVersion());
                dst.setVersionOperator(src.getVersionOperator());
            }
        }
        return (T)t;
    }

    public ParametersListResponse list(Dao dao, DbDefaultFilter filter, int instanceType, ParametersListRequest.SortedField sortedField, Integer maxSize, boolean restricted, SessionParameterType sessionParameterType, int accessLevel, ExpressionEvaluationData data) throws DashboardException {
        List elementList = dao.listAll(filter, instanceType, sortedField, maxSize);
        return this.list(elementList, maxSize, restricted, sessionParameterType, accessLevel, data);
    }

    public ParametersListResponse list(List<Element> elementList, Integer maxSize, boolean restricted, SessionParameterType sessionParameterType, int accessLevel, ExpressionEvaluationData data) throws DashboardException {
        int m;
        if (restricted) {
            ArrayList<Element> l = new ArrayList<Element>();
            for (Element e : elementList) {
                l.add((Element)new BasicBean((I18nElement)((Bean)e)));
            }
            elementList = l;
        }
        boolean truncated = false;
        if (maxSize != null && elementList != null && (m = maxSize.intValue()) > 0 && elementList.size() > m) {
            elementList.subList(m, elementList.size()).clear();
            truncated = true;
        }
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        BeanSession session = (BeanSession)sessionDao.getCore(sessionParameterType.getId());
        ParametersListResponse response = new ParametersListResponse();
        response.setDescription((String)session.getDescriptionMap().get(data.getLocale()));
        response.setList(this.getList(elementList, accessLevel, data));
        response.setTruncatedData(truncated);
        response.setAccessLevel(Integer.valueOf(accessLevel));
        return response;
    }

    List<SecurityAdapter> getList(List<Element> elementList, int accessLevel, ExpressionEvaluationData data) throws DashboardException {
        SecurityHelper securityHelper = SecurityHelper.getInstance(this.daoFactory);
        ArrayList<SecurityAdapter> list = new ArrayList<SecurityAdapter>();
        for (int i = elementList.size() - 1; i >= 0; --i) {
            Bean elt = (Bean)elementList.get(i);
            SecurityAdapter sa = securityHelper.create((I18nElement)elt, data, accessLevel);
            if (!sa.isRead()) continue;
            list.add(sa);
        }
        Collections.sort(list, new I18nComparator(data.getLocale()));
        return list;
    }

    void checkForSave(Dao dao, ExpressionEvaluationData data, Bean elt, boolean isNew) throws DashboardException {
        this.checkForSave(dao, data, elt, isNew, false);
    }

    void checkForSave(Dao dao, ExpressionEvaluationData data, Bean elt, boolean isNew, boolean isImport) throws DashboardException {
        if (isNew) {
            this.checkForSaveAsNew(dao, data, (Element)elt);
            elt.setObjectID(0);
            elt.setOwner(data.getUserName());
            elt.setCreationDate(new Date());
        } else {
            Bean prev = dao.getCore(elt.getName());
            if (prev instanceof OwnerEntity) {
                EntityHelper entityHelper = EntityHelper.getInstance(this.daoFactory);
                this.checkOwnerEntity(entityHelper, data, (OwnerEntity)prev);
            }
            this.checkSaveConcurrency(data, elt, isImport, prev);
            elt.setObjectID(prev.getObjectID());
            this.checkForSave(data, (Element)elt);
        }
    }

    protected void checkSaveConcurrency(ExpressionEvaluationData data, Bean elt, boolean isImport, Bean prev) throws DashboardException {
        boolean concurrence;
        boolean isTargetModifiedExternallyWhileEditing = prev.getLastModificationDate() != null && elt.getLastModificationDate() != null && (elt.getLastModificationDate().getTime() - prev.getLastModificationDate().getTime()) / 1000L != 0L;
        boolean bl = concurrence = isImport ? this.isPreventAutomatedImport(data, elt, prev) : isTargetModifiedExternallyWhileEditing;
        if (concurrence) {
            elt.setLastModificationDate(prev.getLastModificationDate());
            long ms = (new Date().getTime() - (prev.getLastModificationDate() == null ? new Date().getTime() : prev.getLastModificationDate().getTime())) / 60000L;
            if (ms < 1L) {
                ms = 1L;
            }
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.SAVE_ACTION_SKIPPED, "concurrentSave", new Object[]{prev.getLastModifier(), ms}, null);
        }
    }

    private int[] extractVersionArray(String version) {
        String[] tokens = version.split("\\.");
        int[] array = new int[tokens.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Integer.parseInt(tokens[i]);
        }
        return array;
    }

    private int compareVersions(String firstVersion, String secondVersion) {
        int[] secondVersionArray;
        if (StringUtils.isBlank((String)firstVersion)) {
            if (StringUtils.isBlank((String)secondVersion)) {
                return 0;
            }
            return -1;
        }
        if (StringUtils.isBlank((String)secondVersion)) {
            return 1;
        }
        if (firstVersion.equalsIgnoreCase(secondVersion)) {
            return 0;
        }
        int[] firstVersionArray = this.extractVersionArray(firstVersion);
        if (firstVersionArray[0] < (secondVersionArray = this.extractVersionArray(secondVersion))[0]) {
            return -1;
        }
        if (firstVersionArray[0] > secondVersionArray[0]) {
            return 1;
        }
        if (firstVersionArray[1] < secondVersionArray[1]) {
            return -1;
        }
        if (firstVersionArray[1] > secondVersionArray[1]) {
            return 1;
        }
        if (firstVersionArray[2] < secondVersionArray[2]) {
            return -1;
        }
        return 1;
    }

    private boolean isPreventAutomatedImport(ExpressionEvaluationData data, Bean elt, Bean prev) {
        if (!"superadmin".equalsIgnoreCase(data.getUserName())) {
            return false;
        }
        if (elt instanceof Versionable && prev instanceof Versionable) {
            return this.compareVersions(((Versionable)elt).getVersion(), ((Versionable)prev).getVersion()) <= 0;
        }
        return prev.getLastModifier() != null && elt.getLastModifier() != null && !elt.getLastModifier().equals(prev.getLastModifier());
    }

    public void checkDescriptionMap(Map<Locale, String> descriptionMap, Locale locale) throws DashboardException {
        String desc = descriptionMap.get(locale);
        if (desc == null || desc.trim().isEmpty()) {
            DashboardException e = ExceptionHelper.getInstance(locale).createDashboardException(ErrorCode.NO_VALID_DATA, "descriptionMandatory", null, null);
            throw e;
        }
    }

    void checkForSave(ExpressionEvaluationData data, Element element) throws DashboardException {
        ProfileRestriction pr;
        if (element instanceof ProfileRestriction && (pr = (ProfileRestriction)element).getProfile() > data.getProfile()) {
            throw this.createDashboardException(data, "insufficientProfile");
        }
        if (element.getName() == null || element.getName().isEmpty()) {
            throw this.createDashboardException(data, "missingName");
        }
    }

    void checkForSaveAsNew(Dao dao, ExpressionEvaluationData data, Element element) throws DashboardException {
        if (element.getName() == null || element.getName().isEmpty()) {
            throw this.createDashboardException(data, "missingName");
        }
        if (dao.exists(element.getName())) {
            throw this.createDashboardException(data, "unicityName");
        }
        if (element instanceof BeanUserDefinition) {
            this.checkUserName(data.getLocale(), element.getName());
        } else {
            this.checkName(data.getLocale(), element.getName());
        }
        if ("new".equalsIgnoreCase(element.getName()) || "prepare".equalsIgnoreCase(element.getName())) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("invalidCharInName", null, null);
        }
    }

    void checkPathIsSafe(Locale locale, String path) throws DashboardException {
        Pattern pattern;
        Matcher matcher;
        if (path != null && (matcher = (pattern = Pattern.compile("\\.\\.")).matcher(path)).find()) {
            throw ExceptionHelper.getInstance(locale).createDashboardException("notASafeDirectory", null, null);
        }
    }

    public void checkName(Locale locale, String name) throws DashboardException {
        Pattern pattern;
        Matcher matcher;
        if (name != null && (matcher = (pattern = Pattern.compile("\\s")).matcher(name)).find()) {
            throw ExceptionHelper.getInstance(locale).createDashboardException("spacesInName", null, null);
        }
        if (!this.pattern.matcher(name).matches()) {
            throw ExceptionHelper.getInstance(locale).createDashboardException("invalidCharInName", null, null);
        }
    }

    public void checkUserName(Locale locale, String name) throws DashboardException {
        if (!this.userPattern.matcher(name).matches()) {
            throw ExceptionHelper.getInstance(locale).createDashboardException("invalidCharInName", null, null);
        }
    }

    private DashboardException createDashboardException(ExpressionEvaluationData data, String key) {
        return ExceptionHelper.getInstance(data.getLocale()).createDashboardException(key, null, null);
    }

    @Deprecated
    void checkForDelete(ExpressionEvaluationData data, Element element) throws DashboardException {
        this.checkForDelete(null, data, element);
    }

    void checkForDelete(List<DependencyDefinition> list, ExpressionEvaluationData data, Element element) throws DashboardException {
        ProfileRestriction pr;
        SystemRestriction sr;
        if (element.getObjectID() == 0) {
            throw this.createDashboardException(data, "cannotDelete");
        }
        if (element instanceof UserCustomisation) {
            return;
        }
        if (element instanceof SystemRestriction && (sr = (SystemRestriction)element).getSystem()) {
            throw this.createDashboardException(data, "cannotDeleteSystemObject");
        }
        if (element instanceof ProfileRestriction && (pr = (ProfileRestriction)element).getProfile() > data.getProfile()) {
            throw this.createDashboardException(data, "insufficientProfile");
        }
        if (list != null) {
            for (DependencyDefinition def : list) {
                Dao dao = this.daoFactory.getDao(def.getSessionParameterType());
                List dep = dao.listAll(def.getFilter(), 1, null, Integer.valueOf(1));
                if (dep.isEmpty()) continue;
                throw this.createDashboardException(data, "deleteDependantObjectFirst");
            }
        }
    }

    void addDependencies(List<DependencyGroup> dependencies, List<Element> list, ExpressionEvaluationData data, SessionParameterType sessionParameterType) throws DashboardException {
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        BeanSession session = (BeanSession)sessionDao.getCore(sessionParameterType.getId());
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        WorkspaceDao.SessionAccessLevel accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), sessionParameterType);
        List<SecurityAdapter> saList = this.getList(list, accessLevel.getAccessLevel(), data);
        if (!saList.isEmpty()) {
            DependencyGroup group = new DependencyGroup();
            group.setDescription((String)session.getDescriptionMap().get(data.getLocale()));
            group.setItems(saList.toArray(new SecurityAdapter[saList.size()]));
            dependencies.add(group);
        }
    }

    List<DependencyGroup> getDependencies(List<DependencyDefinition> list, ExpressionEvaluationData data) throws DashboardException {
        SessionDao sessionDao = this.daoFactory.getSessionDao();
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        ArrayList<DependencyGroup> dependencies = new ArrayList<DependencyGroup>();
        for (DependencyDefinition def : list) {
            SessionParameterType sessionParameterType = def.getSessionParameterType();
            BeanSession session = (BeanSession)sessionDao.getCore(sessionParameterType.getId());
            WorkspaceDao.SessionAccessLevel accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), sessionParameterType);
            Dao dao = this.daoFactory.getDao(sessionParameterType);
            List l = dao.listAll(def.getFilter(), 1);
            List<SecurityAdapter> saList = this.getList(l, accessLevel.getAccessLevel(), data);
            if (saList.isEmpty()) continue;
            DependencyGroup group = new DependencyGroup();
            group.setDescription((String)session.getDescriptionMap().get(data.getLocale()));
            group.setItems(saList.toArray(new SecurityAdapter[saList.size()]));
            dependencies.add(group);
        }
        return dependencies;
    }

    public DependencyResponse getResponse(Bean bean, List<DependencyGroup> list, ExpressionEvaluationData data, SessionParameterType sessionOid) throws DashboardException {
        SecurityHelper securityHelper = SecurityHelper.getInstance(this.daoFactory);
        SecurityAdapter elt = securityHelper.create((I18nElement)bean, data, 2);
        DependencyResponse response = new DependencyResponse();
        response.setDependencies(list);
        response.setElement(elt);
        return response;
    }

    void updateDescriptionMap(Bean bean, Locale defaultLocale) {
        this.updateDescriptionMap(bean, this.getLocales(), defaultLocale);
    }

    void updateDescriptionMap(Bean bean, List<Locale> locales, Locale defaultLocale) {
        this.updateDescriptionMap(bean.getDescriptionMap(), locales, defaultLocale);
        if (bean instanceof Comment) {
            Comment c = (Comment)bean;
            this.updateDescriptionMap(c.getCommentMap(), locales, defaultLocale);
        }
    }

    void updateDescriptionMap(Map<Locale, String> descriptionMap, List<Locale> locales, Locale defaultLocale) {
        if (descriptionMap.isEmpty()) {
            return;
        }
        HashMap<Locale, String> copy = new HashMap<Locale, String>(descriptionMap);
        descriptionMap.clear();
        String defaultLabel = (String)copy.get(defaultLocale);
        for (Locale locale : locales) {
            String label = (String)copy.get(locale);
            if (label == null || label.isEmpty()) {
                descriptionMap.put(locale, defaultLabel);
                continue;
            }
            descriptionMap.put(locale, label);
        }
    }

    void updateDescKey(Bean bean, boolean replace) {
        if (replace || this.isInvalidDescKey(bean.getDescriptionKey())) {
            bean.setDescriptionKey(this.guidFactory.generateGUID((Object)bean));
        }
        if (bean instanceof Comment) {
            Comment c = (Comment)bean;
            if (replace || this.isInvalidDescKey(c.getCommentKey())) {
                c.setCommentKey(this.guidFactory.generateGUID((Object)bean));
            }
        }
    }

    List<Locale> getLocales() {
        return this.daoFactory.getLanguageDao().getLocaleList();
    }

    boolean isInvalidDescKey(String descKey) {
        return descKey == null || descKey.isEmpty();
    }
}

