/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.LanguageDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbLanguageFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.SQLImportHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanLanguage;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.LanguageFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class LanguageHelper
extends ParameterHelper
implements Dependency {
    private final LanguageDao dao;

    LanguageHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getLanguageDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanLanguage)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanLanguage)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanLanguage)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.LANGUAGE);
    }

    public BeanLanguage create(ExpressionEvaluationData data) throws DashboardException {
        BeanLanguage elt = new BeanLanguage();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanLanguage elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.LANGUAGE);
    }

    private ParameterResponse getSave(BeanLanguage elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.LANGUAGE);
    }

    public void save(BeanLanguage elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanLanguage elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        if (isNew) {
            this.helper.checkForSaveAsNew((Dao)this.dao, data, (Element)elt);
            if (elt.getLanguage() == null || elt.getLanguage().isEmpty()) {
                throw ExceptionHelper.getInstance(data.getLocale()).createMissingParameter("language");
            }
            DbLanguageFilter filter = new DbLanguageFilter();
            filter.setLanguage(elt.getLanguage());
            List l = this.dao.listAll((DbDefaultFilter)filter, 1);
            if (!l.isEmpty()) {
                throw ExceptionHelper.getInstance(data.getLocale()).createUnicityNameException(SessionParameterType.LANGUAGE, elt.getLanguage());
            }
            elt.setObjectID(0);
            elt.setOwner(data.getUserName());
            elt.setCreationDate(new Date());
        } else {
            Bean prev = this.dao.getCore(elt.getName());
            this.helper.checkSaveConcurrency(data, (Bean)elt, isImport, prev);
        }
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
        if (elt.isActive()) {
            Boolean overwrite = Boolean.FALSE;
            Configuration configuration = Configuration.getInstance();
            DataSourceConfiguration dsc = configuration.getDataSourceConfiguration();
            SQLImportHelper helper = SQLImportHelper.getInstance(dsc.getDataSource());
            String filename = new StringBuffer("lang_").append(elt.getLanguage()).append(".properties").toString();
            PrelytisInfoDao prelytisInfoDao = this.daoFactory.getPrelytisInfoDao();
            BeanPRPInfo info = prelytisInfoDao.getPrelytisInfo();
            int fromLanguageOid = info.getLanguageOID();
            try {
                helper.importData(filename, overwrite, fromLanguageOid);
            }
            catch (SQLException e) {
                throw this.getException(e);
            }
        }
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanLanguage elt = this.helper.get((Dao)this.dao, name, 1, BeanLanguage.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanLanguage elt = this.helper.get((Dao)this.dao, name, instanceType, BeanLanguage.class);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.LANGUAGE);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanLanguage elt = (BeanLanguage)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.LANGUAGE);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.LANGUAGE).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.LANGUAGE);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.LANGUAGE, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanLanguage elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanLanguage.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.LANGUAGE);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbLanguageFilter filter = this.helper.getFilter(defaultFilter, data, DbLanguageFilter.class);
        if (defaultFilter instanceof LanguageFilter) {
            LanguageFilter src = (LanguageFilter)defaultFilter;
            filter.setActive(src.getActive());
            filter.setLanguage(src.getLanguage());
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbUserFilter userFilter = new DbUserFilter();
        userFilter.setUserLanguageOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)userFilter, SessionParameterType.USER));
        return list;
    }

    public static LanguageHelper getInstance(DaoFactory daoFactory) {
        return new LanguageHelper(daoFactory);
    }

    public BeanLanguage getDefinition(String name) throws DashboardException {
        BeanLanguage bean = this.helper.get((Dao)this.dao, name, 2, BeanLanguage.class);
        return bean;
    }

    public List<BeanLanguage> getActiveLanguageList() {
        DbLanguageFilter languageFilter = new DbLanguageFilter();
        languageFilter.setActive(Boolean.TRUE);
        List eltList = this.dao.listAll((DbDefaultFilter)languageFilter, 2, null, null);
        return this.asList(eltList, BeanLanguage.class);
    }
}

