/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.MessageProviderDao;
import com.prelytis.dashboard.dao.MessageTypeDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbMessageProviderFilter;
import com.prelytis.dashboard.dao.filter.DbMessageTypeFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.MessageProviderHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanMessageProvDefinition;
import com.prelytis.dashboard.value.data.BeanMessageProvParam;
import com.prelytis.dashboard.value.data.BeanMessageType;
import com.prelytis.dashboard.value.data.BeanMessageTypeDefinition;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class MessageTypeHelper
extends ParameterHelper
implements References {
    private final MessageTypeDao dao;

    MessageTypeHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getMessageTypeDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanMessageType)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanMessageTypeDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanMessageTypeDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
            case REFRESH: {
                if (!(value.getElement() instanceof BeanMessageTypeDefinition)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("nothingToRefresh", null, null);
                }
                return this.getRefresh((BeanMessageTypeDefinition)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.MESSAGE_TYPE);
    }

    public BeanMessageTypeDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanMessageTypeDefinition elt = new BeanMessageTypeDefinition();
        this.helper.updateDescKey((Bean)elt, false);
        MessageProviderHelper messageProviderHelper = new MessageProviderHelper(this.daoFactory);
        List<Element> messageProviderList = messageProviderHelper.list(null, 2, null, 1, data);
        if (messageProviderList.isEmpty()) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_MESSAGE_TYPE_CREATION_NO_PROVIDER, null, null, null);
        }
        BeanMessageProvDefinition provider = (BeanMessageProvDefinition)messageProviderList.get(0);
        this.updateParameters(elt, provider);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanMessageTypeDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MESSAGE_TYPE);
    }

    private ParameterResponse getSave(BeanMessageTypeDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MESSAGE_TYPE);
    }

    public void save(BeanMessageTypeDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanMessageTypeDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanMessageType)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMessageType elt = this.helper.get((Dao)this.dao, name, 1, BeanMessageType.class);
        this.helper.checkForDelete(data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMessageType elt = this.helper.get((Dao)this.dao, name, instanceType, BeanMessageType.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.MESSAGE_TYPE);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanMessageTypeDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanMessageTypeDefinition.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateNames((BeanMessageType)elt);
        return this.getRefresh(elt, data);
    }

    private ParameterResponse getRefresh(BeanMessageTypeDefinition bean, ExpressionEvaluationData data) throws DashboardException {
        MessageProviderDao providerDao = this.daoFactory.getMessageProviderDao();
        BeanMessageProvDefinition provDefinition = (BeanMessageProvDefinition)providerDao.getDefinition(bean.getMessageProviderName());
        this.updateParameters(bean, provDefinition);
        return this.helper.getResponse((I18nElement)bean, data, SessionParameterType.MESSAGE_TYPE);
    }

    private void updateParameters(BeanMessageTypeDefinition bean, BeanMessageProvDefinition provDefinition) {
        HashMap<String, String> map = new HashMap<String, String>();
        List paramList = bean.getBeanMessageProvParamList();
        for (int i = 0; i < paramList.size(); ++i) {
            BeanMessageProvParam param = (BeanMessageProvParam)paramList.get(i);
            if (!param.getParam()) continue;
            map.put(param.getName(), param.getValue());
        }
        paramList.clear();
        bean.setMessageProvOID(provDefinition.getObjectID());
        bean.setMessageProviderName(provDefinition.getName());
        for (BeanMessageProvParam param : provDefinition.getBeanMessageProvParamList()) {
            String value = (String)map.get(param.getName());
            if (value != null && param.getParam()) {
                param.setValue(value);
            }
            paramList.add(param);
        }
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.MESSAGE_TYPE).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.MESSAGE_TYPE);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.MESSAGE_TYPE, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbMessageTypeFilter filter = this.helper.getFilter(defaultFilter, data, DbMessageTypeFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    public static MessageTypeHelper getInstance(DaoFactory daoFactory) {
        return new MessageTypeHelper(daoFactory);
    }

    private void updateNames(BeanMessageType bean) throws DashboardException {
        bean.setMessageProviderName(this.getName(SessionParameterType.MESSAGE_PROVIDER, bean.getMessageProvOID()));
    }

    private void updateOids(BeanMessageType bean) throws DashboardException {
        bean.setMessageProvOID(this.getOid(SessionParameterType.MESSAGE_PROVIDER, bean.getMessageProviderName()));
    }

    public BeanMessageTypeDefinition getDefinition(String name) throws DashboardException {
        BeanMessageTypeDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanMessageTypeDefinition.class);
        this.updateNames((BeanMessageType)bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbMessageProviderFilter messageProviderFilter = new DbMessageProviderFilter();
        messageProviderFilter.setUsedByMessageType(oid);
        MessageProviderDao messageProviderDao = this.daoFactory.getMessageProviderDao();
        l.addAll(messageProviderDao.listAll((DbDefaultFilter)messageProviderFilter, 1));
        return l;
    }
}

