/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.LengthUnitDao;
import com.prelytis.dashboard.dao.PageDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbLengthUnitFilter;
import com.prelytis.dashboard.dao.filter.DbPageFilter;
import com.prelytis.dashboard.dao.filter.DbPageLayoutFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.LengthUnitHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.util.FormatCheck;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanLengthUnit;
import com.prelytis.dashboard.value.data.BeanPage;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class PageHelper
extends ParameterHelper
implements Dependency,
References {
    private final PageDao dao;

    PageHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getPageDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanPage)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanPage)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanPage)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.PAGE);
    }

    public BeanPage create(ExpressionEvaluationData data) throws DashboardException {
        BeanPage elt = new BeanPage();
        this.helper.updateDescKey((Bean)elt, false);
        LengthUnitHelper lengthUnitHelper = new LengthUnitHelper(this.daoFactory);
        List<Element> lengthUnitList = lengthUnitHelper.list(null, 2, null, 1, data);
        if (lengthUnitList.isEmpty()) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException(ErrorCode.INSIGHT_LENGTH_UNIT_NAME_NOT_FOUND, null, null, null);
        }
        BeanLengthUnit lengthUnit = (BeanLengthUnit)lengthUnitList.get(0);
        elt.setLengthUnitName(lengthUnit.getName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanPage elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.PAGE);
    }

    private ParameterResponse getSave(BeanPage elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.PAGE);
    }

    public void save(BeanPage elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanPage elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids(elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        if (!FormatCheck.isPositifNumeric((String)String.valueOf(elt.getWidth()), (int)6, (int)2)) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("invalidNumber", null, null);
        }
        if (!FormatCheck.isPositifNumeric((String)String.valueOf(elt.getHeight()), (int)6, (int)2)) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("invalidNumber", null, null);
        }
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanPage elt = this.helper.get((Dao)this.dao, name, 1, BeanPage.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanPage elt = this.helper.get((Dao)this.dao, name, instanceType, BeanPage.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.PAGE);
    }

    private void updateNames(BeanPage bean) throws DashboardException {
        bean.setLengthUnitName(this.getName(SessionParameterType.LENGTH_UNIT, bean.getLengthUnitOID()));
    }

    private void updateOids(BeanPage bean) throws DashboardException {
        bean.setLengthUnitOID(this.getOid(SessionParameterType.LENGTH_UNIT, bean.getLengthUnitName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanPage elt = this.helper.get((Dao)this.dao, name, 2, BeanPage.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.PAGE);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.PAGE).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.PAGE);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.PAGE, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanPage elt = this.helper.get((Dao)this.daoFactory.getPageDao(), value.getName(), 1, BeanPage.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.PAGE);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbPageFilter filter = this.helper.getFilter(defaultFilter, data, DbPageFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanPage)elt);
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbPageLayoutFilter pageLayoutFilter = new DbPageLayoutFilter();
        pageLayoutFilter.setPageOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)pageLayoutFilter, SessionParameterType.PAGE_LAYOUT));
        return list;
    }

    public static PageHelper getInstance(DaoFactory daoFactory) {
        return new PageHelper(daoFactory);
    }

    public BeanPage getDefinition(String name) throws DashboardException {
        BeanPage bean = this.helper.get((Dao)this.dao, name, 2, BeanPage.class);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbLengthUnitFilter lengthUnitFilter = new DbLengthUnitFilter();
        lengthUnitFilter.setUsedByPage(oid);
        LengthUnitDao lengthUnitDao = this.daoFactory.getLengthUnitDao();
        l.addAll(lengthUnitDao.listAll((DbDefaultFilter)lengthUnitFilter, 1));
        return l;
    }
}

