/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.ColorListHelper;
import com.prelytis.dashboard.model.helper.ControlGroupHelper;
import com.prelytis.dashboard.model.helper.ControlHelper;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ExecutionContextHelper;
import com.prelytis.dashboard.model.helper.ExtSessionHelper;
import com.prelytis.dashboard.model.helper.FieldGroupHelper;
import com.prelytis.dashboard.model.helper.FolderHelper;
import com.prelytis.dashboard.model.helper.FormHelper;
import com.prelytis.dashboard.model.helper.Helper;
import com.prelytis.dashboard.model.helper.ImportHelper;
import com.prelytis.dashboard.model.helper.JdbcDriverHelper;
import com.prelytis.dashboard.model.helper.LanguageHelper;
import com.prelytis.dashboard.model.helper.LengthUnitHelper;
import com.prelytis.dashboard.model.helper.LinkHelper;
import com.prelytis.dashboard.model.helper.MaintenancePeriodHelper;
import com.prelytis.dashboard.model.helper.MessageProviderHelper;
import com.prelytis.dashboard.model.helper.MessageTypeHelper;
import com.prelytis.dashboard.model.helper.MetricHelper;
import com.prelytis.dashboard.model.helper.PageHelper;
import com.prelytis.dashboard.model.helper.PageLayoutHelper;
import com.prelytis.dashboard.model.helper.PersFieldHelper;
import com.prelytis.dashboard.model.helper.PerspectiveHelper;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.SessionGroupHelper;
import com.prelytis.dashboard.model.helper.SessionHelper;
import com.prelytis.dashboard.model.helper.SqlFunctionGroupHelper;
import com.prelytis.dashboard.model.helper.SqlFunctionHelper;
import com.prelytis.dashboard.model.helper.SqlFunctionImplHelper;
import com.prelytis.dashboard.model.helper.SqlStyleHelper;
import com.prelytis.dashboard.model.helper.StrategicObjectiveHelper;
import com.prelytis.dashboard.model.helper.StrokeTypeHelper;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.model.helper.TaskGroupHelper;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.model.helper.TextHelper;
import com.prelytis.dashboard.model.helper.ThemeHelper;
import com.prelytis.dashboard.model.helper.ThresholdTypeHelper;
import com.prelytis.dashboard.model.helper.TimeUnitHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.model.helper.UserManagementHelper;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.model.helper.WorldHelper;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanColorListDefinition;
import com.prelytis.dashboard.value.data.BeanControlGroup;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanEntityDefinition;
import com.prelytis.dashboard.value.data.BeanExecutionContext;
import com.prelytis.dashboard.value.data.BeanExtSessionDefinition;
import com.prelytis.dashboard.value.data.BeanFieldGroup;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.BeanFormDefinition;
import com.prelytis.dashboard.value.data.BeanImportDefinition;
import com.prelytis.dashboard.value.data.BeanJDBCDriverDefinition;
import com.prelytis.dashboard.value.data.BeanLanguage;
import com.prelytis.dashboard.value.data.BeanLengthUnit;
import com.prelytis.dashboard.value.data.BeanLinkDefinition;
import com.prelytis.dashboard.value.data.BeanMaintenancePeriod;
import com.prelytis.dashboard.value.data.BeanMessageProvDefinition;
import com.prelytis.dashboard.value.data.BeanMessageTypeDefinition;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanPage;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanPersField;
import com.prelytis.dashboard.value.data.BeanPerspective;
import com.prelytis.dashboard.value.data.BeanQueryDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFctImplDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFunctionDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFunctionGroup;
import com.prelytis.dashboard.value.data.BeanSQLStyle;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanSessionGroup;
import com.prelytis.dashboard.value.data.BeanStrategicObjective;
import com.prelytis.dashboard.value.data.BeanStrokeTypeDefinition;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanTaskControl;
import com.prelytis.dashboard.value.data.BeanTaskDefinition;
import com.prelytis.dashboard.value.data.BeanTaskGroup;
import com.prelytis.dashboard.value.data.BeanTaskMetric;
import com.prelytis.dashboard.value.data.BeanText;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.BeanThresholdTypeDefinition;
import com.prelytis.dashboard.value.data.BeanTimeUnit;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.BeanWorkspaceDefinition;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class ParameterHelper {
    protected final Helper helper;
    protected final DaoFactory daoFactory;
    protected final GuidFactory guidFactory;

    protected ParameterHelper(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
        this.guidFactory = GuidFactory.getInstance();
        this.helper = Helper.getInstance(daoFactory, this.guidFactory);
    }

    public abstract ParameterResponse getResponse(ParameterRequest var1, ExpressionEvaluationData var2) throws DashboardException;

    public abstract ParametersListResponse getResponse(ParametersListRequest var1, ExpressionEvaluationData var2) throws DashboardException;

    public static final ParameterHelper getInstance(DaoFactory daoFactory, SessionParameterType sessionParameterType) {
        if (sessionParameterType != null) {
            switch (sessionParameterType) {
                case COLOR_LIST: {
                    return new ColorListHelper(daoFactory);
                }
                case CONTROL_GROUP: {
                    return new ControlGroupHelper(daoFactory);
                }
                case CONTROL: {
                    return new ControlHelper(daoFactory);
                }
                case DASHBOARD: {
                    return new DashBoardHelper(daoFactory);
                }
                case ENTITY: {
                    return new EntityHelper(daoFactory);
                }
                case EXECUTION_CONTEXT: {
                    return new ExecutionContextHelper(daoFactory);
                }
                case EXTERN_SESSION: {
                    return new ExtSessionHelper(daoFactory);
                }
                case FIELD_GROUP: {
                    return new FieldGroupHelper(daoFactory);
                }
                case FOLDER: {
                    return new FolderHelper(daoFactory);
                }
                case FORM: {
                    return new FormHelper(daoFactory);
                }
                case IMPORT_TASK: {
                    return new ImportHelper(daoFactory);
                }
                case JDBC_DRIVER: {
                    return new JdbcDriverHelper(daoFactory);
                }
                case LANGUAGE: {
                    return new LanguageHelper(daoFactory);
                }
                case LENGTH_UNIT: {
                    return new LengthUnitHelper(daoFactory);
                }
                case LINK: {
                    return new LinkHelper(daoFactory);
                }
                case MAINTENANCE_PERIOD: {
                    return new MaintenancePeriodHelper(daoFactory);
                }
                case MESSAGE_PROVIDER: {
                    return new MessageProviderHelper(daoFactory);
                }
                case MESSAGE_TYPE: {
                    return new MessageTypeHelper(daoFactory);
                }
                case METRIC: {
                    return new MetricHelper(daoFactory);
                }
                case PAGE: {
                    return new PageHelper(daoFactory);
                }
                case PAGE_LAYOUT: {
                    return new PageLayoutHelper(daoFactory);
                }
                case PERS_FIELD: {
                    return new PersFieldHelper(daoFactory);
                }
                case PERSPECTIVE: {
                    return new PerspectiveHelper(daoFactory);
                }
                case SETTINGS: {
                    return new PrelytisInfoHelper(daoFactory);
                }
                case QUERY: {
                    return new QueryHelper(daoFactory);
                }
                case REPORT: {
                    return new ReportHelper(daoFactory);
                }
                case SESSION: {
                    return new SessionHelper(daoFactory);
                }
                case SESSION_GROUP: {
                    return new SessionGroupHelper(daoFactory);
                }
                case SQL_FUNCTION: {
                    return new SqlFunctionHelper(daoFactory);
                }
                case SQL_FUNCTION_GROUP: {
                    return new SqlFunctionGroupHelper(daoFactory);
                }
                case SQL_FUNCTION_IMPL: {
                    return new SqlFunctionImplHelper(daoFactory);
                }
                case SQL_STYLE: {
                    return new SqlStyleHelper(daoFactory);
                }
                case STRATEGIC_OBJECTIVE: {
                    return new StrategicObjectiveHelper(daoFactory);
                }
                case STROKE_TYPE: {
                    return new StrokeTypeHelper(daoFactory);
                }
                case STYLE: {
                    return new StyleHelper(daoFactory);
                }
                case TASK: {
                    return new TaskHelper(daoFactory);
                }
                case TASK_GROUP: {
                    return new TaskGroupHelper(daoFactory);
                }
                case TEXT: {
                    return new TextHelper(daoFactory);
                }
                case THEME: {
                    return new ThemeHelper(daoFactory);
                }
                case THRESHOLD_TYPE: {
                    return new ThresholdTypeHelper(daoFactory);
                }
                case TIME_UNIT: {
                    return new TimeUnitHelper(daoFactory);
                }
                case USER: {
                    return new UserHelper(daoFactory);
                }
                case USER_MANAGEMENT: {
                    return new UserManagementHelper(daoFactory);
                }
                case WORKSPACE: {
                    return new WorkspaceHelper(daoFactory);
                }
                case WORLD: {
                    return new WorldHelper(daoFactory);
                }
            }
        }
        throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN);
    }

    protected final DashboardException getException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        return new DashboardException((Throwable)e);
    }

    protected String getName(SessionParameterType type, int objectId) throws DashboardException {
        if (objectId == 0) {
            return null;
        }
        Dao dao = this.daoFactory.getDao(type);
        try {
            Bean elt = dao.getCore(objectId);
            return elt.getName();
        }
        catch (DashboardRuntimeException dre) {
            throw this.getException(type, dre, this.getParam(type, objectId));
        }
    }

    protected String getName(SessionParameterType type, Integer objectId) throws DashboardException {
        if (objectId == null || objectId == 0) {
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException("notFound", null, null);
        }
        Dao dao = this.daoFactory.getDao(type);
        try {
            Bean elt = dao.getCore(objectId.intValue());
            return elt.getName();
        }
        catch (DashboardRuntimeException dre) {
            throw this.getException(type, dre, this.getParam(type, objectId));
        }
    }

    protected String optName(SessionParameterType type, Integer objectId) throws DashboardException {
        if (objectId == null || objectId == 0) {
            return null;
        }
        Dao dao = this.daoFactory.getDao(type);
        try {
            Bean elt = dao.getCore(objectId.intValue());
            return elt.getName();
        }
        catch (DashboardRuntimeException dre) {
            throw this.getException(type, dre, this.getParam(type, objectId));
        }
    }

    protected int getOid(SessionParameterType type, String name) throws DashboardException {
        if (name == null || name.isEmpty()) {
            ErrorCode code = this.getMissingNameCode(type);
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException(code, "missingName", null, null);
        }
        Dao dao = this.daoFactory.getDao(type);
        try {
            Bean elt = dao.getCore(name);
            return elt.getObjectID();
        }
        catch (DashboardRuntimeException dre) {
            throw this.getException(type, dre, this.getParam(type, name));
        }
    }

    protected Integer optOid(SessionParameterType type, String name) throws DashboardException {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Dao dao = this.daoFactory.getDao(type);
        try {
            Bean elt = dao.getCore(name);
            return elt.getObjectID();
        }
        catch (DashboardRuntimeException dre) {
            throw this.getException(type, dre, this.getParam(type, name));
        }
    }

    protected Integer[] optOids(SessionParameterType type, String name) throws DashboardException {
        Integer o = this.optOid(type, name);
        if (o == null) {
            return null;
        }
        return new Integer[]{o};
    }

    protected <T extends Bean> T getCore(SessionParameterType type, String name, Class<T> clazz) throws DashboardException {
        if (name == null || name.isEmpty()) {
            ErrorCode code = this.getMissingNameCode(type);
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException(code, "missingName", null, null);
        }
        Dao dao = this.daoFactory.getDao(type);
        try {
            Bean elt = dao.getCore(name);
            return (T)((Bean)clazz.cast(elt));
        }
        catch (DashboardRuntimeException dre) {
            throw this.getException(type, dre, this.getParam(type, name));
        }
    }

    protected <T extends Bean> T getDefinition(SessionParameterType type, String name, Class<T> clazz) throws DashboardException {
        if (name == null || name.isEmpty()) {
            ErrorCode code = this.getMissingNameCode(type);
            throw ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException(code, "missingName", null, null);
        }
        Dao dao = this.daoFactory.getDao(type);
        try {
            Bean elt = dao.getDefinition(name);
            return (T)((Bean)clazz.cast(elt));
        }
        catch (DashboardRuntimeException dre) {
            throw this.getException(type, dre, this.getParam(type, name));
        }
    }

    private String getParam(SessionParameterType sessionParameterType, String name) {
        return sessionParameterType.toString() + "/" + name;
    }

    private String getParam(SessionParameterType sessionParameterType, int oid) {
        return sessionParameterType.toString() + "/" + oid;
    }

    private DashboardException getException(SessionParameterType sessionParameterType, DashboardRuntimeException dre, String param) {
        if (dre.getCode() == ErrorCode.NOT_FOUND_ERROR) {
            ErrorCode code = this.getNameNotFoundCode(sessionParameterType);
            return ExceptionHelper.getInstance(Locale.ENGLISH).createDashboardException(code, "notFound", new Object[]{param}, dre);
        }
        DashboardException de = new DashboardException(dre.getCode(), (Throwable)dre, null);
        return de;
    }

    public abstract List<Element> list(DefaultFilter var1, int var2, ParametersListRequest.SortedField var3, Integer var4, ExpressionEvaluationData var5) throws DashboardException;

    protected <T extends Element> Map<String, T> getMap(List<Element> list, Class<T> clazz) {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element elt : list) {
            Element t = (Element)clazz.cast(elt);
            map.put(t.getName(), t);
        }
        return map;
    }

    protected <T extends Element> Map<String, T> getMap(List<T> list) {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element elt : list) {
            map.put(elt.getName(), elt);
        }
        return map;
    }

    protected <T extends Element> List<T> asList(List<Element> list, Class<T> clazz) {
        ArrayList<T> newList = new ArrayList<T>();
        for (Element e : list) {
            newList.add(clazz.cast(e));
        }
        return newList;
    }

    private ErrorCode getMissingNameCode(SessionParameterType type) {
        assert (type != null);
        switch (type) {
            case COLOR_LIST: {
                return ErrorCode.INSIGHT_MISSING_COLOR_LIST_NAME;
            }
            case CONTROL_GROUP: {
                return ErrorCode.INSIGHT_MISSING_CONTROL_GROUP_NAME;
            }
            case CONTROL: {
                return ErrorCode.INSIGHT_MISSING_CONTROL_NAME;
            }
            case DASHBOARD: {
                return ErrorCode.INSIGHT_MISSING_DASHBOARD_NAME;
            }
            case DISPLAY_TYPE: {
                return ErrorCode.INSIGHT_MISSING_DISPLAY_TYPE_NAME;
            }
            case ENTITY: {
                return ErrorCode.INSIGHT_MISSING_ENTITY_NAME;
            }
            case EXECUTION_CONTEXT: {
                return ErrorCode.INSIGHT_MISSING_EXECUTION_CONTEXT_NAME;
            }
            case EXPORT_XML: {
                return ErrorCode.INSIGHT_MISSING_EXPORT_XML_NAME;
            }
            case EXTERN_SESSION: {
                return ErrorCode.INSIGHT_MISSING_EXTERN_SESSION_NAME;
            }
            case FIELD_GROUP: {
                return ErrorCode.INSIGHT_MISSING_FIELD_GROUP_NAME;
            }
            case FOLDER: {
                return ErrorCode.INSIGHT_MISSING_FOLDER_NAME;
            }
            case FORM: {
                return ErrorCode.INSIGHT_MISSING_FORM_NAME;
            }
            case IMPORT_TASK: {
                return ErrorCode.INSIGHT_MISSING_IMPORT_TASK_NAME;
            }
            case IMPORT_XML: {
                return ErrorCode.INSIGHT_MISSING_IMPORT_XML_NAME;
            }
            case JDBC_DRIVER: {
                return ErrorCode.INSIGHT_MISSING_JDBC_DRIVER_NAME;
            }
            case LANGUAGE: {
                return ErrorCode.INSIGHT_MISSING_LANGUAGE_NAME;
            }
            case LENGTH_UNIT: {
                return ErrorCode.INSIGHT_MISSING_LENGTH_UNIT_NAME;
            }
            case LINK: {
                return ErrorCode.INSIGHT_MISSING_LINK_NAME;
            }
            case MAINTENANCE_PERIOD: {
                return ErrorCode.INSIGHT_MISSING_MAINTENANCE_PERIOD_NAME;
            }
            case MESSAGE_PROVIDER: {
                return ErrorCode.INSIGHT_MISSING_MESSAGE_PROVIDER_NAME;
            }
            case MESSAGE_TYPE: {
                return ErrorCode.INSIGHT_MISSING_MESSAGE_TYPE_NAME;
            }
            case METRIC: {
                return ErrorCode.INSIGHT_MISSING_METRIC_NAME;
            }
            case PAGE: {
                return ErrorCode.INSIGHT_MISSING_PAGE_NAME;
            }
            case PAGE_LAYOUT: {
                return ErrorCode.INSIGHT_MISSING_PAGE_LAYOUT_NAME;
            }
            case PERS_FIELD: {
                return ErrorCode.INSIGHT_MISSING_PERS_FIELD_NAME;
            }
            case PERSPECTIVE: {
                return ErrorCode.INSIGHT_MISSING_PERSPECTIVE_NAME;
            }
            case QUERY: {
                return ErrorCode.INSIGHT_MISSING_QUERY_NAME;
            }
            case REPORT: {
                return ErrorCode.INSIGHT_MISSING_REPORT_NAME;
            }
            case SESSION_GROUP: {
                return ErrorCode.INSIGHT_MISSING_SESSION_GROUP_NAME;
            }
            case SQL_FUNCTION: {
                return ErrorCode.INSIGHT_MISSING_SQL_FUNCTION_NAME;
            }
            case SQL_FUNCTION_GROUP: {
                return ErrorCode.INSIGHT_MISSING_SQL_FUNCTION_GROUP_NAME;
            }
            case SQL_FUNCTION_IMPL: {
                return ErrorCode.INSIGHT_MISSING_SQL_FUNCTION_IMPL_NAME;
            }
            case SQL_STYLE: {
                return ErrorCode.INSIGHT_MISSING_SQL_STYLE_NAME;
            }
            case STRATEGIC_OBJECTIVE: {
                return ErrorCode.INSIGHT_MISSING_STRATEGIC_OBJECTIVE_NAME;
            }
            case STROKE_TYPE: {
                return ErrorCode.INSIGHT_MISSING_STROKE_TYPE_NAME;
            }
            case STYLE: {
                return ErrorCode.INSIGHT_MISSING_STYLE_NAME;
            }
            case TASK: {
                return ErrorCode.INSIGHT_MISSING_TASK_NAME;
            }
            case TASK_GROUP: {
                return ErrorCode.INSIGHT_MISSING_TASK_GROUP_NAME;
            }
            case TEXT: {
                return ErrorCode.INSIGHT_MISSING_TEXT_NAME;
            }
            case THEME: {
                return ErrorCode.INSIGHT_MISSING_THEME_NAME;
            }
            case THRESHOLD_TYPE: {
                return ErrorCode.INSIGHT_MISSING_THRESHOLD_TYPE_NAME;
            }
            case TIME_UNIT: {
                return ErrorCode.INSIGHT_MISSING_TIME_UNIT_NAME;
            }
            case USER: {
                return ErrorCode.INSIGHT_MISSING_USER_NAME;
            }
            case USER_MANAGEMENT: {
                return ErrorCode.INSIGHT_MISSING_USER_MANAGEMENT_NAME;
            }
            case WORKSPACE: {
                return ErrorCode.INSIGHT_MISSING_WORKSPACE_NAME;
            }
            case WORLD: {
                return ErrorCode.INSIGHT_MISSING_WORLD_NAME;
            }
            case SESSION: {
                return ErrorCode.INSIGHT_SESSION_NAME;
            }
            case SETTINGS: {
                return ErrorCode.INSIGHT_SETTINGS_NAME;
            }
            case TASK_MANAGEMENT: {
                return ErrorCode.INSIGHT_TASK_MANAGEMENT_NAME;
            }
        }
        throw new AssertionError();
    }

    private ErrorCode getNameNotFoundCode(SessionParameterType type) {
        assert (type != null);
        switch (type) {
            case COLOR_LIST: {
                return ErrorCode.INSIGHT_COLOR_LIST_NAME_NOT_FOUND;
            }
            case CONTROL_GROUP: {
                return ErrorCode.INSIGHT_CONTROL_GROUP_NAME_NOT_FOUND;
            }
            case CONTROL: {
                return ErrorCode.INSIGHT_CONTROL_NOT_FOUND;
            }
            case DASHBOARD: {
                return ErrorCode.INSIGHT_DASHBOARD_NAME_NOT_FOUND;
            }
            case DISPLAY_TYPE: {
                return ErrorCode.INSIGHT_DISPLAY_TYPE_NAME_NOT_FOUND;
            }
            case ENTITY: {
                return ErrorCode.INSIGHT_ENTITY_NAME_NOT_FOUND;
            }
            case EXECUTION_CONTEXT: {
                return ErrorCode.INSIGHT_EXECUTION_CONTEXT_NAME_NOT_FOUND;
            }
            case EXPORT_XML: {
                return ErrorCode.INSIGHT_EXPORT_XML_NAME_NOT_FOUND;
            }
            case EXTERN_SESSION: {
                return ErrorCode.INSIGHT_EXTERN_SESSION_NAME_NOT_FOUND;
            }
            case FIELD_GROUP: {
                return ErrorCode.INSIGHT_FIELD_GROUP_NAME_NOT_FOUND;
            }
            case FOLDER: {
                return ErrorCode.INSIGHT_FOLDER_NAME_NOT_FOUND;
            }
            case FORM: {
                return ErrorCode.INSIGHT_FORM_NAME_NOT_FOUND;
            }
            case IMPORT_TASK: {
                return ErrorCode.INSIGHT_IMPORT_TASK_NAME_NOT_FOUND;
            }
            case IMPORT_XML: {
                return ErrorCode.INSIGHT_IMPORT_XML_NAME_NOT_FOUND;
            }
            case JDBC_DRIVER: {
                return ErrorCode.INSIGHT_JDBC_DRIVER_NAME_NOT_FOUND;
            }
            case LANGUAGE: {
                return ErrorCode.INSIGHT_LANGUAGE_NAME_NOT_FOUND;
            }
            case LENGTH_UNIT: {
                return ErrorCode.INSIGHT_LENGTH_UNIT_NAME_NOT_FOUND;
            }
            case LINK: {
                return ErrorCode.INSIGHT_LINK_NAME_NOT_FOUND;
            }
            case MAINTENANCE_PERIOD: {
                return ErrorCode.INSIGHT_MAINTENANCE_PERIOD_NAME_NOT_FOUND;
            }
            case MESSAGE_PROVIDER: {
                return ErrorCode.INSIGHT_MESSAGE_PROVIDER_NAME_NOT_FOUND;
            }
            case MESSAGE_TYPE: {
                return ErrorCode.INSIGHT_MESSAGE_TYPE_NAME_NOT_FOUND;
            }
            case METRIC: {
                return ErrorCode.INSIGHT_METRIC_NOT_FOUND;
            }
            case PAGE: {
                return ErrorCode.INSIGHT_PAGE_NAME_NOT_FOUND;
            }
            case PAGE_LAYOUT: {
                return ErrorCode.INSIGHT_PAGE_LAYOUT_NAME_NOT_FOUND;
            }
            case PERS_FIELD: {
                return ErrorCode.INSIGHT_PERS_FIELD_NAME_NOT_FOUND;
            }
            case PERSPECTIVE: {
                return ErrorCode.INSIGHT_PERSPECTIVE_NAME_NOT_FOUND;
            }
            case QUERY: {
                return ErrorCode.INSIGHT_QUERY_NAME_NOT_FOUND;
            }
            case REPORT: {
                return ErrorCode.INSIGHT_REPORT_NAME_NOT_FOUND;
            }
            case SESSION_GROUP: {
                return ErrorCode.INSIGHT_SESSION_GROUP_NAME_NOT_FOUND;
            }
            case SQL_FUNCTION: {
                return ErrorCode.INSIGHT_SQL_FUNCTION_NAME_NOT_FOUND;
            }
            case SQL_FUNCTION_GROUP: {
                return ErrorCode.INSIGHT_SQL_FUNCTION_GROUP_NAME_NOT_FOUND;
            }
            case SQL_FUNCTION_IMPL: {
                return ErrorCode.INSIGHT_SQL_FUNCTION_IMPL_NAME_NOT_FOUND;
            }
            case SQL_STYLE: {
                return ErrorCode.INSIGHT_SQL_STYLE_NAME_NOT_FOUND;
            }
            case STRATEGIC_OBJECTIVE: {
                return ErrorCode.INSIGHT_STRATEGIC_OBJECTIVE_NAME_NOT_FOUND;
            }
            case STROKE_TYPE: {
                return ErrorCode.INSIGHT_STROKE_TYPE_NAME_NOT_FOUND;
            }
            case STYLE: {
                return ErrorCode.INSIGHT_STYLE_NAME_NOT_FOUND;
            }
            case TASK: {
                return ErrorCode.INSIGHT_TASK_NAME_NOT_FOUND;
            }
            case TASK_GROUP: {
                return ErrorCode.INSIGHT_TASK_GROUP_NAME_NOT_FOUND;
            }
            case TEXT: {
                return ErrorCode.INSIGHT_TEXT_NAME_NOT_FOUND;
            }
            case THEME: {
                return ErrorCode.INSIGHT_THEME_NAME_NOT_FOUND;
            }
            case THRESHOLD_TYPE: {
                return ErrorCode.INSIGHT_THRESHOLD_TYPE_NAME_NOT_FOUND;
            }
            case TIME_UNIT: {
                return ErrorCode.INSIGHT_TIME_UNIT_NAME_NOT_FOUND;
            }
            case USER: {
                return ErrorCode.INSIGHT_USER_NAME_NOT_FOUND;
            }
            case USER_MANAGEMENT: {
                return ErrorCode.INSIGHT_USER_MANAGEMENT_NAME_NOT_FOUND;
            }
            case WORKSPACE: {
                return ErrorCode.INSIGHT_WORKSPACE_NAME_NOT_FOUND;
            }
            case WORLD: {
                return ErrorCode.INSIGHT_WORLD_NAME_NOT_FOUND;
            }
            case SESSION: {
                return ErrorCode.INSIGHT_SESSION_NAME_NOT_FOUND;
            }
            case SETTINGS: {
                return ErrorCode.INSIGHT_SETTINGS_NAME_NOT_FOUND;
            }
            case TASK_MANAGEMENT: {
                return ErrorCode.INSIGHT_TASK_MANAGEMENT_NAME_NOT_FOUND;
            }
        }
        throw new AssertionError();
    }

    protected final ParameterResponse getDelete(String name, Bean element, ExpressionEvaluationData data) throws DashboardException {
        this.delete(element == null ? name : element.getName(), data);
        return new ParameterResponse();
    }

    public abstract Bean create(ExpressionEvaluationData var1) throws DashboardException;

    public abstract void delete(String var1, ExpressionEvaluationData var2) throws DashboardException;

    public static void save(DaoFactory daoFactory, Bean elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        ParameterHelper.save(daoFactory, elt, data, isNew, false);
    }

    public static void save(DaoFactory daoFactory, Bean elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        switch (elt.getSessionParameterType()) {
            case COLOR_LIST: {
                ColorListHelper.getInstance(daoFactory).save((BeanColorListDefinition)elt, data, isNew, isImport);
                break;
            }
            case CONTROL_GROUP: {
                ControlGroupHelper.getInstance(daoFactory).save((BeanControlGroup)elt, data, isNew);
                break;
            }
            case CONTROL: {
                ControlHelper.getInstance(daoFactory).save((BeanTaskControl)elt, data, isNew, isImport);
                break;
            }
            case DASHBOARD: {
                DashBoardHelper.getInstance(daoFactory).save((BeanDashBoardDefinition)elt, data, isNew, isImport);
                break;
            }
            case ENTITY: {
                EntityHelper.getInstance(daoFactory).save((BeanEntityDefinition)elt, data, isNew, isImport);
                break;
            }
            case EXECUTION_CONTEXT: {
                ExecutionContextHelper.getInstance(daoFactory).save((BeanExecutionContext)elt, data, isNew, isImport);
                break;
            }
            case EXTERN_SESSION: {
                ExtSessionHelper.getInstance(daoFactory).save((BeanExtSessionDefinition)elt, data, isNew, isImport);
                break;
            }
            case FIELD_GROUP: {
                FieldGroupHelper.getInstance(daoFactory).save((BeanFieldGroup)elt, data, isNew, isImport);
                break;
            }
            case FOLDER: {
                FolderHelper.getInstance(daoFactory).save((BeanFile)elt, data, isNew, isImport);
                break;
            }
            case FORM: {
                FormHelper.getInstance(daoFactory).save((BeanFormDefinition)elt, data, isNew, isImport);
                break;
            }
            case IMPORT_TASK: {
                ImportHelper.getInstance(daoFactory).save((BeanImportDefinition)elt, data, isNew, isImport);
                break;
            }
            case JDBC_DRIVER: {
                JdbcDriverHelper.getInstance(daoFactory).save((BeanJDBCDriverDefinition)elt, data, isNew, isImport);
                break;
            }
            case LANGUAGE: {
                LanguageHelper.getInstance(daoFactory).save((BeanLanguage)elt, data, isNew, isImport);
                break;
            }
            case LENGTH_UNIT: {
                LengthUnitHelper.getInstance(daoFactory).save((BeanLengthUnit)elt, data, isNew, isImport);
                break;
            }
            case LINK: {
                LinkHelper.getInstance(daoFactory).save((BeanLinkDefinition)elt, data, isNew, isImport);
                break;
            }
            case MAINTENANCE_PERIOD: {
                MaintenancePeriodHelper.getInstance(daoFactory).save((BeanMaintenancePeriod)elt, data, isNew, isImport);
                break;
            }
            case MESSAGE_PROVIDER: {
                MessageProviderHelper.getInstance(daoFactory).save((BeanMessageProvDefinition)elt, data, isNew, isImport);
                break;
            }
            case MESSAGE_TYPE: {
                MessageTypeHelper.getInstance(daoFactory).save((BeanMessageTypeDefinition)elt, data, isNew, isImport);
                break;
            }
            case METRIC: {
                MetricHelper.getInstance(daoFactory).save((BeanTaskMetric)elt, data, isNew, isImport);
                break;
            }
            case PAGE: {
                PageHelper.getInstance(daoFactory).save((BeanPage)elt, data, isNew, isImport);
                break;
            }
            case PAGE_LAYOUT: {
                PageLayoutHelper.getInstance(daoFactory).save((BeanPageLayout)elt, data, isNew, isImport);
                break;
            }
            case PERS_FIELD: {
                PersFieldHelper.getInstance(daoFactory).save((BeanPersField)elt, data, isNew, isImport);
                break;
            }
            case PERSPECTIVE: {
                PerspectiveHelper.getInstance(daoFactory).save((BeanPerspective)elt, data, isNew, isImport);
                break;
            }
            case SETTINGS: {
                PrelytisInfoHelper.getInstance(daoFactory).save((BeanPRPInfo)elt, data, isImport);
                break;
            }
            case QUERY: {
                QueryHelper.getInstance(daoFactory).save((BeanQueryDefinition)elt, data, isNew, isImport);
                break;
            }
            case REPORT: {
                ReportHelper.getInstance(daoFactory).save((AbstractBeanReport)elt, data, isNew, isImport);
                break;
            }
            case SESSION: {
                SessionHelper.getInstance(daoFactory).save((BeanSession)elt, data, isNew, isImport);
                break;
            }
            case SESSION_GROUP: {
                SessionGroupHelper.getInstance(daoFactory).save((BeanSessionGroup)elt, data, isNew, isImport);
                break;
            }
            case SQL_FUNCTION: {
                SqlFunctionHelper.getInstance(daoFactory).save((BeanSQLFunctionDefinition)elt, data, isNew, isImport);
                break;
            }
            case SQL_FUNCTION_GROUP: {
                SqlFunctionGroupHelper.getInstance(daoFactory).save((BeanSQLFunctionGroup)elt, data, isNew, isImport);
                break;
            }
            case SQL_FUNCTION_IMPL: {
                SqlFunctionImplHelper.getInstance(daoFactory).save((BeanSQLFctImplDefinition)elt, data, isNew, isImport);
                break;
            }
            case SQL_STYLE: {
                SqlStyleHelper.getInstance(daoFactory).save((BeanSQLStyle)elt, data, isNew, isImport);
                break;
            }
            case STRATEGIC_OBJECTIVE: {
                StrategicObjectiveHelper.getInstance(daoFactory).save((BeanStrategicObjective)elt, data, isNew, isImport);
                break;
            }
            case STROKE_TYPE: {
                StrokeTypeHelper.getInstance(daoFactory).save((BeanStrokeTypeDefinition)elt, data, isNew, isImport);
                break;
            }
            case STYLE: {
                StyleHelper.getInstance(daoFactory).save((BeanStyleDefinition)elt, data, isNew, isImport);
                break;
            }
            case TASK: {
                TaskHelper.getInstance(daoFactory).save((BeanTaskDefinition)elt, data, isNew, isImport);
                break;
            }
            case TASK_GROUP: {
                TaskGroupHelper.getInstance(daoFactory).save((BeanTaskGroup)elt, data, isNew, isImport);
                break;
            }
            case TEXT: {
                TextHelper.getInstance(daoFactory).save((BeanText)elt, data, isNew, isImport);
                break;
            }
            case THEME: {
                ThemeHelper.getInstance(daoFactory).save((BeanThemeDefinition)elt, data, isNew, isImport);
                break;
            }
            case THRESHOLD_TYPE: {
                ThresholdTypeHelper.getInstance(daoFactory).save((BeanThresholdTypeDefinition)elt, data, isNew, isImport);
                break;
            }
            case TIME_UNIT: {
                TimeUnitHelper.getInstance(daoFactory).save((BeanTimeUnit)elt, data, isNew, isImport);
                break;
            }
            case USER: {
                BeanUserDefinition user = (BeanUserDefinition)elt;
                UserHelper userHelper = UserHelper.getInstance(daoFactory);
                userHelper.save(user, data, isNew, isImport);
                userHelper.saveBookmarks(user, data);
                break;
            }
            case WORKSPACE: {
                WorkspaceHelper.getInstance(daoFactory).mergeAndSave((BeanWorkspaceDefinition)elt, data, isImport);
                break;
            }
            case WORLD: {
                WorldHelper.getInstance(daoFactory).save((BeanWorldDefinition)elt, data, isNew, isImport);
                break;
            }
            default: {
                throw new DashboardException();
            }
        }
    }
}

