/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.business.MaintenancePeriodFacade;
import com.prelytis.dashboard.business.StandardAuthenticationFacade;
import com.prelytis.dashboard.business.TraceFacade;
import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.ImportSqlDao;
import com.prelytis.dashboard.dao.LanguageDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbLanguageFilter;
import com.prelytis.dashboard.ext.LdapAuthenticationFacade;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanLanguage;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanPRPInfoModule;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PrelytisInfoHelper
extends ParameterHelper
implements References {
    private static final String ALL = "all";
    private final PrelytisInfoDao dao;

    PrelytisInfoHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getPrelytisInfoDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case SAVE: {
                return this.getSave((BeanPRPInfo)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanPRPInfo elt = this.helper.get((Dao)this.dao, "LiveDashBoard", instanceType, BeanPRPInfo.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SETTINGS);
    }

    private void updateNames(BeanPRPInfo bean) throws DashboardException {
        List exportList;
        ImportSqlDao importSqlDao;
        List importList;
        bean.setLanguageName(this.getName(SessionParameterType.LANGUAGE, bean.getLanguageOID()));
        if (bean.getIpAllowedRest() == null || bean.getIpAllowedRest().isEmpty()) {
            bean.setIpAllowedRest(ALL);
        }
        if ((importList = (importSqlDao = this.daoFactory.getImportSqlDao()).getImportSqlList()) != null) {
            int i = 0;
            for (String s : importList) {
                bean.getImportSqlNameList().add(new BeanPRPInfo.Element(Integer.toString(i, 10), s));
                ++i;
            }
        }
        if ((exportList = importSqlDao.getExportSqlList()) != null) {
            int i = 0;
            for (String s : exportList) {
                bean.getExportSqlNameList().add(new BeanPRPInfo.Element(Integer.toString(i, 10), s));
                ++i;
            }
        }
    }

    private void updateOids(BeanPRPInfo bean) throws DashboardException {
        bean.setLanguageOID(this.getOid(SessionParameterType.LANGUAGE, bean.getLanguageName()));
    }

    private ParameterResponse getSave(BeanPRPInfo elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SETTINGS);
    }

    private boolean isProfileAllowed(int profile, ExpressionEvaluationData data) {
        int userProfile = data.getProfile();
        switch (userProfile) {
            case 2: 
            case 3: {
                return profile <= userProfile;
            }
        }
        return false;
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.SETTINGS).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.SETTINGS);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            DbDefaultFilter filter = this.helper.getFilter(value.getFilter(), data, DbDefaultFilter.class);
            return this.helper.list((Dao)this.dao, filter, instanceType, value.getSortedField(), value.getMaxSize(), false, SessionParameterType.SETTINGS, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<Element> eltList = new ArrayList<Element>();
        BeanPRPInfo elt = this.helper.get((Dao)this.daoFactory.getPrelytisInfoDao(), "LiveDashBoard", instanceType, BeanPRPInfo.class);
        eltList.add((Element)elt);
        return eltList;
    }

    public BeanPRPInfo getPrelytisInfo() throws DashboardException {
        BeanPRPInfo elt = this.helper.get((Dao)this.daoFactory.getPrelytisInfoDao(), "LiveDashBoard", 2, BeanPRPInfo.class);
        this.updateNames(elt);
        return elt;
    }

    public void saveModules(List<BeanPRPInfoModule> modules) {
        this.checkModules(modules);
        this.dao.saveModules(modules);
    }

    public void save(BeanPRPInfo elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
    }

    public void save(BeanPRPInfo elt, ExpressionEvaluationData data, boolean isImport) throws DashboardException {
        BeanPRPInfo prev = (BeanPRPInfo)this.dao.getCore(elt.getName());
        this.helper.checkSaveConcurrency(data, (Bean)elt, isImport, (Bean)prev);
        if (this.isProfileAllowed(prev.getProfileAddDashBoardDepDoc(), data)) {
            if (this.isProfileAllowed(elt.getProfileAddDashBoardDepDoc(), data)) {
                prev.setProfileAddDashBoardDepDoc(elt.getProfileAddDashBoardDepDoc());
            }
            prev.setAddDashBoardDepDoc(elt.isAddDashBoardDepDoc());
        }
        if (this.isProfileAllowed(prev.getProfileAddDocInWorkspace(), data)) {
            if (this.isProfileAllowed(elt.getProfileAddDocInWorkspace(), data)) {
                prev.setProfileAddDocInWorkspace(elt.getProfileAddDocInWorkspace());
            }
            prev.setAddDocInWorkspace(elt.isAddDocInWorkspace());
        }
        if (this.isProfileAllowed(prev.getProfileAutoNameGeneration(), data)) {
            if (this.isProfileAllowed(elt.getProfileAutoNameGeneration(), data)) {
                prev.setProfileAutoNameGeneration(elt.getProfileAutoNameGeneration());
            }
            prev.setAutoNameGeneration(elt.isAutoNameGeneration());
        }
        if (this.isProfileAllowed(prev.getProfileAutoValidateFilter(), data)) {
            if (this.isProfileAllowed(elt.getProfileAutoValidateFilter(), data)) {
                prev.setProfileAutoValidateFilter(elt.getProfileAutoValidateFilter());
            }
            prev.setAutoValidateFilter(elt.isAutoValidateFilter());
        }
        if (this.isProfileAllowed(prev.getProfileChangePasswordEnabled(), data)) {
            if (this.isProfileAllowed(elt.getProfileChangePasswordEnabled(), data)) {
                prev.setProfileChangePasswordEnabled(elt.getProfileChangePasswordEnabled());
            }
            prev.setChangePasswordEnabled(elt.isChangePasswordEnabled());
        }
        if (this.isProfileAllowed(prev.getProfileChromeFrameEnabled(), data)) {
            if (this.isProfileAllowed(elt.getProfileChromeFrameEnabled(), data)) {
                prev.setProfileChromeFrameEnabled(elt.getProfileChromeFrameEnabled());
            }
            prev.setChromeFrameEnabled(elt.isChromeFrameEnabled());
        }
        if (this.isProfileAllowed(prev.getProfileCommentsLifetime(), data)) {
            if (this.isProfileAllowed(elt.getProfileCommentsLifetime(), data)) {
                prev.setProfileCommentsLifetime(elt.getProfileCommentsLifetime());
            }
            prev.setCommentsLifetime(elt.getCommentsLifetime());
        }
        if (this.isProfileAllowed(prev.getProfileDefaultTimeZone(), data)) {
            if (this.isProfileAllowed(elt.getProfileDefaultTimeZone(), data)) {
                prev.setProfileDefaultTimeZone(elt.getProfileDefaultTimeZone());
            }
            prev.setDefaultTimeZone(elt.getDefaultTimeZone());
        }
        if (this.isProfileAllowed(prev.getProfileDirectLink(), data)) {
            if (this.isProfileAllowed(elt.getProfileDirectLink(), data)) {
                prev.setProfileDirectLink(elt.getProfileDirectLink());
            }
            prev.setDirectLink(elt.isDirectLink());
        }
        if (this.isProfileAllowed(prev.getProfileDisplayPopup(), data)) {
            if (this.isProfileAllowed(elt.getProfileDisplayPopup(), data)) {
                prev.setProfileDisplayPopup(elt.getProfileDisplayPopup());
            }
            prev.setDisplayPopup(elt.isDisplayPopup());
        }
        if (this.isProfileAllowed(prev.getProfileDisplayReportFilterTop(), data)) {
            if (this.isProfileAllowed(elt.getProfileDisplayReportFilterTop(), data)) {
                prev.setProfileDisplayReportFilterTop(elt.getProfileDisplayReportFilterTop());
            }
            prev.setDisplayReportFilterTop(elt.isDisplayReportFilterTop());
        }
        if (this.isProfileAllowed(prev.getProfileSimplifiedRuleEnabled(), data)) {
            if (this.isProfileAllowed(elt.getProfileSimplifiedRuleEnabled(), data)) {
                prev.setProfileSimplifiedRuleEnabled(elt.getProfileSimplifiedRuleEnabled());
            }
            prev.setSimplifiedRuleEnabled(elt.isSimplifiedRuleEnabled());
        }
        if (this.isProfileAllowed(prev.getProfileDisplayTooltips(), data)) {
            if (this.isProfileAllowed(elt.getProfileDisplayTooltips(), data)) {
                prev.setProfileDisplayTooltips(elt.getProfileDisplayTooltips());
            }
            prev.setDisplayTooltips(elt.isDisplayTooltips());
        }
        if (this.isProfileAllowed(prev.getProfileFixDatabaseOnStartup(), data)) {
            if (this.isProfileAllowed(elt.getProfileFixDatabaseOnStartup(), data)) {
                prev.setProfileFixDatabaseOnStartup(elt.getProfileFixDatabaseOnStartup());
            }
            prev.setFixDatabaseOnStartup(elt.isFixDatabaseOnStartup());
        }
        if (this.isProfileAllowed(prev.getProfileFixDictionnariesOnStartup(), data)) {
            if (this.isProfileAllowed(elt.getProfileFixDictionnariesOnStartup(), data)) {
                prev.setProfileFixDictionnariesOnStartup(elt.getProfileFixDictionnariesOnStartup());
            }
            prev.setFixDictionnariesOnStartup(elt.isFixDictionnariesOnStartup());
        }
        if (this.isProfileAllowed(prev.getProfileFixI18nOnStartup(), data)) {
            if (this.isProfileAllowed(elt.getProfileFixI18nOnStartup(), data)) {
                prev.setProfileFixI18nOnStartup(elt.getProfileFixI18nOnStartup());
            }
            prev.setFixI18nOnStartup(elt.isFixI18nOnStartup());
        }
        if (this.isProfileAllowed(prev.getProfileHeaderType(), data)) {
            if (this.isProfileAllowed(elt.getProfileHeaderType(), data)) {
                prev.setProfileHeaderType(elt.getProfileHeaderType());
            }
            prev.setHeaderType(elt.getHeaderType());
        }
        if (this.isProfileAllowed(prev.getProfileHideNameFromLists(), data)) {
            if (this.isProfileAllowed(elt.getProfileHideNameFromLists(), data)) {
                prev.setProfileHideNameFromLists(elt.getProfileHideNameFromLists());
            }
            prev.setHideNameFromLists(elt.isHideNameFromLists());
        }
        if (this.isProfileAllowed(prev.getProfileHtmlAllowedInReports(), data)) {
            if (this.isProfileAllowed(elt.getProfileHtmlAllowedInReports(), data)) {
                prev.setProfileHtmlAllowedInReports(elt.getProfileHtmlAllowedInReports());
            }
            prev.setHtmlAllowedInReports(elt.isHtmlAllowedInReports());
        }
        if (this.isProfileAllowed(prev.getProfileIpAllowedRest(), data)) {
            if (this.isProfileAllowed(elt.getProfileIpAllowedRest(), data)) {
                prev.setProfileIpAllowedRest(elt.getProfileIpAllowedRest());
            }
            prev.setIpAllowedRest(elt.getIpAllowedRest());
        }
        if (this.isProfileAllowed(prev.getProfileLinkPreview(), data)) {
            if (this.isProfileAllowed(elt.getProfileLinkPreview(), data)) {
                prev.setProfileLinkPreview(elt.getProfileLinkPreview());
            }
            prev.setLinkPreviewHeight(elt.getLinkPreviewHeight());
            prev.setLinkPreviewWidth(elt.getLinkPreviewWidth());
            prev.setLinkPreviewScale(elt.getLinkPreviewScale());
        }
        if (this.isProfileAllowed(prev.getProfileNewParameterIfEmpty(), data)) {
            if (this.isProfileAllowed(elt.getProfileNewParameterIfEmpty(), data)) {
                prev.setProfileNewParameterIfEmpty(elt.getProfileNewParameterIfEmpty());
            }
            prev.setNewParameterIfEmpty(elt.isNewParameterIfEmpty());
        }
        if (this.isProfileAllowed(prev.getProfileOverwriteI18n(), data)) {
            if (this.isProfileAllowed(elt.getProfileOverwriteI18n(), data)) {
                prev.setProfileOverwriteI18n(elt.getProfileOverwriteI18n());
            }
            prev.setOverwriteI18n(elt.isOverwriteI18n());
        }
        if (this.isProfileAllowed(prev.getProfileParamMenu(), data)) {
            if (this.isProfileAllowed(elt.getProfileParamMenu(), data)) {
                prev.setProfileParamMenu(elt.getProfileParamMenu());
            }
            prev.setParamMenu(elt.isParamMenu());
        }
        if (this.isProfileAllowed(prev.getProfilePasswordRegex(), data)) {
            if (this.isProfileAllowed(elt.getProfilePasswordRegex(), data)) {
                prev.setProfilePasswordRegex(elt.getProfilePasswordRegex());
            }
            if (elt.getPasswordRegex() == null || elt.getPasswordRegex().isEmpty()) {
                prev.setPasswordRegex(".*");
            } else {
                try {
                    Pattern.compile(elt.getPasswordRegex());
                }
                catch (PatternSyntaxException pse) {
                    throw new DashboardRuntimeException(ErrorCode.INVALID_EXPRESSION);
                }
                prev.setPasswordRegex(elt.getPasswordRegex());
            }
        }
        if (this.isProfileAllowed(prev.getProfileShowHelp(), data)) {
            if (this.isProfileAllowed(elt.getProfileShowHelp(), data)) {
                prev.setProfileShowHelp(elt.getProfileShowHelp());
            }
            prev.setShowHelp(elt.isShowHelp());
        }
        if (this.isProfileAllowed(prev.getProfileStartTaskMgr(), data)) {
            if (this.isProfileAllowed(elt.getProfileStartTaskMgr(), data)) {
                prev.setProfileStartTaskMgr(elt.getProfileStartTaskMgr());
            }
            prev.setStartTaskMgr(elt.isStartTaskMgr());
        }
        if (this.isProfileAllowed(prev.getProfileUpload(), data)) {
            if (this.isProfileAllowed(elt.getProfileUpload(), data)) {
                prev.setProfileUpload(elt.getProfileUpload());
            }
            prev.setUploadMaxSize(elt.getUploadMaxSize());
            prev.setUploadRepository(elt.getUploadRepository());
            prev.setUploadThreshold(elt.getUploadThreshold());
        }
        if (this.isProfileAllowed(prev.getProfileUserChooseLanguage(), data)) {
            if (this.isProfileAllowed(elt.getProfileUserChooseLanguage(), data)) {
                prev.setProfileUserChooseLanguage(elt.getProfileUserChooseLanguage());
            }
            prev.setUserChooseLanguage(elt.isUserChooseLanguage());
        }
        if (this.isProfileAllowed(prev.getProfileUserChooseTheme(), data)) {
            if (this.isProfileAllowed(elt.getProfileUserChooseTheme(), data)) {
                prev.setProfileUserChooseTheme(elt.getProfileUserChooseTheme());
            }
            prev.setUserChooseTheme(elt.isUserChooseTheme());
        }
        prev.setLanguageName(elt.getLanguageName());
        prev.setLastModificationDate(new Date());
        prev.setLastModifier(data.getUserName());
        this.updateOids(prev);
        this.helper.checkForSave(data, (Element)prev);
        this.dao.save((Element)prev);
    }

    public static PrelytisInfoHelper getInstance(DaoFactory daoFactory) {
        return new PrelytisInfoHelper(daoFactory);
    }

    private Map<String, BeanPRPInfoModule> getDefaultModules() {
        BeanPRPInfoModule stdAuth = new BeanPRPInfoModule();
        stdAuth.setClassName(StandardAuthenticationFacade.class.getCanonicalName());
        stdAuth.setActive(true);
        stdAuth.setSystem(true);
        stdAuth.getParams().put("connectionType", "web,mobility");
        stdAuth.getParams().put("maxIncorrectPassword", "");
        BeanPRPInfoModule ldapAuth = new BeanPRPInfoModule();
        ldapAuth.setClassName(LdapAuthenticationFacade.class.getCanonicalName());
        ldapAuth.setActive(false);
        ldapAuth.setSystem(true);
        ldapAuth.getParams().put("connectionType", "web,mobility");
        ldapAuth.getParams().put("principalDNPrefix", "");
        ldapAuth.getParams().put("principalDNSuffix", "");
        ldapAuth.getParams().put("forceConnection", "true");
        ldapAuth.getParams().put("java.naming.security.protocol", "");
        ldapAuth.getParams().put("java.naming.provider.url", "");
        ldapAuth.getParams().put("java.naming.factory.initial", "");
        ldapAuth.getParams().put("java.naming.security.authentication", "");
        BeanPRPInfoModule maint = new BeanPRPInfoModule();
        maint.setClassName(MaintenancePeriodFacade.class.getCanonicalName());
        maint.setActive(true);
        maint.setSystem(true);
        BeanPRPInfoModule trace = new BeanPRPInfoModule();
        trace.setClassName(TraceFacade.class.getCanonicalName());
        trace.setActive(false);
        trace.setSystem(true);
        trace.getParams().put("debug", "true");
        trace.getParams().put("connectionTrace", "true");
        trace.getParams().put("connectionTraceHistory", "10");
        HashMap<String, BeanPRPInfoModule> map = new HashMap<String, BeanPRPInfoModule>();
        map.put(stdAuth.getClassName(), stdAuth);
        map.put(ldapAuth.getClassName(), ldapAuth);
        map.put(maint.getClassName(), maint);
        map.put(trace.getClassName(), trace);
        return map;
    }

    private void checkModules(List<BeanPRPInfoModule> modules) {
        Map<String, BeanPRPInfoModule> ref = this.getDefaultModules();
        for (BeanPRPInfoModule module : modules) {
            BeanPRPInfoModule refModule = ref.remove(module.getClassName());
            if (refModule == null) continue;
            module.setSystem(refModule.isSystem());
            HashMap old = new HashMap(module.getParams());
            module.getParams().clear();
            module.getParams().putAll(refModule.getParams());
            for (Map.Entry entry : old.entrySet()) {
                if (!module.getParams().containsKey(entry.getKey())) continue;
                module.getParams().put(entry.getKey(), entry.getValue());
            }
        }
        for (BeanPRPInfoModule missing : ref.values()) {
            missing.setActive(false);
            modules.add(missing);
        }
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbLanguageFilter languageFilter = new DbLanguageFilter();
        languageFilter.setUsedByPrelytisInfo(oid);
        LanguageDao languageDao = this.daoFactory.getLanguageDao();
        l.addAll(languageDao.listAll((DbDefaultFilter)languageFilter, 1));
        return l;
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        throw new SecurityException();
    }

    public BeanPRPInfo create(ExpressionEvaluationData data) throws DashboardException {
        throw new SecurityException();
    }

    public Locale getDefaultLocale() {
        try {
            LanguageDao languageDao = this.daoFactory.getLanguageDao();
            BeanLanguage language = (BeanLanguage)languageDao.getCore(this.getPrelytisInfo().getLanguageName());
            return new Locale(language.getLanguage());
        }
        catch (DashboardException de) {
            return Locale.ENGLISH;
        }
    }
}

