/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.FieldGroupDao;
import com.prelytis.dashboard.dao.FormDao;
import com.prelytis.dashboard.dao.JdbcDriverDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbExternSessionFilter;
import com.prelytis.dashboard.dao.filter.DbFieldGroupFilter;
import com.prelytis.dashboard.dao.filter.DbFormFilter;
import com.prelytis.dashboard.dao.filter.DbImportFilter;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.filter.DbWorldFilter;
import com.prelytis.dashboard.dao.value.DbJdbcDriver;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.helper.QuerySQLHelper;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operation.OperationSelect;
import com.prelytis.dashboard.db.operator.ConnectionHelper;
import com.prelytis.dashboard.db.operator.OperatorSelect;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.document.factory.AbstractImageFactory;
import com.prelytis.dashboard.helper.DataStructureMap;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.TableHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.interfaces.OutputFormat;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.DataStructureHelper;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.SecurityHelper;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.util.QueryDSTableHelper;
import com.prelytis.dashboard.value.DataStructureRequest;
import com.prelytis.dashboard.value.DataStructureResponse;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.TableProperties;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanQuery;
import com.prelytis.dashboard.value.data.BeanQueryDataStructure;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureFinal;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoin;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoinElement;
import com.prelytis.dashboard.value.data.BeanQueryDefinition;
import com.prelytis.dashboard.value.data.BeanQueryMultiWorld;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanQuerySQLFilter;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.BeanReport;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.Position;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.QueryFilter;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.DatatypesHelper;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.IPoolDBInfo;
import java.net.URL;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class QueryHelper
extends ParameterHelper
implements Dependency,
References {
    private final EntityHelper entityHelper;
    private final boolean autoNameGeneration;
    private final QueryDao dao;

    QueryHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = daoFactory.getQueryDao();
        this.entityHelper = new EntityHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
    }

    public static final QueryHelper getInstance(DaoFactory daoFactory) {
        return new QueryHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanQuery)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanQueryDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanQueryDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
            case REFRESH: {
                if (!(value.getElement() instanceof BeanQueryDefinition)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("nothingToRefresh", null, null);
                }
                return this.getRefresh((BeanQueryDefinition)value.getElement(), data);
            }
            case TOGGLE_DS: {
                if (!(value.getElement() instanceof BeanQueryDefinition)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createMissingParameter("query");
                }
                return this.getToggleDS((BeanQueryDefinition)value.getElement(), data);
            }
            case TOGGLE_MULTI: {
                if (!(value.getElement() instanceof BeanQueryDefinition)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createMissingParameter("query");
                }
                return this.getToggleMulti((BeanQueryDefinition)value.getElement(), data);
            }
            case TOGGLE_SQL: {
                if (!(value.getElement() instanceof BeanQueryDefinition)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createMissingParameter("query");
                }
                return this.getToggleSql((BeanQueryDefinition)value.getElement(), data);
            }
            case REFRESH_FILTER: {
                if (!(value.getElement() instanceof BeanQuerySQL)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createMissingParameter("sqlquery");
                }
                return this.getRefreshFilter((BeanQuerySQL)value.getElement(), data);
            }
            case REFRESH_FIELD: {
                if (!(value.getElement() instanceof BeanQuerySQL)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createMissingParameter("sqlquery");
                }
                return this.getRefreshField((BeanQuerySQL)value.getElement(), data);
            }
            case REFRESH_FILTERS_FIELDS: {
                if (!(value.getElement() instanceof BeanQuerySQL)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createMissingParameter("sqlquery");
                }
                return this.getRefreshFilterField((BeanQuerySQL)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private void updateNames(BeanQuery bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        switch (bean.getQueryType()) {
            case 1: 
            case 2: {
                bean.setWorldName(this.getName(SessionParameterType.WORLD, bean.getWorldOID()));
            }
        }
        if (bean instanceof BeanQuerySQL) {
            BeanQuerySQL elt = (BeanQuerySQL)bean;
            HashMap<Integer, String> fieldGroupMap = new HashMap<Integer, String>();
            for (BeanQuerySQLField field : elt.getBeanQuerySQLFieldList()) {
                field.setFieldGroupName(this.getFieldGroup(fieldGroupMap, field.getFldGrpOid()));
            }
        } else if (bean instanceof BeanQueryStar) {
            BeanQueryStar elt = (BeanQueryStar)bean;
            HashMap<Integer, String> fieldGroupMap = new HashMap<Integer, String>();
            this.updateNames(fieldGroupMap, elt.getTableFact());
        }
    }

    private String getFieldGroup(Map<Integer, String> fieldGroupMap, int fldGrpOid) throws DashboardException {
        Integer key = fldGrpOid;
        String name = fieldGroupMap.get(key);
        if (name == null) {
            name = this.getName(SessionParameterType.FIELD_GROUP, fldGrpOid);
            fieldGroupMap.put(key, name);
        }
        return name;
    }

    private void updateNames(Map<Integer, String> fieldGroupMap, BeanQueryDataStructureTable table) throws DashboardException {
        if (table == null || table.getTableFieldList() == null) {
            return;
        }
        for (BeanQueryDataStructureTableField f : table.getTableFieldList()) {
            f.setFieldGroupName(this.getFieldGroup(fieldGroupMap, f.getFldGrpOid()));
        }
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            this.updateNames(fieldGroupMap, t);
        }
    }

    private void updateDescKeys(BeanQueryDefinition bean, boolean replace) {
        this.helper.updateDescKey((Bean)bean, replace);
        if (bean instanceof BeanQuerySQL) {
            BeanQuerySQL elt = (BeanQuerySQL)bean;
            for (BeanQuerySQLField field : elt.getBeanQuerySQLFieldList()) {
                if (!replace && !this.helper.isInvalidDescKey(field.getDescriptionKey())) continue;
                field.setDescriptionKey(this.guidFactory.generateGUID((Object)field));
            }
            for (BeanQuerySQLFilter filter : elt.getBeanQuerySQLFilterList()) {
                if (!replace && !this.helper.isInvalidDescKey(filter.getDescriptionKey())) continue;
                filter.setDescriptionKey(this.guidFactory.generateGUID((Object)filter));
            }
        } else if (bean instanceof BeanQueryStar) {
            BeanQueryStar elt = (BeanQueryStar)bean;
            this.updateDescKeys(elt.getTableFact(), replace);
        }
    }

    private void updateOids(BeanQuery bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        switch (bean.getQueryType()) {
            case 1: 
            case 2: {
                bean.setWorldOID(this.getOid(SessionParameterType.WORLD, bean.getWorldName()));
                break;
            }
            default: {
                bean.setWorldOID(0);
            }
        }
        if (bean instanceof BeanQuerySQL) {
            BeanQuerySQL elt = (BeanQuerySQL)bean;
            for (BeanQuerySQLField field : elt.getBeanQuerySQLFieldList()) {
                field.setFldGrpOid(this.getOid(SessionParameterType.FIELD_GROUP, field.getFieldGroupName()));
            }
        } else if (bean instanceof BeanQueryStar) {
            BeanQueryStar elt = (BeanQueryStar)bean;
            this.updateOids(elt.getTableFact());
        }
    }

    private void updateDescKeys(BeanQueryDataStructureTable table, boolean replace) {
        if (table == null) {
            return;
        }
        if (replace || this.helper.isInvalidDescKey(table.getDescriptionKey())) {
            table.setDescriptionKey(this.guidFactory.generateGUID((Object)table));
        }
        for (BeanQueryDataStructureTableField f : table.getTableFieldList()) {
            if (!replace && !this.helper.isInvalidDescKey(f.getDescriptionKey())) continue;
            f.setDescriptionKey(this.guidFactory.generateGUID((Object)f));
        }
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            this.updateDescKeys(t, replace);
        }
    }

    private void updateOids(BeanQueryDataStructureTable table) throws DashboardException {
        if (table == null || table.getTableFieldList() == null) {
            return;
        }
        for (BeanQueryDataStructureTableField f : table.getTableFieldList()) {
            f.setFldGrpOid(this.getOid(SessionParameterType.FIELD_GROUP, f.getFieldGroupName()));
        }
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            this.updateOids(t);
        }
    }

    private ParameterResponse getRefreshFilterField(BeanQuerySQL elt, ExpressionEvaluationData data) throws DashboardException {
        this.reformatRequest(elt);
        this.refreshFilter(elt);
        this.refreshFieldList(elt, data, false);
        this.refreshI18n(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.QUERY);
    }

    private void refreshI18n(BeanQuerySQL elt) {
    }

    private ParameterResponse getRefreshField(BeanQuerySQL elt, ExpressionEvaluationData data) throws DashboardException {
        this.refreshFieldList(elt, data, false);
        this.refreshI18n(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.QUERY);
    }

    private ParameterResponse getRefreshFilter(BeanQuerySQL elt, ExpressionEvaluationData data) throws DashboardException {
        this.reformatRequest(elt);
        this.refreshFilter(elt);
        this.refreshI18n(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.QUERY);
    }

    private ParameterResponse getToggleSql(BeanQueryDefinition element, ExpressionEvaluationData data) throws DashboardException {
        BeanQuerySQL sql = new BeanQuerySQL((BeanQuery)element);
        return this.helper.getResponse((I18nElement)sql, data, SessionParameterType.QUERY);
    }

    private ParameterResponse getToggleMulti(BeanQueryDefinition element, ExpressionEvaluationData data) throws DashboardException {
        BeanQueryMultiWorld multi = new BeanQueryMultiWorld((BeanQuery)element);
        return this.helper.getResponse((I18nElement)multi, data, SessionParameterType.QUERY);
    }

    private ParameterResponse getToggleDS(BeanQueryDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        BeanQueryDataStructure ds = new BeanQueryDataStructure((BeanQuery)elt);
        return this.helper.getResponse((I18nElement)ds, data, SessionParameterType.QUERY);
    }

    private ParameterResponse getRefresh(BeanQueryDefinition initial, ExpressionEvaluationData data) throws DashboardException {
        Object f = initial.getQueryType() == 1 && !(initial instanceof BeanQuerySQL) ? new BeanQuerySQL((BeanQuery)initial) : (initial.getQueryType() == 2 && !(initial instanceof BeanQueryDataStructure) ? new BeanQueryDataStructure((BeanQuery)initial) : (initial.getQueryType() == 3 && !(initial instanceof BeanQueryMultiWorld) ? new BeanQueryMultiWorld((BeanQuery)initial) : initial));
        this.updateOids((BeanQuery)f);
        if (f instanceof BeanQuerySQL) {
            BeanQuerySQL querySql = f;
            this.reformatRequest(querySql);
            this.refreshFilter(querySql);
        }
        this.updateNames((BeanQuery)f);
        return this.helper.getResponse((I18nElement)f, data, SessionParameterType.QUERY);
    }

    private ParameterResponse getSaveAsNew(BeanQueryDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.QUERY);
    }

    private ParameterResponse getSave(BeanQueryDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.QUERY);
    }

    public void save(BeanQueryDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanQueryDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanQuery)elt);
        this.updateDescKeys(elt, false);
        this.updateDescriptionMap(elt, this.helper.getLocales(), data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        if (elt instanceof BeanQuerySQL) {
            BeanQuerySQL bean = (BeanQuerySQL)elt;
            List sqlFieldList = bean.getBeanQuerySQLFieldList();
            HashSet<String> set = new HashSet<String>();
            for (BeanQuerySQLField sqlField : sqlFieldList) {
                String name = sqlField.getName();
                if (name == null) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("missingFieldName", null, null);
                }
                if (set.add(name)) continue;
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("fieldNameUnicity", new String[]{name}, null);
            }
            List queryFilterList = bean.getBeanQuerySQLFilterList();
            for (BeanQuerySQLFilter queryFilter : queryFilterList) {
                if (queryFilter.getFltMode() != 1 || !"".equals(queryFilter.getOperand())) continue;
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("missingOperandName", new String[]{queryFilter.getName()}, null);
            }
        } else if (elt instanceof BeanQueryStar) {
            BeanQueryStar ds = (BeanQueryStar)elt;
            HashSet<String> fieldNameMap = new HashSet<String>();
            if (ds.getTableFact() != null) {
                this.checkName(ds.getTableFact(), fieldNameMap, new HashSet<String>(), data.getLocale());
                this.checkLink(ds.getTableFact(), data.getLocale());
                this.updateTableParent(null, ds.getTableFact(), data.getLocale());
            }
        }
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void updateTableParent(BeanQueryDataStructureTable parent, BeanQueryDataStructureTable table, Locale locale) {
        table.setParentTable(parent);
        for (BeanQueryDataStructureTableField field : table.getTableFieldList()) {
            field.setBeanQueryDataStructureTable(table);
        }
        for (BeanQueryDataStructureTable child : table.getTableChildList()) {
            this.updateTableParent(table, child, locale);
        }
    }

    private void updateDescriptionMap(BeanQueryDefinition bean, List<Locale> locales, Locale locale) {
        this.helper.updateDescriptionMap((Bean)bean, locales, locale);
        if (bean instanceof BeanQuerySQL) {
            BeanQuerySQL elt = (BeanQuerySQL)bean;
            for (BeanQuerySQLField field : elt.getBeanQuerySQLFieldList()) {
                this.helper.updateDescriptionMap(field.getDescriptionMap(), locales, locale);
            }
            for (BeanQuerySQLFilter filter : elt.getBeanQuerySQLFilterList()) {
                this.helper.updateDescriptionMap(filter.getDescriptionMap(), locales, locale);
            }
        } else if (bean instanceof BeanQueryDataStructure) {
            BeanQueryDataStructure elt = (BeanQueryDataStructure)bean;
            this.updateDescriptionMap(elt.getTableFact(), locales, locale);
        }
    }

    private void updateDescriptionMap(BeanQueryDataStructureTable table, List<Locale> locales, Locale defaultLocale) {
        if (table == null) {
            return;
        }
        this.helper.updateDescriptionMap(table.getDescriptionMap(), locales, defaultLocale);
        for (BeanQueryDataStructureTableField f : table.getTableFieldList()) {
            this.helper.updateDescriptionMap(f.getDescriptionMap(), locales, defaultLocale);
        }
        for (BeanQueryDataStructureTable t : table.getTableChildList()) {
            this.updateDescriptionMap(t, locales, defaultLocale);
        }
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanQuery elt = this.helper.get((Dao)this.dao, name, 1, BeanQuery.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanQuery elt = this.helper.get((Dao)this.dao, name, instanceType, BeanQuery.class);
        if (elt instanceof BeanQueryDefinition) {
            this.update((BeanQueryDefinition)elt);
        }
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.QUERY);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.QUERY);
    }

    public BeanQueryDataStructure create(ExpressionEvaluationData data) throws DashboardException {
        BeanQueryDataStructure elt = new BeanQueryDataStructure();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.updateDescKeys((BeanQueryDefinition)elt, false);
        elt.setCommentKey(this.guidFactory.generateGUID((Object)elt));
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanQueryDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanQueryDefinition.class);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.updateNames((BeanQuery)elt);
        this.updateDescKeys(elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        if (elt instanceof BeanQuerySQL) {
            this.updateCopy((BeanQuerySQL)elt);
        } else if (elt instanceof BeanQueryDataStructure) {
            this.updateCopy((BeanQueryDataStructure)elt);
        } else if (elt instanceof BeanQueryMultiWorld) {
            this.updateCopy((BeanQueryMultiWorld)elt);
        }
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.QUERY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFieldList(BeanQuerySQL query, ExpressionEvaluationData data, boolean fix) throws DashboardException {
        try {
            WorldDao worldDao = this.daoFactory.getWorldDao();
            BeanWorldDefinition world = (BeanWorldDefinition)worldDao.getDefinition(query.getWorldName());
            JdbcDriverDao driverDao = this.daoFactory.getJdbcDriverDao();
            DbJdbcDriver driver = driverDao.getDriver(world.getDriverOID());
            ExecutionContext context = new ExecutionContext();
            context.setData(data);
            context.setDriver(driver);
            context.setQuery((IQueryDefinition)query);
            context.setWorld(world);
            QuerySQLHelper sqlHelper = new QuerySQLHelper();
            QuerySQL querySQL = sqlHelper.getQuerySQL(context, null);
            querySQL.setMaxRows(1);
            WorldHelper worldHelper = WorldHelper.getInstance((BeanWorldDefinition)context.getWorld(), (DriverCharacteristics)context.getDriver(), (ExpressionEvaluationData)context.getData());
            ConnectionHelper helper = ConnectionHelper.getInstance((WorldHelper)worldHelper);
            IPoolDBInfo dbInfo = helper.getPoolDbInfo();
            OperationSelect os = new OperationSelect();
            if (!world.isUseDefault()) {
                os.setResultSetConcurrency(Integer.valueOf(world.getResultSetConcurrency()));
                os.setResultSetType(Integer.valueOf(world.getResultSetType()));
                os.setFetchSize(Integer.valueOf(world.getFetchSize()));
            }
            os.setDatabase(dbInfo);
            os.setQuerySQL(querySQL);
            try (OperatorSelect operatorSelect = new OperatorSelect(os);){
                int col;
                operatorSelect.init();
                ResultSetMetaData md = operatorSelect.getMetaData();
                int nbCols = md.getColumnCount();
                List fieldList = query.getBeanQuerySQLFieldList();
                for (col = fieldList.size() - 1; col >= nbCols; --col) {
                    fieldList.remove(col);
                }
                for (col = 0; col < nbCols; ++col) {
                    BeanQuerySQLField field;
                    int sqlType = md.getColumnType(col + 1);
                    DataType datatype = DatatypesHelper.getDatatypeFromSql((int)sqlType);
                    String name = md.getColumnName(col + 1);
                    if (name == null || "".equals(name)) {
                        name = md.getColumnLabel(col + 1);
                    }
                    if (datatype == null || datatype.equals((Object)DataType.BLOB)) {
                        Logger.getLogger(QueryHelper.class).debug((Object)("Skipping blob or unidentified column " + name));
                        if (col >= fieldList.size()) continue;
                        fieldList.remove(col);
                        continue;
                    }
                    String sqlCaption = name.toUpperCase();
                    if (sqlCaption.length() > 60) {
                        sqlCaption = sqlCaption.substring(0, 60);
                    }
                    if (col < fieldList.size()) {
                        boolean fixDatatype;
                        field = (BeanQuerySQLField)fieldList.get(col);
                        boolean bl = fixDatatype = field.getSize() <= 0 && fix;
                        if (!field.getSqlField().equals(sqlCaption)) {
                            field.setSqlField(sqlCaption);
                            field.setName(name);
                            if (DataType.isNumeric((DataType)datatype)) {
                                field.setFieldGroupName("Metric");
                            } else if (DataType.isDate((DataType)datatype)) {
                                field.setFieldGroupName("TimeAxis");
                            } else {
                                field.setFieldGroupName("Attribut");
                            }
                            field.getDescriptionMap().put(data.getLocale(), name);
                            if (datatype != field.getDataType()) {
                                field.setDataType(datatype);
                                fixDatatype = true;
                            }
                        }
                        if (!fixDatatype) continue;
                        field.setSize(md.getPrecision(col + 1));
                        field.setDigits(md.getScale(col + 1));
                        field.setNullable(md.isNullable(col + 1) == 1);
                        field.setAutoIncrement(md.isAutoIncrement(col + 1));
                        continue;
                    }
                    field = new BeanQuerySQLField();
                    String key = this.guidFactory.generateGUID((Object)field);
                    field.getDescriptionMap().put(data.getLocale(), name);
                    if (name.length() > 30) {
                        name = name.substring(0, 30);
                    }
                    if (DataType.isNumeric((DataType)datatype)) {
                        field.setFieldGroupName("Metric");
                    } else if (DataType.isDate((DataType)datatype)) {
                        field.setFieldGroupName("TimeAxis");
                    } else {
                        field.setFieldGroupName("Attribut");
                    }
                    field.setSqlField(sqlCaption);
                    field.setName(name);
                    field.setDescriptionKey(key);
                    field.setDataType(datatype);
                    field.setActive(true);
                    field.setSize(md.getPrecision(col + 1));
                    field.setDigits(md.getScale(col + 1));
                    field.setNullable(md.isNullable(col + 1) == 1);
                    field.setAutoIncrement(md.isAutoIncrement(col + 1));
                    fieldList.add(field);
                }
            }
        }
        catch (DashboardException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DashboardException((Throwable)e);
        }
    }

    private int getNonBlobColumnCount(ResultSetMetaData metaData) throws SQLException {
        int result = metaData.getColumnCount();
        for (int col = 0; col < metaData.getColumnCount(); ++col) {
            int sqlType = metaData.getColumnType(col + 1);
            DataType dataType = DatatypesHelper.getDatatypeFromSql((int)sqlType);
            if (dataType != null && !dataType.equals((Object)DataType.BLOB)) continue;
            --result;
        }
        return result;
    }

    private String[] get(String group) {
        int pi = group.indexOf("?");
        String p = group.substring(0, pi);
        String s = group.substring(pi);
        return new String[]{p, s};
    }

    private boolean isEven(int v) {
        return 2 * (v / 2) == v;
    }

    public void reformatRequest(BeanQuerySQL query) {
        String request = query.getRequest();
        if (request == null) {
            return;
        }
        Pattern pattern = Pattern.compile("\\?([\\[][\\d]+[\\]])?");
        Matcher matcher = pattern.matcher(request);
        int start = 0;
        int nbParams = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find(start)) {
            String grp = matcher.group();
            if ("?".equals(grp)) {
                ++nbParams;
            } else if (!list.contains(grp)) {
                list.add(grp);
                ++nbParams;
            }
            start = matcher.end();
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (int cpt = 0; cpt < nbParams; ++cpt) {
            String key = "?[" + (cpt + 1) + "]";
            if (list.contains(key)) continue;
            newList.add(key);
        }
        start = 0;
        StringBuilder sql = new StringBuilder();
        while (matcher.find(start)) {
            String lGrp = matcher.group();
            if ("?".equals(lGrp)) {
                lGrp = (String)newList.remove(0);
            }
            sql.append(request.substring(start, matcher.start())).append(lGrp);
            start = matcher.end();
        }
        sql.append(request.substring(start));
        query.setRequest(sql.toString());
    }

    public void refreshFilter(BeanQuerySQL query) {
        int cpt;
        String request = query.getRequest();
        Pattern pattern = Pattern.compile("\\?[\\[][\\d]+[\\]]");
        Matcher matcher = pattern.matcher(request);
        int start = 0;
        int nbParams = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find(start)) {
            String grp = matcher.group();
            if (!list.contains(grp)) {
                list.add(grp);
                ++nbParams;
            }
            start = matcher.end();
        }
        List filterList = query.getBeanQuerySQLFilterList();
        for (cpt = filterList.size(); cpt > nbParams; --cpt) {
            filterList.remove(cpt - 1);
        }
        for (cpt = filterList.size(); cpt < nbParams; ++cpt) {
            BeanQuerySQLFilter filter = new BeanQuerySQLFilter();
            filter.setDescriptionKey(this.guidFactory.generateGUID((Object)filter));
            filterList.add(filter);
        }
        if (list != null) {
            list.clear();
        }
    }

    public void fix() throws DashboardException {
        throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, "Not implemented");
    }

    private void updateCopy(BeanQuerySQL bean) {
        List fieldList = bean.getBeanQuerySQLFieldList();
        for (BeanQuerySQLField field : fieldList) {
            field.setDescriptionKey(this.guidFactory.generateGUID((Object)bean));
        }
        this.updateCopy(bean.getBeanQuerySQLFilterList());
    }

    private void updateCopy(List<BeanQuerySQLFilter> filterList) {
        for (BeanQuerySQLFilter filter : filterList) {
            String newId = this.guidFactory.generateGUID((Object)filter);
            filter.setDescriptionKey(newId);
        }
    }

    private void updateCopy(BeanQueryDataStructure query) {
        this.updateCopy(query.getTableFact());
    }

    private void updateCopy(BeanQueryMultiWorld query) {
        this.updateCopy(query.getTableFact());
        for (List filterList : query.getFilterMap().values()) {
            this.updateCopy(filterList);
        }
    }

    private void updateCopy(BeanQueryDataStructureTable table) {
        if (table == null) {
            return;
        }
        table.setDescriptionKey(this.guidFactory.generateGUID((Object)table));
        List fieldList = table.getTableFieldList();
        for (BeanQueryDataStructureTableField field : fieldList) {
            field.setDescriptionKey(this.guidFactory.generateGUID((Object)table));
        }
        List childList = table.getTableChildList();
        for (BeanQueryDataStructureTable t : childList) {
            this.updateCopy(t);
        }
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.QUERY).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.QUERY);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.QUERY, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private void checkLink(BeanQueryDataStructureTable tableFact, Locale locale) throws DashboardException {
        BeanQueryDataStructureTableJoin join = tableFact.getJoin();
        if (join != null && tableFact.getParentTable() != null) {
            Map<String, BeanQueryDataStructureTableField> leftFieldMap = this.getFieldMap(tableFact.getParentTable().getTableFieldList());
            Map<String, BeanQueryDataStructureTableField> rightFieldMap = this.getFieldMap(tableFact.getTableFieldList());
            List joinList = join.getJoinElementList();
            for (BeanQueryDataStructureTableJoinElement elt : joinList) {
                BeanQueryDataStructureTableField lf = leftFieldMap.get(elt.getLeftField());
                if (lf == null) {
                    throw ExceptionHelper.getInstance(locale).createDashboardException("checkFieldMulti", new String[]{tableFact.getParentTable().getName(), elt.getLeftField()}, null);
                }
                BeanQueryDataStructureTableField rf = rightFieldMap.get(elt.getRightField());
                if (rf != null) continue;
                throw ExceptionHelper.getInstance(locale).createDashboardException("checkFieldMulti", new String[]{tableFact.getName(), elt.getRightField()}, null);
            }
        }
    }

    private Map<String, BeanQueryDataStructureTableField> getFieldMap(List<BeanQueryDataStructureTableField> fieldList) {
        HashMap<String, BeanQueryDataStructureTableField> map = new HashMap<String, BeanQueryDataStructureTableField>();
        for (BeanQueryDataStructureTableField field : fieldList) {
            map.put(field.getSqlField(), field);
        }
        return map;
    }

    private void checkName(BeanQueryDataStructureTable table, Set<String> fieldSet, Set<String> joinSet, Locale locale) throws DashboardException {
        if (table.getName() == null || "".equals(table.getName().trim())) {
            throw ExceptionHelper.getInstance(locale).createDashboardException("missingTableName", null, null);
        }
        String tableName = table.getName().toLowerCase();
        if (tableName.length() > 60) {
            throw ExceptionHelper.getInstance(locale).createDashboardException("tableNameLength", new String[]{tableName}, null);
        }
        BeanQueryDataStructureTableJoin join = table.getJoin();
        if (!join.getJoinElementList().isEmpty()) {
            if (join.getJoinName() == null || "".equals(join.getJoinName().trim())) {
                throw ExceptionHelper.getInstance(locale).createDashboardException("missingJoinName", null, null);
            }
            String joinName = join.getJoinName().toLowerCase();
            if (joinSet.contains(joinName)) {
                throw ExceptionHelper.getInstance(locale).createDashboardException("joinNameUnicity", new String[]{joinName}, null);
            }
            if (joinName.length() > 60) {
                throw ExceptionHelper.getInstance(locale).createDashboardException("joinNameLength", new String[]{joinName}, null);
            }
            joinSet.add(joinName);
        }
        this.checkFieldName(table.getTableFieldList(), fieldSet, locale);
        List list = table.getTableChildList();
        for (int i = 0; i < list.size(); ++i) {
            this.checkName((BeanQueryDataStructureTable)list.get(i), fieldSet, joinSet, locale);
        }
    }

    private void checkFieldName(List<BeanQueryDataStructureTableField> tableFieldList, Set<String> fieldSet, Locale locale) throws DashboardException {
        for (int i = 0; i < tableFieldList.size(); ++i) {
            BeanQueryDataStructureTableField field = tableFieldList.get(i);
            if (field.getName() == null || "".equals(field.getName().trim())) {
                throw ExceptionHelper.getInstance(locale).createDashboardException("missingFieldName", null, null);
            }
            String fieldName = field.getName().toLowerCase();
            if (fieldSet.contains(fieldName)) {
                throw ExceptionHelper.getInstance(locale).createDashboardException("fieldNameUnicity", new String[]{fieldName}, null);
            }
            if (fieldName.length() > 60) {
                throw ExceptionHelper.getInstance(locale).createDashboardException("fieldNameLength", new String[]{fieldName}, null);
            }
            fieldSet.add(fieldName);
        }
    }

    private void update(BeanQueryDefinition query) throws DashboardException {
        Integer queryOid = query.getObjectID();
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setChildQueryOid(queryOid);
        query.setUsedByMulti(!this.dao.listAll((DbDefaultFilter)queryFilter, 1).isEmpty());
        if (query.isUsedByMulti()) {
            query.setAvailableForMulti(true);
        }
        ReportDao reportDao = this.daoFactory.getReportDao();
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setQueryOid(queryOid);
        query.setUsedByReport(!reportDao.listAll((DbDefaultFilter)reportFilter, 1).isEmpty());
        if (query.isUsedByReport()) {
            query.setAvailableForReport(true);
        }
        TaskDao taskDao = this.daoFactory.getTaskDao();
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setQueryOid(queryOid);
        query.setUsedByTask(!taskDao.listAll((DbDefaultFilter)taskFilter, 1).isEmpty());
        if (query.isUsedByTask()) {
            query.setAvailableForTask(true);
        }
        FormDao formDao = this.daoFactory.getFormDao();
        DbFormFilter formFilter = new DbFormFilter();
        formFilter.setQueryOid(queryOid);
        query.setUsedByForm(!formDao.listAll((DbDefaultFilter)formFilter, 1).isEmpty());
        if (query.isUsedByForm()) {
            query.setAvailableForForm(true);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanQuery elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanQuery.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.QUERY);
    }

    public IQueryDefinition getFinal(int queryOid) throws DashboardException {
        BeanQueryDefinition query = (BeanQueryDefinition)this.dao.getDefinition(queryOid);
        return this.getFinal(query);
    }

    public IQueryDefinition getFinal(String name) throws DashboardException {
        BeanQueryDefinition query = this.helper.get((Dao)this.dao, name, 2, BeanQueryDefinition.class);
        return this.getFinal(query);
    }

    private IQueryDefinition getFinal(BeanQueryDefinition query) throws DashboardException {
        this.updateNames((BeanQuery)query);
        if (query instanceof BeanQueryStar) {
            return BeanQueryDataStructureFinal.getInstance((BeanQueryStar)((BeanQueryStar)query));
        }
        if (query instanceof BeanQuerySQL) {
            return (BeanQuerySQL)query;
        }
        throw new DashboardRuntimeException(ErrorCode.UNKNOWN_QUERY_TYPE, "Unknown query type");
    }

    public List<Element> getCoreList(DbQueryFilter filter, ExpressionEvaluationData data) throws DashboardException {
        List list = this.dao.listAll((DbDefaultFilter)filter, 1, null, null);
        for (Element elt : list) {
            this.updateNames((BeanQuery)elt);
        }
        return list;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbQueryFilter filter = this.helper.getFilter(defaultFilter, data, DbQueryFilter.class);
        if (defaultFilter instanceof QueryFilter) {
            QueryFilter src = (QueryFilter)defaultFilter;
            filter.setWorldOid(this.optOid(SessionParameterType.WORLD, src.getWorldName()));
            filter.setForForm(src.getForForm());
            filter.setForQuery(src.getForQuery());
            filter.setForReport(src.getForReport());
            filter.setForTask(src.getForTask());
            filter.setReadOnlyWorld(src.getReadOnlyWorld());
            filter.setChildQueryOid(this.optOid(SessionParameterType.QUERY, src.getChildQueryName()));
            filter.setFieldGroupOid(this.optOid(SessionParameterType.FIELD_GROUP, src.getFieldGroupName()));
            filter.setQueryType(src.getQueryType());
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        if (instanceType != 1) {
            for (Element elt : eltList) {
                this.updateNames((BeanQuery)elt);
            }
        }
        return eltList;
    }

    public Response getResponse(DataStructureRequest value, ExpressionEvaluationData data) throws DashboardException {
        DataStructureResponse response = new DataStructureResponse();
        DataStructureRequest.Action action = value.getAction();
        OutputFormat outputFormat = OutputFormat.PNG;
        if (value.getOutputFormat() != null) {
            outputFormat = value.getOutputFormat();
        }
        QueryDSTableHelper tableContainer = new QueryDSTableHelper(value.getQuery(), data.getLocale());
        int fieldImport = 2;
        if (value.getFieldImport() != null) {
            fieldImport = value.getFieldImport();
        }
        ImageDocument image = null;
        switch (action) {
            case ADD_TABLE: {
                BeanQueryDataStructureTable parent = tableContainer.findTableById(value.getId().intValue());
                if (parent == null) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("unknownTable", new String[]{String.valueOf(value.getId())}, null);
                }
                DataStructureHelper<?> dsHelper = DataStructureHelper.getInstance(this.daoFactory, value.getQuery(), data);
                dsHelper.addTable(parent, value.getTable(), value.getJoin());
                break;
            }
            case DELETE_TABLE: 
            case DELETE_JOIN: {
                tableContainer.deleteTable(value.getId().intValue());
                break;
            }
            case DELETE_FIELD: {
                tableContainer.deleteField(value.getId().intValue());
                break;
            }
            case CONTEXTUALIZE_TABLE: {
                break;
            }
            case DETECT_TABLE: {
                int maxLevel = 1;
                if (value.getMaxLevel() != null) {
                    maxLevel = value.getMaxLevel();
                }
                DataStructureHelper<?> dsHelper = DataStructureHelper.getInstance(this.daoFactory, value.getQuery(), data);
                if (value.getId() == null) {
                    dsHelper.detect(value.getTable(), maxLevel, fieldImport);
                    break;
                }
                dsHelper.detect(value.getId(), maxLevel, fieldImport);
                break;
            }
            case GENERATE_IMAGE: {
                image = this.getDataStructureMap(value.getQuery(), outputFormat, data.getLocale());
                break;
            }
            case LIST_FIELD: {
                DataStructureHelper<?> dsHelper = DataStructureHelper.getInstance(this.daoFactory, value.getQuery(), data);
                BeanQueryDataStructureTable parent = tableContainer.findTableById(value.getId().intValue());
                response.setList(dsHelper.listField(parent));
                break;
            }
            case UPDATE_FIELD_LIST: {
                DataStructureHelper<?> dsHelper = DataStructureHelper.getInstance(this.daoFactory, value.getQuery(), data);
                BeanQueryDataStructureTable parent = tableContainer.findTableById(value.getId().intValue());
                dsHelper.updateFieldList(parent, value.getList());
            }
        }
        SecurityHelper sh = SecurityHelper.getInstance(this.daoFactory);
        response.setElement(sh.create((I18nElement)value.getQuery(), data, 2));
        if (image != null) {
            response.setImage(image);
        }
        return response;
    }

    private ImageDocument getDataStructureMap(BeanQueryStar ds, OutputFormat outputFormat, Locale locale) throws DashboardException {
        try {
            if (ds.getTableFact() == null) {
                return null;
            }
            DataStructureMap dataStructureMap = new DataStructureMap(ds, locale);
            String file = "/com/prelytis/dashboard/resources/img/tab-ctx.png";
            URL url = this.getClass().getResource(file);
            dataStructureMap.setContextualizationIcon(url);
            dataStructureMap.init();
            AbstractImageFactory factory = AbstractImageFactory.getInstance(outputFormat);
            return factory.getImageDocument((I18nElement)ds, dataStructureMap, null, 1.0, null, false);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setChildQueryOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)queryFilter, SessionParameterType.QUERY));
        DbReportFilter reportFilter = new DbReportFilter();
        reportFilter.setQueryOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)reportFilter, SessionParameterType.REPORT));
        DbImportFilter importFilter = new DbImportFilter();
        importFilter.setQueryOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)importFilter, SessionParameterType.IMPORT_TASK));
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setQueryOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)taskFilter, SessionParameterType.TASK));
        DbExternSessionFilter externSessionFilter = new DbExternSessionFilter();
        externSessionFilter.setQueryOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)externSessionFilter, SessionParameterType.EXTERN_SESSION));
        DbFormFilter formFilter = new DbFormFilter();
        formFilter.setQueryOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)formFilter, SessionParameterType.FORM));
        return list;
    }

    public BeanQueryDefinition getDefinition(String name) throws DashboardException {
        BeanQueryDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanQueryDefinition.class);
        this.updateNames((BeanQuery)bean);
        return bean;
    }

    public ReportDocument getPreviewDocument(BeanQuerySQL query, ExpressionEvaluationData data) throws DashboardException {
        this.updateOids((BeanQuery)query);
        TableProperties displayProperties = new TableProperties();
        displayProperties.setDisplayType(BeanDisplayType.TABLE);
        StyleHelper styleHelper = StyleHelper.getInstance(this.daoFactory);
        BeanStyleDefinition style = styleHelper.getDefinition("default");
        TableHelper tableHelper = TableHelper.getInstance(this.daoFactory);
        tableHelper.setPreview(true);
        tableHelper.setReport(null);
        tableHelper.setQuery((IQueryDefinition)query);
        tableHelper.setStyle(style);
        tableHelper.setData(data);
        ReportDocument document = new ReportDocument();
        document.setObjectID(0);
        document.setName(query.getName());
        document.setDescription((String)query.getDescriptionMap().get(data.getLocale()));
        document.getDescriptionMap().putAll(query.getDescriptionMap());
        document.setComment((String)query.getCommentMap().get(data.getLocale()));
        document.setStyle(style.getName());
        document.setPageLayoutOid(1);
        document.setPageLayoutName("A4");
        document.setDisplayProperties((DisplayProperties)displayProperties);
        document.setCustomized(false);
        document.setFilterContent(BeanReport.FilterContent.ALL_FILTERS);
        document.setFilterPosition(Position.TOP);
        document.setCommentPosition(Position.HIDDEN);
        document.setShowFilterFirst(false);
        document.setFilterList(null);
        document.setRowsPerPage(11);
        ReportDocument rd = tableHelper.getDocument();
        document.addAll((Collection)rd);
        return document;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setOwnerEntityOid(data.getEntityOid());
        queryFilter.setSelectForDisplayType(5);
        queryFilter.setUsedByQuery(oid);
        QueryDao queryDao = this.daoFactory.getQueryDao();
        l.addAll(queryDao.listAll((DbDefaultFilter)queryFilter, 1));
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setOwnerEntityOid(data.getEntityOid());
        entityFilter.setSelectForDisplayType(5);
        entityFilter.setUsedByQuery(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        DbWorldFilter worldFilter = new DbWorldFilter();
        worldFilter.setUsedByQuery(oid);
        WorldDao worldDao = this.daoFactory.getWorldDao();
        l.addAll(worldDao.listAll((DbDefaultFilter)worldFilter, 1));
        DbFieldGroupFilter fieldGroupFilter = new DbFieldGroupFilter();
        fieldGroupFilter.setUsedByQuery(oid);
        FieldGroupDao fieldGroupDao = this.daoFactory.getFieldGroupDao();
        l.addAll(fieldGroupDao.listAll((DbDefaultFilter)fieldGroupFilter, 1));
        return l;
    }
}

