/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.axway.sentinel.dashboard.command.TrackingCommandBean;
import com.axway.sentinel.dashboard.command.TrackingCommandListResponse;
import com.axway.sentinel.dashboard.exception.DashboardServiceException;
import com.prelytis.dashboard.dao.ColorListDao;
import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.FieldGroupDao;
import com.prelytis.dashboard.dao.PageLayoutDao;
import com.prelytis.dashboard.dao.PersFieldDao;
import com.prelytis.dashboard.dao.PrelytisInfoDao;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.dao.ReportDao;
import com.prelytis.dashboard.dao.StrokeTypeDao;
import com.prelytis.dashboard.dao.StyleDao;
import com.prelytis.dashboard.dao.ThresholdTypeDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbColorListFilter;
import com.prelytis.dashboard.dao.filter.DbControlFilter;
import com.prelytis.dashboard.dao.filter.DbDashboardFilter;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.dao.filter.DbFieldGroupFilter;
import com.prelytis.dashboard.dao.filter.DbLinkFilter;
import com.prelytis.dashboard.dao.filter.DbMetricFilter;
import com.prelytis.dashboard.dao.filter.DbPageLayoutFilter;
import com.prelytis.dashboard.dao.filter.DbPersFieldFilter;
import com.prelytis.dashboard.dao.filter.DbQueryFilter;
import com.prelytis.dashboard.dao.filter.DbReportFilter;
import com.prelytis.dashboard.dao.filter.DbStrokeTypeFilter;
import com.prelytis.dashboard.dao.filter.DbStyleFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.value.DbChartProperties;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.I18nComparator;
import com.prelytis.dashboard.helper.TableHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.FieldGroupHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.model.helper.SystemSessionGroup;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.persistence.helper.IdHelper;
import com.prelytis.dashboard.security.DashboardManager;
import com.prelytis.dashboard.security.IDashboardManager;
import com.prelytis.dashboard.util.BeanReportHelper;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.DisplayTypeFactory;
import com.prelytis.dashboard.util.ThresholdHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.chart.DisplayProperties;
import com.prelytis.dashboard.value.chart.PaintableProperties;
import com.prelytis.dashboard.value.chart.properties.AxisLabelMaxWidth;
import com.prelytis.dashboard.value.chart.properties.BarLine;
import com.prelytis.dashboard.value.chart.properties.Bubble;
import com.prelytis.dashboard.value.chart.properties.ChartExtent;
import com.prelytis.dashboard.value.chart.properties.ChartNbIntermediateValues;
import com.prelytis.dashboard.value.chart.properties.Common;
import com.prelytis.dashboard.value.chart.properties.DefaultColorList;
import com.prelytis.dashboard.value.chart.properties.ExtentCalculation;
import com.prelytis.dashboard.value.chart.properties.ExtentCalculationB;
import com.prelytis.dashboard.value.chart.properties.Format;
import com.prelytis.dashboard.value.chart.properties.Gauge;
import com.prelytis.dashboard.value.chart.properties.GaugeThresholdMode;
import com.prelytis.dashboard.value.chart.properties.LabelMaxWidth;
import com.prelytis.dashboard.value.chart.properties.Legend;
import com.prelytis.dashboard.value.chart.properties.LinearGauge;
import com.prelytis.dashboard.value.chart.properties.LinearGaugeDisplayMode;
import com.prelytis.dashboard.value.chart.properties.Map;
import com.prelytis.dashboard.value.chart.properties.Marker;
import com.prelytis.dashboard.value.chart.properties.Milestones;
import com.prelytis.dashboard.value.chart.properties.Pie;
import com.prelytis.dashboard.value.chart.properties.Radar;
import com.prelytis.dashboard.value.chart.properties.RadarDisplayMode;
import com.prelytis.dashboard.value.chart.properties.RegressionLine;
import com.prelytis.dashboard.value.chart.properties.ShowPercent;
import com.prelytis.dashboard.value.chart.properties.ShowThresholds;
import com.prelytis.dashboard.value.chart.properties.ShowValues;
import com.prelytis.dashboard.value.chart.properties.ShowValuesExtended;
import com.prelytis.dashboard.value.chart.properties.StrokeType;
import com.prelytis.dashboard.value.chart.properties.StrokeTypeB;
import com.prelytis.dashboard.value.chart.properties.TimeAxis;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.AbstractBeanReportCalculation;
import com.prelytis.dashboard.value.data.AbstractBeanReportFilter;
import com.prelytis.dashboard.value.data.Agregation;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanCommand;
import com.prelytis.dashboard.value.data.BeanDisplayType;
import com.prelytis.dashboard.value.data.BeanFieldGroup;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureFinal;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanQuerySQLFilter;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.BeanReport;
import com.prelytis.dashboard.value.data.BeanReportAvlCalcField;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanReportAvlGroup;
import com.prelytis.dashboard.value.data.BeanReportCalculationLabel;
import com.prelytis.dashboard.value.data.BeanReportCalculationLine;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportCrossTableUsedField;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportFilter;
import com.prelytis.dashboard.value.data.BeanReportFinal;
import com.prelytis.dashboard.value.data.BeanReportSQLPreview;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdBreak;
import com.prelytis.dashboard.value.data.BeanReportStdHeader;
import com.prelytis.dashboard.value.data.BeanReportStdRanking;
import com.prelytis.dashboard.value.data.BeanReportStdSection;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanReportUsedField;
import com.prelytis.dashboard.value.data.BeanSentinelCommands;
import com.prelytis.dashboard.value.data.BeanStrokeType;
import com.prelytis.dashboard.value.data.BeanStrokeTypeElement;
import com.prelytis.dashboard.value.data.BeanTaskDefinition;
import com.prelytis.dashboard.value.data.BeanTaskDocExport;
import com.prelytis.dashboard.value.data.BeanThresholdTypeDefinition;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.data.FieldCalculation;
import com.prelytis.dashboard.value.data.HierarchicalElement;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.ReportUniqueName;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.ReportFilter;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.ICalculatedOperand;
import com.prelytis.dashboard.value.query.IOperandGroup;
import com.prelytis.dashboard.value.query.IOperandGroupElement;
import com.prelytis.dashboard.value.query.InteractiveOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.OperandExpression;
import com.prelytis.dashboard.value.query.PromptHierarchicalElt;
import com.prelytis.dashboard.value.query.PromptOperand;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Threshold;
import com.prelytis.dashboard.value.util.Thresholds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.ServiceUnavailableException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class ReportHelper
extends ParameterHelper
implements Dependency,
References {
    private final boolean autoNameGeneration;
    private final boolean addDocInWorkspace;
    private final EntityHelper entityHelper;
    private final QueryHelper queryHelper;
    private final ReportDao dao;

    ReportHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getReportDao();
        this.entityHelper = new EntityHelper(daoFactory);
        this.queryHelper = new QueryHelper(daoFactory);
        PrelytisInfoDao prelytisInfoDao = daoFactory.getPrelytisInfoDao();
        this.autoNameGeneration = prelytisInfoDao.isAutoNameGeneration();
        this.addDocInWorkspace = prelytisInfoDao.isAddDocInWorkspace();
    }

    public static final ReportHelper getInstance(DaoFactory daoFactory) {
        return new ReportHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), value.getUserExternalId(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data, value.getUserExternalId());
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanReport)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((AbstractBeanReport)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((AbstractBeanReport)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data, value.getUserExternalId());
            }
            case REFRESH: {
                if (!(value.getElement() instanceof AbstractBeanReport)) {
                    throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("nothingToRefresh", null, null);
                }
                return this.getRefresh((AbstractBeanReport)value.getElement(), data);
            }
            case REFRESH_REPORT_SQL: {
                return this.getRefreshSql((AbstractBeanReport)value.getElement(), data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getRefreshSql(AbstractBeanReport report, ExpressionEvaluationData data) throws DashboardException {
        BeanReportSQLPreview preview = new BeanReportSQLPreview();
        preview.setSql(this.getSQL(report, data));
        return this.helper.getResponse((I18nElement)preview, data, SessionParameterType.REPORT);
    }

    private ParameterResponse getRefresh(AbstractBeanReport element, ExpressionEvaluationData data) throws DashboardException {
        this.updateOids((BeanReport)element);
        element = this.refresh(element, data);
        return this.helper.getResponse((I18nElement)element, data, SessionParameterType.REPORT);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data, long userExternalId) throws DashboardException {
        BeanReportStd elt = this.create(data);
        this.loadSentinelCommands(elt, userExternalId);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.REPORT);
    }

    public BeanReportStd create(ExpressionEvaluationData data) throws DashboardException {
        BeanReportStd elt = new BeanReportStd();
        if (this.autoNameGeneration) {
            elt.setName(this.guidFactory.generateGUID((Object)elt));
        }
        this.updateDescKeys((AbstractBeanReport)elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        elt.setPageLayoutName("A4P");
        elt.setStyleName("default");
        return elt;
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanReport elt = this.helper.get((Dao)this.dao, name, 1, BeanReport.class);
        this.checkOwnerEntity(data, (Bean)elt);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getSaveAsNew(AbstractBeanReport elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.REPORT);
    }

    private ParameterResponse getSave(AbstractBeanReport elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.REPORT);
    }

    public void save(AbstractBeanReport elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(AbstractBeanReport elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanReport)elt);
        DisplayProperties dp = elt.getDisplayProperties();
        elt.setDisplayProperties((DisplayProperties)this.getDbChartProperties(dp));
        this.checkOwnerEntity(data, (Bean)elt);
        this.updateDescKeys(elt, false);
        this.updateDescriptionMap(elt, this.helper.getLocales(), data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        if (elt.getRowsPerPage() <= 0) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("invalidRowsPerPage", null, null);
        }
        this.checkFilters(elt.getFilterList(), data.getLocale());
        this.checkAvlField(elt.getAvlGroupList(), data.getLocale());
        this.updateAvlCalcField(elt, data);
        ArrayList<ReportUniqueName> toFix = new ArrayList<ReportUniqueName>();
        HashSet<String> nameSet = new HashSet<String>();
        int id = 0;
        if (elt instanceof BeanReportStd) {
            BeanReportStd std = (BeanReportStd)elt;
            id = this.fillNameList(std.getFieldList(), nameSet, toFix, id);
            this.updateSelectedSentinelCommandsFromCache(std);
        } else if (elt instanceof BeanReportCrossTable) {
            BeanReportCrossTable ct = (BeanReportCrossTable)elt;
            id = this.fillNameList((TreeNode<? extends ReportUniqueName>)ct.getColFieldList(), nameSet, toFix, id);
            id = this.fillNameList((TreeNode<? extends ReportUniqueName>)ct.getRowFieldList(), nameSet, toFix, id);
            id = this.fillNameList(ct.getDataFieldList(), nameSet, toFix, id);
        }
        this.fillNameList(elt.getSectionList(), nameSet, toFix, id);
        this.fixNameUnicity(toFix, id);
        if (elt.isShowFilterFirst() && !this.hasInteractifFilter(elt)) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("reportMissingFilter", null, null);
        }
        this.dao.save((Element)elt);
        if (this.addDocInWorkspace) {
            this.saveReportToWorkspace(elt, data);
        }
        if (elt.getExecutionMode() == 1) {
            DbTaskFilter filter = new DbTaskFilter();
            filter.setReportOid(Integer.valueOf(elt.getObjectID()));
            filter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_DOCUMENT_EXPORT));
            TaskHelper taskHelper = TaskHelper.getInstance(this.daoFactory);
            boolean exists = taskHelper.exists(filter);
            if (!exists) {
                BeanTaskDocExport docExport = new BeanTaskDocExport();
                docExport.setName(this.guidFactory.generateGUID((Object)docExport));
                docExport.setReportOid(Integer.valueOf(elt.getObjectID()));
                docExport.setReportName(elt.getName());
                docExport.setDataType(1);
                docExport.setOwnerEntOID(elt.getOwnerEntOID());
                docExport.setOwnerEntityName(elt.getOwnerEntityName());
                docExport.setCreationDate(elt.getCreationDate());
                docExport.setOwner(elt.getOwner());
                docExport.setLastModificationDate(elt.getLastModificationDate());
                docExport.setLastModifier(elt.getLastModifier());
                docExport.getDescriptionMap().putAll(elt.getDescriptionMap());
                taskHelper.save((BeanTaskDefinition)docExport, data, true);
            }
        }
        elt.setDisplayProperties(dp);
    }

    private void saveReportToWorkspace(AbstractBeanReport elt, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceHelper workspaceHelper = new WorkspaceHelper(this.daoFactory);
        workspaceHelper.addSession(data.getWorkspaceOid(), SessionType.DOCUMENT, elt.getObjectID(), SystemSessionGroup.EN_COURS.getOid(), true, data.getLocale());
    }

    private void updateAvlCalcField(AbstractBeanReport elt, ExpressionEvaluationData data) throws DashboardException {
        IQueryDefinition query = this.queryHelper.getFinal(elt.getQueryName());
        List fieldList = query.getBeanQuerySQLFieldList();
        HashMap<String, BeanQuerySQLField> fieldMap = new HashMap<String, BeanQuerySQLField>();
        for (BeanQuerySQLField field : fieldList) {
            fieldMap.put(field.getName(), field);
        }
        for (BeanReportAvlGroup group : elt.getAvlGroupList()) {
            for (AbstractBeanReportAvlField avlField : group.getFields()) {
                BeanReportAvlField field;
                BeanQuerySQLField sqlField;
                if (!(avlField instanceof BeanReportAvlField) || (sqlField = (BeanQuerySQLField)fieldMap.get((field = (BeanReportAvlField)avlField).getName())) == null) continue;
                field.setField(sqlField);
            }
        }
    }

    private void updateDescriptionMap(AbstractBeanReport elt, List<Locale> locales, Locale defaultLocale) {
        BeanReportStd report;
        Object calcField;
        this.helper.updateDescriptionMap((Bean)elt, locales, defaultLocale);
        for (Object group : elt.getAvlGroupList()) {
            for (AbstractBeanReportAvlField avlField : group.getFields()) {
                if (!(avlField instanceof BeanReportAvlCalcField)) continue;
                calcField = (BeanReportAvlCalcField)avlField;
                this.helper.updateDescriptionMap(calcField.getDescriptionMap(), locales, defaultLocale);
            }
        }
        List filterList = elt.getFilterList();
        for (Object filter : filterList) {
            this.helper.updateDescriptionMap(filter.getDescriptionMap(), locales, defaultLocale);
        }
        this.updateDescriptionMap(elt.getTopExpression(), locales, defaultLocale);
        if (elt instanceof BeanReportStd) {
            List sectionList;
            report = (BeanReportStd)elt;
            for (Object hl : report.getHeaderLineList()) {
                calcField = hl.iterator();
                while (calcField.hasNext()) {
                    BeanReportStdHeader h = (BeanReportStdHeader)calcField.next();
                    h.setDescriptionKey(this.guidFactory.generateGUID((Object)report));
                }
            }
            this.updateDescriptionMap(report.getFieldList(), locales, defaultLocale);
            List breakList = report.getBreakList();
            if (breakList != null) {
                for (BeanReportStdBreak b : breakList) {
                    this.updateCalculationDescriptionMap(b.getCalculationLineList(), locales, defaultLocale);
                }
            }
            if ((sectionList = report.getSectionList()) != null) {
                for (BeanReportStdSection s : sectionList) {
                    this.updateCalculationDescriptionMap(s.getCalculationLineList(), locales, defaultLocale);
                }
            }
            this.updateCalculationDescriptionMap(report.getGlobalCalcLineList(), locales, defaultLocale);
            BeanReportStdRanking ranking = report.getRanking();
            this.helper.updateDescriptionMap(ranking.getOthersLabelMap(), locales, defaultLocale);
        }
        if (elt instanceof BeanReportCrossTable) {
            report = (BeanReportCrossTable)elt;
            this.updateDescriptionMap((TreeNode<BeanReportCrossTableUsedField>)report.getColFieldList(), locales, defaultLocale);
            this.updateDescriptionMap((TreeNode<BeanReportCrossTableUsedField>)report.getRowFieldList(), locales, defaultLocale);
            this.updateDescriptionMap(report.getDataFieldList(), locales, defaultLocale);
            this.updateCalculationDescriptionMap((TreeNode<BeanReportCrossTableUsedField>)report.getColFieldList(), locales, defaultLocale);
            this.updateCalculationDescriptionMap((TreeNode<BeanReportCrossTableUsedField>)report.getRowFieldList(), locales, defaultLocale);
        }
    }

    private void updateDescriptionMap(List<? extends BeanReportUsedField> fieldList, List<Locale> locales, Locale defaultLocale) {
        for (BeanReportUsedField beanReportUsedField : fieldList) {
            this.updateDescriptionMap(beanReportUsedField, locales, defaultLocale);
        }
    }

    private void updateDescriptionMap(TreeNode<BeanReportCrossTableUsedField> node, List<Locale> locales, Locale defaultLocale) {
        if (node != null) {
            if (node.getUserObject() != null) {
                this.updateDescriptionMap((BeanReportUsedField)node.getUserObject(), locales, defaultLocale);
            }
            if (node.getChildren() != null) {
                for (TreeNode cn : node.getChildren()) {
                    this.updateDescriptionMap((TreeNode<BeanReportCrossTableUsedField>)cn, locales, defaultLocale);
                }
            }
        }
    }

    private void updateDescriptionMap(BeanReportUsedField field, List<Locale> locales, Locale defaultLocale) {
        this.helper.updateDescriptionMap(field.getDescriptionMap(), locales, defaultLocale);
    }

    private void updateCalculationDescriptionMap(List<BeanReportCalculationLine> list, List<Locale> locales, Locale defaultLocale) {
        if (list != null) {
            for (BeanReportCalculationLine line : list) {
                List abc = line.getCalculationList();
                if (abc == null) continue;
                for (AbstractBeanReportCalculation calc : abc) {
                    if (!(calc instanceof BeanReportCalculationLabel)) continue;
                    BeanReportCalculationLabel label = (BeanReportCalculationLabel)calc;
                    this.helper.updateDescriptionMap(label.getDescriptionMap(), locales, defaultLocale);
                }
            }
        }
    }

    private void updateCalculationDescriptionMap(TreeNode<BeanReportCrossTableUsedField> node, List<Locale> locales, Locale defaultLocale) {
        if (node != null) {
            if (node.getUserObject() != null) {
                this.updateCalculationDescriptionMap(((BeanReportCrossTableUsedField)node.getUserObject()).getCalculationLineList(), locales, defaultLocale);
            }
            if (node.getChildren() != null) {
                for (TreeNode cn : node.getChildren()) {
                    this.updateCalculationDescriptionMap((TreeNode<BeanReportCrossTableUsedField>)cn, locales, defaultLocale);
                }
            }
        }
    }

    private void updateDescriptionMap(Expression expression, List<Locale> locales, Locale defaultLocale) {
        block5: {
            block4: {
                if (expression == null) {
                    return;
                }
                if (!(expression instanceof LogicalExpression)) break block4;
                LogicalExpression logical = (LogicalExpression)expression;
                for (Expression e : logical.getExpressionList()) {
                    this.updateDescriptionMap(e, locales, defaultLocale);
                }
                break block5;
            }
            if (!(expression instanceof OperandExpression)) break block5;
            OperandExpression operandExpression = (OperandExpression)expression;
            for (Operand operand : operandExpression.getOperands()) {
                if (!(operand instanceof PromptOperand)) continue;
                PromptOperand promptOperand = (PromptOperand)operand;
                this.helper.updateDescriptionMap(promptOperand.getDescriptionMap(), locales, defaultLocale);
                if (promptOperand.getHierarchicalEltList() == null) continue;
                for (PromptHierarchicalElt phe : promptOperand.getHierarchicalEltList()) {
                    this.helper.updateDescriptionMap(phe.getDescriptionMap(), locales, defaultLocale);
                }
            }
        }
    }

    private void checkOwnerEntity(ExpressionEvaluationData data, Bean elt) throws DashboardException {
        if (!this.entityHelper.isChild(data.getEntityOid(), ((OwnerEntity)elt).getOwnerEntOID())) {
            throw new SecurityException();
        }
    }

    private String getSQL(AbstractBeanReport report, ExpressionEvaluationData data) throws DashboardException {
        TableHelper tableHelper = TableHelper.getInstance(this.daoFactory);
        tableHelper.setReport(report);
        tableHelper.setData(data);
        return tableHelper.getSql();
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data, long userExternalId) throws DashboardException {
        AbstractBeanReport elt = this.helper.get((Dao)this.dao, name, 2, AbstractBeanReport.class);
        this.helper.updateForCopy((Bean)elt, this.autoNameGeneration);
        this.updateNames((BeanReport)elt);
        this.updateDescKeys(elt, true);
        this.refresh(elt, data);
        this.updateCalcFieldDescriptionMap(elt);
        elt.setDisplayProperties(this.getDisplayProperties(elt.getDisplayProperties()));
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        if (elt instanceof BeanReportStd) {
            this.loadSentinelCommands((BeanReportStd)elt, userExternalId);
        }
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.REPORT);
    }

    DisplayProperties getDisplayProperties(DisplayProperties properties) throws DashboardException {
        if (properties instanceof DbChartProperties) {
            BeanStrokeType strokeType;
            StrokeTypeDao strokeTypeDao;
            PaintableProperties dst;
            DisplayTypeFactory factory = new DisplayTypeFactory();
            DbChartProperties src = (DbChartProperties)properties;
            DisplayProperties dp = factory.getProperties(src.getDisplayType());
            if (dp instanceof PaintableProperties && (dst = (PaintableProperties)dp).getBackground() != null) {
                dst.setBackground(src.getBackground());
            }
            if (dp instanceof Common) {
                dst = (Common)dp;
                if (src.getEnhancedLook() != null) {
                    dst.setEnhancedLook(src.getEnhancedLook());
                }
                if (src.getInteractive() != null) {
                    dst.setInteractive(src.getInteractive());
                }
                if (src.getRotate() != null) {
                    dst.setRotate(src.getRotate());
                }
            }
            if (dp instanceof AxisLabelMaxWidth) {
                dst = (AxisLabelMaxWidth)dp;
                if (src.getAxisLabelMaxWidth() != null) {
                    dst.setAxisLabelMaxWidth(src.getAxisLabelMaxWidth());
                }
            }
            if (dp instanceof BarLine) {
                dst = (BarLine)dp;
                if (src.getBarLineNbBars() != null) {
                    dst.setNbBars(src.getBarLineNbBars());
                }
                if (src.getBarLineNbLines() != null) {
                    dst.setNbLines(src.getBarLineNbLines());
                }
                if (src.getBarLineBindAxis() != null) {
                    dst.setBindAxis(src.getBarLineBindAxis());
                }
            }
            if (dp instanceof Bubble) {
                dst = (Bubble)dp;
                if (src.getBubbleMode() != null) {
                    dst.setBubbleMode(src.getBubbleMode());
                }
                if (src.getBubbleMultiColor() != null) {
                    dst.setMulticolor(src.getBubbleMultiColor());
                }
                if (dst.getMarkers() == null) {
                    dst.setMarkers(new ArrayList());
                }
                this.copyMarkers(src.getMarkers(), dst.getMarkers());
            }
            if (dp instanceof DefaultColorList) {
                dst = (DefaultColorList)dp;
                if (src.getColorListOID() != null) {
                    dst.setColorListName(this.getName(SessionParameterType.COLOR_LIST, (int)src.getColorListOID()));
                }
            }
            if (dp instanceof ExtentCalculation) {
                dst = (ExtentCalculation)dp;
                if (src.getExtentCalc() != null) {
                    dst.setExtentCalculation(ChartExtent.valueOf((int)src.getExtentCalc()));
                }
                if (src.getExtentCalcMin() != null) {
                    dst.setExtentMinOrdinate(src.getExtentCalcMin());
                }
                if (src.getExtentCalcMax() != null) {
                    dst.setExtentMaxOrdinate(src.getExtentCalcMax());
                }
                if (src.getExtentCalcNbValues() != null) {
                    dst.setNbIntermediateValues(ChartNbIntermediateValues.valueOf((int)src.getExtentCalcNbValues()));
                }
            }
            if (dp instanceof ExtentCalculationB) {
                dst = (ExtentCalculationB)dp;
                if (src.getExtentCalcB() != null) {
                    dst.setExtentCalculationB(ChartExtent.valueOf((int)src.getExtentCalcB()));
                }
                if (src.getExtentCalcBMin() != null) {
                    dst.setExtentBMinOrdinate(src.getExtentCalcBMin());
                }
                if (src.getExtentCalcBMax() != null) {
                    dst.setExtentBMaxOrdinate(src.getExtentCalcBMax());
                }
            }
            if (dp instanceof Format) {
                dst = (Format)dp;
                if (src.getFormat() != null) {
                    dst.setFormat(src.getFormat());
                }
            }
            if (dp instanceof LabelMaxWidth) {
                dst = (LabelMaxWidth)dp;
                if (src.getLabelMaxWidth() != null) {
                    dst.setLabelMaxWidth(src.getLabelMaxWidth());
                }
            }
            if (dp instanceof Legend) {
                dst = (Legend)dp;
                if (src.getShowLegend() != null) {
                    dst.setLegend(src.getShowLegend());
                }
            }
            if (dp instanceof com.prelytis.dashboard.value.chart.properties.Map) {
                dst = (com.prelytis.dashboard.value.chart.properties.Map)dp;
                if (src.getMapType() != null) {
                    dst.setMapType(src.getMapType());
                }
                if (src.getMapZoom() != null) {
                    dst.setZoom(src.getMapZoom());
                }
                if (src.getMapBlankColor() != null) {
                    dst.setBlankColor(src.getMapBlankColor());
                }
                if (src.getMapDispBlankLegend() != null) {
                    dst.setDisplayBlankLegend(src.getMapDispBlankLegend());
                }
                if (src.getMapColorPolicy() != null) {
                    dst.setColorPolicy(Map.ColorPolicy.valueOf((int)src.getMapColorPolicy()));
                }
            }
            if (dp instanceof RegressionLine) {
                dst = (RegressionLine)dp;
                if (src.getDrawRegLine() != null) {
                    dst.setDrawRegressionLine(src.getDrawRegLine());
                }
            }
            if (dp instanceof ShowThresholds) {
                dst = (ShowThresholds)dp;
                if (src.getThresholdShowLabel() != null) {
                    dst.setShowThresholdLabel(src.getThresholdShowLabel());
                }
                if (src.getThresholdTypeOID() != null) {
                    ThresholdTypeDao thresholdTypeDao = this.daoFactory.getThresholdTypeDao();
                    BeanThresholdTypeDefinition thresholdType = (BeanThresholdTypeDefinition)thresholdTypeDao.getDefinition(src.getThresholdTypeOID().intValue());
                    dst.setThresholdType(thresholdType.getName());
                    Thresholds ths = ThresholdHelper.copy((Thresholds)thresholdType.getThresholds());
                    dst.setThresholds(ths);
                    ConversionHelper conversionHelper = ConversionHelper.getDBConverter();
                    if (ths != null) {
                        List values = src.getThresholdValues();
                        int cpt = 0;
                        try {
                            for (Threshold th : ths) {
                                th.setValue(conversionHelper.parse(DataType.DOUBLE, (String)values.get(cpt)));
                                ++cpt;
                            }
                        }
                        catch (Exception e) {
                            LogManager.getLogger(ReportHelper.class).warn((Object)("Impossible to get threshold value: " + e.getMessage()));
                        }
                    }
                }
            }
            if (dp instanceof ShowValues) {
                dst = (ShowValues)dp;
                if (src.getShowValues() != null) {
                    dst.setShowValues(src.getShowValues());
                }
            }
            if (dp instanceof ShowValuesExtended) {
                dst = (ShowValuesExtended)dp;
                if (src.getShowValuesExt() != null) {
                    dst.setShowValuesExtended(src.getShowValuesExt());
                }
            }
            if (dp instanceof ShowPercent) {
                dst = (ShowPercent)dp;
                if (src.getShowPercent() != null) {
                    dst.setShowPercent(src.getShowPercent());
                }
            }
            if (dp instanceof Pie) {
                dst = (Pie)dp;
                if (src.getOrientation() != null) {
                    dst.setOrientation(src.getOrientation());
                }
                if (src.getExplode() != null) {
                    dst.setExplode(src.getExplode());
                }
            }
            if (dp instanceof StrokeType) {
                dst = (StrokeType)dp;
                if (src.getStrokeTypeOID() != null) {
                    strokeTypeDao = this.daoFactory.getStrokeTypeDao();
                    strokeType = (BeanStrokeType)strokeTypeDao.getCore(src.getStrokeTypeOID().intValue());
                    dst.setStrokeTypeName(strokeType.getName());
                }
            }
            if (dp instanceof StrokeTypeB) {
                dst = (StrokeTypeB)dp;
                if (src.getStrokeTypeOID() != null) {
                    strokeTypeDao = this.daoFactory.getStrokeTypeDao();
                    strokeType = (BeanStrokeType)strokeTypeDao.getCore(src.getStrokeTypeBOID().intValue());
                    dst.setStrokeTypeBName(strokeType.getName());
                }
                if (src.getNbLeftLines() != null) {
                    dst.setNbLeftLines(src.getNbLeftLines());
                }
                if (src.getNbRightLines() != null) {
                    dst.setNbRightLines(src.getNbRightLines());
                }
            }
            if (dp instanceof LinearGauge) {
                dst = (LinearGauge)dp;
                if (src.getLinearGaugeDisplayMode() != null) {
                    dst.setLinearGaugeDisplayMode(LinearGaugeDisplayMode.valueOf((int)src.getLinearGaugeDisplayMode()));
                }
            }
            if (dp instanceof Gauge) {
                dst = (Gauge)dp;
                if (src.getGaugeThresholdMode() != null) {
                    dst.setGaugeThresholdMode(GaugeThresholdMode.valueOf((int)src.getGaugeThresholdMode()));
                }
            }
            if (dp instanceof Radar) {
                dst = (Radar)dp;
                if (src.getRadarDspMode() != null) {
                    dst.setRadarDisplayMode(RadarDisplayMode.valueOf((int)src.getRadarDspMode()));
                }
            }
            if (dp instanceof Milestones) {
                dst = (Milestones)dp;
                if (src.getShowMilestones() != null) {
                    dst.setShowMilestones(src.getShowMilestones().booleanValue());
                }
            }
            if (dp instanceof TimeAxis) {
                dst = (TimeAxis)dp;
                if (src.getTimeAxisStartToday() != null) {
                    dst.setStartToday(src.getTimeAxisStartToday().booleanValue());
                }
            }
            return dp;
        }
        return properties;
    }

    DbChartProperties getDbChartProperties(DisplayProperties dp) throws DashboardException {
        BeanStrokeType strokeType;
        StrokeTypeDao strokeTypeDao;
        PaintableProperties src;
        DbChartProperties dst = new DbChartProperties();
        dst.setDisplayType(dp.getDisplayType());
        if (dp instanceof PaintableProperties) {
            src = (PaintableProperties)dp;
            dst.setBackground(src.getBackground());
        }
        if (dp instanceof Common) {
            src = (Common)dp;
            if (src.getEnhancedLook() != null) {
                dst.setEnhancedLook(src.getEnhancedLook());
            }
            if (src.getInteractive() != null) {
                dst.setInteractive(src.getInteractive());
            }
            if (src.getRotate() != null) {
                dst.setRotate(src.getRotate());
            }
        }
        if (dp instanceof AxisLabelMaxWidth && (src = (AxisLabelMaxWidth)dp).getAxisLabelMaxWidth() != null) {
            dst.setAxisLabelMaxWidth(src.getAxisLabelMaxWidth());
        }
        if (dp instanceof BarLine) {
            src = (BarLine)dp;
            if (src.getNbBars() != null) {
                dst.setBarLineNbBars(src.getNbBars());
            }
            if (src.getNbLines() != null) {
                dst.setBarLineNbLines(src.getNbLines());
            }
            if (src.getBindAxis() != null) {
                dst.setBarLineBindAxis(src.getBindAxis());
            }
        }
        if (dp instanceof Bubble) {
            src = (Bubble)dp;
            if (src.getBubbleMode() != null) {
                dst.setBubbleMode(src.getBubbleMode());
            }
            if (src.getMulticolor() != null) {
                dst.setBubbleMultiColor(src.getMulticolor());
            }
            this.copyMarkers(src.getMarkers(), dst.getMarkers());
        }
        if (dp instanceof DefaultColorList) {
            src = (DefaultColorList)dp;
            dst.setColorListOID(this.optOid(SessionParameterType.COLOR_LIST, src.getColorListName()));
        }
        if (dp instanceof ExtentCalculation) {
            src = (ExtentCalculation)dp;
            if (src.getExtentCalculation() != null) {
                dst.setExtentCalc(Integer.valueOf(src.getExtentCalculation().getId()));
            }
            dst.setExtentCalcMin(src.getExtentMinOrdinate());
            dst.setExtentCalcMax(src.getExtentMaxOrdinate());
            if (src.getNbIntermediateValues() != null) {
                dst.setExtentCalcNbValues(Integer.valueOf(src.getNbIntermediateValues().getIntValue()));
            }
        }
        if (dp instanceof ExtentCalculationB) {
            src = (ExtentCalculationB)dp;
            if (src.getExtentCalculationB() != null) {
                dst.setExtentCalcB(Integer.valueOf(src.getExtentCalculationB().getId()));
            }
            dst.setExtentCalcBMin(src.getExtentBMinOrdinate());
            dst.setExtentCalcBMax(src.getExtentBMaxOrdinate());
        }
        if (dp instanceof Format) {
            src = (Format)dp;
            dst.setFormat(src.getFormat());
        }
        if (dp instanceof LabelMaxWidth) {
            src = (LabelMaxWidth)dp;
            dst.setLabelMaxWidth(src.getLabelMaxWidth());
        }
        if (dp instanceof Legend) {
            src = (Legend)dp;
            dst.setShowLegend(src.getLegend());
        }
        if (dp instanceof com.prelytis.dashboard.value.chart.properties.Map) {
            src = (com.prelytis.dashboard.value.chart.properties.Map)dp;
            dst.setMapType(src.getMapType());
            dst.setMapZoom(src.getZoom());
            dst.setMapBlankColor(src.getBlankColor());
            dst.setMapDispBlankLegend(src.getDisplayBlankLegend());
            if (src.getColorPolicy() != null) {
                dst.setMapColorPolicy(Integer.valueOf(src.getColorPolicy().getId()));
            }
        }
        if (dp instanceof RegressionLine && (src = (RegressionLine)dp).getDrawRegressionLine() != null) {
            dst.setDrawRegLine(src.getDrawRegressionLine());
        }
        if (dp instanceof ShowThresholds) {
            src = (ShowThresholds)dp;
            dst.setThresholdShowLabel(src.getShowThresholdLabel());
            if (src.getThresholdType() != null) {
                ThresholdTypeDao thresholdTypeDao = this.daoFactory.getThresholdTypeDao();
                BeanThresholdTypeDefinition thresholdType = (BeanThresholdTypeDefinition)thresholdTypeDao.getDefinition(src.getThresholdType());
                dst.setThresholdTypeOID(Integer.valueOf(thresholdType.getObjectID()));
                Thresholds ths = src.getThresholds();
                ConversionHelper ch = ConversionHelper.getDBConverter();
                for (Threshold t : ths) {
                    dst.getThresholdValues().add(ch.format(t.getValue()));
                }
            }
        }
        if (dp instanceof ShowValues && (src = (ShowValues)dp).getShowValues() != null) {
            dst.setShowValues(src.getShowValues());
        }
        if (dp instanceof ShowValuesExtended && (src = (ShowValuesExtended)dp).getShowValuesExtended() != null) {
            dst.setShowValuesExt(src.getShowValuesExtended());
        }
        if (dp instanceof ShowPercent && (src = (ShowPercent)dp).getShowPercent() != null) {
            dst.setShowPercent(src.getShowPercent());
        }
        if (dp instanceof Pie) {
            src = (Pie)dp;
            dst.setOrientation(src.getOrientation());
            dst.setExplode(src.getExplode());
        }
        if (dp instanceof StrokeType && (src = (StrokeType)dp).getStrokeTypeName() != null) {
            strokeTypeDao = this.daoFactory.getStrokeTypeDao();
            strokeType = (BeanStrokeType)strokeTypeDao.getCore(src.getStrokeTypeName());
            dst.setStrokeTypeOID(Integer.valueOf(strokeType.getObjectID()));
        }
        if (dp instanceof StrokeTypeB) {
            src = (StrokeTypeB)dp;
            if (src.getStrokeTypeBName() != null) {
                strokeTypeDao = this.daoFactory.getStrokeTypeDao();
                strokeType = (BeanStrokeType)strokeTypeDao.getCore(src.getStrokeTypeBName());
                dst.setStrokeTypeBOID(Integer.valueOf(strokeType.getObjectID()));
            }
            dst.setNbLeftLines(src.getNbLeftLines());
            dst.setNbRightLines(src.getNbRightLines());
        }
        if (dp instanceof LinearGauge && (src = (LinearGauge)dp).getLinearGaugeDisplayMode() != null) {
            dst.setLinearGaugeDisplayMode(Integer.valueOf(src.getLinearGaugeDisplayMode().getId()));
        }
        if (dp instanceof Gauge && (src = (Gauge)dp).getGaugeThresholdMode() != null) {
            dst.setGaugeThresholdMode(Integer.valueOf(src.getGaugeThresholdMode().getId()));
        }
        if (dp instanceof Radar && (src = (Radar)dp).getRadarDisplayMode() != null) {
            dst.setRadarDspMode(Integer.valueOf(src.getRadarDisplayMode().getId()));
        }
        if (dp instanceof Milestones) {
            src = (Milestones)dp;
            dst.setShowMilestones(Boolean.valueOf(src.isShowMilestones()));
        }
        if (dp instanceof TimeAxis) {
            src = (TimeAxis)dp;
            dst.setTimeAxisStartToday(Boolean.valueOf(src.isStartToday()));
        }
        return dst;
    }

    private void copyMarkers(List<Marker> srcMarkers, List<Marker> dstMarkers) {
        if (srcMarkers == null) {
            return;
        }
        dstMarkers.clear();
        for (Marker srcM : srcMarkers) {
            Marker dstM = new Marker();
            dstM.setAgregation(srcM.getAgregation());
            dstM.setAxis(srcM.getAxis());
            dstM.setColor(srcM.getColor());
            dstM.setColumn(srcM.getColumn());
            dstM.setDescription(srcM.getDescription());
            BeanStrokeTypeElement dstST = new BeanStrokeTypeElement(srcM.getStrokeType());
            dstM.setStrokeType(dstST);
            dstMarkers.add(dstM);
        }
    }

    private void updateDescKeys(AbstractBeanReport elt, boolean replace) {
        BeanReportStd report;
        Object calcField;
        this.helper.updateDescKey((Bean)elt, replace);
        for (Object group : elt.getAvlGroupList()) {
            for (AbstractBeanReportAvlField avlField : group.getFields()) {
                if (!(avlField instanceof BeanReportAvlCalcField)) continue;
                calcField = (BeanReportAvlCalcField)avlField;
                if (!replace && !this.helper.isInvalidDescKey(calcField.getDescriptionKey())) continue;
                calcField.setDescriptionKey(this.guidFactory.generateGUID((Object)avlField));
            }
        }
        List filterList = elt.getFilterList();
        for (Object filter : filterList) {
            if (!replace && !this.helper.isInvalidDescKey(filter.getDescriptionKey())) continue;
            filter.setDescriptionKey(this.guidFactory.generateGUID(filter));
        }
        this.updateDescKeys(elt.getTopExpression(), replace);
        if (elt instanceof BeanReportStd) {
            List sectionList;
            report = (BeanReportStd)elt;
            for (Object hl : report.getHeaderLineList()) {
                calcField = hl.iterator();
                while (calcField.hasNext()) {
                    BeanReportStdHeader h = (BeanReportStdHeader)calcField.next();
                    h.setDescriptionKey(this.guidFactory.generateGUID((Object)report));
                }
            }
            this.updateDescKeys(report.getFieldList(), replace);
            List breakList = report.getBreakList();
            if (breakList != null) {
                for (BeanReportStdBreak b : breakList) {
                    this.updateDescKeysCalculation(b.getCalculationLineList(), replace);
                }
            }
            if ((sectionList = report.getSectionList()) != null) {
                for (BeanReportStdSection s : sectionList) {
                    this.updateDescKeysCalculation(s.getCalculationLineList(), replace);
                }
            }
            this.updateDescKeysCalculation(report.getGlobalCalcLineList(), replace);
            BeanReportStdRanking ranking = report.getRanking();
            if (replace || this.helper.isInvalidDescKey(ranking.getOthersLabelKey())) {
                ranking.setOthersLabelKey(this.guidFactory.generateGUID((Object)report));
            }
        }
        if (elt instanceof BeanReportCrossTable) {
            report = (BeanReportCrossTable)elt;
            this.updateDescKeys((TreeNode<BeanReportCrossTableUsedField>)report.getColFieldList(), replace);
            this.updateDescKeys((TreeNode<BeanReportCrossTableUsedField>)report.getRowFieldList(), replace);
            this.updateDescKeys(report.getDataFieldList(), replace);
            this.updateDescKeysCalculation((TreeNode<BeanReportCrossTableUsedField>)report.getColFieldList(), replace);
            this.updateDescKeysCalculation((TreeNode<BeanReportCrossTableUsedField>)report.getRowFieldList(), replace);
        }
    }

    public BeanReportFinal getFinal(AbstractBeanReport report, ExpressionEvaluationData data) throws DashboardException {
        BeanReportStd bean;
        BeanReportFinal reportFinal = new BeanReportFinal();
        reportFinal.setObjectID(report.getObjectID());
        reportFinal.setName(report.getName());
        reportFinal.setDescriptionKey(report.getDescriptionKey());
        reportFinal.getDescriptionMap().putAll(report.getDescriptionMap());
        reportFinal.setExecutionMode(report.getExecutionMode());
        if (report instanceof BeanReportStd) {
            bean = (BeanReportStd)report;
            reportFinal.getFieldList().addAll(bean.getFieldList());
        } else {
            bean = (BeanReportCrossTable)report;
            this.fill(reportFinal.getFieldList(), (TreeNode<BeanReportCrossTableUsedField>)bean.getColFieldList());
            this.fill(reportFinal.getFieldList(), (TreeNode<BeanReportCrossTableUsedField>)bean.getRowFieldList());
            reportFinal.getFieldList().addAll(bean.getDataFieldList());
        }
        IQueryDefinition query = null;
        if (report.getQueryName() != null) {
            query = this.queryHelper.getFinal(report.getQueryName());
        }
        reportFinal.getFilterList().addAll(this.getFilterList(report, query, data));
        reportFinal.getReportSectionList().addAll(report.getSectionList());
        return reportFinal;
    }

    private void fill(List<BeanReportUsedField> fieldList, TreeNode<BeanReportCrossTableUsedField> node) {
        if (node != null) {
            if (node.getUserObject() != null) {
                fieldList.add((BeanReportUsedField)node.getUserObject());
            }
            if (node.getChildren() != null) {
                for (TreeNode cn : node.getChildren()) {
                    this.fill(fieldList, (TreeNode<BeanReportCrossTableUsedField>)cn);
                }
            }
        }
    }

    List<com.prelytis.dashboard.value.data.ReportFilter> getVisibleFilterList(AbstractBeanReport report, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<com.prelytis.dashboard.value.data.ReportFilter> newList = new ArrayList<com.prelytis.dashboard.value.data.ReportFilter>();
        List<com.prelytis.dashboard.value.data.ReportFilter> list = this.getFilterList(report, data);
        if (list != null) {
            for (com.prelytis.dashboard.value.data.ReportFilter filter : list) {
                if (!filter.isVisible()) continue;
                newList.add(filter);
            }
        }
        return newList;
    }

    public List<com.prelytis.dashboard.value.data.ReportFilter> getLinkableFilterList(AbstractBeanReport report, ExpressionEvaluationData data) throws DashboardException {
        ArrayList<com.prelytis.dashboard.value.data.ReportFilter> newList = new ArrayList<com.prelytis.dashboard.value.data.ReportFilter>();
        List<com.prelytis.dashboard.value.data.ReportFilter> list = this.getFilterList(report, data);
        if (list != null) {
            for (com.prelytis.dashboard.value.data.ReportFilter filter : list) {
                if (!filter.isLinkable()) continue;
                newList.add(filter);
            }
        }
        return newList;
    }

    private List<com.prelytis.dashboard.value.data.ReportFilter> getFilterList(AbstractBeanReport report, ExpressionEvaluationData data) throws DashboardException {
        IQueryDefinition query = this.queryHelper.getFinal(report.getQueryName());
        return this.getFilterList(report, query, data);
    }

    public List<com.prelytis.dashboard.value.data.ReportFilter> getFilterList(AbstractBeanReport report, IQueryDefinition query, ExpressionEvaluationData data) throws DashboardRuntimeException, DashboardException {
        List<com.prelytis.dashboard.value.data.ReportFilter> filterList = null;
        if (query instanceof BeanQueryDataStructureFinal) {
            BeanQueryDataStructureFinal ds = (BeanQueryDataStructureFinal)query;
            filterList = this.getSQLFilterList(report, data);
            HashSet<String> set = new HashSet<String>();
            this.addField(ds.getTableFact(), set);
            this.addCalcField(report.getAvlGroupList(), set);
            Map<String, AbstractBeanReportFilter> map = this.getFilterMap(report);
            Map<String, AbstractBeanReportAvlField> reportFilterMap = this.getFieldMap(report);
            this.addExpression(filterList, set, report.getTopExpression(), map, reportFilterMap, data);
        } else if (query instanceof BeanQuerySQL) {
            filterList = this.getSQLFilterList(report, data);
        } else {
            throw new DashboardRuntimeException(ErrorCode.UNKNOWN_QUERY_TYPE, "Unknown query type");
        }
        return filterList;
    }

    private Map<String, AbstractBeanReportFilter> getFilterMap(AbstractBeanReport report) {
        HashMap<String, AbstractBeanReportFilter> map = new HashMap<String, AbstractBeanReportFilter>();
        List refFilterList = report.getFilterList();
        if (refFilterList != null) {
            for (AbstractBeanReportFilter flt : refFilterList) {
                map.put(flt.getName(), flt);
            }
        }
        return map;
    }

    private void addCalcField(List<BeanReportAvlGroup> groupList, Set<String> set) {
        if (groupList != null) {
            for (BeanReportAvlGroup group : groupList) {
                for (AbstractBeanReportAvlField avlField : group.getFields()) {
                    if (!(avlField instanceof BeanReportAvlCalcField)) continue;
                    set.add(avlField.getName());
                }
            }
        }
    }

    private void addExpression(List<com.prelytis.dashboard.value.data.ReportFilter> list, Set<String> set, Expression expression, Map<String, AbstractBeanReportFilter> map, Map<String, AbstractBeanReportAvlField> reportFilterMap, ExpressionEvaluationData data) throws DashboardException {
        OperandExpression operandExpression;
        String fieldName;
        if (expression == null) {
            return;
        }
        if (expression instanceof OperandExpression && set.contains(fieldName = ((FieldOperand)(operandExpression = (OperandExpression)expression).getOperands()[0]).getField())) {
            for (Operand operand : operandExpression.getOperands()) {
                AbstractBeanReportFilter refFilter;
                if (!(operand instanceof InteractiveOperand)) continue;
                InteractiveOperand interactiveOperand = (InteractiveOperand)operand;
                com.prelytis.dashboard.value.data.ReportFilter filter = new com.prelytis.dashboard.value.data.ReportFilter();
                filter.setDatatype(interactiveOperand.getDataType());
                if (data != null) {
                    filter.setDescription((String)interactiveOperand.getDescriptionMap().get(data.getLocale()));
                }
                filter.setLinkable(interactiveOperand.isLinkable());
                filter.setMandatory(interactiveOperand.isMandatory());
                filter.setName(interactiveOperand.getName());
                filter.setVisible(interactiveOperand.isVisible());
                filter.setPromptType(interactiveOperand.getPromptType());
                filter.setHierarchicalFilter(interactiveOperand.isHierarchicalFilter());
                filter.setFormat(interactiveOperand.getFormat());
                filter.setSortOrder(interactiveOperand.getSortOrder());
                if (interactiveOperand.getHierarchicalEltList() != null) {
                    ArrayList<HierarchicalElement> filterList = new ArrayList<HierarchicalElement>();
                    for (int j = interactiveOperand.getHierarchicalEltList().size() - 1; j >= 0; --j) {
                        PromptHierarchicalElt phe = (PromptHierarchicalElt)interactiveOperand.getHierarchicalEltList().get(j);
                        HierarchicalElement he = new HierarchicalElement();
                        he.setName(phe.getHierarchicalField());
                        he.setDescription((String)phe.getDescriptionMap().get(data.getLocale()));
                        he.setDatatype(reportFilterMap.get(phe.getHierarchicalField()).getDataType());
                        he.setPromptType(phe.getTypeList());
                        he.setValueList(new ArrayList());
                        he.setFormat(phe.getFormat());
                        he.setSortOrder(phe.getSortOrder());
                        he.setCompleteList(interactiveOperand.isCompleteList());
                        filterList.add(he);
                    }
                    filter.setHierarchicalEltList(filterList);
                }
                if ((refFilter = map.get(filter.getName())) != null) {
                    filter.setUseFilter(refFilter.isUseFilter());
                    filter.setValues(new Object[]{refFilter.getDefaultValue()});
                } else {
                    filter.setUseFilter(interactiveOperand.isUsed());
                    filter.setValues(interactiveOperand.getValues());
                }
                list.add(filter);
            }
        }
        if (expression instanceof LogicalExpression) {
            LogicalExpression logical = (LogicalExpression)expression;
            for (Expression e : logical.getExpressionList()) {
                this.addExpression(list, set, e, map, reportFilterMap, data);
            }
        }
    }

    private void addField(BeanQueryDataStructureTable dsTable, Set<String> set) {
        List fieldList = dsTable.getTableFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            BeanQueryDataStructureTableField field = (BeanQueryDataStructureTableField)fieldList.get(i);
            set.add(field.getName());
        }
        List childList = dsTable.getTableChildList();
        for (int i = 0; i < childList.size(); ++i) {
            BeanQueryDataStructureTable dsTableChild = (BeanQueryDataStructureTable)childList.get(i);
            this.addField(dsTableChild, set);
        }
    }

    private List<com.prelytis.dashboard.value.data.ReportFilter> getSQLFilterList(AbstractBeanReport report, ExpressionEvaluationData data) {
        ArrayList<com.prelytis.dashboard.value.data.ReportFilter> filterList = new ArrayList<com.prelytis.dashboard.value.data.ReportFilter>();
        List reportFilterList = report.getFilterList();
        if (reportFilterList != null) {
            for (int i = 0; i < reportFilterList.size(); ++i) {
                BeanReportFilter filter = (BeanReportFilter)reportFilterList.get(i);
                com.prelytis.dashboard.value.data.ReportFilter reportFilterSQL = new com.prelytis.dashboard.value.data.ReportFilter();
                reportFilterSQL.setDatatype(filter.getDataType());
                if (data != null) {
                    reportFilterSQL.setDescription((String)filter.getDescriptionMap().get(data.getLocale()));
                }
                reportFilterSQL.setLinkable(true);
                reportFilterSQL.setMandatory(true);
                reportFilterSQL.setName(filter.getName());
                reportFilterSQL.setVisible(filter.getParameter() == '2');
                switch (filter.getPromptType()) {
                    case 2: {
                        reportFilterSQL.setPromptType(2);
                        break;
                    }
                    case 3: {
                        reportFilterSQL.setPromptType(3);
                        break;
                    }
                    default: {
                        reportFilterSQL.setPromptType(1);
                    }
                }
                reportFilterSQL.setUseFilter(true);
                reportFilterSQL.setValue(filter.getDefaultValue());
                filterList.add(reportFilterSQL);
            }
        }
        return filterList;
    }

    private ParameterResponse get(Integer instanceType, String name, long userId, ExpressionEvaluationData data) throws DashboardException {
        int it = instanceType == null || instanceType == 3 ? 2 : instanceType;
        BeanReport bean = this.helper.get((Dao)this.dao, name, it, BeanReport.class);
        this.updateNames(bean);
        if (bean instanceof AbstractBeanReport) {
            AbstractBeanReport elt = (AbstractBeanReport)bean;
            bean = this.refresh(elt, data);
            this.updateCalcFieldDescriptionMap(elt);
            elt.setDisplayProperties(this.getDisplayProperties(elt.getDisplayProperties()));
            if (elt instanceof BeanReportStd) {
                this.loadSentinelCommands((BeanReportStd)elt, userId);
            }
        }
        if (instanceType != null && instanceType == 3) {
            BeanReportFinal f = this.getFinal((AbstractBeanReport)bean, data);
            return this.helper.getResponse((I18nElement)f, data, SessionParameterType.REPORT);
        }
        return this.helper.getResponse((I18nElement)bean, data, SessionParameterType.REPORT);
    }

    private void updateNames(BeanReport bean) throws DashboardException {
        boolean modified = bean instanceof AbstractBeanReport ? ((AbstractBeanReport)bean).isModified() : false;
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
        bean.setQueryName(this.getName(SessionParameterType.QUERY, bean.getQueryOID()));
        bean.setPageLayoutName(this.getName(SessionParameterType.PAGE_LAYOUT, bean.getPageLayoutOID()));
        bean.setStyleName(this.getName(SessionParameterType.STYLE, bean.getStyleOid()));
        if (bean instanceof AbstractBeanReport) {
            AbstractBeanReport elt = (AbstractBeanReport)bean;
            for (BeanReportAvlGroup group : elt.getAvlGroupList()) {
                for (AbstractBeanReportAvlField avlField : group.getFields()) {
                    if (!(avlField instanceof BeanReportAvlCalcField)) continue;
                    BeanReportAvlCalcField f = (BeanReportAvlCalcField)avlField;
                    this.updateNames(f.getOperand());
                }
            }
            for (AbstractBeanReportFilter filter : elt.getFilterList()) {
                Integer oid = filter.getValueListOID() == 0 ? null : Integer.valueOf(filter.getValueListOID());
                filter.setValueListName(this.optName(SessionParameterType.QUERY, oid));
            }
            elt.setModified(modified);
        }
    }

    private void updateNames(ICalculatedOperand operand) throws DashboardException {
        if (operand != null && operand.getOperand() instanceof CalcFunctionOperand) {
            CalcFunctionOperand cfo = (CalcFunctionOperand)operand.getOperand();
            cfo.setSqlFunctionName(this.getName(SessionParameterType.SQL_FUNCTION, cfo.getSQLFunctionOID()));
            for (IOperandGroup grp : cfo.getOperandGroups()) {
                for (IOperandGroupElement elt : grp.getElementList()) {
                    for (ICalculatedOperand o : elt.getOperands()) {
                        this.updateNames(o);
                    }
                }
            }
        }
    }

    private void updateOids(BeanReport bean) throws DashboardException {
        boolean modified = bean instanceof AbstractBeanReport ? ((AbstractBeanReport)bean).isModified() : false;
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
        bean.setQueryOID(this.getOid(SessionParameterType.QUERY, bean.getQueryName()));
        bean.setPageLayoutOID(this.getOid(SessionParameterType.PAGE_LAYOUT, bean.getPageLayoutName()));
        bean.setStyleOid(this.getOid(SessionParameterType.STYLE, bean.getStyleName()));
        if (bean instanceof AbstractBeanReport) {
            AbstractBeanReport elt = (AbstractBeanReport)bean;
            for (BeanReportAvlGroup group : elt.getAvlGroupList()) {
                for (AbstractBeanReportAvlField avlField : group.getFields()) {
                    if (!(avlField instanceof BeanReportAvlCalcField)) continue;
                    BeanReportAvlCalcField f = (BeanReportAvlCalcField)avlField;
                    this.updateOids(f.getOperand());
                }
            }
            Iterator iterator = elt.getFilterList().iterator();
            while (iterator.hasNext()) {
                AbstractBeanReportFilter filter;
                Integer oid = this.optOid(SessionParameterType.QUERY, (filter = (AbstractBeanReportFilter)iterator.next()).getValueListName());
                filter.setValueListOID(oid == null ? 0 : oid);
            }
            elt.setModified(modified);
        }
    }

    private void updateOids(ICalculatedOperand operand) throws DashboardException {
        if (operand != null && operand.getOperand() instanceof CalcFunctionOperand) {
            CalcFunctionOperand cfo = (CalcFunctionOperand)operand.getOperand();
            cfo.setSQLFunctionOID(this.getOid(SessionParameterType.SQL_FUNCTION, cfo.getSqlFunctionName()));
            for (IOperandGroup grp : cfo.getOperandGroups()) {
                for (IOperandGroupElement elt : grp.getElementList()) {
                    for (ICalculatedOperand o : elt.getOperands()) {
                        this.updateOids(o);
                    }
                }
            }
        }
    }

    private void updateDescKeys(List<? extends BeanReportUsedField> fieldList, boolean replace) {
        for (BeanReportUsedField beanReportUsedField : fieldList) {
            this.updateDescKeys(beanReportUsedField, replace);
        }
    }

    private void updateDescKeys(TreeNode<BeanReportCrossTableUsedField> node, boolean replace) {
        if (node != null) {
            if (node.getUserObject() != null) {
                this.updateDescKeys((BeanReportUsedField)node.getUserObject(), replace);
            }
            if (node.getChildren() != null) {
                for (TreeNode cn : node.getChildren()) {
                    this.updateDescKeys((TreeNode<BeanReportCrossTableUsedField>)cn, replace);
                }
            }
        }
    }

    private void updateDescKeys(BeanReportUsedField field, boolean replace) {
        if (replace || this.helper.isInvalidDescKey(field.getDescriptionKey())) {
            field.setDescriptionKey(this.guidFactory.generateGUID((Object)field));
        }
    }

    private void updateDescKeysCalculation(List<BeanReportCalculationLine> list, boolean replace) {
        if (list != null) {
            for (BeanReportCalculationLine line : list) {
                List abc = line.getCalculationList();
                if (abc == null) continue;
                for (AbstractBeanReportCalculation calc : abc) {
                    if (!(calc instanceof BeanReportCalculationLabel)) continue;
                    BeanReportCalculationLabel label = (BeanReportCalculationLabel)calc;
                    if (!replace && !this.helper.isInvalidDescKey(label.getDescriptionKey())) continue;
                    label.setDescriptionKey(this.guidFactory.generateGUID((Object)label));
                }
            }
        }
    }

    private void updateDescKeysCalculation(TreeNode<BeanReportCrossTableUsedField> node, boolean replace) {
        if (node != null) {
            if (node.getUserObject() != null) {
                this.updateDescKeysCalculation(((BeanReportCrossTableUsedField)node.getUserObject()).getCalculationLineList(), replace);
            }
            if (node.getChildren() != null) {
                for (TreeNode cn : node.getChildren()) {
                    this.updateDescKeysCalculation((TreeNode<BeanReportCrossTableUsedField>)cn, replace);
                }
            }
        }
    }

    private void updateDescKeys(Expression expression, boolean replace) {
        block6: {
            block5: {
                if (expression == null) {
                    return;
                }
                if (!(expression instanceof LogicalExpression)) break block5;
                LogicalExpression logical = (LogicalExpression)expression;
                for (Expression e : logical.getExpressionList()) {
                    this.updateDescKeys(e, replace);
                }
                break block6;
            }
            if (!(expression instanceof OperandExpression)) break block6;
            OperandExpression operandExpression = (OperandExpression)expression;
            for (Operand operand : operandExpression.getOperands()) {
                if (!(operand instanceof PromptOperand)) continue;
                PromptOperand promptOperand = (PromptOperand)operand;
                if (replace || this.helper.isInvalidDescKey(promptOperand.getDescriptionKey())) {
                    promptOperand.setDescriptionKey(this.guidFactory.generateGUID((Object)promptOperand));
                }
                if (promptOperand.getHierarchicalEltList() == null) continue;
                for (PromptHierarchicalElt phe : promptOperand.getHierarchicalEltList()) {
                    if (!replace && !this.helper.isInvalidDescKey(phe.getDescKey())) continue;
                    phe.setDescKey(this.guidFactory.generateGUID((Object)promptOperand));
                }
            }
        }
    }

    private void loadSentinelCommands(BeanReportStd bean, long userId) {
        BeanSentinelCommands sentinelCommands = bean.getSentinelCommands();
        try {
            TrackingCommandBean[] userCommandsList;
            IDashboardManager manager = DashboardManager.getInstance();
            TrackingCommandListResponse allCommandsResponse = manager.getAllTrackingCommands();
            TrackingCommandBean[] allSentinelCommands = allCommandsResponse.getCommandList();
            Map allWdCommandsMap = sentinelCommands.getAllCommands();
            HashMap<Long, BeanCommand> updatedAllCommandsMap = new HashMap<Long, BeanCommand>();
            for (int i = 0; i < allSentinelCommands.length; ++i) {
                TrackingCommandBean sentinelCommand = allSentinelCommands[i];
                BeanCommand command = new BeanCommand();
                command.setId(sentinelCommand.getId());
                command.setName(sentinelCommand.getName());
                command.setType(sentinelCommand.getType());
                if (allWdCommandsMap.containsKey(sentinelCommand.getId())) {
                    BeanCommand dbCommandInfo = (BeanCommand)allWdCommandsMap.get(sentinelCommand.getId());
                    command.setCriteria(dbCommandInfo.getCriteria());
                    command.setSelected(dbCommandInfo.isSelected());
                }
                updatedAllCommandsMap.put(command.getId(), command);
            }
            sentinelCommands.setAllCommands(updatedAllCommandsMap);
            TrackingCommandListResponse userCommandsResponse = manager.getTrackingCommands(userId);
            for (TrackingCommandBean userCommand : userCommandsList = userCommandsResponse.getCommandList()) {
                BeanCommand command = (BeanCommand)updatedAllCommandsMap.get(userCommand.getId());
                command.setAvailable(true);
            }
            this.updateSentinelCommandsMessage(sentinelCommands, userCommandsResponse.getMessage());
        }
        catch (ServiceUnavailableException e) {
            Logger.getLogger(this.getClass()).error((Object)("Sentinel server is not available: " + e.getLocalizedMessage()));
            sentinelCommands.reset();
            sentinelCommands.setMesssage("sentinelServerDownMessage");
        }
        catch (DashboardServiceException e) {
            Logger.getLogger(this.getClass()).error((Object)("Could not retrieve current user: " + e.getLocalizedMessage()));
            sentinelCommands.reset();
            sentinelCommands.setMesssage("noTrackingCommandsForRightsMessage");
        }
    }

    private void updateSentinelCommandsMessage(BeanSentinelCommands sentinelCommands, String sentinelMessage) {
        sentinelCommands.setMesssage(null);
        if (sentinelMessage == null) {
            return;
        }
        if (sentinelMessage.equals("noTrackingCommandsOnServerMessage")) {
            sentinelCommands.setMesssage("noTrackingCommandsOnServerMessage");
        }
        if (sentinelMessage.equals("noTrackingCommandsForRightsMessage")) {
            sentinelCommands.setMesssage("noTrackingCommandsForRightsMessage");
        }
    }

    private void updateSelectedSentinelCommandsFromCache(BeanReportStd reportStd) {
        if (reportStd.getDisplayProperties().getDisplayType() != BeanDisplayType.SEARCH) {
            BeanSentinelCommands sentinelCommands = reportStd.getSentinelCommands();
            for (BeanCommand command : sentinelCommands.getAllCommands().values()) {
                command.setSelected(false);
            }
        }
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.REPORT).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.REPORT);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.REPORT, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private AbstractBeanReport refresh(AbstractBeanReport report, ExpressionEvaluationData data) throws DashboardException {
        BeanReportCrossTable cross;
        AbstractBeanReport newReport = report;
        FieldGroupHelper fieldGroupHelper = FieldGroupHelper.getInstance(this.daoFactory);
        List<Element> fl = fieldGroupHelper.list(null, 2, null, null, data);
        HashMap<String, BeanReportAvlGroup> groupMap = new HashMap<String, BeanReportAvlGroup>();
        for (Element elt : fl) {
            BeanFieldGroup g = (BeanFieldGroup)elt;
            BeanReportAvlGroup group = new BeanReportAvlGroup();
            group.setName(g.getName());
            group.getDescriptionMap().putAll(g.getDescriptionMap());
            groupMap.put(g.getName(), group);
        }
        if (newReport.isModified()) {
            IQueryDefinition query = this.queryHelper.getFinal(newReport.getQueryName());
            newReport = BeanReportHelper.getInstance().getReport((BeanReport)newReport, query);
            List avlGroupList = newReport.getAvlGroupList();
            avlGroupList.clear();
            if (query != null) {
                List fieldList = query.getBeanQuerySQLFieldList();
                for (int i = 0; i < fieldList.size(); ++i) {
                    BeanQuerySQLField field = (BeanQuerySQLField)fieldList.get(i);
                    if (!field.isActive()) continue;
                    BeanReportAvlGroup group = (BeanReportAvlGroup)groupMap.get(field.getFieldGroupName());
                    BeanReportAvlField avlField = new BeanReportAvlField();
                    avlField.setId(i);
                    avlField.setField(field);
                    avlField.setVisible(true);
                    group.getFields().add(avlField);
                }
                avlGroupList.addAll(groupMap.values());
                I18nComparator comp = new I18nComparator(data.getLocale());
                Collections.sort(avlGroupList, comp);
                for (BeanReportAvlGroup group : avlGroupList) {
                    Collections.sort(group.getFields(), comp);
                }
            }
            this.resetFilters(newReport, query);
            newReport.getSectionList().clear();
            if (newReport instanceof BeanReportStd) {
                BeanReportStd std = (BeanReportStd)newReport;
                std.getFieldList().clear();
                std.getSortFieldList().clear();
            } else {
                BeanReportCrossTable cross2 = (BeanReportCrossTable)newReport;
                cross2.getColFieldList().clear();
                cross2.getRowFieldList().clear();
                cross2.getDataFieldList().clear();
            }
        } else {
            boolean invalid = newReport.getReportType() == 0 && !(newReport instanceof BeanReportStd);
            boolean bl = invalid = invalid || newReport.getReportType() == 2 && !(newReport instanceof BeanReportCrossTable);
            if (invalid) {
                IQueryDefinition query = this.queryHelper.getFinal(newReport.getQueryName());
                newReport = BeanReportHelper.getInstance().getReport((BeanReport)newReport, query);
            }
            ArrayList oldGrps = new ArrayList(newReport.getAvlGroupList());
            List avlGroupList = newReport.getAvlGroupList();
            avlGroupList.clear();
            for (BeanReportAvlGroup oldGrp : oldGrps) {
                BeanReportAvlGroup newGrp = (BeanReportAvlGroup)groupMap.get(oldGrp.getName());
                newGrp.getFields().addAll(oldGrp.getFields());
            }
            avlGroupList.addAll(groupMap.values());
            I18nComparator comp = new I18nComparator(data.getLocale());
            Collections.sort(avlGroupList, comp);
            for (BeanReportAvlGroup group : avlGroupList) {
                Collections.sort(group.getFields(), comp);
            }
        }
        if (newReport instanceof BeanReportStd) {
            BeanReportStd std = (BeanReportStd)newReport;
            if (std.getRanking() != null && std.getRanking().getOthersLabelKey() == null) {
                std.getRanking().setOthersLabelKey(this.guidFactory.generateGUID((Object)std));
            }
        } else if (newReport instanceof BeanReportCrossTable && (cross = (BeanReportCrossTable)newReport).getRanking() != null && cross.getRanking().getOtherDescriptionKey() == null) {
            cross.getRanking().setOtherDescriptionKey(this.guidFactory.generateGUID((Object)cross));
        }
        this.checkUsedField(newReport, report);
        newReport.setModified(false);
        return newReport;
    }

    private Map<String, AbstractBeanReportAvlField> getFieldMap(AbstractBeanReport report) {
        HashMap<String, AbstractBeanReportAvlField> map = new HashMap<String, AbstractBeanReportAvlField>();
        for (BeanReportAvlGroup group : report.getAvlGroupList()) {
            for (AbstractBeanReportAvlField avlField : group.getFields()) {
                map.put(avlField.getName(), avlField);
            }
        }
        return map;
    }

    private void updateCalcFieldDescriptionMap(AbstractBeanReport report) {
        Map<String, AbstractBeanReportAvlField> fieldMap = this.getFieldMap(report);
        for (BeanReportAvlGroup group : report.getAvlGroupList()) {
            for (AbstractBeanReportAvlField avlField : group.getFields()) {
                BeanReportAvlCalcField calcField;
                ICalculatedOperand operand;
                if (!(avlField instanceof BeanReportAvlCalcField) || (operand = (calcField = (BeanReportAvlCalcField)avlField).getOperand()) == null) continue;
                this.updateCalcFieldDescriptionMap(operand.getOperand(), fieldMap);
            }
        }
    }

    private void updateCalcFieldDescriptionMap(Operand operand, Map<String, AbstractBeanReportAvlField> fieldMap) {
        if (operand instanceof FieldOperand) {
            FieldOperand fo = (FieldOperand)operand;
            AbstractBeanReportAvlField field = fieldMap.get(fo.getField());
            if (field != null) {
                fo.getDescriptionMap().putAll(field.getDescriptionMap());
            }
        } else if (operand instanceof CalcFunctionOperand) {
            CalcFunctionOperand cfo = (CalcFunctionOperand)operand;
            for (IOperandGroup og : cfo.getOperandGroups()) {
                for (IOperandGroupElement oge : og.getElementList()) {
                    for (ICalculatedOperand o : oge.getOperands()) {
                        this.updateCalcFieldDescriptionMap(o.getOperand(), fieldMap);
                    }
                }
            }
        }
    }

    private void checkUsedField(AbstractBeanReport newReport, AbstractBeanReport oldReport) {
        if (newReport instanceof BeanReportCrossTable) {
            if (oldReport instanceof BeanReportStd) {
                this.checkUsedField2((BeanReportCrossTable)newReport, (BeanReportStd)oldReport);
            } else {
                this.checkUsedField((BeanReportCrossTable)newReport);
            }
        } else if (oldReport instanceof BeanReportCrossTable) {
            this.checkUsedField2((BeanReportStd)newReport, (BeanReportCrossTable)oldReport);
        } else {
            this.checkUsedField((BeanReportStd)newReport);
        }
    }

    private void checkUsedField2(BeanReportStd newReport, BeanReportCrossTable oldReport) {
        this.checkUsedField(newReport);
    }

    private void checkUsedField2(BeanReportCrossTable newReport, BeanReportStd oldReport) {
        this.checkUsedField(newReport);
    }

    private void checkUsedField(BeanReportStd report) {
        List fieldList = report.getFieldList();
        IdHelper idHelper = new IdHelper(fieldList);
        if (fieldList.isEmpty()) {
            AbstractBeanReportAvlField avlField = null;
            block0: for (BeanReportAvlGroup group : report.getAvlGroupList()) {
                for (AbstractBeanReportAvlField fld : group.getFields()) {
                    if (!fld.isVisible()) continue;
                    avlField = fld;
                    continue block0;
                }
            }
            if (avlField != null) {
                this.addUsedField((IdHelper<BeanReportStdUsedField>)idHelper, fieldList, avlField);
            }
        }
    }

    private void checkUsedField(BeanReportCrossTable report) {
        List fieldList;
        IdHelper idHelper;
        TreeNode tnFieldList;
        AbstractBeanReportAvlField attrField1 = null;
        AbstractBeanReportAvlField attrField2 = null;
        AbstractBeanReportAvlField metrField1 = null;
        block0: for (BeanReportAvlGroup group : report.getAvlGroupList()) {
            for (AbstractBeanReportAvlField avlfield : group.getFields()) {
                if (!avlfield.isVisible()) continue;
                if (metrField1 == null && DataType.isNumeric((DataType)avlfield.getDataType())) {
                    metrField1 = avlfield;
                    continue;
                }
                if (attrField1 == null) {
                    attrField1 = avlfield;
                    continue;
                }
                if (attrField2 == null) {
                    attrField2 = avlfield;
                    continue;
                }
                if (metrField1 == null) continue;
                continue block0;
            }
        }
        if (attrField1 == null) {
            attrField1 = metrField1;
        }
        if (attrField1 != null && ((tnFieldList = report.getColFieldList()).getChildren() == null || tnFieldList.getChildren().isEmpty())) {
            if (tnFieldList.getChildren() == null) {
                tnFieldList.setChildren(new ArrayList());
            }
            idHelper = new IdHelper(tnFieldList);
            this.addUsedCTField((IdHelper<? extends BeanReportUsedField>)idHelper, (TreeNode<BeanReportCrossTableUsedField>)tnFieldList, attrField1);
        }
        if (attrField2 == null) {
            attrField2 = attrField1;
        }
        if (attrField2 != null && ((tnFieldList = report.getRowFieldList()).getChildren() == null || tnFieldList.getChildren().isEmpty())) {
            if (tnFieldList.getChildren() == null) {
                tnFieldList.setChildren(new ArrayList());
            }
            idHelper = new IdHelper(tnFieldList);
            this.addUsedCTField((IdHelper<? extends BeanReportUsedField>)idHelper, (TreeNode<BeanReportCrossTableUsedField>)tnFieldList, attrField1);
        }
        if (metrField1 == null) {
            metrField1 = attrField2;
        }
        if (metrField1 != null && (fieldList = report.getDataFieldList()).isEmpty()) {
            idHelper = new IdHelper(fieldList);
            this.addDataUsedField((IdHelper<BeanReportDataUsedField>)idHelper, fieldList, metrField1);
        }
    }

    private void addUsedCTField(IdHelper<? extends BeanReportUsedField> idHelper, TreeNode<BeanReportCrossTableUsedField> node, AbstractBeanReportAvlField avlField) {
        BeanReportCrossTableUsedField usedField = new BeanReportCrossTableUsedField();
        usedField.setField(avlField);
        usedField.setDescriptionKey(this.guidFactory.generateGUID((Object)usedField));
        usedField.getDescriptionMap().putAll(avlField.getDescriptionMap());
        usedField.setMode(BeanReportCrossTableUsedField.Mode.ALL_NON_EMPTY);
        usedField.setId(idHelper.getNextId());
        DefaultMutableTreeNode cn = new DefaultMutableTreeNode();
        cn.setUserObject((Object)usedField);
        ArrayList<DefaultMutableTreeNode> l = node.getChildren();
        if (l == null) {
            l = new ArrayList<DefaultMutableTreeNode>();
            node.setChildren(l);
        }
        l.add(cn);
        cn.setParent(node);
    }

    private BeanReportStdUsedField addUsedField(IdHelper<BeanReportStdUsedField> idHelper, List<BeanReportStdUsedField> fieldList, AbstractBeanReportAvlField avlField) {
        BeanReportStdUsedField usedField = new BeanReportStdUsedField();
        usedField.setField(avlField);
        usedField.setDescriptionKey(this.guidFactory.generateGUID((Object)usedField));
        usedField.getDescriptionMap().putAll(avlField.getDescriptionMap());
        usedField.setVisible(true);
        usedField.setEraseDoub(false);
        usedField.setAgregation(FieldAgregation.AGREGATION_NONE);
        usedField.setCalculation(FieldCalculation.CALCULATION_NONE);
        usedField.setId(idHelper.getNextId());
        fieldList.add(usedField);
        return usedField;
    }

    private BeanReportDataUsedField addDataUsedField(IdHelper<BeanReportDataUsedField> idHelper, List<BeanReportDataUsedField> fieldList, AbstractBeanReportAvlField avlField) {
        BeanReportDataUsedField usedField = new BeanReportDataUsedField();
        usedField.setField(avlField);
        usedField.setDescriptionKey(this.guidFactory.generateGUID((Object)usedField));
        usedField.getDescriptionMap().putAll(avlField.getDescriptionMap());
        usedField.setAgregation(FieldAgregation.AGREGATION_SUM);
        usedField.setId(idHelper.getNextId());
        fieldList.add(usedField);
        return usedField;
    }

    private void resetFilters(AbstractBeanReport report, IQueryDefinition query) {
        List list = query.getBeanQuerySQLFilterList();
        if (list != null) {
            this.resetFilters(report.getFilterList(), list);
        }
        if (query instanceof BeanQueryStar) {
            report.setTopExpression(null);
        }
    }

    private void resetFilters(List<AbstractBeanReportFilter> filterList, List<BeanQuerySQLFilter> queryFilterList) {
        filterList.clear();
        for (int i = 0; i < queryFilterList.size(); ++i) {
            BeanQuerySQLFilter queryFilter = queryFilterList.get(i);
            BeanReportFilter filter = new BeanReportFilter();
            filter.setName(queryFilter.getName());
            filter.setDescriptionKey(this.guidFactory.generateGUID((Object)filter));
            filter.getDescriptionMap().putAll(queryFilter.getDescriptionMap());
            filter.setDataType(queryFilter.getDataType());
            filter.setDefaultValue(queryFilter.getDefaultValue());
            filter.setParameter(queryFilter.getParameter());
            filter.setValueListOID(0);
            filter.setMode(queryFilter.getFltMode());
            filter.setOperand(queryFilter.getOperand());
            filterList.add((AbstractBeanReportFilter)filter);
        }
    }

    private int fillNameList(TreeNode<? extends ReportUniqueName> node, Set<String> nameSet, List<ReportUniqueName> toFix, int lastId) {
        int id = lastId;
        if (node != null) {
            if (node.getUserObject() != null) {
                id = this.fillNameList((ReportUniqueName)node.getUserObject(), nameSet, toFix, id);
            }
            if (node.getChildren() != null) {
                for (TreeNode c : node.getChildren()) {
                    id = this.fillNameList((TreeNode<? extends ReportUniqueName>)c, nameSet, toFix, id);
                }
            }
        }
        return id;
    }

    private int fillNameList(List<? extends ReportUniqueName> fieldList, Set<String> nameSet, List<ReportUniqueName> toFix, int lastId) {
        int id = lastId;
        for (ReportUniqueName reportUniqueName : fieldList) {
            id = this.fillNameList(reportUniqueName, nameSet, toFix, id);
        }
        return id;
    }

    private int fillNameList(ReportUniqueName usedField, Set<String> nameSet, List<ReportUniqueName> toFix, int lastId) {
        if (usedField.getName() == null || "".equals(usedField.getName().trim())) {
            toFix.add(usedField);
        } else {
            String name = usedField.getName().trim();
            usedField.setName(name);
            if (!nameSet.add(name)) {
                toFix.add(usedField);
            }
            if (name.startsWith("col")) {
                int colId = 0;
                try {
                    colId = Integer.parseInt(name.substring(3));
                    if (colId > lastId) {
                        return colId;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return lastId;
    }

    private void fixNameUnicity(List<ReportUniqueName> toFix, int lastId) {
        int id = lastId;
        Logger log = LogManager.getLogger(ReportHelper.class);
        for (ReportUniqueName usedField : toFix) {
            String newName = new StringBuffer().append("col").append(++id).toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer().append("Renaming ").append(usedField.getName()).append(" in ").append(newName).toString());
            }
            usedField.setName(newName);
        }
    }

    private boolean hasInteractifFilter(AbstractBeanReport bean) {
        List filterList = bean.getFilterList();
        for (AbstractBeanReportFilter filter : filterList) {
            if (filter.getParameter() != '2') continue;
            return true;
        }
        Expression expression = bean.getTopExpression();
        return this.hasInteractifFilter(expression);
    }

    private boolean hasInteractifFilter(Expression expression) {
        if (expression != null) {
            if (expression instanceof LogicalExpression) {
                LogicalExpression logical = (LogicalExpression)expression;
                for (Expression e : logical.getExpressionList()) {
                    if (!this.hasInteractifFilter(e)) continue;
                    return true;
                }
            } else if (expression instanceof OperandExpression) {
                OperandExpression operandExpression = (OperandExpression)expression;
                for (Operand operand : operandExpression.getOperands()) {
                    PromptOperand promptOperand;
                    if (!(operand instanceof PromptOperand) || !(promptOperand = (PromptOperand)operand).isVisible()) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void checkFilters(List<AbstractBeanReportFilter> reportFilterList, Locale locale) throws DashboardException {
        if (reportFilterList == null) {
            return;
        }
        for (AbstractBeanReportFilter filter : reportFilterList) {
            if (filter.getPromptType() != 2 && filter.getPromptType() != 3 || filter.getValueListOID() != 0) continue;
            throw ExceptionHelper.getInstance(locale).createDashboardException("missingValueList", new String[]{filter.getName()}, null);
        }
    }

    private void checkAvlField(List<BeanReportAvlGroup> groupList, Locale locale) throws DashboardException {
        if (groupList == null) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        for (BeanReportAvlGroup group : groupList) {
            for (AbstractBeanReportAvlField avlField : group.getFields()) {
                String name = avlField.getName();
                if (name == null) {
                    throw ExceptionHelper.getInstance(locale).createDashboardException("missingFieldName", null, null);
                }
                if (set.add(name)) continue;
                throw ExceptionHelper.getInstance(locale).createDashboardException("fieldNameUnicity", new String[]{name}, null);
            }
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanReport elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanReport.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.REPORT);
    }

    AbstractBeanReport getDefinition(int reportOID) throws DashboardException {
        AbstractBeanReport bean = (AbstractBeanReport)this.dao.getDefinition(reportOID);
        this.updateNames((BeanReport)bean);
        bean.setDisplayProperties(this.getDisplayProperties(bean.getDisplayProperties()));
        return bean;
    }

    public AbstractBeanReport getDefinition(String name) throws DashboardException {
        AbstractBeanReport bean = this.helper.get((Dao)this.dao, name, 2, AbstractBeanReport.class);
        this.updateNames((BeanReport)bean);
        bean.setDisplayProperties(this.getDisplayProperties(bean.getDisplayProperties()));
        return bean;
    }

    public BeanReport getCore(String name) throws DashboardException {
        BeanReport bean = this.helper.get((Dao)this.dao, name, 1, BeanReport.class);
        this.updateNames(bean);
        return bean;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbReportFilter filter = this.helper.getFilter(defaultFilter, data, DbReportFilter.class);
        if (defaultFilter instanceof ReportFilter) {
            ReportFilter src = (ReportFilter)defaultFilter;
            filter.setColorListOid(this.optOid(SessionParameterType.COLOR_LIST, src.getColorListName()));
            filter.setFieldGroupOid(this.optOid(SessionParameterType.FIELD_GROUP, src.getFieldGroupName()));
            filter.setPageLayoutOid(this.optOid(SessionParameterType.PAGE_LAYOUT, src.getPageLayoutName()));
            filter.setQueryOid(this.optOid(SessionParameterType.QUERY, src.getQueryName()));
            filter.setStrokeTypeOid(this.optOid(SessionParameterType.STROKE_TYPE, src.getStrokeTypeName()));
            filter.setStyleOid(this.optOid(SessionParameterType.STYLE, src.getStyleName()));
            filter.setReportType(src.getReportType());
            filter.setExecutionMode(src.getExecutionMode());
            filter.setColRowInv(src.getColRowInv());
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        if (instanceType != 1) {
            for (Element elt : eltList) {
                AbstractBeanReport bean = (AbstractBeanReport)elt;
                this.updateNames((BeanReport)bean);
                bean.setDisplayProperties(this.getDisplayProperties(bean.getDisplayProperties()));
            }
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbLinkFilter linkFilter = new DbLinkFilter();
        linkFilter.setReportOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)linkFilter, SessionParameterType.LINK));
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setTaskTypeSet(EnumSet.of(TaskType.TASK_TYPE_DOCUMENT_EXPORT, TaskType.TASK_TYPE_DOC_GENERATION));
        taskFilter.setReportOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)taskFilter, SessionParameterType.TASK));
        DbControlFilter controlFilter = new DbControlFilter();
        controlFilter.setReportOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)controlFilter, SessionParameterType.CONTROL));
        DbMetricFilter metricFilter = new DbMetricFilter();
        metricFilter.setReportOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)metricFilter, SessionParameterType.METRIC));
        DbDashboardFilter dashboardFilter = new DbDashboardFilter();
        dashboardFilter.setReportOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)dashboardFilter, SessionParameterType.DASHBOARD));
        return list;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbQueryFilter queryFilter = new DbQueryFilter();
        queryFilter.setUsedByReport(oid);
        QueryDao queryDao = this.daoFactory.getQueryDao();
        l.addAll(queryDao.listAll((DbDefaultFilter)queryFilter, 1));
        DbColorListFilter colorListFilter = new DbColorListFilter();
        colorListFilter.setUsedByReport(oid);
        ColorListDao colorListDao = this.daoFactory.getColorListDao();
        l.addAll(colorListDao.listAll((DbDefaultFilter)colorListFilter, 1));
        DbFieldGroupFilter fieldGroupFilter = new DbFieldGroupFilter();
        fieldGroupFilter.setUsedByReport(oid);
        FieldGroupDao fieldGroupDao = this.daoFactory.getFieldGroupDao();
        l.addAll(fieldGroupDao.listAll((DbDefaultFilter)fieldGroupFilter, 1));
        DbStyleFilter styleFilter = new DbStyleFilter();
        styleFilter.setUsedByReport(oid);
        StyleDao styleDao = this.daoFactory.getStyleDao();
        l.addAll(styleDao.listAll((DbDefaultFilter)styleFilter, 1));
        DbPersFieldFilter persFieldFilter = new DbPersFieldFilter();
        persFieldFilter.setUsedByReport(oid);
        PersFieldDao persFieldDao = this.daoFactory.getPersFieldDao();
        l.addAll(persFieldDao.listAll((DbDefaultFilter)persFieldFilter, 1));
        DbPageLayoutFilter pageLayoutFilter = new DbPageLayoutFilter();
        pageLayoutFilter.setUsedByReport(oid);
        PageLayoutDao pageLayoutDao = this.daoFactory.getPageLayoutDao();
        l.addAll(pageLayoutDao.listAll((DbDefaultFilter)pageLayoutFilter, 1));
        DbEntityFilter entityFilter = new DbEntityFilter();
        entityFilter.setUsedByReport(oid);
        EntityDao entityDao = this.daoFactory.getEntityDao();
        l.addAll(entityDao.listAll((DbDefaultFilter)entityFilter, 1));
        DbStrokeTypeFilter strokeTypeFilter = new DbStrokeTypeFilter();
        strokeTypeFilter.setUsedByReport(oid);
        StrokeTypeDao strokeTypeDao = this.daoFactory.getStrokeTypeDao();
        l.addAll(strokeTypeDao.listAll((DbDefaultFilter)strokeTypeFilter, 1));
        return l;
    }

    public static DataType getDatatype(BeanReportDataUsedField usedField) {
        return ReportHelper.getMergedDatatype((Agregation)usedField, usedField.getDataType());
    }

    private static DataType getMergedDatatype(Agregation usedField, DataType dt) {
        switch (usedField.getAgregation()) {
            case AGREGATION_COUNT: {
                return DataType.BIGINT;
            }
            case AGREGATION_MEDIAN: 
            case AGREGATION_VARIANCE: 
            case AGREGATION_STANDARD_DEVIATION: 
            case AGREGATION_AVERAGE: {
                return DataType.DOUBLE;
            }
        }
        return dt;
    }

    public static DataType getDatatype(BeanReportStdUsedField usedField) {
        switch (usedField.getCalculation()) {
            case CALCULATION_PERCENT_EVOL: 
            case CALCULATION_PERCENT_EVOL_PREV_COL: 
            case CALCULATION_PERCENT_TOTAL: 
            case CALCULATION_RATIO: {
                return DataType.DOUBLE;
            }
        }
        return ReportHelper.getMergedDatatype((Agregation)usedField, usedField.getDataType());
    }
}

