/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.ProfileRestriction;
import com.prelytis.dashboard.interfaces.SystemRestriction;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanExecutionContext;
import com.prelytis.dashboard.value.data.BeanSession;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserExecutionContext;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SecurityHelper {
    public static final int ACCESS_NONE = 0;
    public static final int ACCESS_READ_ONLY = 1;
    public static final int ACCESS_ALL = 2;
    private final EntityDao entityDao;
    private final Map<Integer, Map<Integer, EntityDao.Relation>> cache = new HashMap<Integer, Map<Integer, EntityDao.Relation>>();

    private SecurityHelper(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public static SecurityHelper getInstance(DaoFactory daoFactory) {
        return new SecurityHelper(daoFactory.getEntityDao());
    }

    public SecurityAdapter create(I18nElement elt, ExpressionEvaluationData data, int accessLevel) throws DashboardException {
        SystemRestriction sr;
        if (elt == null) {
            return null;
        }
        if (elt instanceof SecurityAdapter) {
            return (SecurityAdapter)elt;
        }
        SecurityAdapter sa = new SecurityAdapter(elt);
        if (data.getProfile() == 0 && accessLevel == 2) {
            accessLevel = 1;
        }
        switch (accessLevel) {
            default: {
                sa.setRead(false);
                sa.setUpdate(false);
                sa.setDelete(false);
                break;
            }
            case 1: {
                sa.setUpdate(false);
                sa.setDelete(false);
            }
            case 2: 
        }
        if (sa.isDelete() && elt instanceof SystemRestriction && (sr = (SystemRestriction)elt).getSystem()) {
            sa.setDelete(false);
        }
        if ((sa.isRead() || sa.isUpdate() || sa.isDelete()) && elt instanceof ProfileRestriction) {
            ProfileRestriction pr = (ProfileRestriction)elt;
            if (data.getProfile() < pr.getProfile()) {
                sa.setRead(false);
                sa.setUpdate(false);
                sa.setDelete(false);
            }
        }
        if (elt instanceof Bean) {
            EntityDao.Relation relation;
            if (elt instanceof OwnerEntity) {
                relation = this.getRelation(data.getEntityOid(), ((OwnerEntity)elt).getOwnerEntOID());
                this.update(relation, sa);
            } else if (elt instanceof BeanEntity && elt.getObjectID() != 0) {
                relation = this.getRelation(data.getEntityOid(), ((BeanEntity)elt).getObjectID());
                this.update(relation, sa);
            } else if (elt instanceof BeanExecutionContext) {
                relation = this.getRelation(data.getEntityOid(), ((BeanExecutionContext)elt).getEntityOid());
                this.update(relation, sa);
            } else if (elt instanceof BeanUser) {
                BeanUser def = (BeanUser)elt;
                List newList = def.getExecutionContextList();
                ArrayList oldList = new ArrayList(newList);
                newList.clear();
                for (BeanUserExecutionContext uec : oldList) {
                    EntityDao.Relation r = this.entityDao.getRelation(data.getEntityOid().intValue(), uec.getEntityOid());
                    switch (r) {
                        case CHILD: 
                        case SAME: {
                            newList.add(uec);
                            this.update(r, sa);
                        }
                    }
                }
                if (newList.isEmpty() && !oldList.isEmpty()) {
                    sa.setRead(false);
                    sa.setDelete(false);
                    sa.setUpdate(false);
                }
                if (elt.getObjectID() == data.getUserOid().intValue()) {
                    sa.setDelete(false);
                }
            }
        }
        if (elt instanceof BeanSession) {
            sa.setDelete(false);
        }
        return sa;
    }

    private void update(EntityDao.Relation relation, SecurityAdapter sa) {
        switch (relation) {
            case NONE: {
                sa.setDelete(false);
                sa.setRead(false);
                sa.setUpdate(false);
                break;
            }
            case PARENT: {
                sa.setUpdate(false);
                sa.setDelete(false);
            }
        }
    }

    public List<SecurityAdapter> create(List<? extends I18nElement> list, ExpressionEvaluationData data, int accessLevel) throws DashboardException {
        if (list == null) {
            return null;
        }
        ArrayList<SecurityAdapter> newList = new ArrayList<SecurityAdapter>();
        for (int i = list.size() - 1; i >= 0; --i) {
            I18nElement elt = list.get(i);
            SecurityAdapter sa = this.create(elt, data, accessLevel);
            if (!sa.isRead()) continue;
            newList.add(sa);
        }
        return newList;
    }

    public EntityDao.Relation getRelation(int e1, int e2) {
        Integer en1 = e1;
        Integer en2 = e2;
        Map<Integer, EntityDao.Relation> map = this.cache.get(en1);
        EntityDao.Relation relation = null;
        if (map == null) {
            map = new HashMap<Integer, EntityDao.Relation>();
            this.cache.put(en1, map);
        } else {
            relation = map.get(en2);
        }
        if (relation == null) {
            relation = this.entityDao.getRelation(e1, e2);
            map.put(en2, relation);
        }
        return relation;
    }
}

