/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.SqlFunctionGroupDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbSqlFunctionFilter;
import com.prelytis.dashboard.dao.filter.DbSqlFunctionGroupFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanSQLFunctionGroup;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class SqlFunctionGroupHelper
extends ParameterHelper
implements Dependency {
    private final SqlFunctionGroupDao dao;

    SqlFunctionGroupHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getSqlFunctionGroupDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanSQLFunctionGroup)value.getElement()), data);
            }
            case SAVE: {
                return this.getSave((BeanSQLFunctionGroup)value.getElement(), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanSQLFunctionGroup)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunctionGroup elt = this.helper.get((Dao)this.dao, name, 1, BeanSQLFunctionGroup.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.SQL_FUNCTION_GROUP);
    }

    public BeanSQLFunctionGroup create(ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunctionGroup elt = new BeanSQLFunctionGroup();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunctionGroup elt = this.helper.get((Dao)this.dao, name, instanceType, BeanSQLFunctionGroup.class);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_GROUP);
    }

    private ParameterResponse getSaveAsNew(BeanSQLFunctionGroup elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_GROUP);
    }

    private ParameterResponse getSave(BeanSQLFunctionGroup elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_GROUP);
    }

    public void save(BeanSQLFunctionGroup elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanSQLFunctionGroup elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanSQLFunctionGroup elt = (BeanSQLFunctionGroup)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION_GROUP);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.SQL_FUNCTION_GROUP).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.SQL_FUNCTION_GROUP);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.SQL_FUNCTION_GROUP, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunctionGroup elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanSQLFunctionGroup.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.SQL_FUNCTION_GROUP);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbSqlFunctionGroupFilter filter = this.helper.getFilter(defaultFilter, data, DbSqlFunctionGroupFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    public static SqlFunctionGroupHelper getInstance(DaoFactory daoFactory) {
        return new SqlFunctionGroupHelper(daoFactory);
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbSqlFunctionFilter sqlFunctionFilter = new DbSqlFunctionFilter();
        sqlFunctionFilter.setSqlFunctionGroupOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)sqlFunctionFilter, SessionParameterType.SQL_FUNCTION));
        return list;
    }

    public BeanSQLFunctionGroup getDefinition(String name) throws DashboardException {
        BeanSQLFunctionGroup bean = this.helper.get((Dao)this.dao, name, 2, BeanSQLFunctionGroup.class);
        return bean;
    }
}

