/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.SqlFunctionDao;
import com.prelytis.dashboard.dao.SqlFunctionGroupDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbJdbcDriverFilter;
import com.prelytis.dashboard.dao.filter.DbSqlFunctionFilter;
import com.prelytis.dashboard.dao.filter.DbSqlFunctionGroupFilter;
import com.prelytis.dashboard.dao.filter.DbSqlFunctionImplFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.References;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanSQLFunction;
import com.prelytis.dashboard.value.data.BeanSQLFunctionDefinition;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.SqlFunctionFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class SqlFunctionHelper
extends ParameterHelper
implements Dependency,
References {
    private final SqlFunctionDao dao;

    SqlFunctionHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getSqlFunctionDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanSQLFunction)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanSQLFunctionDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanSQLFunctionDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.SQL_FUNCTION);
    }

    public BeanSQLFunctionDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunctionDefinition elt = new BeanSQLFunctionDefinition();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateNames((BeanSQLFunction)elt);
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanSQLFunctionDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION);
    }

    private ParameterResponse getSave(BeanSQLFunctionDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION);
    }

    public void save(BeanSQLFunctionDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanSQLFunctionDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.updateOids((BeanSQLFunction)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunction elt = this.helper.get((Dao)this.dao, name, 1, BeanSQLFunction.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunction elt = this.helper.get((Dao)this.dao, name, instanceType, BeanSQLFunction.class);
        this.updateNames(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunctionDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanSQLFunctionDefinition.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        this.updateNames((BeanSQLFunction)elt);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_FUNCTION);
    }

    private void updateNames(BeanSQLFunction elt) throws DashboardException {
        elt.setSqlFunctionGroupName(this.getName(SessionParameterType.SQL_FUNCTION_GROUP, elt.getSQLFunctionGroupOID()));
    }

    private void updateOids(BeanSQLFunction elt) throws DashboardException {
        elt.setSQLFunctionGroupOID(this.getOid(SessionParameterType.SQL_FUNCTION_GROUP, elt.getSqlFunctionGroupName()));
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.SQL_FUNCTION).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.SQL_FUNCTION);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.SQL_FUNCTION, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLFunction elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanSQLFunction.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.SQL_FUNCTION);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbSqlFunctionFilter filter = this.helper.getFilter(defaultFilter, data, DbSqlFunctionFilter.class);
        if (defaultFilter instanceof SqlFunctionFilter) {
            SqlFunctionFilter src = (SqlFunctionFilter)defaultFilter;
            filter.setSqlFunctionGroupOid(this.optOid(SessionParameterType.SQL_FUNCTION_GROUP, src.getSqlFunctionGroupName()));
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            this.updateNames((BeanSQLFunction)elt);
        }
        return eltList;
    }

    public static SqlFunctionHelper getInstance(DaoFactory daoFactory) {
        return new SqlFunctionHelper(daoFactory);
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbJdbcDriverFilter jdbcDriverFilter = new DbJdbcDriverFilter();
        jdbcDriverFilter.setSqlFunctionOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)jdbcDriverFilter, SessionParameterType.JDBC_DRIVER));
        DbSqlFunctionImplFilter sqlFunctionImplFilter = new DbSqlFunctionImplFilter();
        sqlFunctionImplFilter.setSqlFunctionOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)sqlFunctionImplFilter, SessionParameterType.SQL_FUNCTION_IMPL));
        return list;
    }

    public BeanSQLFunctionDefinition getDefinition(String name) throws DashboardException {
        BeanSQLFunctionDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanSQLFunctionDefinition.class);
        this.updateNames((BeanSQLFunction)bean);
        return bean;
    }

    @Override
    public List<Element> getReferences(int objectID, ExpressionEvaluationData data) {
        ArrayList<Element> l = new ArrayList<Element>();
        Integer oid = objectID;
        DbSqlFunctionGroupFilter sqlFunctionGroupFilter = new DbSqlFunctionGroupFilter();
        sqlFunctionGroupFilter.setUsedBySqlFunction(oid);
        SqlFunctionGroupDao sqlFunctionGroupDao = this.daoFactory.getSqlFunctionGroupDao();
        l.addAll(sqlFunctionGroupDao.listAll((DbDefaultFilter)sqlFunctionGroupFilter, 1));
        return l;
    }
}

