/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.SqlStyleDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanSQLStyle;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Date;
import java.util.List;

public final class SqlStyleHelper
extends ParameterHelper {
    private final SqlStyleDao dao;

    SqlStyleHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getSqlStyleDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanSQLStyle)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanSQLStyle)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanSQLStyle)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.SQL_STYLE);
    }

    public BeanSQLStyle create(ExpressionEvaluationData data) throws DashboardException {
        BeanSQLStyle elt = new BeanSQLStyle();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse getSaveAsNew(BeanSQLStyle elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_STYLE);
    }

    private ParameterResponse getSave(BeanSQLStyle elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_STYLE);
    }

    public void save(BeanSQLStyle elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanSQLStyle elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLStyle elt = this.helper.get((Dao)this.dao, name, 1, BeanSQLStyle.class);
        if (elt.getObjectID() < 100) {
            throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("cannotDeleteSystemObject", null, null);
        }
        this.helper.checkForDelete(data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLStyle elt = this.helper.get((Dao)this.dao, name, instanceType, BeanSQLStyle.class);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_STYLE);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanSQLStyle elt = this.helper.get((Dao)this.dao, name, 2, BeanSQLStyle.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.SQL_STYLE);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.SQL_STYLE).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.SQL_STYLE);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.SQL_STYLE, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbDefaultFilter filter = this.helper.getFilter(defaultFilter, data, DbDefaultFilter.class);
        List eltList = this.dao.listAll(filter, instanceType, sort, maxSize);
        return eltList;
    }

    public static SqlStyleHelper getInstance(DaoFactory daoFactory) {
        return new SqlStyleHelper(daoFactory);
    }

    public BeanSQLStyle getDefinition(String name) throws DashboardException {
        BeanSQLStyle bean = this.helper.get((Dao)this.dao, name, 2, BeanSQLStyle.class);
        return bean;
    }
}

