/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.TaskGroupDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbTaskFilter;
import com.prelytis.dashboard.dao.filter.DbTaskGroupFilter;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanTaskGroup;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.TaskGroupFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class TaskGroupHelper
extends ParameterHelper
implements Dependency {
    private final TaskGroupDao dao;

    TaskGroupHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getTaskGroupDao();
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        Integer instanceType = value.getInstanceType();
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(instanceType, value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanTaskGroup)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanTaskGroup)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanTaskGroup)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTaskGroup elt = this.helper.get((Dao)this.dao, name, 1, BeanTaskGroup.class);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.TASK_GROUP);
    }

    public BeanTaskGroup create(ExpressionEvaluationData data) throws DashboardException {
        BeanTaskGroup elt = new BeanTaskGroup();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return elt;
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTaskGroup elt = this.helper.get((Dao)this.dao, name, instanceType, BeanTaskGroup.class);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK_GROUP);
    }

    private ParameterResponse getSaveAsNew(BeanTaskGroup elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK_GROUP);
    }

    private ParameterResponse getSave(BeanTaskGroup elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK_GROUP);
    }

    public void save(BeanTaskGroup elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanTaskGroup elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        if (name == null) {
            throw new DashboardException();
        }
        BeanTaskGroup elt = (BeanTaskGroup)this.dao.getDefinition(name);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.TASK_GROUP);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.TASK_GROUP).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.TASK_GROUP);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.TASK_GROUP, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanTaskGroup elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanTaskGroup.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.TASK_GROUP);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        DbTaskGroupFilter filter = this.helper.getFilter(defaultFilter, data, DbTaskGroupFilter.class);
        if (defaultFilter instanceof TaskGroupFilter) {
            TaskGroupFilter src = (TaskGroupFilter)defaultFilter;
            filter.setActive(src.getActive());
        }
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbTaskFilter taskFilter = new DbTaskFilter();
        taskFilter.setTaskGrpOid(new Integer[]{objectID});
        list.add(new DependencyDefinition((DbDefaultFilter)taskFilter, SessionParameterType.TASK));
        return list;
    }

    public static TaskGroupHelper getInstance(DaoFactory daoFactory) {
        return new TaskGroupHelper(daoFactory);
    }

    public BeanTaskGroup getDefinition(String name) throws DashboardException {
        BeanTaskGroup bean = this.helper.get((Dao)this.dao, name, 2, BeanTaskGroup.class);
        return bean;
    }
}

