/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.Dao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.DefaultImageDao;
import com.prelytis.dashboard.dao.ThemeDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbThemeFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.Dependency;
import com.prelytis.dashboard.model.helper.DependencyDefinition;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.DependencyGroup;
import com.prelytis.dashboard.value.DependencyRequest;
import com.prelytis.dashboard.value.DependencyResponse;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanTheme;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.OwnerEntity;
import com.prelytis.dashboard.value.data.ThemeImage;
import com.prelytis.dashboard.value.data.ThemeImageBundle;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public final class ThemeHelper
extends ParameterHelper
implements Dependency {
    private final EntityHelper entityHelper;
    private final ThemeDao dao;

    ThemeHelper(DaoFactory daoFactory) {
        super(daoFactory);
        this.dao = this.daoFactory.getThemeDao();
        this.entityHelper = new EntityHelper(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        ParameterRequest.Action action = value.getAction() == null ? ParameterRequest.Action.OPEN : value.getAction();
        switch (action) {
            case OPEN: 
            case OPEN_AS_SUPER_USER: {
                return this.get(value.getInstanceType(), value.getName(), data);
            }
            case COPY: {
                return this.getCopy(value.getName(), data);
            }
            case DELETE: {
                return this.getDelete(value.getName(), (Bean)((BeanTheme)value.getElement()), data);
            }
            case SAVE_AS_NEW: {
                return this.getSaveAsNew((BeanThemeDefinition)value.getElement(), data);
            }
            case SAVE: {
                return this.getSave((BeanThemeDefinition)value.getElement(), data);
            }
            case NEW: {
                return this.getNew(data);
            }
        }
        throw new DashboardException();
    }

    private ParameterResponse getNew(ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getResponse((I18nElement)this.create(data), data, SessionParameterType.THEME);
    }

    public BeanThemeDefinition create(ExpressionEvaluationData data) throws DashboardException {
        BeanThemeDefinition elt = new BeanThemeDefinition();
        this.helper.updateDescKey((Bean)elt, false);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        DefaultImageDao defaultImageDao = this.daoFactory.getDefaultImageDao();
        elt.getImageList().addAll(defaultImageDao.getImageList());
        this.copy(defaultImageDao.getLogo(), elt.getLogo());
        return elt;
    }

    private void copy(ThemeImageBundle src, ThemeImageBundle dst) {
        dst.setName(src.getName());
        dst.setWidth(src.getWidth());
        dst.setHeight(src.getHeight());
        dst.setLowDpiImage(this.getCopy(src.getLowDpiImage()));
        dst.setHighDpiImage(this.getCopy(src.getHighDpiImage()));
        dst.setVectorImage(this.getCopy(src.getVectorImage()));
    }

    private ThemeImage getCopy(ThemeImage src) {
        if (src == null) {
            return null;
        }
        ThemeImage dst = new ThemeImage();
        dst.setData(src.getData());
        dst.setHeight(src.getHeight());
        dst.setWidth(src.getWidth());
        dst.setImageType(src.getImageType());
        return dst;
    }

    private ParameterResponse getSaveAsNew(BeanThemeDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, true);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.THEME);
    }

    private ParameterResponse getSave(BeanThemeDefinition elt, ExpressionEvaluationData data) throws DashboardException {
        this.save(elt, data, false);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.THEME);
    }

    public void save(BeanThemeDefinition elt, ExpressionEvaluationData data, boolean isNew) throws DashboardException {
        this.save(elt, data, isNew, false);
    }

    public void save(BeanThemeDefinition elt, ExpressionEvaluationData data, boolean isNew, boolean isImport) throws DashboardException {
        this.helper.checkDescriptionMap(elt.getDescriptionMap(), data.getLocale());
        this.helper.checkForSave((Dao)this.dao, data, (Bean)elt, isNew, isImport);
        this.updateOids((BeanTheme)elt);
        this.helper.updateDescKey((Bean)elt, false);
        this.helper.updateDescriptionMap((Bean)elt, data.getLocale());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.checkColor(elt.getButtonColor());
        this.checkColor(elt.getCurrentNavigationBackgroundColor());
        this.checkColor(elt.getMainColor());
        this.checkColor(elt.getOddRowBackgroundColor());
        this.checkColor(elt.getTableHeaderBackgroundColor());
        this.checkColor(elt.getTitleColor());
        this.checkColor(elt.getMainBackgroundColor());
        this.checkColor(elt.getActiveMenuItemBackgroundColor());
        this.checkColor(elt.getCurrentNavigationColor());
        HashSet<String> set = new HashSet<String>();
        if (elt.getImageList().isEmpty()) {
            DefaultImageDao defaultImageDao = this.daoFactory.getDefaultImageDao();
            elt.getImageList().addAll(defaultImageDao.getImageList());
        }
        for (ThemeImageBundle bundle : elt.getImageList()) {
            if (bundle.getName() == null || bundle.getName().isEmpty()) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("missingName", null, null);
            }
            if (!set.add(bundle.getName().toLowerCase())) {
                throw ExceptionHelper.getInstance(data.getLocale()).createDashboardException("unicityName", null, null);
            }
            this.helper.checkName(data.getLocale(), bundle.getName());
            this.updateSize(bundle.getLowDpiImage(), bundle.getWidth(), bundle.getHeight());
            this.updateSize(bundle.getHighDpiImage(), 2 * bundle.getWidth(), 2 * bundle.getHeight());
            this.updateSize(bundle.getVectorImage(), 2 * bundle.getWidth(), 2 * bundle.getHeight());
        }
        ThemeImageBundle bundle = elt.getLogo();
        bundle.setName("logo");
        this.updateSize(bundle.getLowDpiImage(), bundle.getWidth(), bundle.getHeight());
        this.updateSize(bundle.getHighDpiImage(), 2 * bundle.getWidth(), 2 * bundle.getHeight());
        this.updateSize(bundle.getVectorImage(), 2 * bundle.getWidth(), 2 * bundle.getHeight());
        this.helper.checkForSave(data, (Element)elt);
        this.dao.save((Element)elt);
    }

    private void updateSize(ThemeImage image, int width, int height) {
        if (image != null) {
            image.setWidth(width);
            image.setHeight(height);
        }
    }

    private void checkColor(String color) throws DashboardException {
        if (color == null || color.isEmpty()) {
            return;
        }
        try {
            new Color(Integer.parseInt(color, 16));
        }
        catch (NumberFormatException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTheme elt = this.helper.get((Dao)this.dao, name, 1, BeanTheme.class);
        this.helper.checkOwnerEntity(this.entityHelper, data, (OwnerEntity)elt);
        this.helper.checkForDelete(this.getDependencyDefinitionList((Bean)elt), data, (Element)elt);
        this.dao.delete((Element)elt);
    }

    private ParameterResponse get(Integer instanceType, String name, ExpressionEvaluationData data) throws DashboardException {
        BeanTheme elt = this.helper.get((Dao)this.dao, name, instanceType, BeanTheme.class);
        this.updateNames(elt);
        this.check(elt);
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.THEME);
    }

    private void check(BeanTheme elt) {
        if (elt instanceof BeanThemeDefinition) {
            DefaultImageDao defaultImageDao;
            BeanThemeDefinition bean = (BeanThemeDefinition)elt;
            ThemeImageBundle logo = bean.getLogo();
            logo.setName("logo");
            if (logo.getLowDpiImage() == null) {
                defaultImageDao = this.daoFactory.getDefaultImageDao();
                this.copy(defaultImageDao.getLogo(), logo);
            }
            if (bean.getImageList().isEmpty()) {
                defaultImageDao = this.daoFactory.getDefaultImageDao();
                bean.getImageList().addAll(defaultImageDao.getImageList());
            }
        }
    }

    private void updateNames(BeanTheme bean) throws DashboardException {
        bean.setOwnerEntityName(this.getName(SessionParameterType.ENTITY, bean.getOwnerEntOID()));
    }

    private void updateOids(BeanTheme bean) throws DashboardException {
        bean.setOwnerEntOID(this.getOid(SessionParameterType.ENTITY, bean.getOwnerEntityName()));
    }

    private ParameterResponse getCopy(String name, ExpressionEvaluationData data) throws DashboardException {
        BeanThemeDefinition elt = this.helper.get((Dao)this.dao, name, 2, BeanThemeDefinition.class);
        this.helper.updateForCopy((Bean)elt);
        this.helper.updateDescKey((Bean)elt, true);
        elt.setOwnerEntOID(data.getEntityOid().intValue());
        elt.setOwnerEntityName(data.getEntityName());
        elt.setCreationDate(new Date());
        elt.setOwner(data.getUserName());
        elt.setLastModificationDate(new Date());
        elt.setLastModifier(data.getUserName());
        return this.helper.getResponse((I18nElement)elt, data, SessionParameterType.THEME);
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        try {
            int accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), SessionParameterType.THEME).getAccessLevel();
            if (accessLevel == 0) {
                boolean limitedAccess = workspaceDao.getLimitedAccessForUser(data.getUserOid().intValue(), data.getExecutionContextOid().intValue(), SessionParameterType.THEME);
                if (!limitedAccess) {
                    throw new SecurityException();
                }
                accessLevel = 1;
            }
            int instanceType = value.getBeanType() == null ? 1 : value.getBeanType();
            List<Element> eltList = this.list(value.getFilter(), instanceType, value.getSortedField(), value.getMaxSize(), data);
            return this.helper.list(eltList, value.getMaxSize(), false, SessionParameterType.THEME, accessLevel, data);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public DependencyResponse getResponse(DependencyRequest value, ExpressionEvaluationData data) throws DashboardException {
        BeanTheme elt = this.helper.get((Dao)this.dao, value.getName(), 1, BeanTheme.class);
        List<DependencyGroup> dependencies = this.getDependencies((Bean)elt, data);
        return this.helper.getResponse((Bean)elt, dependencies, data, SessionParameterType.THEME);
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) throws DashboardException {
        DbThemeFilter filter = this.helper.getFilter(defaultFilter, data, DbThemeFilter.class);
        List eltList = this.dao.listAll((DbDefaultFilter)filter, instanceType, sort, maxSize);
        for (Element elt : eltList) {
            BeanTheme bean = (BeanTheme)elt;
            this.updateNames(bean);
            this.check(bean);
        }
        return eltList;
    }

    @Override
    public List<DependencyGroup> getDependencies(Bean elt, ExpressionEvaluationData data) throws DashboardException {
        return this.helper.getDependencies(this.getDependencyDefinitionList(elt), data);
    }

    private List<DependencyDefinition> getDependencyDefinitionList(Bean elt) {
        Integer objectID = elt.getObjectID();
        ArrayList<DependencyDefinition> list = new ArrayList<DependencyDefinition>();
        DbUserFilter userFilter = new DbUserFilter();
        userFilter.setThemeOid(objectID);
        list.add(new DependencyDefinition((DbDefaultFilter)userFilter, SessionParameterType.USER));
        return list;
    }

    public static ThemeHelper getInstance(DaoFactory daoFactory) {
        return new ThemeHelper(daoFactory);
    }

    public BeanThemeDefinition getDefinition(String name) throws DashboardException {
        BeanThemeDefinition bean = this.helper.get((Dao)this.dao, name, 2, BeanThemeDefinition.class);
        this.updateNames((BeanTheme)bean);
        return bean;
    }
}

