/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.helper;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.helper.ConnectionInformationHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.util.sql.ConnectionInformation;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.ParameterResponse;
import com.prelytis.dashboard.value.ParametersListRequest;
import com.prelytis.dashboard.value.ParametersListResponse;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.BeanUserExecutionContext;
import com.prelytis.dashboard.value.data.BeanWorkspace;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import com.prelytis.dashboard.value.data.UserManagement;
import com.prelytis.dashboard.value.data.UserManagementEntity;
import com.prelytis.dashboard.value.data.UserManagementUser;
import com.prelytis.dashboard.value.data.UserManagementWorkspace;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.EntityFilter;
import com.prelytis.dashboard.value.data.filter.UserFilter;
import com.prelytis.dashboard.value.data.filter.WorkspaceFilter;
import com.prelytis.dashboard.value.tree.DefaultMutableTreeNode;
import com.prelytis.dashboard.value.tree.TreeNode;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class UserManagementHelper
extends ParameterHelper {
    UserManagementHelper(DaoFactory daoFactory) {
        super(daoFactory);
    }

    @Override
    public ParameterResponse getResponse(ParameterRequest value, ExpressionEvaluationData data) throws DashboardException {
        boolean allUsers = value.getAction() == null ? false : value.getAction().equals((Object)ParameterRequest.Action.ALL_USERS);
        ParameterResponse response = new ParameterResponse();
        SecurityAdapter sa = this.getUserList(allUsers, data);
        response.setElement(sa);
        return response;
    }

    @Override
    public ParametersListResponse getResponse(ParametersListRequest value, ExpressionEvaluationData data) throws DashboardException {
        return null;
    }

    @Override
    public List<Element> list(DefaultFilter defaultFilter, int instanceType, ParametersListRequest.SortedField sort, Integer maxSize, ExpressionEvaluationData data) {
        return null;
    }

    private boolean isAccessible(WorkspaceDao.SessionAccessLevel sessionAccessLevel) {
        return this.getAccessLevel(sessionAccessLevel) != 0;
    }

    private int getAccessLevel(WorkspaceDao.SessionAccessLevel sessionAccessLevel) {
        return sessionAccessLevel == null ? 0 : sessionAccessLevel.getAccessLevel();
    }

    private TreeNode<Object> getWorkspaceNode(String entityName, String workspaceName, Map<String, BeanEntity> entityCache, Map<String, BeanWorkspace> workspaceCache, Map<String, TreeNode<Object>> entityTreeMap, Map<String, Map<String, TreeNode<Object>>> entityWorkspaceMap, Locale locale) {
        TreeNode<Object> entityNode = this.getNode(entityCache, entityTreeMap, entityName, locale, new HashSet<String>());
        if (entityNode != null) {
            BeanWorkspace w;
            DefaultMutableTreeNode workspaceNode;
            Map<String, TreeNode<Object>> workspaceTreeMap = entityWorkspaceMap.get(entityName);
            if (workspaceTreeMap == null) {
                workspaceTreeMap = new HashMap<String, TreeNode<Object>>();
                entityWorkspaceMap.put(entityName, workspaceTreeMap);
            }
            if ((workspaceNode = workspaceTreeMap.get(workspaceName)) == null && (w = workspaceCache.get(workspaceName)) != null) {
                workspaceNode = new DefaultMutableTreeNode();
                UserManagementWorkspace workspace = new UserManagementWorkspace();
                workspace.setWorkspaceName(workspaceName);
                workspace.setDescription((String)w.getDescriptionMap().get(locale));
                workspaceNode.setUserObject((Object)workspace);
                this.addNode(entityNode, (TreeNode<Object>)workspaceNode, false);
                workspaceTreeMap.put(workspaceName, (TreeNode<Object>)workspaceNode);
            }
            return workspaceNode;
        }
        return null;
    }

    private TreeNode<Object> getNode(Map<String, BeanEntity> entityMap, Map<String, TreeNode<Object>> entityTreeMap, String entityName, Locale locale, Set<String> loopCheck) {
        DefaultMutableTreeNode entityNode = entityTreeMap.get(entityName);
        if (entityNode == null) {
            BeanEntity e = entityMap.get(entityName);
            if (e == null) {
                return null;
            }
            UserManagementEntity entity = new UserManagementEntity();
            entity.setEntityName(entityName);
            entity.setDescription((String)e.getDescriptionMap().get(locale));
            entityNode = new DefaultMutableTreeNode();
            entityNode.setUserObject((Object)entity);
            entityTreeMap.put(entityName, (TreeNode<Object>)entityNode);
            if (!loopCheck.add(entityName)) {
                return null;
            }
            String parentEntityName = e.getParentEntityName();
            if (parentEntityName != null && !parentEntityName.equals(entityName)) {
                TreeNode<Object> parentNode = this.getNode(entityMap, entityTreeMap, parentEntityName, locale, loopCheck);
                this.addNode(parentNode, (TreeNode<Object>)entityNode, true);
            } else {
                entityTreeMap.put("", (TreeNode<Object>)entityNode);
            }
        }
        return entityNode;
    }

    private void addNode(TreeNode<Object> parent, TreeNode<Object> node, boolean beginning) {
        if (parent.getChildren() == null) {
            parent.setChildren(new ArrayList());
        }
        if (beginning) {
            parent.getChildren().add(0, node);
        } else {
            parent.getChildren().add(node);
        }
        node.setParent(parent);
    }

    private SecurityAdapter getUserList(boolean allUsers, ExpressionEvaluationData data) throws DashboardException {
        HashMap<String, BeanEntity> entityCache = new HashMap<String, BeanEntity>();
        EntityHelper entityHelper = EntityHelper.getInstance(this.daoFactory);
        EntityFilter entityFilter = new EntityFilter();
        entityFilter.setOwnerEntityName(data.getEntityName());
        entityFilter.setSelectForDisplayType(5);
        List<Element> entityList = entityHelper.list((DefaultFilter)entityFilter, 1, null, null, data);
        for (Element elt : entityList) {
            entityCache.put(elt.getName(), (BeanEntity)elt);
        }
        HashMap<String, BeanWorkspace> workspaceCache = new HashMap<String, BeanWorkspace>();
        WorkspaceHelper workspaceHelper = WorkspaceHelper.getInstance(this.daoFactory);
        WorkspaceFilter workspaceFilter = new WorkspaceFilter();
        workspaceFilter.setOwnerEntityName(data.getEntityName());
        workspaceFilter.setSelectForDisplayType(5);
        List<Element> workspaceList = workspaceHelper.list((DefaultFilter)workspaceFilter, 1, null, null, data);
        for (Element elt : workspaceList) {
            workspaceCache.put(elt.getName(), (BeanWorkspace)elt);
        }
        HashMap<String, TreeNode<Object>> entityTreeMap = new HashMap<String, TreeNode<Object>>();
        HashMap<String, Map<String, TreeNode<Object>>> entityWorkspaceMap = new HashMap<String, Map<String, TreeNode<Object>>>();
        ConnectionInformationHelper connectionInformationHelper = ConnectionInformationHelper.getInstance(this.daoFactory);
        List<ConnectionInformation> userList = connectionInformationHelper.getConnectedUsers();
        HashMap<String, BeanUserDefinition> userCache = new HashMap<String, BeanUserDefinition>();
        UserHelper userHelper = UserHelper.getInstance(this.daoFactory);
        UserFilter userFilter = new UserFilter();
        userFilter.setActive(Boolean.TRUE);
        List<Element> ul = userHelper.list((DefaultFilter)userFilter, 2, null, null, data);
        for (Element u : ul) {
            userCache.put(u.getName(), (BeanUserDefinition)u);
        }
        for (ConnectionInformation ci : userList) {
            TreeNode<Object> workspaceNode = this.getWorkspaceNode(ci.getEntityName(), ci.getWorkspaceName(), entityCache, workspaceCache, entityTreeMap, entityWorkspaceMap, data.getLocale());
            BeanUser user = (BeanUser)userCache.remove(ci.getUserName());
            if (workspaceNode == null || user == null) continue;
            UserManagementUser connection = new UserManagementUser();
            connection.setDescription((String)user.getDescriptionMap().get(data.getLocale()));
            connection.setUserName(ci.getUserName());
            connection.setConnectionDate(ci.getConnectionDate());
            connection.setIpAddress(ci.getIpAddress());
            connection.setIpForwardedAddress(ci.getIpAddressForwarded());
            connection.setSessionId(ci.getSessionGUID());
            DefaultMutableTreeNode connectionNode = new DefaultMutableTreeNode();
            connectionNode.setUserObject((Object)connection);
            this.addNode(workspaceNode, (TreeNode<Object>)connectionNode, false);
        }
        if (allUsers) {
            for (BeanUser user : userCache.values()) {
                BeanUserExecutionContext uec;
                TreeNode<Object> workspaceNode;
                List list = user.getExecutionContextList();
                if (list.isEmpty() || (workspaceNode = this.getWorkspaceNode((uec = (BeanUserExecutionContext)list.get(0)).getEntityName(), uec.getWorkspaceName(), entityCache, workspaceCache, entityTreeMap, entityWorkspaceMap, data.getLocale())) == null) continue;
                UserManagementUser connection = new UserManagementUser();
                connection.setDescription((String)user.getDescriptionMap().get(data.getLocale()));
                connection.setUserName(user.getName());
                DefaultMutableTreeNode connectionNode = new DefaultMutableTreeNode();
                connectionNode.setUserObject((Object)connection);
                this.addNode(workspaceNode, (TreeNode<Object>)connectionNode, false);
            }
        }
        UserManagement user = new UserManagement();
        TreeNode topNode = (TreeNode)entityTreeMap.get("");
        user.setUsers(topNode);
        WorkspaceDao workspaceDao = this.daoFactory.getWorkspaceDao();
        int execCtxOid = data.getExecutionContextOid();
        user.setEntityAccess(this.isAccessible(workspaceDao.getAccessLevelForEC(execCtxOid, SessionParameterType.ENTITY)));
        user.setUserAccess(this.isAccessible(workspaceDao.getAccessLevelForEC(execCtxOid, SessionParameterType.USER)));
        user.setWorkspaceAccess(this.isAccessible(workspaceDao.getAccessLevelForEC(execCtxOid, SessionParameterType.WORKSPACE)));
        SecurityAdapter sa = new SecurityAdapter((I18nElement)user);
        sa.setUpdate(2 == this.getAccessLevel(workspaceDao.getAccessLevelForEC(execCtxOid, 42)));
        return sa;
    }

    @Override
    public void delete(String name, ExpressionEvaluationData data) throws DashboardException {
        throw new SecurityException();
    }

    @Override
    public Bean create(ExpressionEvaluationData data) throws DashboardException {
        throw new SecurityException();
    }
}

