/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.reader;

import com.prelytis.dashboard.persistence.MonitorableDataSource;
import com.prelytis.dashboard.value.util.IDBInfo;
import com.prelytis.dashboard.value.util.IPoolDBInfo;
import com.prelytis.dashboard.xml.stax.XMLEventProducer;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.XMLEventConsumer;

public class DataSourceEventProducer
implements XMLEventProducer {
    private static final String DATASOURCES_TAG = "datasources";
    private static final String DATASOURCE_TAG = "datasource";
    private static final String URL_TAG = "url";
    private static final String USER_TAG = "user";
    private static final String NAME_TAG = "name";
    private static final String VALUE_TAG = "value";
    private static final String PROPERTIES_TAG = "properties";
    private static final String PROPERTY_TAG = "property";
    private static final String NUM_ACTIVE_TAG = "numactive";
    private static final String NUM_IDLE_TAG = "numidle";
    private static final String POOL_TAG = "pool";
    private static final String MAX_ACTIVE_TAG = "maxactive";
    private static final String MAX_IDLE_TAG = "maxidle";
    private static final String MIN_IDLE_TAG = "minidle";
    private static final String VALIDATION_QUERY_TAG = "validationquery";
    private static final String MAX_WAIT_TAG = "maxwait";
    private static final String MIN_EVICTABLE_IDLE_TIME_TAG = "minevictableidletime";
    private static final String TIME_BETWEEN_EVICTION_RUNS_TAG = "timebetweenevictionruns";
    private final Iterator<MonitorableDataSource> datasources;
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private int pos;
    private final String prefix = "";
    private final String namespaceUri = "";

    public DataSourceEventProducer(Iterator<MonitorableDataSource> datasources) {
        this.datasources = datasources;
    }

    public void produce(XMLEventWriter writer) throws XMLStreamException {
        switch (this.pos) {
            case 0: {
                writer.add(this.eventFactory.createStartDocument("UTF-8", "1.0"));
                this.getClass();
                this.getClass();
                writer.add(this.eventFactory.createStartElement("", "", DATASOURCES_TAG));
                ++this.pos;
                break;
            }
            case 1: {
                if (this.datasources.hasNext()) {
                    MonitorableDataSource ds = this.datasources.next();
                    IPoolDBInfo poolDBInfo = ds.getPoolDBInfo();
                    IDBInfo dbInfo = poolDBInfo.getDBInfo();
                    this.getClass();
                    this.getClass();
                    writer.add(this.eventFactory.createStartElement("", "", DATASOURCE_TAG));
                    this.add((XMLEventConsumer)writer, URL_TAG, dbInfo.getUrl());
                    this.add((XMLEventConsumer)writer, USER_TAG, dbInfo.getUser());
                    this.getClass();
                    this.getClass();
                    writer.add(this.eventFactory.createStartElement("", "", PROPERTIES_TAG));
                    for (Map.Entry<Object, Object> entry : dbInfo.getProperties().entrySet()) {
                        this.getClass();
                        this.getClass();
                        writer.add(this.eventFactory.createStartElement("", "", PROPERTY_TAG));
                        this.add((XMLEventConsumer)writer, NAME_TAG, entry.getKey().toString());
                        this.add((XMLEventConsumer)writer, VALUE_TAG, entry.getValue() == null ? "" : entry.getValue().toString());
                        this.getClass();
                        this.getClass();
                        writer.add(this.eventFactory.createEndElement("", "", PROPERTY_TAG));
                    }
                    this.getClass();
                    this.getClass();
                    writer.add(this.eventFactory.createEndElement("", "", PROPERTIES_TAG));
                    if (poolDBInfo.getType() == IPoolDBInfo.Type.POOL) {
                        this.getClass();
                        this.getClass();
                        writer.add(this.eventFactory.createStartElement("", "", POOL_TAG));
                        this.add((XMLEventConsumer)writer, MAX_ACTIVE_TAG, poolDBInfo.getMaxActive());
                        this.add((XMLEventConsumer)writer, MAX_IDLE_TAG, poolDBInfo.getMaxIdle());
                        this.add((XMLEventConsumer)writer, MIN_IDLE_TAG, poolDBInfo.getMinIdle());
                        this.add((XMLEventConsumer)writer, VALIDATION_QUERY_TAG, poolDBInfo.getValidationQuery());
                        this.add((XMLEventConsumer)writer, MAX_WAIT_TAG, poolDBInfo.getMaxWait());
                        this.add((XMLEventConsumer)writer, MIN_EVICTABLE_IDLE_TIME_TAG, poolDBInfo.getMinEvictableIdleTimeMillis());
                        this.add((XMLEventConsumer)writer, TIME_BETWEEN_EVICTION_RUNS_TAG, poolDBInfo.getTimeBetweenEvictionRunsMillis());
                        this.add((XMLEventConsumer)writer, NUM_ACTIVE_TAG, ds.getNumActive());
                        this.add((XMLEventConsumer)writer, NUM_IDLE_TAG, ds.getNumIdle());
                        this.getClass();
                        this.getClass();
                        writer.add(this.eventFactory.createEndElement("", "", POOL_TAG));
                    }
                    this.getClass();
                    this.getClass();
                    writer.add(this.eventFactory.createEndElement("", "", DATASOURCE_TAG));
                    break;
                }
                this.getClass();
                this.getClass();
                writer.add(this.eventFactory.createEndElement("", "", DATASOURCES_TAG));
                writer.add(this.eventFactory.createEndDocument());
                ++this.pos;
            }
        }
    }

    private void add(XMLEventConsumer writer, String localName, long value) throws XMLStreamException {
        this.add(writer, localName, String.valueOf(value));
    }

    private void add(XMLEventConsumer writer, String localName, int value) throws XMLStreamException {
        this.add(writer, localName, String.valueOf(value));
    }

    private void add(XMLEventConsumer writer, String localName, String value) throws XMLStreamException {
        writer.add(this.eventFactory.createStartElement(value, value, localName));
        if (value != null) {
            writer.add(this.eventFactory.createCData(value));
        }
        writer.add(this.eventFactory.createEndElement(value, value, localName));
    }

    public boolean hasMore() {
        return this.pos != 2;
    }
}

