/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.model.reader;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.xml.stax.XMLEventProducer;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class XmlResponseEventProducer
implements XMLEventProducer {
    private final String prefix = "r";
    private final String namespaceUri = "http://www.prelytis.com/schemas/livedashboard/4.8/ws.xsd";
    private static final String RESPONSE_TAG = "response";
    private static final String ERROR_CODE_TAG = "errorCode";
    private static final String MESSAGE_TAG = "message";
    private static final String USER_SESSION_GUID_TAG = "userSessionGuid";
    private static final String HREF_TAG = "href";
    private static final String EXECUTION_CONTEXT_TAG = "executionContext";
    private final DashboardException de;
    private final String userSessionGuid;
    private final String href;
    private final String executionContext;
    private boolean more = true;
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();

    public XmlResponseEventProducer(DashboardException de) {
        this.de = de;
        this.userSessionGuid = null;
        this.executionContext = null;
        this.href = null;
    }

    public XmlResponseEventProducer(String userSessionGuid, String executionContext, String href) {
        this.de = null;
        this.userSessionGuid = userSessionGuid;
        this.executionContext = executionContext;
        this.href = href;
    }

    public void produce(XMLEventWriter writer) throws XMLStreamException {
        writer.add(this.eventFactory.createStartDocument("UTF-8", "1.0"));
        writer.add(this.eventFactory.createStartElement(this.prefix, this.namespaceUri, RESPONSE_TAG));
        writer.add(this.eventFactory.createNamespace(this.prefix, this.namespaceUri));
        if (this.de != null) {
            writer.add(this.eventFactory.createStartElement(this.prefix, this.namespaceUri, ERROR_CODE_TAG));
            if (this.de.getCode() != null) {
                writer.add(this.eventFactory.createCharacters(this.de.getCode().toString()));
            }
            writer.add(this.eventFactory.createEndElement(this.prefix, this.namespaceUri, ERROR_CODE_TAG));
            writer.add(this.eventFactory.createStartElement(this.prefix, this.namespaceUri, MESSAGE_TAG));
            if (this.de.getMessage() != null) {
                writer.add(this.eventFactory.createCharacters(this.de.getMessage()));
            }
            writer.add(this.eventFactory.createEndElement(this.prefix, this.namespaceUri, MESSAGE_TAG));
        } else {
            writer.add(this.eventFactory.createStartElement(this.prefix, this.namespaceUri, USER_SESSION_GUID_TAG));
            writer.add(this.eventFactory.createCharacters(this.userSessionGuid));
            writer.add(this.eventFactory.createEndElement(this.prefix, this.namespaceUri, USER_SESSION_GUID_TAG));
            writer.add(this.eventFactory.createStartElement(this.prefix, this.namespaceUri, EXECUTION_CONTEXT_TAG));
            writer.add(this.eventFactory.createCharacters(this.executionContext));
            writer.add(this.eventFactory.createEndElement(this.prefix, this.namespaceUri, EXECUTION_CONTEXT_TAG));
            if (this.href != null) {
                writer.add(this.eventFactory.createStartElement(this.prefix, this.namespaceUri, HREF_TAG));
                writer.add(this.eventFactory.createCharacters(this.href));
                writer.add(this.eventFactory.createEndElement(this.prefix, this.namespaceUri, HREF_TAG));
            }
        }
        writer.add(this.eventFactory.createEndElement(this.prefix, this.namespaceUri, RESPONSE_TAG));
        writer.add(this.eventFactory.createEndDocument());
        this.more = false;
    }

    public boolean hasMore() {
        return this.more;
    }
}

