/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.sentinel.security;

import com.axway.sentinel.security.dashboard.DashboardPrincipal;
import com.axway.sentinel.security.dashboard.DashboardPrincipalRoles;
import com.axway.sentinel.security.dashboard.DashboardPrincipalStatus;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;

public class DashboardAuthenticationManagerMock {
    private static Map<String, DashboardPrincipal> principals = new HashMap<String, DashboardPrincipal>();
    private static Map<String, String> usersByToken = new HashMap<String, String>();

    private DashboardAuthenticationManagerMock(String host, String port) throws LoginException {
    }

    public DashboardPrincipal login(String login, String password, String domain) throws LoginException {
        DashboardPrincipal result = principals.get(login);
        if (result == null) {
            result = new DashboardPrincipal();
            result.setStatus(DashboardPrincipalStatus.NO_USER);
        }
        return result;
    }

    public DashboardPrincipal login(String token) throws LoginException {
        String login = usersByToken.get(token);
        if (login == null) {
            DashboardPrincipal principal = new DashboardPrincipal();
            principal.setStatus(DashboardPrincipalStatus.NO_USER);
            return principal;
        }
        return this.login(login, "", "");
    }

    public boolean usesDomain() throws LoginException {
        return true;
    }

    public String[] getDomains() throws LoginException {
        return new String[]{"Synchrony", "Sentinel", "Passport"};
    }

    public static DashboardAuthenticationManagerMock createInstance(String host, String port) throws LoginException {
        return new DashboardAuthenticationManagerMock(host, port);
    }

    public static void main(String[] args) {
        try {
            DashboardAuthenticationManagerMock manager = DashboardAuthenticationManagerMock.createInstance("", "");
            System.out.println("Login with user and pass:\n");
            DashboardPrincipal principal = manager.login("Admin", "Admin", "");
            System.out.println(principal.getStatus());
            principal = manager.login("NoRightsUser", "NoRights", "");
            System.out.println(principal.getStatus());
            principal = manager.login("NoPassUser", "NoPass", "");
            System.out.println(principal.getStatus());
            principal = manager.login("SomeUser", "SomePass", "");
            System.out.println(principal.getStatus());
            System.out.println("\nLogin with token:\n");
            principal = manager.login("AdminToken");
            System.out.println(principal.getStatus());
            principal = manager.login("NoRightsUserToken");
            System.out.println(principal.getStatus());
            principal = manager.login("NoPassUserToken");
            System.out.println(principal.getStatus());
            principal = manager.login("SomeUserToken");
            System.out.println(principal.getStatus());
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
    }

    static {
        DashboardPrincipal principal = new DashboardPrincipal();
        principal.setStatus(DashboardPrincipalStatus.HAS_RIGHTS);
        principal.setName("superadmin");
        principal.setRole(DashboardPrincipalRoles.SUPER_ADMIN);
        principals.put("superadmin", principal);
        usersByToken.put("AdminToken", "superadmin");
        principal = new DashboardPrincipal();
        principal.setStatus(DashboardPrincipalStatus.NO_RIGHTS);
        principal.setName("NoRightsUser");
        principals.put("NoRightsUser", principal);
        usersByToken.put("NoRightsUserToken", "NoRightsUser");
        principal = new DashboardPrincipal();
        principal.setStatus(DashboardPrincipalStatus.NOT_AUTHENTICATED);
        principal.setName("NoPassUser");
        principals.put("NoPassUser", principal);
        usersByToken.put("NoPassUserToken", "NoPassUser");
    }
}

