/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.sentinel.security;

import com.axway.sentinel.security.dashboard.DashboardPrincipal;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.model.helper.PersFieldHelper;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.util.ValueHelper;
import com.prelytis.dashboard.value.data.BeanPersField;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.filter.DefaultFilter;
import com.prelytis.dashboard.value.data.filter.PersFieldFilter;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PersFieldsLoader {
    private static final Logger LOG = LogManager.getLogger(PersFieldsLoader.class);
    private static final String PP_DATE_FORMAT = "MM/DD/yyyy HH:mm";
    private static final String WD_DATE_FORMAT = "M/dd/yy hh:mm:ss a";
    private static final String SENTINEL_ADMIN_TIME_FORMAT = "HH:mm:ss";
    private static final String WD_TIME_FORMAT = "hh:mm:ss a";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String DATE = "date";
    private static final String BOOLEAN = "boolean";
    private static final String NUMBER = "number";
    private static final String STRING = "string";
    private static final String TIME = "time";
    private final DashboardPrincipal sentinelUser;
    private final DaoFactory daoFactory;
    private final ExpressionEvaluationData evalData;
    private UserHelper userHelper;
    private BeanUserDefinition userDefinition;
    private PersFieldHelper persFieldHelper;
    private List<Element> userPersFields;
    private Map<String, String> persFieldsValues;

    public PersFieldsLoader(DashboardPrincipal sentinelUser, DaoFactory daoFactory, ExpressionEvaluationData evalData) {
        this.sentinelUser = sentinelUser;
        this.daoFactory = daoFactory;
        this.evalData = evalData;
    }

    public void loadPersFields() {
        LOG.debug((Object)("Begin loading PersFields from PassPort for user: " + this.sentinelUser.getWDUserName()));
        LOG.debug((Object)("User properties to load: " + this.getUserProperties().toString()));
        this.init();
        this.savePersFieldObjects();
        this.saveUserPersFieldValues();
    }

    private void init() {
        this.userHelper = UserHelper.getInstance(this.daoFactory);
        this.persFieldHelper = PersFieldHelper.getInstance(this.daoFactory);
        this.persFieldsValues = new HashMap<String, String>();
        this.userPersFields = new ArrayList<Element>();
    }

    private void savePersFieldObjects() {
        for (Map.Entry<String, String> property : this.getUserProperties().entrySet()) {
            String propertyName = PersFieldsLoader.getPropertyName(property.getKey());
            String propertyType = PersFieldsLoader.getPropertyType(property.getKey());
            BeanPersField beanPersField = this.getUserPersField(propertyName);
            if (beanPersField == null) {
                LOG.debug((Object)("New! An object PersField '" + propertyName + "' is not defined. It will be created!... "));
                this.createPersField(propertyName, propertyType);
            } else {
                LOG.debug((Object)("Exist! An object PersField '" + propertyName + "' already exists! Type: " + beanPersField.getType()));
                if (1 != beanPersField.getType()) {
                    LOG.warn((Object)("An object PersField '" + propertyName + "' already exists but it is not USER TYPE. This property will be skiped. Nothing to update!"));
                    continue;
                }
                this.savePersField(beanPersField, propertyName, propertyType);
            }
            this.addValueForSave(property);
        }
    }

    private void addValueForSave(Map.Entry<String, String> entryProperty) {
        String propertyName = PersFieldsLoader.getPropertyName(entryProperty.getKey());
        try {
            String propertyType = PersFieldsLoader.getPropertyType(entryProperty.getKey());
            DataType pfDataType = this.convertToPersFieldType(propertyType);
            String propertyValue = this.convertToPersFieldValue(pfDataType, entryProperty.getValue());
            this.persFieldsValues.put(propertyName, propertyValue);
        }
        catch (DashboardException exc) {
            LOG.error((Object)("Object name '" + propertyName + "'. Saving error: " + exc.getMessage()), (Throwable)exc);
        }
        catch (ParseException pex) {
            LOG.error((Object)("Object name '" + propertyName + "'. Saving error: " + pex.getMessage()), (Throwable)pex);
        }
    }

    private void savePersField(BeanPersField persField, String propertyName, String propertyType) {
        try {
            DataType propertyDataType = this.convertToPersFieldType(propertyType);
            if (!propertyDataType.equals((Object)persField.getDataType())) {
                LOG.debug((Object)("Object PersField '" + propertyName + "' has the type " + persField.getDataType() + ". It will be overwrited with: " + propertyType));
                persField.setDataType(propertyDataType);
                this.persFieldHelper.save(persField, this.evalData, false);
            }
        }
        catch (DashboardException exc) {
            LOG.error((Object)("The PersField object with name '" + propertyName + "' update failed: " + exc.getMessage()), (Throwable)exc);
        }
    }

    private void createPersField(String propertyName, String propertyType) {
        try {
            DataType propertyDataType = this.convertToPersFieldType(propertyType);
            BeanPersField newPersField = this.persFieldHelper.create(this.evalData);
            newPersField.setName(propertyName);
            newPersField.getDescriptionMap().put(Locale.ENGLISH, propertyName);
            newPersField.setType(1);
            newPersField.setDataType(propertyDataType);
            this.persFieldHelper.save(newPersField, this.evalData, true);
            LOG.debug((Object)("An object PersField with name '" + newPersField.getName() + "' and data type " + newPersField.getDataType() + " was created."));
        }
        catch (DashboardException exc) {
            LOG.error((Object)("PersField object '" + propertyName + "' creation failed: " + exc.getMessage()), (Throwable)exc);
        }
    }

    private void saveUserPersFieldValues() {
        try {
            Map<String, BeanPersFieldValue> pfValuesMap = this.getDBPersFieldsValues();
            BeanUserDefinition userDef = this.getUserDefinition();
            for (Map.Entry<String, String> pfStringValue : this.persFieldsValues.entrySet()) {
                String propertyName = pfStringValue.getKey();
                String propertyValue = pfStringValue.getValue();
                BeanPersFieldValue beanValue = pfValuesMap.get(propertyName);
                if (beanValue == null) {
                    LOG.error((Object)("Error on saving: " + propertyName + " is not found as PersFieldValue!"));
                    continue;
                }
                Object newValue = this.parseValue(propertyValue, beanValue);
                beanValue.setValues(newValue);
                LOG.debug((Object)("UPDATE PersField: " + propertyName + ", NEW value: " + newValue));
            }
            this.userHelper.save(userDef, this.evalData, false);
        }
        catch (DashboardException exc) {
            LOG.error((Object)("Update PersField error:" + exc.getMessage()), (Throwable)exc);
        }
    }

    private BeanUserDefinition getUserDefinition() throws DashboardException {
        if (this.userDefinition == null) {
            this.userDefinition = this.userHelper.findUserUsingLogin(this.sentinelUser.getWDUserName());
        }
        return this.userDefinition;
    }

    private DataType convertToPersFieldType(String propertyType) throws DashboardException {
        DataType dataType = null;
        if (STRING.equalsIgnoreCase(propertyType)) {
            dataType = DataType.VARCHAR;
        } else if (NUMBER.equalsIgnoreCase(propertyType) || BOOLEAN.equalsIgnoreCase(propertyType)) {
            dataType = DataType.NUMERIC;
        } else if (DATE.equalsIgnoreCase(propertyType)) {
            dataType = DataType.TIMESTAMP;
        } else if (TIME.equalsIgnoreCase(propertyType)) {
            dataType = DataType.TIME;
        } else {
            throw new DashboardException("Not supported property type: " + propertyType);
        }
        return dataType;
    }

    private String convertToPersFieldValue(DataType persFieldType, String value) throws ParseException {
        String retValue = value;
        if (DataType.NUMERIC.equals((Object)persFieldType)) {
            retValue = TRUE.equalsIgnoreCase(value) ? Integer.toString(1) : (FALSE.equalsIgnoreCase(value) ? Integer.toString(0) : value);
        } else if (DataType.TIMESTAMP.equals((Object)persFieldType)) {
            retValue = this.formatDate(value);
        } else if (DataType.TIME.equals((Object)persFieldType)) {
            retValue = this.formatTime(value);
        }
        LOG.debug((Object)("Value convertion. (Type: " + persFieldType + ")  " + value + " => " + retValue));
        return retValue;
    }

    private Object parseValue(String propertyValue, BeanPersFieldValue pfValue) {
        Object formatedValue = null;
        try {
            Locale locale = PrelytisInfoHelper.getInstance(this.daoFactory).getDefaultLocale();
            ValueHelper valueHelper = ValueHelper.getInstance((Locale)locale);
            formatedValue = valueHelper.parse(pfValue.getDataType(), propertyValue);
        }
        catch (ParseException pex) {
            LOG.error((Object)("Update PersField error:" + pex.getMessage()), (Throwable)pex);
        }
        return formatedValue;
    }

    private String formatDate(String ppDate) throws ParseException {
        SimpleDateFormat ppFormat = new SimpleDateFormat(PP_DATE_FORMAT, Locale.ENGLISH);
        Date date = ppFormat.parse(ppDate);
        SimpleDateFormat wdFormat = new SimpleDateFormat(WD_DATE_FORMAT, Locale.ENGLISH);
        return wdFormat.format(date);
    }

    private String formatTime(String time) throws ParseException {
        SimpleDateFormat timeFormat = new SimpleDateFormat(SENTINEL_ADMIN_TIME_FORMAT, Locale.ENGLISH);
        Date date = timeFormat.parse(time);
        SimpleDateFormat wdTimeFormat = new SimpleDateFormat(WD_TIME_FORMAT, Locale.ENGLISH);
        return wdTimeFormat.format(date);
    }

    private BeanPersField getUserPersField(String fieldName) {
        BeanPersField foundPersField = null;
        List<Element> persFieldList = this.getAllUserPersFields();
        for (Element persField : persFieldList) {
            if (!fieldName.equals(persField.getName())) continue;
            foundPersField = (BeanPersField)persField;
            break;
        }
        return foundPersField;
    }

    private List<Element> getAllUserPersFields() {
        if (this.userPersFields.isEmpty()) {
            this.userPersFields = this.persFieldHelper.list((DefaultFilter)new PersFieldFilter(), 2, null, null, this.evalData);
        }
        return this.userPersFields;
    }

    private Map<String, BeanPersFieldValue> getDBPersFieldsValues() {
        HashMap<String, BeanPersFieldValue> pfValuesMap = new HashMap<String, BeanPersFieldValue>();
        try {
            BeanUserDefinition userDef = this.getUserDefinition();
            List pfValues = userDef.getBeanPersFieldValueList();
            for (BeanPersFieldValue pfValue : pfValues) {
                pfValuesMap.put(pfValue.getName(), pfValue);
            }
        }
        catch (DashboardException exc) {
            LOG.error((Object)("Update PersField error:" + exc.getMessage()), (Throwable)exc);
        }
        return pfValuesMap;
    }

    private static String getPropertyType(String property) {
        String propertyType = "";
        String[] strings = property.split("\\|");
        if (strings.length > 0) {
            propertyType = strings[1];
        }
        return propertyType;
    }

    private static String getPropertyName(String propertyKey) {
        String propertyName = propertyKey.split("\\|")[0];
        return propertyName.toLowerCase(Locale.ENGLISH);
    }

    private Map<String, String> getUserProperties() {
        return this.sentinelUser.getUserProperties();
    }
}

