/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.sentinel.security;

import com.axway.sentinel.common.webdashboard.access.ResourceTypes;
import com.axway.sentinel.dashboard.exception.DashboardServiceException;
import com.axway.sentinel.security.dashboard.DashboardPrincipal;
import com.axway.sentinel.security.dashboard.DashboardPrincipalRoles;
import com.axway.sentinel.security.dashboard.DashboardPrincipalStatus;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.LanguageHelper;
import com.prelytis.dashboard.model.helper.PrelytisInfoHelper;
import com.prelytis.dashboard.model.helper.ThemeHelper;
import com.prelytis.dashboard.model.helper.TimeZoneHelper;
import com.prelytis.dashboard.model.helper.UserHelper;
import com.prelytis.dashboard.model.helper.UserLoginNamesBean;
import com.prelytis.dashboard.model.helper.WorkspaceHelper;
import com.prelytis.dashboard.security.DashboardManager;
import com.prelytis.dashboard.security.util.LoginType;
import com.prelytis.dashboard.security.util.SettingsHelper;
import com.prelytis.dashboard.sentinel.security.AuthWorkspaceHelper;
import com.prelytis.dashboard.sentinel.security.DefaultUserEvaluationData;
import com.prelytis.dashboard.sentinel.security.ISentinelAuthenticationFacade;
import com.prelytis.dashboard.sentinel.security.PersFieldsLoader;
import com.prelytis.dashboard.util.PRP;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanLanguage;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.BeanUserExecutionContext;
import com.prelytis.dashboard.value.data.BeanUserMessageType;
import com.prelytis.dashboard.value.data.BeanWorkspaceDefinition;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.HostnameUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.ServiceUnavailableException;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SentinelAuthenticationFacade
implements ISentinelAuthenticationFacade {
    private static final Logger LOG = LogManager.getLogger(SentinelAuthenticationFacade.class);
    private static final String EMAIL_NAME_MSG_TYPE = "email";
    private static ISentinelAuthenticationFacade instance = null;
    private static Map<String, Lock> loginsInProgress = new ConcurrentHashMap<String, Lock>();
    private static Map<DashboardPrincipalRoles, Integer> rolesMap = new HashMap<DashboardPrincipalRoles, Integer>();

    public static synchronized ISentinelAuthenticationFacade getInstance() throws DashboardException {
        if (instance == null) {
            instance = new SentinelAuthenticationFacade();
        }
        return instance;
    }

    @Override
    public boolean usesDomain() {
        boolean result = false;
        try {
            result = DashboardManager.getInstance().usesDomain();
        }
        catch (ServiceUnavailableException e) {
            LOG.warn((Object)"Could not determine if domain is used!");
            LOG.warn((Object)e.getLocalizedMessage());
        }
        return result;
    }

    @Override
    public String[] getDomains() {
        String[] result = null;
        try {
            result = DashboardManager.getInstance().getDomains();
        }
        catch (ServiceUnavailableException e) {
            LOG.warn((Object)"Could not retrieve list of domains!");
            LOG.warn((Object)e.getLocalizedMessage());
        }
        return result;
    }

    private void auditLoginAction(String ipAddress, String userName, String sessionId, LoginType loginType) {
        try {
            String host = HostnameUtil.resolveAddressToHostname((String)ipAddress);
            DashboardManager.getInstance().auditWebDashboardLoginAction(userName, sessionId, host, loginType);
        }
        catch (ServiceUnavailableException e) {
            LOG.error((Object)"Failed to contact Sentinel audit service", (Throwable)e);
        }
    }

    private String determineAuditLoginName(DashboardPrincipal sentinelUser) throws DashboardException {
        String organization = sentinelUser.getOrganization();
        String name = sentinelUser.getName();
        boolean usesDomain = false;
        try {
            usesDomain = DashboardManager.getInstance().usesDomain();
        }
        catch (ServiceUnavailableException e) {
            throw new DashboardException((Throwable)e);
        }
        if (usesDomain && organization != null && !StringUtils.isBlank((String)organization)) {
            name = name + ":" + organization;
        }
        return name;
    }

    @Override
    public UserLoginNamesBean login(String login, String password, String domain, boolean sso, String sessionId, String ipAddress) throws DashboardException {
        DashboardPrincipal sentinelUser;
        try {
            sentinelUser = DashboardManager.getInstance().login(login, password, domain, sso);
        }
        catch (LoginException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (ServiceUnavailableException e) {
            throw new DashboardException((Throwable)e);
        }
        String resultLogin = this.manageLoginResponse(sentinelUser, ipAddress);
        String auditLoginName = this.determineAuditLoginName(sentinelUser);
        this.auditLoginAction(ipAddress, auditLoginName, sessionId, sso ? LoginType.SSO : LoginType.STANDARD);
        return new UserLoginNamesBean(resultLogin, auditLoginName);
    }

    @Override
    public UserLoginNamesBean login(String token, String sessionId, String ipAddress) throws DashboardException {
        DashboardPrincipal sentinelUser;
        try {
            sentinelUser = DashboardManager.getInstance().login(token);
        }
        catch (LoginException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (ServiceUnavailableException e) {
            throw new DashboardException((Throwable)e);
        }
        String resultLogin = this.manageLoginResponse(sentinelUser, ipAddress);
        String auditLoginName = this.determineAuditLoginName(sentinelUser);
        this.auditLoginAction(ipAddress, auditLoginName, sessionId, LoginType.TOKEN);
        return new UserLoginNamesBean(resultLogin, auditLoginName);
    }

    @Override
    public UserLoginNamesBean loginCommonSSO(String login, String sessionId, String ipAddress, HashMap attributes) throws DashboardException {
        DashboardPrincipal sentinelUser;
        try {
            sentinelUser = DashboardManager.getInstance().loginCommonSSO(login, attributes);
        }
        catch (LoginException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (ServiceUnavailableException e) {
            throw new DashboardException((Throwable)e);
        }
        String resultLogin = this.manageLoginResponse(sentinelUser, ipAddress);
        String auditLoginName = this.determineAuditLoginName(sentinelUser);
        this.auditLoginAction(ipAddress, auditLoginName, sessionId, LoginType.COMMON_SSO);
        return new UserLoginNamesBean(resultLogin, auditLoginName);
    }

    private String getLogin(DashboardPrincipal user) {
        int sep = 95;
        String userName = user.getName();
        StringBuilder sb = new StringBuilder(userName);
        if (user.getOrganization() != null) {
            sb.append('_');
            sb.append(user.getOrganization());
        }
        if (user.getDomain() != null) {
            sb.append('_');
            sb.append(user.getDomain());
        }
        return sb.toString();
    }

    private String manageLoginResponse(DashboardPrincipal sentinelUser, String ipAddress) throws DashboardException {
        boolean authenticationFailed;
        String login = this.getLogin(sentinelUser);
        DashboardPrincipalStatus authenticationStatus = sentinelUser.getStatus();
        if ("webdashboard".equals(sentinelUser.getName())) {
            authenticationFailed = DashboardPrincipalStatus.NO_RIGHTS.equals((Object)authenticationStatus);
        } else {
            switch (authenticationStatus) {
                case HAS_RIGHTS: {
                    authenticationFailed = false;
                    this.handleAuthenticatedUser(sentinelUser);
                    break;
                }
                case NO_USER: 
                case NOT_AUTHENTICATED: 
                case NO_RIGHTS: {
                    authenticationFailed = true;
                    break;
                }
                default: {
                    throw new DashboardException(null, "Unknown status code : " + sentinelUser.getStatus().name());
                }
            }
            if (DashboardPrincipalStatus.NO_USER.equals((Object)authenticationStatus)) {
                this.deleteUserWithLogin(login);
            }
        }
        if (authenticationFailed) {
            LOG.error((Object)("authentication failed for user " + login + ", status = " + sentinelUser.getStatus().name()));
            this.auditFailedLogin(ipAddress, sentinelUser.getName());
            throw this.createLoginException(DaoFactory.getInstance(), ErrorCode.INSIGHT_INVALID_CREDENTIALS, "invalidUser");
        }
        return login;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticatedUser(DashboardPrincipal sentinelUser) throws DashboardException {
        boolean usesPassportAuthorization;
        DaoFactory daoFactory = DaoFactory.getInstance();
        UserHelper userHelper = UserHelper.getInstance(daoFactory);
        DefaultUserEvaluationData evalData = new DefaultUserEvaluationData();
        try {
            usesPassportAuthorization = SettingsHelper.getInstance().usesPassportAuthorization();
        }
        catch (DashboardServiceException e) {
            throw new DashboardException((Throwable)e);
        }
        this.checkRequiredObjects(sentinelUser, daoFactory, usesPassportAuthorization);
        String psw = "dummyPass";
        String login = this.getLogin(sentinelUser);
        WorkspaceHelper workspaceHelper = WorkspaceHelper.getInstance(daoFactory);
        if (usesPassportAuthorization) {
            String newWorkspace = this.createWorkspace(workspaceHelper, evalData, sentinelUser.getId());
            sentinelUser.setWorkspaceName(newWorkspace);
        }
        BeanUserDefinition existingUserBean = null;
        Lock lock = null;
        Map<String, Lock> map = loginsInProgress;
        synchronized (map) {
            lock = loginsInProgress.get(login);
            if (lock == null) {
                lock = new ReentrantLock(true);
                loginsInProgress.put(login, lock);
            }
        }
        lock.lock();
        try {
            try {
                existingUserBean = userHelper.getDefinition(login);
            }
            catch (DashboardException e) {
                if (e.getCode() == ErrorCode.NOT_FOUND_ERROR) {
                    this.handleNewUser(sentinelUser, login, "dummyPass", userHelper, evalData);
                }
                throw e;
            }
            if (existingUserBean != null) {
                this.handleExistingUser(sentinelUser, existingUserBean, login, "dummyPass", userHelper, evalData, workspaceHelper, usesPassportAuthorization);
            }
            try {
                PersFieldsLoader pfLoader = new PersFieldsLoader(sentinelUser, daoFactory, evalData);
                pfLoader.loadPersFields();
            }
            catch (Throwable e) {
                LOG.error((Object)"Error while loading Personlized Fields");
                LOG.debug((Object)e);
            }
        }
        finally {
            lock.unlock();
            map = loginsInProgress;
            synchronized (map) {
                if (lock.tryLock()) {
                    loginsInProgress.remove(login);
                    lock.unlock();
                }
            }
        }
    }

    protected String createWorkspace(WorkspaceHelper workspaceHelper, ExpressionEvaluationData evalData, long userId) throws DashboardException {
        BeanWorkspaceDefinition newWorkspace = AuthWorkspaceHelper.createWorkspace(workspaceHelper, evalData);
        try {
            Map<ResourceTypes, List<String>> availableResources = AuthWorkspaceHelper.retrieveAvailableObjects();
            Map accessLevels = DashboardManager.getInstance().getAccessLevelsOnResources(userId, availableResources);
            AuthWorkspaceHelper.addAllObjectsToWorkspace(newWorkspace);
            AuthWorkspaceHelper.updateAccessLevels(newWorkspace, accessLevels);
            AuthWorkspaceHelper.updateAccessLevels(newWorkspace, userId);
            AuthWorkspaceHelper.customizeMenus(newWorkspace);
        }
        catch (ServiceUnavailableException e) {
            LOG.error((Object)"Failed to contact Sentinel service.");
            throw new DashboardException((Throwable)e);
        }
        catch (DashboardServiceException e) {
            LOG.error((Object)"Failed to retrieve access rights.");
            throw new DashboardException((Throwable)e);
        }
        workspaceHelper.save(newWorkspace, evalData, true);
        return newWorkspace.getName();
    }

    private void handleNewUser(DashboardPrincipal sentinelUser, String login, String psw, UserHelper userHelper, ExpressionEvaluationData evalData) throws DashboardException {
        this.deleteUserWithLogin(login);
        BeanUserDefinition wdUserDefinition = this.getUserDefinitionBySentinelUser(login, psw, sentinelUser);
        this.updateUserProperties(sentinelUser, wdUserDefinition);
        userHelper.save(wdUserDefinition, evalData, true);
    }

    private void handleExistingUser(DashboardPrincipal sentinelUser, BeanUserDefinition existingUserBean, String login, String psw, UserHelper userHelper, ExpressionEvaluationData evalData, WorkspaceHelper workspaceHelper, boolean usesPassportAuthorization) throws DashboardException {
        Set<String> oldWorkspaces = this.updateUserDefinitionBySentinelUser(existingUserBean, login, psw, sentinelUser);
        if (!existingUserBean.getLogin().equals(login)) {
            this.deleteUserWithLogin(login);
        }
        this.resetDefaultUserSettingsIfNeeded(existingUserBean);
        this.updateUserProperties(sentinelUser, existingUserBean);
        userHelper.save(existingUserBean, evalData, false);
        if (usesPassportAuthorization) {
            AuthWorkspaceHelper.deleteWorkspaces(workspaceHelper, evalData, oldWorkspaces);
        }
    }

    private void auditFailedLogin(String ipAddress, String login) {
        String host = HostnameUtil.resolveAddressToHostname((String)ipAddress);
        try {
            DashboardManager.getInstance().auditWebDashboardLoginActionFailed(login, host);
        }
        catch (ServiceUnavailableException e) {
            LOG.error((Object)"Failed to contact Sentinel audit service", (Throwable)e);
        }
    }

    private DashboardException createLoginException(DaoFactory daoFactory, ErrorCode errorCode, String key) {
        PrelytisInfoHelper prelytisInfoHelper = PrelytisInfoHelper.getInstance(daoFactory);
        Locale locale = prelytisInfoHelper.getDefaultLocale();
        return ExceptionHelper.getInstance(locale).createLoginException(errorCode, key);
    }

    protected void updateUserProperties(DashboardPrincipal sentinelUser, BeanUserDefinition userDefinition) {
        this.updateLanguage(sentinelUser, userDefinition);
        this.updateTheme(sentinelUser, userDefinition);
        this.updateTimezone(sentinelUser, userDefinition);
        this.updateHome(sentinelUser, userDefinition);
    }

    private void updateLanguage(DashboardPrincipal sentinelUser, BeanUserDefinition userDefinition) {
        if (sentinelUser == null || !userDefinition.getUseAmLang().booleanValue() && this.getActiveLanguage(userDefinition.getLanguageName()) != null) {
            return;
        }
        String languageName = sentinelUser.getLanguage();
        BeanLanguage language = this.getActiveLanguage(languageName);
        if (language == null) {
            return;
        }
        userDefinition.setLanguageName(languageName);
        userDefinition.setLanguageOID(language.getObjectID());
        userDefinition.setUseAmLang(Boolean.valueOf(true));
    }

    private BeanLanguage getActiveLanguage(String languageName) {
        if (languageName == null) {
            return null;
        }
        DaoFactory daoFactory = DaoFactory.getInstance();
        LanguageHelper lh = LanguageHelper.getInstance(daoFactory);
        try {
            BeanLanguage bl = lh.getDefinition(languageName);
            if (bl == null) {
                return null;
            }
            List<BeanLanguage> activeLanguageList = lh.getActiveLanguageList();
            for (BeanLanguage beanFromList : activeLanguageList) {
                if (!bl.getName().equals(beanFromList.getName())) continue;
                return bl;
            }
        }
        catch (DashboardException e) {
            LOG.error((Object)("Failed to load " + languageName + " and it will not be used."));
            LOG.debug((Object)"Exception is: ", (Throwable)e);
        }
        return null;
    }

    private void updateTheme(DashboardPrincipal sentinelUser, BeanUserDefinition userDefinition) {
        if (sentinelUser == null || !userDefinition.getUseAmTheme().booleanValue()) {
            return;
        }
        DaoFactory daoFactory = DaoFactory.getInstance();
        String themeName = sentinelUser.getTheme();
        if (themeName == null) {
            return;
        }
        try {
            ThemeHelper th = ThemeHelper.getInstance(daoFactory);
            BeanThemeDefinition bt = th.getDefinition(themeName);
            if (bt == null) {
                return;
            }
            userDefinition.setThemeName(themeName);
            userDefinition.setThemeOID(bt.getObjectID());
        }
        catch (DashboardException e) {
            LOG.error((Object)"Failed to get theme for user. Set default theme");
            LOG.debug((Object)"Exception is: ", (Throwable)e);
        }
    }

    private void updateTimezone(DashboardPrincipal sentinelUser, BeanUserDefinition userDefinition) {
        if (sentinelUser == null || !userDefinition.getUseAmTimeZone().booleanValue()) {
            return;
        }
        String timeZoneID = sentinelUser.getTimeZone();
        if (timeZoneID == null) {
            return;
        }
        Locale locale = Locale.getDefault();
        TimeZoneHelper tzHelper = new TimeZoneHelper(locale);
        List<String> tzIds = tzHelper.getValues();
        if (!tzIds.contains(timeZoneID)) {
            return;
        }
        userDefinition.setTimeZone(timeZoneID);
    }

    private void updateHome(DashboardPrincipal sentinelUser, BeanUserDefinition userDefinition) {
        if (sentinelUser == null || !userDefinition.getUseAmHome().booleanValue()) {
            return;
        }
        DaoFactory daoFactory = DaoFactory.getInstance();
        String dashboardName = sentinelUser.getHome();
        if (dashboardName == null) {
            return;
        }
        DashBoardHelper dh = DashBoardHelper.getInstance(daoFactory);
        try {
            BeanDashBoardDefinition bd = dh.getDefinition(dashboardName);
            if (bd != null) {
                userDefinition.getExecutionContextList();
                for (BeanUserExecutionContext buec : userDefinition.getExecutionContextList()) {
                    buec.setDashboardName(dashboardName);
                    buec.setDashBoardOid(Integer.valueOf(bd.getObjectID()));
                }
            }
        }
        catch (DashboardException e) {
            LOG.error((Object)"Failed to get home execution context for user. Set default execution context");
            LOG.debug((Object)"Exception is: ", (Throwable)e);
        }
    }

    private Set<String> updateUserDefinitionBySentinelUser(BeanUserDefinition userDefinition, String principal, String pwd, DashboardPrincipal sentinelUser) {
        BeanUserMessageType messageType;
        userDefinition.setExternalId(sentinelUser.getId());
        userDefinition.setLogin(principal);
        userDefinition.setPassword(PRP.encryptPassword((String)pwd));
        this.updateDescriptionMap(userDefinition, sentinelUser);
        Integer profile = rolesMap.get(sentinelUser.getRole());
        if (profile == null) {
            profile = 1;
        }
        HashSet<String> oldWorkspaces = new HashSet<String>();
        for (BeanUserExecutionContext context : userDefinition.getExecutionContextList()) {
            oldWorkspaces.add(context.getWorkspaceName());
            context.setProfile(profile.intValue());
            context.setEntityName(sentinelUser.getEntityName() == null ? "default" : sentinelUser.getEntityName());
            context.setWorkspaceName(sentinelUser.getWorkspaceName() == null ? "superadmin" : sentinelUser.getWorkspaceName());
        }
        Iterator iterator = userDefinition.getBeanUserMessageTypeList().iterator();
        while (iterator.hasNext() && !(messageType = (BeanUserMessageType)iterator.next()).getName().equals(EMAIL_NAME_MSG_TYPE)) {
        }
        return oldWorkspaces;
    }

    private void updateDescriptionMap(BeanUserDefinition userDefinition, DashboardPrincipal sentinelUser) {
        List<Locale> locales = Arrays.asList(Locale.ENGLISH, Locale.FRENCH);
        String userName = sentinelUser.getName();
        Map descriptionMap = userDefinition.getDescriptionMap();
        for (Locale locale : locales) {
            if (descriptionMap.get(locale) != null) continue;
            descriptionMap.put(locale, userName);
        }
    }

    protected void deleteUserWithLogin(String login) throws DashboardException {
        DaoFactory daoFactory = DaoFactory.getInstance();
        UserHelper userHelper = UserHelper.getInstance(daoFactory);
        DefaultUserEvaluationData evalData = new DefaultUserEvaluationData();
        try {
            BeanUserDefinition foundUserWithSameLogin = userHelper.findUserUsingLogin(login);
            userHelper.delete(foundUserWithSameLogin.getName(), evalData);
        }
        catch (DashboardRuntimeException e) {
            if (e.getCode() != ErrorCode.NOT_FOUND_ERROR) {
                throw new DashboardException((Throwable)e);
            }
        }
        catch (DashboardException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void checkRequiredObjects(DashboardPrincipal principal, DaoFactory daoFactory, boolean usesPassportAuthorization) throws DashboardException {
        EntityHelper entityHelper = EntityHelper.getInstance(daoFactory);
        WorkspaceHelper wsHelper = WorkspaceHelper.getInstance(daoFactory);
        try {
            if (principal.getEntityName() != null) {
                entityHelper.getDefinition(principal.getEntityName());
            }
            if (principal.getWorkspaceName() != null && !usesPassportAuthorization) {
                wsHelper.getDefinition(principal.getWorkspaceName());
            }
        }
        catch (DashboardException e) {
            if (e.getCode() == ErrorCode.NOT_FOUND_ERROR) {
                throw this.createLoginException(daoFactory, ErrorCode.NOT_FOUND_ERROR, "missingEntityOrWorkspace");
            }
            throw e;
        }
    }

    private BeanUserDefinition getUserDefinitionBySentinelUser(String login, String password, DashboardPrincipal sentinelUser) {
        BeanUserExecutionContext ec = new BeanUserExecutionContext();
        ec.setEntityName(sentinelUser.getEntityName() == null ? "default" : sentinelUser.getEntityName());
        Integer profile = rolesMap.get(sentinelUser.getRole());
        ec.setProfile(profile == null ? 1 : profile);
        ec.setWorkspaceName(sentinelUser.getWorkspaceName() == null ? "superadmin" : sentinelUser.getWorkspaceName());
        ec.setSystem(true);
        BeanUserDefinition user = new BeanUserDefinition();
        user.setName(login);
        user.setLogin(login);
        user.setExternalId(sentinelUser.getId());
        String description = sentinelUser.getName();
        user.getDescriptionMap().put(Locale.FRENCH, description);
        user.getDescriptionMap().put(Locale.ENGLISH, description);
        user.setActive(true);
        user.setPassword(PRP.encryptPassword((String)password));
        user.setDefaultExecutionContextOID(ec.getObjectID());
        user.getExecutionContextList().add(ec);
        DefaultUserEvaluationData defaultUserEvaluationData = new DefaultUserEvaluationData();
        user.setLanguageOID(defaultUserEvaluationData.getDefaultLanguageOid());
        user.setTimeZone(defaultUserEvaluationData.getDefaultTimezone());
        user.setThemeName("Axway");
        return user;
    }

    private void resetDefaultUserSettingsIfNeeded(BeanUserDefinition sentinelUser) {
        DefaultUserEvaluationData defaultUserEvaluationData = new DefaultUserEvaluationData();
        if (sentinelUser.getUseAmLang().booleanValue()) {
            sentinelUser.setLanguageOID(defaultUserEvaluationData.getDefaultLanguageOid());
            sentinelUser.setLanguageName(null);
        }
        if (sentinelUser.getUseAmTimeZone().booleanValue()) {
            sentinelUser.setTimeZone(defaultUserEvaluationData.getDefaultTimezone());
        }
    }

    static {
        rolesMap.put(DashboardPrincipalRoles.ADMIN, 2);
        rolesMap.put(DashboardPrincipalRoles.SUPER_ADMIN, 3);
        rolesMap.put(DashboardPrincipalRoles.USER, 1);
    }
}

