/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.TaskControlExecution;
import com.prelytis.dashboard.task.TaskDataMartExecution;
import com.prelytis.dashboard.task.TaskDocExportExecution;
import com.prelytis.dashboard.task.TaskDocGenerationExecution;
import com.prelytis.dashboard.task.TaskEvent;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.TaskExecutionListener;
import com.prelytis.dashboard.task.TaskMetricExecution;
import com.prelytis.dashboard.task.TaskScriptExecution;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanTask;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.structure.Task;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageI18n;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractTaskExecution {
    protected static final Logger log = LogManager.getLogger(AbstractTaskExecution.class);
    private final TaskExecutionListener listener;
    protected final MessageListener messageListener;

    public AbstractTaskExecution(MessageListener messageListener, TaskExecutionListener listener) {
        this.messageListener = messageListener;
        this.listener = listener;
    }

    public static final AbstractTaskExecution getInstance(MessageListener messageListener, TaskExecutionListener listener, TaskType taskType) {
        switch (taskType) {
            case TASK_TYPE_CONTROL: {
                return new TaskControlExecution(messageListener, listener);
            }
            case TASK_TYPE_DATAMART: 
            case TASK_TYPE_IMPORT_PARAM: 
            case TASK_TYPE_EXPORT_PARAM: 
            case TASK_TYPE_XSLFO_DOC_GENERATION: 
            case TASK_TYPE_IMG_GENERATION: {
                return new TaskDataMartExecution(messageListener, listener);
            }
            case TASK_TYPE_SCRIPT: {
                return new TaskScriptExecution(messageListener, listener);
            }
            case TASK_TYPE_METRIC: {
                return new TaskMetricExecution(messageListener, listener);
            }
            case TASK_TYPE_DOC_GENERATION: {
                return new TaskDocGenerationExecution(messageListener, listener);
            }
            case TASK_TYPE_DOCUMENT_EXPORT: {
                return new TaskDocExportExecution(messageListener, listener);
            }
        }
        return null;
    }

    public abstract int execute(DaoFactory var1, Task var2) throws TaskExecutionException;

    protected void addMessage(ExecutionMessage message) {
        if (message == null) {
            return;
        }
        this.messageListener.log(message);
    }

    protected void addMessage(int severity, String msgKey, String param) {
        try {
            this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(severity, msgKey, param));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addMessage(int severity, String message) {
        try {
            this.messageListener.log((ExecutionMessage)new ExecutionMessageStd(severity, message));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void traceFinalException(BeanTask task, Throwable e) {
        if (e instanceof TaskExecutionException) {
            TaskExecutionException exception = (TaskExecutionException)e;
            if (!exception.isLogged()) {
                this.traceUnknownException(e);
            }
        } else {
            this.traceUnknownException(e);
        }
    }

    protected void traceUnknownException(Throwable e) {
        try {
            log.error((Object)e.getMessage(), e);
            Throwable throwable = e;
            if (e.getCause() != null) {
                throwable = e.getCause();
            }
            String message = throwable.getMessage() + " (" + throwable.getStackTrace()[0].toString() + ")";
            log.error((Object)message);
            this.addMessage(3, message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    protected void handleException(Exception e) throws TaskExecutionException {
        if (e instanceof TaskExecutionException) {
            throw (TaskExecutionException)e;
        }
        log.error((Object)e);
        throw new TaskExecutionException(e, true);
    }

    protected TaskExecutionException getException(Exception e) {
        if (e instanceof TaskExecutionException) {
            return (TaskExecutionException)e;
        }
        log.error((Object)e);
        return new TaskExecutionException(e, true);
    }

    protected void silentlyClose(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected BeanPersFieldValue getPersFieldValue(List<BeanPersFieldValue> list, int oid) {
        for (BeanPersFieldValue value : list) {
            if (value.getObjectID() != oid) continue;
            return value;
        }
        return null;
    }

    protected final void startTask(TaskEvent event) {
        try {
            event.setId(GuidFactory.getInstance().generateGUID((Object)event));
            this.listener.start(event);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected final void endTask(TaskEvent event) {
        try {
            this.listener.end(event);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

