/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CSVHandler
extends DefaultHandler {
    private StringBuffer textBuffer;
    private Map<Integer, String> values;
    private Map<Integer, FieldMetaData> fields;
    private int nbCols;
    private boolean definition;
    private List<String> fielddescription = new ArrayList<String>();
    private int lines;
    private final BufferedWriter fos;
    private Integer fieldName;
    private String separator;
    private String textDelimiter;
    private boolean exportHeading;

    public CSVHandler(BufferedWriter fos, String separator, String textDelimiter, boolean exportHeading) {
        this.fos = fos;
        this.textDelimiter = textDelimiter == null ? "" : textDelimiter;
        this.separator = separator;
        this.exportHeading = exportHeading;
        this.definition = false;
        this.lines = 0;
    }

    @Override
    public void startDocument() throws SAXException {
        this.values = new HashMap<Integer, String>();
        this.fields = new HashMap<Integer, FieldMetaData>();
    }

    @Override
    public void endDocument() throws SAXException {
        this.values.clear();
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.textBuffer = null;
        if (this.isElement(namespaceURI, sName, qName, "table")) {
            String tmp = this.getValue(attrs, namespaceURI, "nbcols");
            try {
                this.nbCols = Integer.parseInt(tmp);
            }
            catch (Exception e) {
                throw new SAXException("nbcols attribute missing");
            }
        }
        if (this.isElement(namespaceURI, sName, qName, "record")) {
            this.values.clear();
        } else if (this.isElement(namespaceURI, sName, qName, "definition")) {
            this.fields.clear();
            this.definition = true;
        } else if (this.isElement(namespaceURI, sName, qName, "fielddefinition")) {
            if (this.definition) {
                DataType dataType;
                String col = this.getValue(attrs, namespaceURI, "col");
                String name = this.getValue(attrs, namespaceURI, "name");
                String description = this.getValue(attrs, namespaceURI, "description");
                this.fielddescription.add(this.textDelimiter + (description == null ? name : description) + this.textDelimiter);
                String tmp = this.getValue(attrs, namespaceURI, "datatype");
                try {
                    dataType = DataType.valueOf((int)new Integer(tmp));
                }
                catch (Exception e) {
                    throw new SAXException("datatype attribute missing");
                }
                if (DataType.isNumeric((DataType)dataType)) {
                    int fieldPrecision;
                    int fieldScale;
                    tmp = this.getValue(attrs, namespaceURI, "fieldscale");
                    try {
                        fieldScale = new Integer(tmp);
                    }
                    catch (Exception e) {
                        fieldScale = 10;
                    }
                    tmp = this.getValue(attrs, namespaceURI, "fieldprecision");
                    try {
                        fieldPrecision = new Integer(tmp);
                    }
                    catch (Exception e) {
                        fieldPrecision = 2;
                    }
                    this.fields.put(Integer.valueOf(col), new FieldMetaData(0, name, description, dataType, fieldPrecision, fieldScale));
                } else if (DataType.isChar((DataType)dataType)) {
                    int fieldSize;
                    tmp = this.getValue(attrs, namespaceURI, "fieldsize");
                    try {
                        fieldSize = new Integer(tmp);
                    }
                    catch (Exception e) {
                        throw new SAXException("fieldsize attribute missing");
                    }
                    this.fields.put(Integer.valueOf(col), new FieldMetaData(0, name, description, dataType, fieldSize));
                }
            }
        } else if (this.isElement(namespaceURI, sName, qName, "field")) {
            String col = this.getValue(attrs, namespaceURI, "col");
            this.fieldName = Integer.valueOf(col);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        int i;
        if (this.isElement(namespaceURI, sName, qName, "definition")) {
            if (this.nbCols == 0) {
                throw new SAXException("No Column Found");
            }
            this.definition = false;
            if (this.exportHeading) {
                try {
                    StringBuffer lLine = new StringBuffer();
                    for (i = 0; i < this.nbCols; ++i) {
                        lLine.append(this.separator).append(this.fielddescription.get(i));
                    }
                    this.fos.write(lLine.substring(this.separator.length()));
                    this.fos.write(10);
                }
                catch (Exception e) {
                    throw new SAXException(e.getMessage());
                }
            }
        }
        if (!this.definition) {
            if (this.isElement(namespaceURI, sName, qName, "field")) {
                if (this.textBuffer != null) {
                    this.values.put(this.fieldName, this.textBuffer.toString());
                }
                this.fieldName = null;
            } else if (this.isElement(namespaceURI, sName, qName, "record")) {
                try {
                    StringBuffer line = new StringBuffer();
                    for (i = 0; i < this.nbCols; ++i) {
                        line.append(this.separator).append(this.values.get(i + 1));
                    }
                    this.fos.write(line.substring(this.separator.length()));
                    this.fos.write(10);
                    ++this.lines;
                }
                catch (Exception e) {
                    throw new SAXException(e.getMessage());
                }
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (this.textDelimiter != null) {
            s = this.textDelimiter + s + this.textDelimiter;
        }
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    public int getLines() {
        return this.lines;
    }

    private String getValue(Attributes attrs, String uri, String name) {
        String value = attrs.getValue(name);
        if (value != null) {
            return value;
        }
        return attrs.getValue(uri, name);
    }

    private boolean isElement(String namespaceURI, String sName, String qName, String elt) {
        return sName.equals(elt) || qName.equals(elt);
    }
}

