/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class CSVReader
implements XMLReader {
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final char[] carriageReturn = "\n".toCharArray();
    private int importFileFrom;
    private int importFromLine;
    private int importFileTo;
    private int importToLine;
    private String textDelimiter;
    private String separator;
    private String nameSpaceURI = "";
    private String prefix = "";
    private boolean fNamespaces = false;
    private boolean fNamespacePrefixes = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        AttributesImpl attributes = new AttributesImpl();
        ContentHandler contentHandler = this.contentHandler;
        String prefix = this.prefix;
        String nameSpaceURI = this.nameSpaceURI;
        String separator = this.separator;
        boolean stopImport = false;
        try (BufferedReader reader = new BufferedReader(input.getCharacterStream());){
            int numRow;
            attributes.clear();
            contentHandler.startDocument();
            contentHandler.startPrefixMapping(prefix, "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd");
            String line = reader.readLine();
            String[] fields = line.split(separator);
            attributes.addAttribute(nameSpaceURI, "nbcols", "nbcols", "CDATA", Integer.valueOf(fields.length).toString());
            contentHandler.startElement(nameSpaceURI, "table", prefix + "table", attributes);
            attributes.clear();
            contentHandler.startElement(nameSpaceURI, "definition", prefix + "definition", attributes);
            for (int i = 0; i < fields.length; ++i) {
                String eltName = "fielddefinition";
                attributes.clear();
                attributes.addAttribute(nameSpaceURI, "col", "col", "CDATA", String.valueOf(i + 1));
                attributes.addAttribute(nameSpaceURI, "name", "name", "CDATA", "field" + String.valueOf(i + 1));
                attributes.addAttribute(nameSpaceURI, "description", "description", "CDATA", "field " + String.valueOf(i + 1));
                attributes.addAttribute(nameSpaceURI, "datatype", "datatype", "CDATA", Integer.valueOf(12).toString());
                attributes.addAttribute(nameSpaceURI, "fieldsize", "fieldsize", "CDATA", "255");
                contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
                contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
            }
            contentHandler.endElement(nameSpaceURI, "definition", prefix + "definition");
            if (this.importFileFrom == 1) {
                this.importFromLine = 0;
            }
            for (numRow = 1; numRow < this.importFromLine; ++numRow) {
                line = reader.readLine();
            }
            while (line != null && !stopImport) {
                contentHandler.ignorableWhitespace(carriageReturn, 0, carriageReturn.length);
                attributes.clear();
                attributes.addAttribute(nameSpaceURI, "row", "row", "CDATA", String.valueOf(numRow));
                contentHandler.startElement(nameSpaceURI, "record", prefix + "record", attributes);
                fields = line.split(separator);
                for (int i = 0; i < fields.length; ++i) {
                    String elt = fields[i];
                    String textDelimiter = this.textDelimiter;
                    if (textDelimiter != null && !textDelimiter.equals("") && elt.startsWith(textDelimiter)) {
                        int begin = elt.indexOf(textDelimiter) + 1;
                        int end = elt.lastIndexOf(textDelimiter);
                        elt = elt.substring(begin, end);
                    }
                    attributes.clear();
                    attributes.addAttribute(nameSpaceURI, "col", "col", "CDATA", String.valueOf(i + 1));
                    contentHandler.startElement(nameSpaceURI, "field", prefix + "field", attributes);
                    contentHandler.characters(elt.toCharArray(), 0, elt.length());
                    contentHandler.endElement(nameSpaceURI, "field", prefix + "field");
                }
                contentHandler.endElement(nameSpaceURI, "record", prefix + "record");
                line = reader.readLine();
                if (this.importFileTo == 2 && numRow >= this.importToLine) {
                    stopImport = true;
                }
                ++numRow;
            }
            contentHandler.endElement(nameSpaceURI, "table", prefix + "table");
            contentHandler.endPrefixMapping(prefix);
            contentHandler.endDocument();
        }
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public void setFeature(String name, boolean value) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.fNamespaces = value;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.fNamespacePrefixes = value;
        }
        if (this.fNamespacePrefixes && this.fNamespaces) {
            this.nameSpaceURI = "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd";
            this.prefix = "dm:";
        } else {
            this.nameSpaceURI = "";
            this.prefix = "";
        }
    }

    @Override
    public boolean getFeature(String name) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.fNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.fNamespacePrefixes;
        }
        return false;
    }

    public int getImportFileFrom() {
        return this.importFileFrom;
    }

    public void setImportFileFrom(int importFileFrom) {
        this.importFileFrom = importFileFrom;
    }

    public int getImportFileTo() {
        return this.importFileTo;
    }

    public void setImportFileTo(int importFileTo) {
        this.importFileTo = importFileTo;
    }

    public int getImportFromLine() {
        return this.importFromLine;
    }

    public void setImportFromLine(int importFromLine) {
        this.importFromLine = importFromLine;
    }

    public int getImportToLine() {
        return this.importToLine;
    }

    public void setImportToLine(int importToLine) {
        this.importToLine = importToLine;
    }

    public String getTextDelimiter() {
        return this.textDelimiter;
    }

    public void setTextDelimiter(String textDelimiter) {
        this.textDelimiter = textDelimiter;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

