/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.data.transformation.DataTransformer;
import com.prelytis.dashboard.data.transformation.interfaces.DataHandler;
import com.prelytis.dashboard.data.transformation.interfaces.DataReader;
import com.prelytis.dashboard.data.transformation.parameter.ContainerParameter;
import com.prelytis.dashboard.data.transformation.parameter.DataParameter;
import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.data.transformation.parameter.RuptureParameter;
import com.prelytis.dashboard.data.transformation.parameter.SectionParameter;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class QueryReader
implements XMLReader,
DataHandler {
    private static final Logger log = LogManager.getLogger(QueryReader.class);
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private AttributesImpl attributes;
    private ConversionHelper xmlConv;
    private DTDHandler handler;
    private EntityResolver entityResolver;
    private String nameSpaceURI = "";
    private String prefix = "";
    private int numRow;
    private DataReader rs;
    private boolean fNamespaces = false;
    private boolean fNamespacePrefixes = false;

    public QueryReader(DataReader rs) {
        this.rs = rs;
        this.attributes = new AttributesImpl();
        this.xmlConv = ConversionHelper.getXMLConverter();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        try {
            DataTransformer transformer = new DataTransformer();
            transformer.transform(this.rs, this);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new SAXException(e);
        }
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.handler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public void setFeature(String name, boolean value) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.fNamespaces = value;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.fNamespacePrefixes = value;
        }
        if (this.fNamespacePrefixes && this.fNamespaces) {
            this.nameSpaceURI = "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd";
            this.prefix = "dm:";
        } else {
            this.nameSpaceURI = "";
            this.prefix = "";
        }
    }

    @Override
    public boolean getFeature(String name) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.fNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.fNamespacePrefixes;
        }
        return false;
    }

    @Override
    public void startContainer(ContainerParameter container) throws DashboardException {
        try {
            this.attributes.clear();
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(this.prefix, "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void endContainer(ContainerParameter container) throws DashboardException {
        try {
            this.contentHandler.endPrefixMapping(this.prefix);
            this.contentHandler.endDocument();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void startSection(SectionParameter section) throws DashboardException {
        throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
    }

    @Override
    public void endSection(SectionParameter section) throws DashboardException {
        throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
    }

    private void addAttribute(String name, int value) {
        this.attributes.addAttribute(this.nameSpaceURI, name, name, "CDATA", String.valueOf(value));
    }

    private void addAttribute(String name, String value) {
        this.attributes.addAttribute(this.nameSpaceURI, name, name, "CDATA", value);
    }

    @Override
    public void startData(DataParameter data) throws DashboardException {
        try {
            this.attributes.addAttribute(this.nameSpaceURI, "nbcols", "nbcols", "CDATA", Integer.valueOf(data.getNbCols()).toString());
            this.contentHandler.startElement(this.nameSpaceURI, "table", this.prefix + "table", this.attributes);
            this.attributes.clear();
            this.contentHandler.startElement(this.nameSpaceURI, "definition", this.prefix + "definition", this.attributes);
            List<FieldMetaData> fmdList = data.getMetaDataList();
            for (int i = 0; i < fmdList.size(); ++i) {
                FieldMetaData fmd = fmdList.get(i);
                this.attributes.clear();
                this.addAttribute("col", i + 1);
                this.addAttribute("name", fmd.getName());
                if (fmd.getDataType() != null) {
                    this.addAttribute("datatype", fmd.getDataType().getId());
                }
                if (DataType.isNumeric((DataType)fmd.getDataType())) {
                    this.addAttribute("fieldscale", fmd.getFieldScale());
                    this.addAttribute("fieldprecision", fmd.getFieldPrecision());
                } else if (DataType.isChar((DataType)fmd.getDataType())) {
                    this.addAttribute("fieldsize", fmd.getFieldSize());
                }
                this.contentHandler.startElement(this.nameSpaceURI, "fielddefinition", this.prefix + "fielddefinition", this.attributes);
                this.contentHandler.endElement(this.nameSpaceURI, "fielddefinition", this.prefix + "fielddefinition");
            }
            this.contentHandler.endElement(this.nameSpaceURI, "definition", this.prefix + "definition");
            this.numRow = 0;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void endData(DataParameter data) throws DashboardException {
        try {
            this.contentHandler.endElement(this.nameSpaceURI, "table", this.prefix + "table");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void startRow(RowParameter row) throws DashboardException {
        try {
            ++this.numRow;
            this.attributes.clear();
            this.attributes.addAttribute(this.nameSpaceURI, "row", this.prefix + "row", "CDATA", String.valueOf(this.numRow));
            this.contentHandler.startElement(this.nameSpaceURI, "record", this.prefix + "record", this.attributes);
            List<RowCell> list = row.getCells();
            for (int i = 0; i < list.size(); ++i) {
                RowCell def = list.get(i);
                String elt = def == null || def.getValue() == null || def.getValue() instanceof ValueNull ? null : this.xmlConv.format(def.getValue().getObject());
                this.attributes.clear();
                this.attributes.addAttribute(this.nameSpaceURI, "col", "col", "CDATA", String.valueOf(i + 1));
                if (elt == null) {
                    this.attributes.addAttribute(this.nameSpaceURI, "isnull", this.prefix + "isnull", "CDATA", "1");
                    this.contentHandler.startElement(this.nameSpaceURI, "field", this.prefix + "field", this.attributes);
                } else {
                    this.contentHandler.startElement(this.nameSpaceURI, "field", this.prefix + "field", this.attributes);
                    this.contentHandler.characters(elt.toCharArray(), 0, elt.length());
                }
                this.contentHandler.endElement(this.nameSpaceURI, "field", this.prefix + "field");
            }
            this.contentHandler.endElement(this.nameSpaceURI, "record", this.prefix + "record");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void endRow(RowParameter row) throws DashboardException {
    }

    private void handleException(Exception e) throws DashboardException {
        if (e instanceof DashboardException) {
            throw (DashboardException)((Object)e);
        }
        if (e instanceof DashboardRuntimeException) {
            throw (DashboardRuntimeException)((Object)e);
        }
        log.error((Object)e);
        throw new DashboardRuntimeException(ErrorCode.INSIGHT_UNKNOWN, e.getMessage(), (Throwable)e);
    }

    @Override
    public void startRupture(RuptureParameter rupture) throws DashboardException {
    }

    @Override
    public void endRupture(RuptureParameter rupture) throws DashboardException {
    }
}

