/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class RenameFilter
extends XMLFilterImpl {
    private Map<String, String> fieldMap = new HashMap<String, String>();
    private int colNum;
    private static final Set<String> SQL92_RESERVED_WORDS = new HashSet<String>(Arrays.asList("ABSOLUTE", "ACTION", "ADD", "ALLOCATE", "ALTER", "ARE", "ASSERTION", "AT", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR_LENGTH", "CHARACTER_LENGTH", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONVERT", "CORRESPONDING", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DATE", "DAY", "DEALLOCATE", "DEFERRABLE", "DEFERRED", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DOMAIN", "DROP", "ELSE", "END-EXEC", "EXCEPT", "EXCEPTION", "EXECUTE", "EXTERNAL", "EXTRACT", "FALSE", "FIRST", "FULL", "GET", "GLOBAL", "HOUR", "IDENTITY", "IMMEDIATE", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INTERSECT", "INTERVAL", "ISOLATION", "JOIN", "LAST", "LEADING", "LEFT", "LEVEL", "LOCAL", "LOWER", "MATCH", "MINUTE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NULLIF", "OCTET_LENGTH", "ONLY", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PREPARE", "PRESERVE", "PRIOR", "READ", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROWS", "SCROLL", "SECOND", "SESSION", "SESSION_USER", "SIZE", "SPACE", "SQLSTATE", "SUBSTRING", "SYSTEM_USER", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNKNOWN", "UPPER", "USAGE", "USING", "VALUE", "VARCHAR", "VARYING", "WHEN", "WRITE", "YEAR", "ZONE"));

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.fieldMap.clear();
        this.colNum = 0;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.isElement(uri, localName, name, "fielddefinition")) {
            String colName = this.getValue(atts, uri, "name");
            String newColName = this.getName(colName);
            ++this.colNum;
            this.fieldMap.put(newColName, colName);
            AttributesImpl newAtts = new AttributesImpl(atts);
            int nameIndex = newAtts.getIndex(uri, "name");
            newAtts.setValue(nameIndex, newColName);
            super.startElement(uri, localName, name, newAtts);
        } else {
            super.startElement(uri, localName, name, atts);
        }
    }

    private String getName(String colName) {
        String c;
        StringBuilder sb = new StringBuilder();
        if (colName != null) {
            boolean p = false;
            for (char c2 : colName.toCharArray()) {
                if (c2 >= '0' && c2 <= '9' && sb.length() != 0) {
                    sb.append(c2);
                    p = false;
                    continue;
                }
                if (c2 >= 'a' && c2 <= 'z') {
                    sb.append(c2);
                    p = false;
                    continue;
                }
                if (c2 >= 'A' && c2 <= 'Z') {
                    sb.append(Character.toLowerCase(c2));
                    p = false;
                    continue;
                }
                if (c2 == '\u00e9' || c2 == '\u00c9' || c2 == '\u00e8' || c2 == '\u00c8' || c2 == '\u00ea' || c2 == '\u00ca' || c2 == '\u00eb' || c2 == '\u00cb') {
                    sb.append('e');
                    p = false;
                    continue;
                }
                if (c2 == '\u00f9' || c2 == '\u00d9' || c2 == '\u00fb' || c2 == '\u00db') {
                    sb.append('u');
                    p = false;
                    continue;
                }
                if (c2 == '\u00e7' || c2 == '\u00c7') {
                    sb.append('c');
                    p = false;
                    continue;
                }
                if (c2 == '\u00e0' || c2 == '\u00c0') {
                    sb.append('a');
                    p = false;
                    continue;
                }
                if (p || sb.length() == 0) continue;
                sb.append("_");
                p = true;
            }
        }
        if ((c = sb.toString()).isEmpty() || this.fieldMap.containsKey(sb.toString()) || SQL92_RESERVED_WORDS.contains(sb.toString().toUpperCase())) {
            return "col" + this.colNum;
        }
        return c;
    }

    private String getValue(Attributes atts, String uri, String name) {
        String value = atts.getValue(name);
        if (value != null) {
            return value;
        }
        return atts.getValue(uri, name);
    }

    private boolean isElement(String uri, String localName, String name, String elt) {
        return elt != null && (elt.equals(localName) || elt.equals(name));
    }

    public Map<String, String> getFieldMap() {
        return new HashMap<String, String>(this.fieldMap);
    }
}

