/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operation.OperationSelect;
import com.prelytis.dashboard.db.operator.OperatorSelect;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class TableReader
implements XMLReader {
    private static final Logger log = LogManager.getLogger(TableReader.class);
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private AttributesImpl attributes = new AttributesImpl();
    private ConversionHelper xmlConv = ConversionHelper.getXMLConverter();
    private DTDHandler handler;
    private EntityResolver entityResolver;
    private String nameSpaceURI = "";
    private String prefix = "";
    private final SQLTable table;
    private final DataSource ds;
    private boolean fNamespaces = false;
    private boolean fNamespacePrefixes = false;

    public TableReader(DataSource ds, SQLTable table) {
        this.table = table;
        this.ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        try {
            this.attributes.clear();
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(this.prefix, "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd");
            List fmdList = this.table.getFieldList();
            this.attributes.addAttribute(this.nameSpaceURI, "nbcols", this.prefix + "nbcols", "CDATA", Integer.toString(fmdList.size()));
            this.attributes.addAttribute(this.nameSpaceURI, "name", this.prefix + "name", "CDATA", this.table.getName());
            this.contentHandler.startElement(this.nameSpaceURI, "table", this.prefix + "table", this.attributes);
            this.attributes.clear();
            this.contentHandler.startElement(this.nameSpaceURI, "definition", this.prefix + "definition", this.attributes);
            for (int i = 0; i < fmdList.size(); ++i) {
                FieldMetaData fmd = (FieldMetaData)fmdList.get(i);
                this.attributes.clear();
                this.addAttribute("col", i + 1);
                this.addAttribute("name", fmd.getName());
                if (fmd.getDataType() != null) {
                    this.addAttribute("datatype", fmd.getDataType().getId());
                }
                this.addAttribute("nullable", fmd.isNullable() ? "1" : "0");
                if (DataType.isNumeric((DataType)fmd.getDataType())) {
                    if (fmd.getFieldPrecision() > 0) {
                        this.addAttribute("fieldscale", fmd.getFieldScale());
                        this.addAttribute("fieldprecision", fmd.getFieldPrecision());
                    }
                } else if (DataType.isChar((DataType)fmd.getDataType())) {
                    this.addAttribute("fieldsize", fmd.getFieldSize());
                }
                this.contentHandler.startElement(this.nameSpaceURI, "fielddefinition", this.prefix + "fielddefinition", this.attributes);
                this.contentHandler.endElement(this.nameSpaceURI, "fielddefinition", this.prefix + "fielddefinition");
            }
            this.contentHandler.endElement(this.nameSpaceURI, "definition", this.prefix + "definition");
            try (Connection con = this.ds.getConnection();){
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT ");
                boolean first = true;
                for (FieldMetaData fmd : this.table.getFieldList()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(fmd.getName());
                }
                sb.append(" FROM ").append(this.table.getName());
                QuerySQL querySQL = new QuerySQL();
                querySQL.setQueryString(sb.toString());
                querySQL.getFieldList().addAll(this.table.getFieldList());
                OperationSelect operation = new OperationSelect();
                operation.setQuerySQL(querySQL);
                OperatorSelect os = new OperatorSelect(operation);
                os.setConnection(con);
                os.init();
                int numRow = 0;
                while (os.next()) {
                    this.attributes.clear();
                    this.attributes.addAttribute(this.nameSpaceURI, "row", this.prefix + "row", "CDATA", String.valueOf(numRow));
                    this.contentHandler.startElement(this.nameSpaceURI, "record", this.prefix + "record", this.attributes);
                    int i = 1;
                    for (Value value : os.getRow()) {
                        String elt = value == null || value instanceof ValueNull ? null : this.xmlConv.format(value.getObject());
                        this.attributes.clear();
                        this.attributes.addAttribute(this.nameSpaceURI, "col", "col", "CDATA", String.valueOf(i));
                        if (elt == null) {
                            this.attributes.addAttribute(this.nameSpaceURI, "isnull", this.prefix + "isnull", "CDATA", "1");
                            this.contentHandler.startElement(this.nameSpaceURI, "field", this.prefix + "field", this.attributes);
                        } else {
                            this.contentHandler.startElement(this.nameSpaceURI, "field", this.prefix + "field", this.attributes);
                            this.contentHandler.characters(elt.toCharArray(), 0, elt.length());
                        }
                        this.contentHandler.endElement(this.nameSpaceURI, "field", this.prefix + "field");
                        ++i;
                    }
                    this.contentHandler.endElement(this.nameSpaceURI, "record", this.prefix + "record");
                }
                os.close();
            }
            this.contentHandler.endElement(this.nameSpaceURI, "table", this.prefix + "table");
            this.contentHandler.endPrefixMapping(this.prefix);
            this.contentHandler.endDocument();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new SAXException(e);
        }
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.handler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.handler = handler;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public void setFeature(String name, boolean value) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.fNamespaces = value;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.fNamespacePrefixes = value;
        }
        if (this.fNamespacePrefixes && this.fNamespaces) {
            this.nameSpaceURI = "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd";
            this.prefix = "dm:";
        } else {
            this.nameSpaceURI = "";
            this.prefix = "";
        }
    }

    @Override
    public boolean getFeature(String name) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.fNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.fNamespacePrefixes;
        }
        return false;
    }

    private void addAttribute(String name, int value) {
        this.attributes.addAttribute(this.nameSpaceURI, name, name, "CDATA", String.valueOf(value));
    }

    private void addAttribute(String name, String value) {
        this.attributes.addAttribute(this.nameSpaceURI, name, name, "CDATA", value);
    }
}

