/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.TaskHelper;
import com.prelytis.dashboard.task.AbstractTaskExecution;
import com.prelytis.dashboard.task.TaskDataMartTransformer;
import com.prelytis.dashboard.task.TaskEvent;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.TaskExecutionListener;
import com.prelytis.dashboard.task.datamart.TaskDataMartTransformerFactory;
import com.prelytis.dashboard.util.Compare;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanTaskDataMart;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.structure.Task;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class TaskDataMartExecution
extends AbstractTaskExecution {
    public TaskDataMartExecution(MessageListener messageListener, TaskExecutionListener listener) {
        super(messageListener, listener);
    }

    @Override
    public int execute(DaoFactory daoFactory, Task task) throws TaskExecutionException {
        BeanTaskDataMart datamart;
        int retVal = 0;
        TaskHelper taskHelper = TaskHelper.getInstance(daoFactory);
        try {
            datamart = (BeanTaskDataMart)taskHelper.getDefinition(task.getName());
        }
        catch (DashboardException de) {
            throw new TaskExecutionException((Exception)((Object)de), false);
        }
        TaskDataMartTransformerFactory factory = new TaskDataMartTransformerFactory();
        TaskDataMartTransformer transformer = factory.getTransformer(daoFactory, datamart, this.messageListener);
        ExpressionEvaluationDataHelper helper = ExpressionEvaluationDataHelper.getInstance(daoFactory);
        switch (datamart.getExecOn()) {
            case 1: {
                try {
                    this.addMessage(1, "taskMsg.uniqueExecution", null);
                    ExpressionEvaluationData data = helper.getDefaultData();
                    retVal = Math.min(retVal, this.execute(transformer, task.getName(), data));
                }
                catch (Exception e) {
                    retVal = -2;
                }
                break;
            }
            case 2: {
                List list;
                this.addMessage(1, "taskMsg.allEntitiesExecution", null);
                EntityDao entityDao = daoFactory.getEntityDao();
                try {
                    DbEntityFilter f = new DbEntityFilter();
                    f.setActive(Boolean.TRUE);
                    list = entityDao.listAll((DbDefaultFilter)f, 1);
                }
                catch (Exception e) {
                    throw new TaskExecutionException(e, false);
                }
                for (int i = 0; i < list.size(); ++i) {
                    BeanEntity entity = (BeanEntity)list.get(i);
                    try {
                        this.addMessage(1, "taskMsg.entityExecution", entity.getName());
                        ExpressionEvaluationData data = helper.getExpressionEvaluationData(entity);
                        retVal = Math.min(retVal, this.execute(transformer, task.getName(), data));
                        continue;
                    }
                    catch (Exception e) {
                        retVal = -2;
                    }
                }
                break;
            }
            case 3: {
                List list;
                this.addMessage(1, "taskMsg.EntitiesExecution", null);
                EntityDao entityDao = daoFactory.getEntityDao();
                ConversionHelper conversionHelper = ConversionHelper.getDBConverter();
                try {
                    DbEntityFilter f = new DbEntityFilter();
                    f.setActive(Boolean.TRUE);
                    list = entityDao.listAll((DbDefaultFilter)f, 1);
                }
                catch (Exception e) {
                    throw new TaskExecutionException(e, false);
                }
                for (int i = 0; i < list.size(); ++i) {
                    BeanEntity entity = (BeanEntity)list.get(i);
                    try {
                        ExpressionEvaluationData data = helper.getExpressionEvaluationData(entity);
                        BeanPersFieldValue persFieldValue = this.getPersFieldValue(data.getPersFieldList(), datamart.getFieldOID());
                        Object value = persFieldValue.getValues();
                        Object v = null;
                        if (value instanceof Object[]) {
                            Object[] values = (Object[])value;
                            if (values != null && values.length > 0) {
                                v = values[0];
                            }
                        } else {
                            v = value;
                        }
                        Object refValue = null;
                        try {
                            refValue = conversionHelper.parse(persFieldValue.getDataType(), datamart.getFieldValue());
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (!Compare.compare((Object)v, (int)datamart.getFieldOperator(), (Object)refValue)) continue;
                        retVal = Math.min(retVal, this.execute(transformer, task.getName(), data));
                        continue;
                    }
                    catch (Exception e) {
                        retVal = -2;
                    }
                }
                break;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(TaskDataMartTransformer transformer, String taskName, ExpressionEvaluationData data) {
        int status = -3;
        TaskEvent event = this.startTask(taskName, data.getEntityName());
        try {
            if (data.getEntityName() != null) {
                this.addMessage(1, "taskMsg.entityExecution", data.getEntityName());
            }
            status = transformer.transform(data);
        }
        catch (Exception e) {
            log.error((Object)("Task '" + taskName + "' : " + (e.getMessage() != null ? e.getMessage() : e.toString())));
            status = -2;
        }
        finally {
            this.endTask(event, status);
        }
        return status;
    }

    private TaskEvent startTask(String name, String entity) {
        TaskEvent current = new TaskEvent();
        current.setStart(new Date());
        current.setEntityName(entity);
        current.setTaskName(name);
        current.setTaskType(TaskType.TASK_TYPE_DATAMART);
        this.startTask(current);
        return current;
    }

    private void endTask(TaskEvent event, int status) {
        event.setEnd(new Date());
        event.setStatus(status);
        this.endTask(event);
    }
}

