/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.dao.TaskExecutionDao;
import com.prelytis.dashboard.helper.AbstractMessageListener;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TaskLogger
extends AbstractMessageListener {
    private final TaskExecutionDao dao;
    private final int taskOid;
    private int msgId;

    public TaskLogger(TaskExecutionDao dao, int taskOid) {
        super(Configuration.getInstance().getDefaultLocale());
        this.taskOid = taskOid;
        this.dao = dao;
        try {
            this.dao.deleteMessages(taskOid);
        }
        catch (Exception e) {
            Logger log = LogManager.getLogger(this.getClass());
            log.error((Object)e);
        }
    }

    @Override
    public void log(ExecutionMessage message) {
        Logger log = LogManager.getLogger(this.getClass());
        log.info((Object)this.getMessage(message));
        try {
            this.dao.saveMessage(this.taskOid, ++this.msgId, message);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

