/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.LengthUnitDao;
import com.prelytis.dashboard.dao.MetricEntityDao;
import com.prelytis.dashboard.dao.MetricResultDao;
import com.prelytis.dashboard.dao.PageLayoutDao;
import com.prelytis.dashboard.dao.ThemeDao;
import com.prelytis.dashboard.dao.TimeUnitDao;
import com.prelytis.dashboard.dao.UserDao;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbUserFilter;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.helper.EngineHelper;
import com.prelytis.dashboard.data.transformation.DataTransformer;
import com.prelytis.dashboard.data.transformation.MetricDataHandler;
import com.prelytis.dashboard.data.transformation.ResultsetDataReader;
import com.prelytis.dashboard.db.operation.OperationFinal;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.document.factory.PDFiTextFactoryTable;
import com.prelytis.dashboard.document.factory.PageLayout;
import com.prelytis.dashboard.document.factory.XLSFactoryTable;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.helper.ReportDocumentHelper;
import com.prelytis.dashboard.helper.SeverityHelper;
import com.prelytis.dashboard.helper.TableHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.message.AbstractSendMessage;
import com.prelytis.dashboard.message.Message;
import com.prelytis.dashboard.message.MessageAttachment;
import com.prelytis.dashboard.message.MessageBody;
import com.prelytis.dashboard.message.MessageSubject;
import com.prelytis.dashboard.message.SendMessageListHelper;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.MetricHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.model.helper.StyleHelper;
import com.prelytis.dashboard.persistence.helper.ListHelper;
import com.prelytis.dashboard.security.util.SettingsHelper;
import com.prelytis.dashboard.task.AIPreparedQuery;
import com.prelytis.dashboard.task.AbstractTaskExecution;
import com.prelytis.dashboard.task.TaskExceptionHandler;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.TaskExecutionListener;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.ThresholdHelper;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.AbstractBeanReportFilter;
import com.prelytis.dashboard.value.data.BeanLengthUnit;
import com.prelytis.dashboard.value.data.BeanPRPInfo;
import com.prelytis.dashboard.value.data.BeanPageLayout;
import com.prelytis.dashboard.value.data.BeanReport;
import com.prelytis.dashboard.value.data.BeanReportCrossTable;
import com.prelytis.dashboard.value.data.BeanReportDataUsedField;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.BeanStyleDefinition;
import com.prelytis.dashboard.value.data.BeanTaskMetric;
import com.prelytis.dashboard.value.data.BeanTaskMetricEntity;
import com.prelytis.dashboard.value.data.BeanTaskMetricResult;
import com.prelytis.dashboard.value.data.BeanThemeDefinition;
import com.prelytis.dashboard.value.data.BeanTimeUnit;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserDefinition;
import com.prelytis.dashboard.value.data.BeanUserMessageType;
import com.prelytis.dashboard.value.data.BeanWorkspaceMetricLevel;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.structure.AbstractDocument;
import com.prelytis.dashboard.value.structure.ImageDocument;
import com.prelytis.dashboard.value.structure.ReportDocument;
import com.prelytis.dashboard.value.structure.Task;
import com.prelytis.dashboard.value.util.Expression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.Severity;
import com.prelytis.dashboard.value.util.Threshold;
import com.prelytis.dashboard.value.util.ThresholdInterval;
import com.prelytis.dashboard.value.util.ThresholdUsage;
import com.prelytis.dashboard.value.util.Thresholds;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;

public class TaskMetricExecution
extends AbstractTaskExecution {
    public TaskMetricExecution(MessageListener messageListener, TaskExecutionListener listener) {
        super(messageListener, listener);
    }

    @Override
    public int execute(DaoFactory daoFactory, Task task) throws TaskExecutionException {
        log.debug((Object)"Entering TaskControlExecution.execute");
        try {
            BeanPRPInfo info = daoFactory.getPrelytisInfoDao().getPrelytisInfo();
            MetricHelper metricHelper = MetricHelper.getInstance(daoFactory);
            BeanTaskMetric taskMetric = metricHelper.getDefinition(task.getName());
            ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
            AbstractBeanReport report = reportHelper.getDefinition(taskMetric.getCalculationReportName());
            AbstractBeanReport analysisReport = null;
            if (taskMetric.getAnalysisReportName() != null) {
                analysisReport = reportHelper.getDefinition(taskMetric.getAnalysisReportName());
            }
            Date plannedDate = taskMetric.getPlannedDate();
            TimeUnitDao timeUnitDao = daoFactory.getTimeUnitDao();
            BeanTimeUnit timeUnit = (BeanTimeUnit)timeUnitDao.getCore(taskMetric.getStoreDurationTimeUnitOID());
            int fact = taskMetric.getStoreDuration() * timeUnit.getConvFactor();
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            if (plannedDate != null) {
                calendar.setTime(plannedDate);
            }
            calendar.add(timeUnit.getConvField().getId(), -fact);
            BeanTimeUnit trendTU = timeUnit;
            if (timeUnit.getObjectID() != taskMetric.getTrendTimeUnitOID()) {
                trendTU = (BeanTimeUnit)timeUnitDao.getCore(taskMetric.getTrendTimeUnitOID());
            }
            fact = taskMetric.getTrendNbPer() * trendTU.getConvFactor();
            if (plannedDate != null) {
                calendar.setTime(plannedDate);
            }
            calendar.add(trendTU.getConvField().getId(), -fact);
            Date refDate = calendar.getTime();
            if (report instanceof BeanReportStd) {
                return this.execute(daoFactory, taskMetric, (BeanReportStd)report, analysisReport, refDate, info);
            }
            return this.execute(daoFactory, taskMetric, (BeanReportCrossTable)report, analysisReport, refDate, info);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new TaskExecutionException(e, true);
        }
    }

    private int execute(DaoFactory daoFactory, BeanTaskMetric task, BeanReportCrossTable report, AbstractBeanReport analysisReport, Date refDate, BeanPRPInfo info) throws TaskExecutionException {
        String fieldName = task.getQueryFieldName();
        FieldAgregation agregation = task.getAgregation();
        int fieldNum = -1;
        int status = 0;
        List fieldList = report.getDataFieldList();
        AbstractBeanReportAvlField ctrlField = null;
        for (int i = 0; i < fieldList.size(); ++i) {
            BeanReportDataUsedField usedField = (BeanReportDataUsedField)fieldList.get(i);
            AbstractBeanReportAvlField field = usedField.getField();
            FieldAgregation ufAgregation = FieldAgregation.AGREGATION_NONE;
            if (usedField.getAgregation() != null) {
                ufAgregation = usedField.getAgregation();
            }
            if (!fieldName.equals(field.getName()) || agregation != ufAgregation) continue;
            fieldNum = report.getSectionList().size() + i;
            ctrlField = field;
        }
        if (fieldNum < 0) {
            this.addMessage(3, "taskMsg.fieldNotFound", task.getFieldName());
            return -2;
        }
        Map<AIPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>> queryMap = this.getQueryMap(daoFactory, task, (AbstractBeanReport)report);
        for (Map.Entry<AIPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>> entry : queryMap.entrySet()) {
            try {
                AIPreparedQuery aiPreparedQuery = entry.getKey();
                Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>> thresholdMap = entry.getValue();
                int localStatus = this.getStatus(daoFactory, task, aiPreparedQuery, thresholdMap, fieldNum, refDate, analysisReport, ctrlField, info);
                status = Math.min(status, localStatus);
            }
            catch (Exception e) {
                status = -2;
                this.addMessage(3, "taskMsg.errExecuTask", null);
                log.error((Object)e);
            }
        }
        return status;
    }

    private int execute(DaoFactory daoFactory, BeanTaskMetric task, BeanReportStd report, AbstractBeanReport analysisReport, Date refDate, BeanPRPInfo info) throws TaskExecutionException {
        String fieldName = task.getQueryFieldName();
        FieldAgregation agregation = task.getAgregation();
        int fieldNum = -1;
        int status = 0;
        List fieldList = report.getFieldList();
        AbstractBeanReportAvlField ctrlField = null;
        for (int i = 0; i < fieldList.size(); ++i) {
            BeanReportStdUsedField usedField = (BeanReportStdUsedField)fieldList.get(i);
            AbstractBeanReportAvlField field = usedField.getField();
            FieldAgregation ufAgregation = FieldAgregation.AGREGATION_NONE;
            if (usedField.getAgregation() != null) {
                ufAgregation = usedField.getAgregation();
            }
            if (!fieldName.equals(field.getName()) || agregation != ufAgregation) continue;
            fieldNum = report.getSectionList().size() + i;
            ctrlField = field;
        }
        if (fieldNum < 0) {
            this.addMessage(3, "taskMsg.fieldNotFound", task.getFieldName());
            return -2;
        }
        try {
            Map<AIPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>> queryMap = this.getQueryMap(daoFactory, task, (AbstractBeanReport)report);
            for (Map.Entry<AIPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>> entry : queryMap.entrySet()) {
                try {
                    AIPreparedQuery aiPreparedQuery = entry.getKey();
                    Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>> thresholdMap = entry.getValue();
                    int localStatus = Math.min(status, this.getStatus(daoFactory, task, aiPreparedQuery, thresholdMap, fieldNum, refDate, analysisReport, ctrlField, info));
                    status = Math.min(status, localStatus);
                }
                catch (Exception e) {
                    status = -2;
                    this.addMessage(3, "taskMsg.errExecuTask", null);
                    log.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            status = -2;
            this.addMessage(3, "taskMsg.errExecuTask", null);
            log.error((Object)e);
        }
        return status;
    }

    private int getStatus(DaoFactory daoFactory, BeanTaskMetric task, AIPreparedQuery aiPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>> thresholdMap, int col, Date refDate, AbstractBeanReport analysisReport, AbstractBeanReportAvlField ctrlField, BeanPRPInfo info) throws TaskExecutionException {
        Result result = null;
        int[] severities = new int[thresholdMap.size()];
        BigDecimal metric = BigDecimal.ZERO;
        int status = -3;
        ThresholdsAndTarget[] thresholdsAndTarget = new ThresholdsAndTarget[thresholdMap.size()];
        int cpt = 0;
        for (ThresholdsAndTarget tat : thresholdMap.keySet()) {
            thresholdsAndTarget[cpt++] = tat;
        }
        try {
            EngineHelper engineHelper = EngineHelper.getInstance(daoFactory);
            result = engineHelper.getResult(aiPreparedQuery.getOperation());
            ResultsetDataReader dataReader = new ResultsetDataReader(result);
            MetricDataHandler handler = new MetricDataHandler();
            handler.setCol(col);
            handler.setCalcMode(task.getCalcMode());
            handler.setCalcExtent(task.getCalcExtent());
            DataTransformer transformer = new DataTransformer();
            transformer.transform(dataReader, handler);
            metric = handler.getMetric();
            TaskMetricExecution.updateSeverities(severities, thresholdsAndTarget, metric);
            status = 0;
        }
        catch (Exception e) {
            status = e instanceof TaskExecutionException ? ((TaskExecutionException)e).getStatus() : -2;
            throw this.getException(e);
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
            int localStatus = this.saveStatus(daoFactory, task, thresholdMap, thresholdsAndTarget, refDate, status, severities, metric, analysisReport, ctrlField, info);
            status = Math.min(status, localStatus);
        }
        return status;
    }

    public static void updateSeverities(int[] severities, ThresholdsAndTarget[] thresholdsAndTarget, Object value) {
        for (int i = 0; i < thresholdsAndTarget.length; ++i) {
            Severity newSeverity = SeverityHelper.getSeverity(thresholdsAndTarget[i].thresholds, value);
            if (newSeverity.getSeverity() <= severities[i]) continue;
            severities[i] = newSeverity.getSeverity();
        }
    }

    private int saveStatus(DaoFactory daoFactory, BeanTaskMetric task, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>> thresholdMap, ThresholdsAndTarget[] thresholdsAndTarget, Date targetDate, int status, int[] severities, BigDecimal metric, AbstractBeanReport analysisReport, AbstractBeanReportAvlField ctrlField, BeanPRPInfo info) {
        int localStatus = 0;
        if (severities == null) {
            severities = new int[thresholdsAndTarget.length];
        }
        for (int i = 0; i < thresholdsAndTarget.length; ++i) {
            Map<Integer, List<UserInfo>> entityMap = thresholdMap.get(thresholdsAndTarget[i]);
            try {
                localStatus = Math.min(localStatus, this.saveStatus(daoFactory, task, entityMap.entrySet(), thresholdsAndTarget[i], targetDate, status, severities[i], metric, analysisReport, ctrlField, info));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)e);
                this.addMessage(1, e.getMessage());
                localStatus = -1;
            }
        }
        return localStatus;
    }

    private int saveStatus(DaoFactory daoFactory, BeanTaskMetric task, Set<Map.Entry<Integer, List<UserInfo>>> entities, ThresholdsAndTarget thresholdsAndTarget, Date targetDate, int status, int severity, BigDecimal metric, AbstractBeanReport analysisReport, AbstractBeanReportAvlField ctrlField, BeanPRPInfo info) throws DashboardException {
        int localStatus = 0;
        ThresholdUsage thresholdUsage = new ThresholdUsage();
        thresholdUsage.setRemoveInfo(task.getRemoveInfoLines());
        thresholdUsage.setFieldName(task.getQueryFieldName());
        thresholdUsage.setAgregation(task.getAgregation());
        thresholdUsage.setThresholds(thresholdsAndTarget.thresholds);
        MessageSender ms = new MessageSender(daoFactory, thresholdUsage, analysisReport, ctrlField);
        MetricResultDao metricResultDao = daoFactory.getMetricResultDao();
        for (Map.Entry<Integer, List<UserInfo>> entry : entities) {
            Integer entity = entry.getKey();
            try {
                metricResultDao.saveHistory(entity.intValue(), task.getObjectID(), task.getPlannedDate() != null ? task.getPlannedDate() : targetDate, metric);
            }
            catch (Exception e) {
                status = -1;
                localStatus = Math.min(status, localStatus);
                this.addMessage(2, "taskMsg.errSaveHist", null);
                log.warn((Object)e);
            }
            BeanTaskMetricResult result = metricResultDao.open(task, entity.intValue());
            result.setPreviousCalcValue(result.getCalcValue());
            result.setCalcThresholdTypeOID(task.getThresholdTypeOID());
            result.setCalcThresholdTypeName(task.getThresholdTypeName());
            result.setCalcThresholds(thresholdsAndTarget.thresholds);
            result.setCalcTargetValue(thresholdsAndTarget.targetValue);
            result.setCalcValue(severity);
            result.setCalcStatus(status);
            result.setCalcDate(new Date());
            result.setMetric(metric);
            result.setTrend(metricResultDao.calcTrend(entity.intValue(), task.getObjectID(), targetDate, metric));
            metricResultDao.save(result);
            for (UserInfo userInfo : entry.getValue()) {
                try {
                    boolean[][] msgPolicy = task.getMessagePolicy();
                    if (!userInfo.getSendMessage() || !msgPolicy[result.getPreviousCalcValue()][result.getCalcValue()]) continue;
                    localStatus = Math.min(localStatus, ms.send(result, userInfo, info));
                }
                catch (Exception ex) {
                    log.warn((Object)ex);
                    this.addMessage(1, ex.getMessage());
                    localStatus = Math.min(localStatus, -1);
                }
            }
        }
        return localStatus;
    }

    private Map<AIPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>> getQueryMap(DaoFactory daoFactory, BeanTaskMetric task, AbstractBeanReport report) throws TaskExecutionException {
        try {
            WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
            List metricLevelList = workspaceDao.listMetricLevelForTask(task.getObjectID());
            Map additionalUserMap = ListHelper.getInstance().getMapById(task.getMessageUserList());
            if (metricLevelList.size() == 0 && additionalUserMap.size() == 0) {
                this.addMessage(2, "taskMsg.nobodyConcerned", null);
                throw new TaskExecutionException("No body is concerned by this task", 1);
            }
            boolean sendMessageToWorkspace = task.getSendMessage() == 2 || task.getSendMessage() == 3;
            boolean sendMessageToUser = task.getSendMessage() == 1 || task.getSendMessage() == 3;
            Helper helper = new Helper(daoFactory, task);
            ExpressionEvaluationDataHelper dh = ExpressionEvaluationDataHelper.getInstance(daoFactory);
            UserDao userDao = daoFactory.getUserDao();
            DbUserFilter userFilter = new DbUserFilter();
            boolean isPassportFGAC = SettingsHelper.getInstance().usesPassportAuthorization();
            for (int i = 0; i < metricLevelList.size(); ++i) {
                BeanWorkspaceMetricLevel metricLevel = (BeanWorkspaceMetricLevel)metricLevelList.get(i);
                userFilter.setWorkspaceOid(Integer.valueOf(metricLevel.getObjectID()));
                userFilter.setActive(Boolean.TRUE);
                List userList = userDao.listAll((DbDefaultFilter)userFilter, 2);
                for (int j = 0; j < userList.size(); ++j) {
                    boolean sendMessage;
                    BeanUserDefinition user = (BeanUserDefinition)userList.get(j);
                    Object tmp = additionalUserMap.remove(user.getObjectID());
                    boolean userMsgAccess = user.getMsgAccess();
                    if (isPassportFGAC) {
                        log.debug((Object)"PassPort FGAC is used, setting user messaging access to true.");
                        userMsgAccess = true;
                    }
                    boolean bl = sendMessage = (tmp != null && sendMessageToUser || sendMessageToWorkspace) && userMsgAccess;
                    if (metricLevel.getAccessLevel() == 0) continue;
                    ExpressionEvaluationData data = dh.getExpressionEvaluationData((BeanUser)user);
                    helper.addUser(daoFactory, data, user.getBeanUserMessageTypeList(), sendMessage);
                }
            }
            if (additionalUserMap.size() > 0) {
                userFilter = new DbUserFilter();
                Integer[] tmp = new Integer[additionalUserMap.keySet().size()];
                userFilter.setObjectId(additionalUserMap.keySet().toArray(tmp));
                List userList = userDao.listAll((DbDefaultFilter)userFilter, 2);
                for (int j = 0; j < userList.size(); ++j) {
                    BeanUserDefinition user = (BeanUserDefinition)userList.get(j);
                    ExpressionEvaluationData data = dh.getExpressionEvaluationData((BeanUser)user);
                    boolean userMsgAccess = user.getMsgAccess();
                    if (isPassportFGAC) {
                        log.debug((Object)"PassPort FGAC is used, setting user messaging access to true.");
                        userMsgAccess = true;
                    }
                    helper.addUser(daoFactory, data, user.getBeanUserMessageTypeList(), sendMessageToUser && userMsgAccess);
                }
            }
            return helper.getMap();
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private List<ReportFilter> getReportFilterList(DaoFactory daoFactory, AbstractBeanReport report, IQueryDefinition query, ExpressionEvaluationData data) throws DashboardException {
        ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
        List<ReportFilter> list = reportHelper.getFilterList(report, query, data);
        return TaskMetricExecution.cleanValueList(list, new ArrayList<ReportFilter>(), data);
    }

    public static List<ReportFilter> cleanValueList(List<ReportFilter> filterList, List<ReportFilter> valueFilterList, ExpressionEvaluationData data) throws DashboardException {
        HashMap<String, ReportFilter> map = new HashMap<String, ReportFilter>();
        for (ReportFilter filter : valueFilterList) {
            map.put(filter.getName(), filter);
        }
        return TaskMetricExecution.cleanValueList(filterList, map, data);
    }

    public static List<ReportFilter> cleanValueList(List<ReportFilter> filterList, Map<String, ReportFilter> valueFilterMap, ExpressionEvaluationData data) throws DashboardException {
        if (filterList == null) {
            return null;
        }
        ArrayList<ReportFilter> dstFilterList = new ArrayList<ReportFilter>();
        for (int i = 0; i < filterList.size(); ++i) {
            ReportFilter filterValue;
            ReportFilter filter = filterList.get(i);
            if (!filter.isVisible()) continue;
            Object[] values = filter.getValues();
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    if (!(values[j] instanceof Expression)) continue;
                    values[j] = ExpressionEvaluationHelper.getInstance().evaluateExpression((Expression)values[j], data);
                }
            }
            if ((filterValue = valueFilterMap.get(filter.getName())) != null) {
                filter.setUseFilter(filterValue.getUseFilter());
                if (filterValue.getUseFilter()) {
                    filter.setValues(filterValue.getValues());
                }
            }
            dstFilterList.add(filter);
        }
        return dstFilterList;
    }

    private class MessageSender {
        private TableHelper tableHelper;
        private AbstractBeanReport analysisReport;
        private AbstractBeanReportAvlField field;
        private BeanStyleDefinition style;
        private final DaoFactory daoFactory;

        public MessageSender(DaoFactory daoFactory, ThresholdUsage thresholdUsage, AbstractBeanReport analysisReport, AbstractBeanReportAvlField field) throws DashboardException {
            this.analysisReport = analysisReport;
            this.field = field;
            this.daoFactory = daoFactory;
            if (analysisReport != null) {
                StyleHelper styleHelper = StyleHelper.getInstance(daoFactory);
                this.style = styleHelper.getDefinition(analysisReport.getStyleName());
                this.tableHelper = TableHelper.getInstance(daoFactory);
                this.tableHelper.setReport(analysisReport);
            }
        }

        public int send(BeanTaskMetricResult metricResult, UserInfo userInfo, BeanPRPInfo info) throws DashboardException {
            ExpressionEvaluationData data = userInfo.getData();
            int sendStatus = -3;
            if (metricResult.getMessageAttachmentType() != null && this.analysisReport != null) {
                List<ReportFilter> reportFilterList;
                this.tableHelper.setData(data);
                QueryHelper queryHelper = QueryHelper.getInstance(this.daoFactory);
                IQueryDefinition query = queryHelper.getFinal(this.analysisReport.getQueryOID());
                if (query.getQueryType() == 2) {
                    reportFilterList = TaskMetricExecution.this.getReportFilterList(this.daoFactory, this.analysisReport, query, data);
                } else {
                    reportFilterList = new ArrayList();
                    List beanReportFilterList = this.analysisReport.getFilterList();
                    for (int i = 0; i < beanReportFilterList.size(); ++i) {
                        AbstractBeanReportFilter flt = (AbstractBeanReportFilter)beanReportFilterList.get(i);
                        ReportFilter filter = new ReportFilter();
                        filter.setDatatype(flt.getDataType());
                        filter.setDescription((String)flt.getDescriptionMap().get(data.getLocale()));
                        filter.setName(flt.getName());
                        reportFilterList.add(filter);
                    }
                }
                ReportDocumentHelper.Builder rdhb = new ReportDocumentHelper.Builder(this.daoFactory, new TaskExceptionHandler(), this.analysisReport, data, false);
                rdhb.filterList(reportFilterList);
                ReportDocumentHelper rdh = rdhb.build(this.tableHelper, this.analysisReport.getExecutionMode());
                ReportDocument reportDocument = rdh.getReportDocument();
                switch (metricResult.getMessageAttachmentType()) {
                    case PDF: {
                        PDFiTextFactoryTable pdfFactory = new PDFiTextFactoryTable(this.daoFactory, (AbstractDocument)reportDocument, data.getLocale(), this.getPageLayout(data), data.getPersFieldList());
                        pdfFactory.setReportFilterList(reportFilterList);
                        pdfFactory.setDisplayReportTop(info.isDisplayReportFilterTop());
                        sendStatus = this.sendMessage(userInfo, metricResult, pdfFactory.getImageDocument());
                        break;
                    }
                    case XLS: {
                        ThemeDao themDao = this.daoFactory.getThemeDao();
                        BeanThemeDefinition theme = (BeanThemeDefinition)themDao.getDefinition(data.getThemeOid().intValue());
                        XLSFactoryTable xlsFactory = new XLSFactoryTable((AbstractDocument)reportDocument, data.getLocale(), this.style, theme, data.getPersFieldList());
                        sendStatus = this.sendMessage(userInfo, metricResult, xlsFactory.getImageDocument());
                    }
                }
            } else {
                sendStatus = this.sendMessage(userInfo, metricResult, null);
            }
            return sendStatus;
        }

        private PageLayout getPageLayout(ExpressionEvaluationData data) {
            ThemeDao themeDao = this.daoFactory.getThemeDao();
            BeanThemeDefinition theme = (BeanThemeDefinition)themeDao.getDefinition(data.getThemeName());
            PageLayoutDao pageLayoutDao = this.daoFactory.getPageLayoutDao();
            BeanPageLayout pl = (BeanPageLayout)pageLayoutDao.getCore(this.analysisReport.getPageLayoutOID());
            LengthUnitDao lengthUnitDao = this.daoFactory.getLengthUnitDao();
            BeanLengthUnit lengthUnit = (BeanLengthUnit)lengthUnitDao.getCore(pl.getLengthUnitOID());
            PageLayout pageLayout = new PageLayout(pl, lengthUnit, theme);
            return pageLayout;
        }

        private int sendMessage(UserInfo userInfo, BeanTaskMetricResult metricResult, ImageDocument attachment) throws DashboardException {
            try {
                ExpressionEvaluationData data = userInfo.getData();
                if (!userInfo.getSendMessage()) {
                    TaskMetricExecution.this.addMessage(2, "taskMsg.noMsgAccess", data.getUserName());
                    return -1;
                }
                List<AbstractSendMessage> sendMessageList = SendMessageListHelper.getInstance(data, userInfo.getMessageTypeList(), metricResult.getName());
                if (sendMessageList.isEmpty()) {
                    return 0;
                }
                int localStatus = 0;
                String messageSubject = this.getMessage(metricResult, (BeanReport)this.analysisReport, metricResult.getMessageSubjectMap(), data.getLocale());
                String messageBody = this.getMessage(metricResult, (BeanReport)this.analysisReport, metricResult.getMessageBodyMap(), data.getLocale());
                for (int i = 0; i < sendMessageList.size(); ++i) {
                    AbstractSendMessage sendMessage = sendMessageList.get(i);
                    String baseURL = sendMessage.getBaseURL();
                    StringBuffer url = baseURL != null ? new StringBuffer(baseURL) : new StringBuffer("");
                    Message message = new Message();
                    MessageSubject subject = new MessageSubject();
                    subject.setText(this.replace(messageSubject, "{url}", url.toString()));
                    message.setSubject(subject);
                    MessageBody body = new MessageBody();
                    body.setText(this.replace(messageBody, "{url}", url.toString()));
                    message.setBody(body);
                    if (attachment != null) {
                        MessageAttachment msg = new MessageAttachment();
                        msg.setName(attachment.getFileName());
                        msg.setContentType(attachment.getContentType());
                        msg.setData(attachment.getData());
                        message.add(msg);
                    }
                    try {
                        if (!sendMessage.sendMessage(message)) continue;
                        TaskMetricExecution.this.addMessage(1, "taskMsg.messageSendOk", data.getUserName());
                        continue;
                    }
                    catch (Exception e) {
                        TaskMetricExecution.this.addMessage(2, "taskMsg.mailnotSend", data.getUserName());
                        localStatus = Math.min(localStatus, -1);
                        AbstractTaskExecution.log.error((Object)e);
                    }
                }
                return localStatus;
            }
            catch (Exception ex) {
                if (ex instanceof DashboardException) {
                    throw (DashboardException)((Object)ex);
                }
                throw new DashboardException((Throwable)ex);
            }
        }

        private String getMessage(BeanTaskMetricResult metricResult, BeanReport report, Map<Locale, String> descMap, Locale locale) {
            ResourceBundle bundle = ResourceBundle.getBundle("com.prelytis.dashboard.resources.Messages", locale);
            String message = descMap.get(locale);
            message = this.replace(message, "{TaskDescription}", (String)metricResult.getDescriptionMap().get(locale));
            message = this.replace(message, "{InitialState}", this.getSeverity(metricResult.getPreviousCalcValue(), bundle));
            message = this.replace(message, "{FinalState}", this.getSeverity(metricResult.getPreviousCalcValue(), bundle));
            if (report != null) {
                message = this.replace(message, "{ReportDescription}", (String)report.getDescriptionMap().get(locale));
            }
            message = this.replace(message, "{ReportField}", (String)this.field.getDescriptionMap().get(locale));
            message = this.replace(message, "{t:TaskDescription}", (String)metricResult.getDescriptionMap().get(locale));
            message = this.replace(message, "{t:InitialState}", this.getSeverity(metricResult.getPreviousCalcValue(), bundle));
            message = this.replace(message, "{t:FinalState}", this.getSeverity(metricResult.getPreviousCalcValue(), bundle));
            if (report != null) {
                message = this.replace(message, "{t:ReportDescription}", (String)report.getDescriptionMap().get(locale));
            }
            message = this.replace(message, "{t:ReportField}", (String)this.field.getDescriptionMap().get(locale));
            String format = "{0}";
            MessageFormat mf = new MessageFormat(format, locale);
            Thresholds thresholds = metricResult.getCalcThresholds();
            ThresholdInterval interval = thresholds.getFirstInterval();
            int cpt = 0;
            while (interval != null && interval.getAfter() != null) {
                Threshold threshold = interval.getAfter();
                message = this.replace(message, "{Threshold" + ++cpt + "}", mf.format(new Object[]{threshold.getValue()}));
                message = this.replace(message, "{t:Threshold" + cpt + "}", mf.format(new Object[]{threshold.getValue()}));
                interval = threshold.getAfter();
            }
            return message;
        }

        private String getSeverity(int severity, ResourceBundle bundle) {
            switch (severity) {
                default: {
                    return bundle.getString("threshold.unknown");
                }
                case 0: {
                    return bundle.getString("threshold.info");
                }
                case 1: {
                    return bundle.getString("threshold.warning");
                }
                case 2: 
            }
            return bundle.getString("threshold.error");
        }

        private String replace(String source, String replace, String by) {
            int index;
            if (by == null) {
                by = "";
            }
            String src = source;
            do {
                if ((index = src.toLowerCase().indexOf(replace.toLowerCase())) < 0) continue;
                src = src.substring(0, index) + by + src.substring(index + replace.length());
            } while (index >= 0);
            return src;
        }
    }

    private static class ThresholdsAndTarget {
        private Thresholds thresholds;
        private Object targetValue;

        private ThresholdsAndTarget() {
        }

        public boolean equals(Object obj) {
            ThresholdsAndTarget tat = (ThresholdsAndTarget)obj;
            if (!this.equalsObject(this.targetValue, tat.targetValue)) {
                return false;
            }
            return this.thresholds.equals((Object)tat.thresholds);
        }

        private boolean equalsObject(Object value1, Object value2) {
            switch (this.checkNull(value1, value2)) {
                case 0: {
                    break;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
            }
            return value1.equals(value2);
        }

        private int checkNull(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null ? 2 : 1;
            }
            if (o2 == null) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            return this.thresholds.hashCode();
        }
    }

    private static class EntityInfo {
        private ExpressionEvaluationData data;
        private AIPreparedQuery AIPreparedQuery;
        private Thresholds thresholds;

        private EntityInfo() {
        }

        public AIPreparedQuery getAIPreparedQuery() {
            return this.AIPreparedQuery;
        }

        public void setAIPreparedQuery(AIPreparedQuery preparedQuery) {
            this.AIPreparedQuery = preparedQuery;
        }

        public Thresholds getThresholds() {
            return this.thresholds;
        }

        public void setThresholds(Thresholds thresholds) {
            this.thresholds = thresholds;
        }

        public ExpressionEvaluationData getData() {
            return this.data;
        }

        public void setData(ExpressionEvaluationData data) {
            this.data = data;
        }
    }

    private static class UserInfo {
        private ExpressionEvaluationData data;
        private List<BeanUserMessageType> messageTypeList;
        private boolean sendMessage = false;

        private UserInfo() {
        }

        public void setSendMessage(boolean sendMessage) {
            this.sendMessage = sendMessage;
        }

        public boolean getSendMessage() {
            return this.sendMessage;
        }

        public ExpressionEvaluationData getData() {
            return this.data;
        }

        public void setData(ExpressionEvaluationData data) {
            this.data = data;
        }

        public List<BeanUserMessageType> getMessageTypeList() {
            return this.messageTypeList;
        }

        public void setMessageTypeList(List<BeanUserMessageType> messageTypeList) {
            this.messageTypeList = messageTypeList;
        }
    }

    private class Helper {
        private BeanTaskMetric task;
        private Map<AIPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>> map;
        private Map<Integer, EntityInfo> entityMap;
        private MetricEntityDao metricDao;
        private AbstractBeanReport report;

        private Helper(DaoFactory daoFactory, BeanTaskMetric task) throws DashboardRuntimeException, DashboardException {
            this.task = task;
            this.map = new HashMap<AIPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>>();
            this.entityMap = new HashMap<Integer, EntityInfo>();
            this.metricDao = daoFactory.getMetricEntityDao();
            ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
            this.report = reportHelper.getDefinition(task.getCalculationReportName());
        }

        public Map<AIPreparedQuery, Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>> getMap() {
            return this.map;
        }

        private void addUser(DaoFactory daoFactory, ExpressionEvaluationData data, List<BeanUserMessageType> messageTypeList, boolean sendMessage) throws DashboardException {
            Integer entityOid;
            List<UserInfo> userList;
            Map<Integer, List<UserInfo>> entitySubMap;
            Map<ThresholdsAndTarget, Map<Integer, List<UserInfo>>> thresholdMap;
            BeanTaskMetricEntity taskUser = null;
            ThresholdsAndTarget thresholdsAndTarget = this.createThresholdsAndTarget(this.task);
            try {
                taskUser = this.metricDao.open(this.task, data.getEntityOid().intValue());
                if (taskUser != null) {
                    thresholdsAndTarget = this.createThresholdsAndTarget((BeanTaskMetric)taskUser);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            EntityInfo entityInfo = this.entityMap.get(data.getEntityOid());
            if (entityInfo == null) {
                EntityHelper entityHelper = EntityHelper.getInstance(daoFactory);
                EngineHelper eh = EngineHelper.getInstance(daoFactory);
                ExecutionContext context = eh.getExecutionContext(this.report, data, null, true);
                OperationFinal operation = eh.getOperation(this.report, context);
                operation.setStreamed(true);
                AIPreparedQuery aiPreparedQuery = new AIPreparedQuery();
                aiPreparedQuery.setOperation(operation);
                entityInfo = new EntityInfo();
                entityInfo.setAIPreparedQuery(aiPreparedQuery);
                entityInfo.setData(data);
                this.entityMap.put(data.getEntityOid(), entityInfo);
                ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();
                Thresholds thresholds = thresholdsAndTarget.thresholds;
                for (int i = 0; i < thresholds.size(); ++i) {
                    Threshold th = thresholds.getThreshold(i);
                    if (!(th.getValue() instanceof Expression)) continue;
                    Object value = helper.evaluateExpression((Expression)th.getValue(), data);
                    if (value instanceof String) {
                        value = new Double((String)value);
                    }
                    th.setValue(value);
                }
                if (thresholdsAndTarget.targetValue instanceof Expression) {
                    Object value = helper.evaluateExpression((Expression)thresholdsAndTarget.targetValue, data);
                    if (value instanceof String) {
                        value = new Double((String)value);
                    }
                    thresholdsAndTarget.targetValue = value;
                }
            }
            AIPreparedQuery aiPreparedQuery = entityInfo.getAIPreparedQuery();
            if (entityInfo.getThresholds() == null) {
                entityInfo.setThresholds(null);
            }
            if ((thresholdMap = this.map.get(aiPreparedQuery)) == null) {
                thresholdMap = new HashMap<ThresholdsAndTarget, Map<Integer, List<UserInfo>>>();
                this.map.put(aiPreparedQuery, thresholdMap);
            }
            if ((entitySubMap = thresholdMap.get(thresholdsAndTarget)) == null) {
                entitySubMap = new HashMap<Integer, List<UserInfo>>();
                thresholdMap.put(thresholdsAndTarget, entitySubMap);
            }
            if ((userList = entitySubMap.get(entityOid = entityInfo.getData().getEntityOid())) == null) {
                userList = new ArrayList<UserInfo>();
                entitySubMap.put(entityOid, userList);
            }
            UserInfo userInfo = new UserInfo();
            userInfo.setData(data);
            userInfo.setSendMessage(sendMessage);
            userInfo.setMessageTypeList(messageTypeList);
            userList.add(userInfo);
        }

        private ThresholdsAndTarget createThresholdsAndTarget(BeanTaskMetric task) {
            ThresholdsAndTarget tat = new ThresholdsAndTarget();
            tat.targetValue = task.getTargetValue();
            tat.thresholds = ThresholdHelper.copy((Thresholds)task.getThresholds());
            return tat;
        }
    }
}

