/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.dao.JdbcDriverDao;
import com.prelytis.dashboard.dao.TaskDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbEntityFilter;
import com.prelytis.dashboard.data.helper.QuerySQLHelper;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operator.ConnectionHelper;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.helper.QuerySQLPattern;
import com.prelytis.dashboard.helper.QuerySQLPatternListHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.AbstractTaskExecution;
import com.prelytis.dashboard.task.TaskEvent;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.TaskExecutionListener;
import com.prelytis.dashboard.util.Compare;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.value.data.BeanEntity;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.BeanJDBCDriverDefinition;
import com.prelytis.dashboard.value.data.BeanPersFieldValue;
import com.prelytis.dashboard.value.data.BeanTaskScript;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.structure.Task;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TaskScriptExecution
extends AbstractTaskExecution {
    public TaskScriptExecution(MessageListener messageListener, TaskExecutionListener listener) {
        super(messageListener, listener);
    }

    @Override
    public int execute(DaoFactory daoFactory, Task task) throws TaskExecutionException {
        try {
            TaskDao taskDao = daoFactory.getTaskDao();
            BeanTaskScript script = (BeanTaskScript)taskDao.getDefinition(task.getObjectID());
            int retVal = 0;
            ScriptExecution scriptExecution = new ScriptExecution(daoFactory, script);
            EntityDao entityDao = daoFactory.getEntityDao();
            DbEntityFilter f = new DbEntityFilter();
            f.setActive(Boolean.TRUE);
            List list = entityDao.listAll((DbDefaultFilter)f, 1);
            ExpressionEvaluationDataHelper eedh = ExpressionEvaluationDataHelper.getInstance(daoFactory);
            switch (script.getExecOn()) {
                case 1: {
                    retVal = Math.min(retVal, this.execute(scriptExecution, task.getName(), eedh.getDefaultData()));
                    return retVal;
                }
                case 2: {
                    for (int i = 0; i < list.size(); ++i) {
                        BeanEntity entity = (BeanEntity)list.get(i);
                        try {
                            ExpressionEvaluationData data = eedh.getExpressionEvaluationData(entity);
                            retVal = Math.min(retVal, this.execute(scriptExecution, task.getName(), data));
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                            retVal = -2;
                        }
                    }
                    return retVal;
                }
                case 3: {
                    for (int i = 0; i < list.size(); ++i) {
                        BeanEntity entity = (BeanEntity)list.get(i);
                        try {
                            ExpressionEvaluationData data = eedh.getExpressionEvaluationData(entity);
                            BeanPersFieldValue persFieldValue = this.getPersFieldValue(data.getPersFieldList(), script.getFieldOID());
                            Object value = persFieldValue.getValues();
                            Object v = null;
                            if (value instanceof Object[]) {
                                Object[] values = (Object[])value;
                                if (values != null && values.length > 0) {
                                    v = values[0];
                                }
                            } else {
                                v = value;
                            }
                            Object refValue = null;
                            ConversionHelper conversionHelper = ConversionHelper.getDBConverter();
                            try {
                                refValue = conversionHelper.parse(persFieldValue.getDataType(), script.getFieldValue());
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            if (!Compare.compare((Object)((Comparable)value), (int)script.getFieldOperator(), (Object)((Comparable)refValue))) continue;
                            retVal = Math.min(retVal, this.execute(scriptExecution, task.getName(), data));
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                            retVal = -2;
                        }
                    }
                    return retVal;
                }
            }
            return retVal;
        }
        catch (Exception ex) {
            throw new TaskExecutionException(ex, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(ScriptExecution scriptExecution, String taskName, ExpressionEvaluationData data) {
        int status = -3;
        TaskEvent event = new TaskEvent();
        event.setStart(new Date());
        event.setEntityName(data.getEntityName());
        event.setTaskName(taskName);
        event.setTaskType(TaskType.TASK_TYPE_SCRIPT);
        this.startTask(event);
        try {
            status = scriptExecution.calc(data);
        }
        catch (Exception e) {
            status = -2;
        }
        finally {
            event.setEnd(new Date());
            event.setStatus(status);
            this.endTask(event);
        }
        return status;
    }

    private static class SQLFileInputStream {
        private BufferedReader reader;

        public SQLFileInputStream(String fileName) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        }

        public String readLine() throws IOException {
            if (this.reader == null) {
                return null;
            }
            StringBuffer line = new StringBuffer();
            String tmp = null;
            while ((tmp = this.reader.readLine()) != null) {
                String tmpTrimmed = tmp.trim();
                if (tmpTrimmed.length() <= 0) continue;
                line.append(tmp).append("\n");
                if (tmpTrimmed.charAt(tmpTrimmed.length() - 1) != ';') continue;
                return line.substring(0, line.lastIndexOf(";"));
            }
            tmp = line.toString();
            if (tmp.trim().length() > 0) {
                return tmp;
            }
            return null;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
        }
    }

    private class ScriptExecution {
        private FileHelper fileHelper;
        private final boolean onErrorStop;
        private final BeanWorldDefinition world;
        private final BeanJDBCDriverDefinition driver;

        private ScriptExecution(DaoFactory daoFactory, BeanTaskScript task) throws DashboardException {
            FolderDao folderDao = daoFactory.getFolderDao();
            BeanFile folder = (BeanFile)folderDao.getDefinition(task.getFileOID());
            this.fileHelper = FileHelper.getInstance(folder, task.getFileName());
            WorldDao worldDao = daoFactory.getWorldDao();
            this.world = (BeanWorldDefinition)worldDao.getDefinition(task.getWorldOID());
            JdbcDriverDao driverDao = daoFactory.getJdbcDriverDao();
            this.driver = (BeanJDBCDriverDefinition)driverDao.getDefinition(this.world.getDriverOID());
            this.onErrorStop = task.getOnError() == 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int calc(ExpressionEvaluationData data) throws TaskExecutionException {
            File file;
            SQLFileInputStream inputStream = null;
            int status = 0;
            try {
                file = this.fileHelper.getFile(data);
            }
            catch (Exception e) {
                TaskScriptExecution.this.addMessage(3, "taskMsg.fileNotFound", null);
                throw new TaskExecutionException(e, true);
            }
            if (file == null) {
                TaskScriptExecution.this.addMessage(3, "taskMsg.noInputFile", null);
                throw new TaskExecutionException(new FileNotFoundException(), true);
            }
            if (!file.exists()) {
                TaskScriptExecution.this.addMessage(3, "taskMsg.fileNotFound", file.getName());
                throw new TaskExecutionException(new FileNotFoundException(), true);
            }
            TaskScriptExecution.this.addMessage(1, "taskMsg.inputFile", file.getName());
            try {
                inputStream = new SQLFileInputStream(file.toString());
                WorldHelper worldHelper = WorldHelper.getInstance((BeanWorldDefinition)this.world, (DriverCharacteristics)this.driver, (ExpressionEvaluationData)data);
                String schema = worldHelper.getSchema(null);
                ArrayList<QuerySQLPattern> patternList = new ArrayList<QuerySQLPattern>();
                patternList.add(QuerySQLPattern.getFixedPattern("s:schema", schema));
                patternList.add(QuerySQLPattern.getFixedPattern("schema", schema));
                QuerySQLPatternListHelper persFieldHelper = new QuerySQLPatternListHelper();
                persFieldHelper.fill(patternList, data);
                ConnectionHelper connectionHelper = ConnectionHelper.getInstance((WorldHelper)worldHelper);
                try (Connection con = connectionHelper.getConnection();){
                    String line;
                    while ((line = inputStream.readLine()) != null) {
                        try {
                            QuerySQL querySQL = new QuerySQL();
                            querySQL.setQueryString(line);
                            QuerySQLHelper querySQLHelper = new QuerySQLHelper();
                            querySQL = querySQLHelper.getTransformedQuerySQL(querySQL, patternList);
                            try (PreparedStatement stmt = con.prepareStatement(querySQL.getQueryString());){
                                boolean result = stmt.execute();
                                if (!result) continue;
                                while (stmt.getMoreResults()) {
                                }
                            }
                        }
                        catch (Exception ex) {
                            try {
                                String message = ex.getMessage() + " (" + ex.getStackTrace()[0].toString() + ")";
                                AbstractTaskExecution.log.info((Object)message);
                                TaskScriptExecution.this.addMessage(2, message);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (this.onErrorStop) {
                                throw ex;
                            }
                            status = -1;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new TaskExecutionException(e, false);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            return status;
        }
    }
}

