/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.TaskDataMartElement;
import com.prelytis.dashboard.task.datamart.TaskDataMartSourceCSVFile;
import com.prelytis.dashboard.task.datamart.TaskDataMartSourceParam;
import com.prelytis.dashboard.task.datamart.TaskDataMartSourceQuery;
import com.prelytis.dashboard.task.datamart.TaskDataMartSourceStdLogFile;
import com.prelytis.dashboard.task.datamart.TaskDataMartSourceXLSFile;
import com.prelytis.dashboard.task.datamart.TaskDataMartSourceXMLFile;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.BeanTaskDataMart;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageI18n;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

abstract class AbstractTaskDataMartSource
implements TaskDataMartElement {
    protected static final Logger log = LogManager.getLogger(AbstractTaskDataMartSource.class);
    protected boolean deleteAfterProcess;
    protected MessageListener messageListener;

    public AbstractTaskDataMartSource(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    protected void addMessage(String msgKey, String param) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(msgKey, param));
    }

    protected void addMessage(int severity, String msgKey, String param) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(severity, msgKey, param));
    }

    public static final AbstractTaskDataMartSource getInstance(DaoFactory daoFactory, MessageListener messageListener, BeanTaskDataMart task) throws TaskExecutionException {
        AbstractTaskDataMartSource source;
        switch (task.getSourceType()) {
            case XML_FILE: {
                source = new TaskDataMartSourceXMLFile(messageListener, AbstractTaskDataMartSource.getFileHelper(daoFactory, task.getSourceFolderOid(), task.getSourceFile()));
                break;
            }
            case CSV_FILE: {
                source = new TaskDataMartSourceCSVFile(messageListener, AbstractTaskDataMartSource.getFileHelper(daoFactory, task.getSourceFolderOid(), task.getSourceFile()), task.getSourceEncoding(), task.getImportFrom(), task.getImportFromRow(), task.getImportTo(), task.getImportToRow(), task.getSourceSeparatedBy().getSeparator(), task.getSourceTextDelimiter());
                break;
            }
            case XLS_FILE: {
                source = new TaskDataMartSourceXLSFile(messageListener, AbstractTaskDataMartSource.getFileHelper(daoFactory, task.getSourceFolderOid(), task.getSourceFile()));
                break;
            }
            case STD_LOG_FILE: {
                source = new TaskDataMartSourceStdLogFile(messageListener, AbstractTaskDataMartSource.getFileHelper(daoFactory, task.getSourceFolderOid(), task.getSourceFile()), task.getSourceEncoding());
                break;
            }
            case QUERY: {
                source = new TaskDataMartSourceQuery(daoFactory, messageListener, task.getSourceQueryOid());
                break;
            }
            case PARAM: {
                source = new TaskDataMartSourceParam(daoFactory, messageListener);
                break;
            }
            default: {
                messageListener.log((ExecutionMessage)new ExecutionMessageI18n(3, "taskMsg.srcNoSupported"));
                throw new TaskExecutionException("Source not supported", 2, false);
            }
        }
        return source;
    }

    public void setDeleteAfterProcess(boolean deleteAfterProcess) {
        this.deleteAfterProcess = deleteAfterProcess;
    }

    public boolean getDeleteAfterProcess() {
        return this.deleteAfterProcess;
    }

    @Override
    public void postProcess(ExpressionEvaluationData data) throws TaskExecutionException {
    }

    protected void handleException(Exception e) throws TaskExecutionException {
        log.error((Object)e);
        if (this.messageListener != null) {
            this.messageListener.log((ExecutionMessage)new ExecutionMessageStd(3, e.getMessage()));
        }
        throw new TaskExecutionException(e, true);
    }

    private static FileHelper getFileHelper(DaoFactory daoFactory, int fileOID, String fileName) throws TaskExecutionException {
        BeanFile folder = null;
        try {
            FolderDao folderDao = daoFactory.getFolderDao();
            folder = (BeanFile)folderDao.getDefinition(fileOID);
            return FileHelper.getInstance(folder, fileName);
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, true);
        }
    }
}

