/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class ParamIterator
implements Iterator<Element> {
    private final Iterator<SessionParameterType> sessions;
    private final Queue<Element> queue = new LinkedList<Element>();
    private final DaoFactory daoFactory;

    public ParamIterator(DaoFactory daoFactory, Iterator<SessionParameterType> sessions) {
        this.daoFactory = daoFactory;
        this.sessions = sessions;
    }

    @Override
    public boolean hasNext() {
        while (this.queue.isEmpty() && this.sessions.hasNext()) {
            SessionParameterType s = this.sessions.next();
            ParameterHelper parameterHelper = ParameterHelper.getInstance(this.daoFactory, s);
            try {
                this.queue.addAll(parameterHelper.list(null, 2, null, null, null));
            }
            catch (DashboardException de) {
                throw new RuntimeException(de);
            }
        }
        return !this.queue.isEmpty();
    }

    @Override
    public Element next() {
        if (this.hasNext()) {
            return this.queue.remove();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

