/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.JdbcDriverDao;
import com.prelytis.dashboard.dao.WorldDao;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.task.TableHandler;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartResult;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.data.BeanJDBCDriverDefinition;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.IPoolDBInfo;
import javax.sql.DataSource;
import javax.xml.transform.sax.SAXResult;

class TaskDataMartResultTable
extends AbstractTaskDataMartResult {
    private final DaoFactory daoFactory;
    private final BeanWorldDefinition world;
    private String table;
    private boolean clearFirst;
    private int insertType;
    private int deleteType;
    private int batchType;
    private int batchNbLine;
    private int commitType;
    private int commitNbLine;
    private boolean createTable;
    private String catalog;
    private String schema;
    private boolean createPrimaryKey;
    private String identifierQuoteString;

    TaskDataMartResultTable(DaoFactory daoFactory, MessageListener messageListener, int worldOID, String table, boolean clearFirst, boolean createTable, int insertType, int deleteType, String catalog, String schema, boolean createPrimaryKey, int batchType, int batchNbLines, int commitType, int commitNbLine) throws TaskExecutionException {
        super(messageListener);
        this.daoFactory = daoFactory;
        try {
            WorldDao worldDao = this.daoFactory.getWorldDao();
            this.world = (BeanWorldDefinition)worldDao.getDefinition(worldOID);
            int driverOID = this.world.getDriverOID();
            JdbcDriverDao driverDao = this.daoFactory.getJdbcDriverDao();
            BeanJDBCDriverDefinition driverDefinition = (BeanJDBCDriverDefinition)driverDao.getDefinition(driverOID);
            this.identifierQuoteString = driverDefinition.getIdentifierQuoteString();
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.worldNotFound", String.valueOf(worldOID));
            throw new TaskExecutionException(e, true);
        }
        this.table = table;
        this.clearFirst = clearFirst;
        this.insertType = insertType;
        this.deleteType = deleteType;
        this.createTable = createTable;
        this.catalog = catalog;
        this.schema = schema;
        this.createPrimaryKey = createPrimaryKey;
        this.batchType = batchType;
        this.batchNbLine = batchNbLines;
        this.commitType = commitType;
        this.commitNbLine = commitNbLine;
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        IPoolDBInfo dbInfo = null;
        String finalCatalog = null;
        String finalSchema = null;
        String newTable = null;
        try {
            WorldHelper worldHelper = WorldHelper.getInstance((DaoFactory)this.daoFactory, (BeanWorldDefinition)this.world, (ExpressionEvaluationData)data);
            dbInfo = worldHelper.getPoolDbInfo();
            finalCatalog = worldHelper.getCatalog(this.catalog);
            finalSchema = worldHelper.getSchema(this.schema);
            newTable = ExpressionEvaluationHelper.getInstance().evaluate(this.table, data);
            Configuration configuration = Configuration.getInstance();
            DataSourceConfiguration dsc = configuration.getDataSourceConfiguration();
            SQLTableHelper sqlTableHelper = SQLTableHelper.getInstance((DataSource)dsc.getDataSource(dbInfo), (String)this.identifierQuoteString);
            container.setResult(new SAXResult(new TableHandler.Builder(sqlTableHelper, this.messageListener).defaultTable(finalCatalog, finalSchema, newTable).empty(this.clearFirst).create(this.createTable, this.createPrimaryKey).type(this.insertType, this.deleteType, this.batchType, this.batchNbLine, this.commitType, this.commitNbLine).build()));
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }
}

