/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.XLSHandler;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartResult;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.transform.sax.SAXResult;

class TaskDataMartResultXLSFile
extends AbstractTaskDataMartResult {
    private FileHelper fileHelper;
    private boolean exportHeading;

    TaskDataMartResultXLSFile(MessageListener messageListener, FileHelper fileHelper, boolean exportHeading) throws TaskExecutionException {
        super(messageListener);
        this.exportHeading = exportHeading;
        this.fileHelper = fileHelper;
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        File file = null;
        try {
            file = this.fileHelper.getFile(data);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.fileNotFound", "?");
            throw new TaskExecutionException(e, true);
        }
        if (file == null) {
            this.addMessage(3, "taskMsg.fileNotFound", "");
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        this.addMessage(1, "taskMsg.outPutFile", file.toString());
        XLSHandler handler = new XLSHandler(file, this.exportHeading);
        container.setResult(new SAXResult(handler));
    }

    public boolean isExportHeading() {
        return this.exportHeading;
    }

    public void setExportHeading(boolean exportHeading) {
        this.exportHeading = exportHeading;
    }
}

