/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.XLSReader;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartSource;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

class TaskDataMartSourceXLSFile
extends AbstractTaskDataMartSource {
    private FileHelper fileHelper;

    TaskDataMartSourceXLSFile(MessageListener messageListener, FileHelper fileHelper) throws TaskExecutionException {
        super(messageListener);
        this.fileHelper = fileHelper;
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        File file = null;
        try {
            file = this.fileHelper.getFile(data);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.noInputFile", null);
            throw new TaskExecutionException(e, true);
        }
        if (file == null) {
            this.addMessage(3, "taskMsg.noInputFile", null);
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        if (!file.exists()) {
            this.addMessage(3, "taskMsg.fileNotFound", file.getName());
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        this.addMessage(1, "taskMsg.inputFile", file.getName());
        try {
            FileInputStream is = new FileInputStream(file);
            container.push(is);
            XLSReader reader = new XLSReader();
            container.setSource(new SAXSource(reader, new InputSource(is)));
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }

    @Override
    public void postProcess(ExpressionEvaluationData data) throws TaskExecutionException {
        if (!this.getDeleteAfterProcess()) {
            return;
        }
        File file = null;
        try {
            file = this.fileHelper.getFile(data);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.fileNotFound", "?");
            throw new TaskExecutionException(e, true);
        }
        if (file == null) {
            this.addMessage(3, "taskMsg.noInputFile", null);
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        if (!file.exists()) {
            this.addMessage(3, "taskMsg.fileNotFound", file.getName());
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        try {
            if (file.delete()) {
                this.addMessage(1, "taskMsg.fileDeleted", file.getName());
            }
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }
}

