/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.PrelytisErrorListener;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.task.datamart.TaskDataMartElement;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageI18n;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;

class TaskDataMartTransformationFile
implements TaskDataMartElement {
    private final FileHelper fileHelper;
    private final MessageListener messageListener;

    TaskDataMartTransformationFile(MessageListener messageListener, FileHelper fileHelper) throws TaskExecutionException {
        this.messageListener = messageListener;
        this.fileHelper = fileHelper;
    }

    protected void addMessage(int severity, String msgKey, String param) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(severity, msgKey, param));
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        File file = null;
        try {
            file = this.fileHelper.getFile(data);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.noInputFile", null);
            throw new TaskExecutionException(e, true);
        }
        if (file == null) {
            this.addMessage(3, "taskMsg.noInputFile", null);
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        if (!file.exists()) {
            this.addMessage(3, "taskMsg.fileNotFound", file.getName());
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        this.addMessage(1, "taskMsg.inputFile", file.getName());
        try {
            FileInputStream is = new FileInputStream(file);
            container.push(is);
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            factory.setErrorListener(new PrelytisErrorListener());
            container.setHandler(factory.newTransformerHandler(new StreamSource(is)));
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }

    @Override
    public void postProcess(ExpressionEvaluationData data) throws TaskExecutionException {
    }
}

