/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.TaskDataMartTransformer;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartResult;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartSource;
import com.prelytis.dashboard.task.datamart.TaskDataMartElement;
import com.prelytis.dashboard.task.datamart.TaskDataMartTransformationFile;
import com.prelytis.dashboard.task.datamart.TaskDataMartTransformationNone;
import com.prelytis.dashboard.task.datamart.TaskDataMartTransformerXML;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.BeanTaskDataMart;
import com.prelytis.dashboard.value.data.TaskType;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageI18n;

public final class TaskDataMartTransformerFactory {
    public TaskDataMartTransformer getTransformer(DaoFactory daoFactory, BeanTaskDataMart task, MessageListener messageListener) throws TaskExecutionException {
        if (task.getTaskType() == TaskType.TASK_TYPE_DATAMART || task.getTaskType() == TaskType.TASK_TYPE_IMPORT_PARAM || task.getTaskType() == TaskType.TASK_TYPE_EXPORT_PARAM || task.getTaskType() == TaskType.TASK_TYPE_DOC_GENERATION || task.getTaskType() == TaskType.TASK_TYPE_XSLFO_DOC_GENERATION || task.getTaskType() == TaskType.TASK_TYPE_IMG_GENERATION) {
            TaskDataMartElement transformation;
            AbstractTaskDataMartSource source = AbstractTaskDataMartSource.getInstance(daoFactory, messageListener, task);
            switch (task.getTransformationType()) {
                case NONE: {
                    transformation = new TaskDataMartTransformationNone();
                    break;
                }
                case XSL: {
                    transformation = new TaskDataMartTransformationFile(messageListener, TaskDataMartTransformerFactory.getFileHelper(daoFactory, task.getTransformationFolderOID(), task.getTransformationFile()));
                    break;
                }
                default: {
                    messageListener.log((ExecutionMessage)new ExecutionMessageI18n(3, "taskMsg.trsNoSupported"));
                    throw new TaskExecutionException("Transformation not supported", 2, false);
                }
            }
            AbstractTaskDataMartResult result = AbstractTaskDataMartResult.getInstance(daoFactory, messageListener, task);
            return new TaskDataMartTransformerXML(messageListener, source, transformation, result);
        }
        throw new TaskExecutionException("Unsupported transformation", 2, false);
    }

    private static FileHelper getFileHelper(DaoFactory daoFactory, int fileOID, String fileName) throws TaskExecutionException {
        BeanFile folder = null;
        try {
            FolderDao folderDao = daoFactory.getFolderDao();
            folder = (BeanFile)folderDao.getDefinition(fileOID);
            return FileHelper.getInstance(folder, fileName);
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, true);
        }
    }
}

